// This file is part of the AliceVision project.
// Copyright (c) 2024 AliceVision contributors.
// This Source Code Form is subject to the terms of the Mozilla Public License,
// v. 2.0. If a copy of the MPL was not distributed with this file,
// You can obtain one at https://mozilla.org/MPL/2.0/.

%module (package="pyalicevision") sfmData

%include <aliceVision/global.i>
%include <aliceVision/camera/IntrinsicBase.i>
%include <aliceVision/camera/Pinhole.i>
%include <aliceVision/camera/Equidistant.i>

%include <aliceVision/sfmData/CameraPose.i>
%include <aliceVision/sfmData/Constraint2D.i>
%include <aliceVision/sfmData/ConstraintPoint.i>
%include <aliceVision/sfmData/SurveyPoint.i>
%include <aliceVision/sfmData/Rig.i>
%include <aliceVision/sfmData/RotationPrior.i>
%include <aliceVision/sfmData/View.i>
%include <aliceVision/sfmData/Landmark.i>

%include <aliceVision/sfmData/SfMData.hpp>

%{
#include <aliceVision/sfmData/SfMData.hpp>
using namespace aliceVision;
using namespace aliceVision::sfmData;
using namespace aliceVision::camera;
%}

%template(Constraints2D) std::vector<aliceVision::sfmData::Constraint2D>;
%template(ImageInfos) std::map<IndexT, std::shared_ptr<aliceVision::sfmData::ImageInfo>>;
%template(Intrinsics) std::map<IndexT, std::shared_ptr<aliceVision::camera::IntrinsicBase>>;
%template(PinholeIntrinsics) std::map<IndexT, std::shared_ptr<aliceVision::camera::Pinhole>>;
%template(EquidistantIntrinsics) std::map<IndexT, std::shared_ptr<aliceVision::camera::Equidistant>>;
%template(Landmarks) std::map<IndexT, aliceVision::sfmData::Landmark>;
%template(Observations) std::map<IndexT, aliceVision::sfmData::Observation>;
%template(Poses) std::map<IndexT, aliceVision::sfmData::CameraPose>;
%template(Rigs) std::map<IndexT, aliceVision::sfmData::Rig>;
%template(RotationPriors) std::vector<aliceVision::sfmData::RotationPrior>;
%template(Views) std::map<IndexT, std::shared_ptr<aliceVision::sfmData::View>>;

%template(ViewsVector) std::vector<std::shared_ptr<aliceVision::sfmData::View>>;
%template(ViewsVectorVector) std::vector<std::vector<std::shared_ptr<aliceVision::sfmData::View>>>;
