#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Harry Potter and the Transformency Spell
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240912.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='harry-potter-and-the-transformency-spell'
GAME_NAME='Harry Potter and the Transformency Spell'

ARCHIVE_BASE_0_NAME='eng_WizardLove_Exchange-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='bde8b88d4de6ba7f5b35648a38f5b5c9'
ARCHIVE_BASE_0_SIZE='88000'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_URL='https://rivarsstudio.itch.io/hpatts'

CONTENT_PATH_DEFAULT='WizardLove_Exchange-linux/game'
CONTENT_GAME_MAIN_FILES='
cache
images
music
sounds
script_version.txt
*.rpy
*.rpyc'
CONTENT_DOC_MAIN_PATH="${CONTENT_PATH_DEFAULT}/.."
CONTENT_DOC_MAIN_FILES='
README.html'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='images/icon.png'

## Ensure easy upgrades from packages generated with pre-20240912.1 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
harry-potter-and-the-transformency-spell-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
