
Notable changes in 0.33.1 since 0.33
====================================

Bugs
----

* POSIX1e ACLs should be restored correctly now.  Previously there
  were two problems.

  First, bup incorrectly restored default (`ACL_TYPE_DEFAULT`) ACLs as
  access acls (`ACL_TYPE_ACCESS`).  When both existed, it restored the
  access ACL first and then the default ACL as an access ACL.  Now,
  bup should restore each with the proper type.  This issue only
  affects saves created on platforms where bup currently supports
  ACLs, so presumably mostly just saves created on Linux since the
  current ACL support depends on non-standard functions like
  `acl_extended(3)`.

  Second, bup stored ACLs in the `acl_to_any_text(3)` format with a
  newlne delimiter, when the standard (and `acl_from_text(3)` which
  restore depends on) requires commas.  Now bup uses commas, and
  translates previously created saves during restore when possible.
  If a previously created ACL entry contains a comma, then bup will
  give up, report an error, and skip it.  If nothing else, this could
  cause restores of relevant saves to fail on some platforms.

Build and install
-----------------

* `MAKE=path ./configure ...` now supports relative `path`s.

* `./configure` will now look for `python3.11-config`, and won't look
  for `python3.6-config` (bup requires 3.7+).

* pytest 7 is now supported.

Thanks to (at least)
====================

Greg Troxel, Johannes Berg, Moritz Lell, and Rob Browning
