*** Settings ***
Documentation       Azure Database Elasticpool plugin

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Start Mockoon    ${MOCKOON_JSON}
Suite Teardown      Stop Mockoon
Test Timeout        120s


*** Variables ***
${MOCKOON_JSON}         ${CURDIR}${/}mockoon.json

${BASE_URL}             http://${HOSTNAME}:${APIPORT}
${LOGIN_ENDPOINT}       ${BASE_URL}/login
${CMD}                  ${CENTREON_PLUGINS} --plugin=cloud::azure::database::elasticpool::plugin --custommode=api --mode=storage --subscription=subscription --tenant=tenant --client-id=client_id --client-secret=secret --login-endpoint=${LOGIN_ENDPOINT} --management-endpoint=${BASE_URL}


*** Test Cases ***
Storage ${tc}
    [Tags]    cloud    azure    api    mockoon
    ${command}    Catenate
    ...    ${CMD}
    ...    --resource=${resource}
    ...    --resource-group=${resource_group}
    ...    ${thresholds}

    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:         tc  resource                                                             resource_group          thresholds                                        expected_result    --
            ...       1   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      ${EMPTY}                                          OK: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Allocated data storage: 201.00 GB, Allocated data storage percentage: 67.00 %, Storage usage percentage: 38.00 %, Storage usage: 114.00 GB | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       2   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --warning-allocated-data-storage-percent=0.01     WARNING: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Allocated data storage percentage: 67.00 % | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;0:0.01;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       3   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --critical-allocated-data-storage-percent=0.01    CRITICAL: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Allocated data storage percentage: 67.00 % | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;0:0.01;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       4   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --warning-allocated-data-storage=0.01             WARNING: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Allocated data storage: 201.00 GB | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;0:0.01;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       5   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --critical-allocated-data-storage=0.01            CRITICAL: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Allocated data storage: 201.00 GB | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;0:0.01;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       6   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --warning-storage-percent=0.01                    WARNING: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Storage usage percentage: 38.00 % | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;0:0.01;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       7   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --critical-storage-percent=0.01                   CRITICAL: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Storage usage percentage: 38.00 % | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;0:0.01;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;;;
            ...       8   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --warning-storage-used=0.01                       WARNING: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Storage usage: 114.00 GB | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;0:0.01;;;
            ...       9   sql-bb-stsw-prod-do/elasticpools/sql-epool-bb-psme-prod-do           emsp-tf-prod-va-rg      --critical-storage-used=0.01                      CRITICAL: Elastic Pool 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do' Statistic 'average' Metrics Storage usage: 114.00 GB | 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.bytes'=215822106624.00B;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.data.allocated.percentage'=67.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.usage.percentage'=38.00%;;;; 'sql-bb-stsw-prod-do/sql-epool-bb-psme-prod-do~average#elasticpool.storage.used.bytes'=122406567936.00B;;0:0.01;;
            ...      10   ${EMPTY}                                                             ${EMPTY}                ${EMPTY}                                          UNKNOWN: Incorrect resource format
