# CiviCRM 5.19.0

Released November 6, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Migrate APIv4 into civicrm-core
  ([15309](https://github.com/civicrm/civicrm-core/pull/15309) and
  [15331](https://github.com/civicrm/civicrm-core/pull/15331))**

  Migrates API version 4 from a standalone extension (`org.civicrm.api4`)
  into the core codebase. If the old extension is present, it will be disabled.

  For more information, see [Developer Guide: APIv4 Usage](https://docs.civicrm.org/dev/en/latest/api/v4/usage/)
  and [Differences between APIv3 / APIv4](https://docs.civicrm.org/dev/en/latest/api/v4/differences-with-v3/).

- **Improve obsolete extension management
  ([15352](https://github.com/civicrm/civicrm-core/pull/15352))**

  This change improves the extension UI by marking obsolete extensions as
  "Obsolete", removing the Install and Enable actions for obsolete extensions
  and completely uninstalling obsolete extensions during core upgrades.

- **Check requirements before upgrading extensions via the UI
  ([15450](https://github.com/civicrm/civicrm-core/pull/15450))**

  Improves user experience by checking for required dependencies when upgrading
  an extension. If the extension version being upgraded to requires a dependency
  throws a helpful error.

- **Upgrader: handle missing obsolete extensions
  ([15343](https://github.com/civicrm/civicrm-core/pull/15343))**

  Improves the mechanism for auto-disabling obsolete extensions during the
  upgrade process to disable extensions even if they are missing.

- **Updated entityRefFilters hook to support alter form create links
  ([15231](https://github.com/civicrm/civicrm-core/pull/15231))**

  Improves the `hook_civicrm_entityRefFilters()` to support altering create
  links like "New Household" and "New Individual".

- **Add getdisplayvalue api with unit test.
  ([15335](https://github.com/civicrm/civicrm-core/pull/15335))**

  Adds a new action `getdisplayvalue` to the `CustomValue` entity.

- **Add in an index on geo_code_1 and geo_code_2 to assist with distance and
  other queries ([15361](https://github.com/civicrm/civicrm-core/pull/15361))**

  Adds an index to `geo_code_1` and `geo_code_2` to help calculation
  queries based on latitude and longitude.

- **Allow columns in relationship table to be modified by searchColumns hook
  ([14184](https://github.com/civicrm/civicrm-core/pull/14184))**

  Allow columns in the relationship table to be modified by
  `hook_civicrm_searchColumns()`. This allows developers to modify the columns
  shown to the user on the Contact relationships tab.

- **Per agreement in NYC sprint, add status check is_active to table
  ([dev/core#1295](https://lab.civicrm.org/dev/core/issues/1295):
  [15409](https://github.com/civicrm/civicrm-core/pull/15409) and
  [15416](https://github.com/civicrm/civicrm-core/pull/15416))**

  Adds an `is_active` field to the `civicrm_status_pref` table which is
  api-accessible but not UI exposed. This field enables developers and system
  administrators to turn off a system check.

- **Declare metadata for component payment fields on export
  ([15243](https://github.com/civicrm/civicrm-core/pull/15243))**

  Adds metadata for component payment fields.

- **Add CRM_Utils_JS::encode function
  ([15285](https://github.com/civicrm/civicrm-core/pull/15285))**

  Adds a utility function for encoding javascript strings which gives an output
  that looks more like handwritten javascript and less like the overly-quoted
  `json_encode`.

- **CRM_Utils_JS - Improve encode handling of strings
  ([15295](https://github.com/civicrm/civicrm-core/pull/15295))**

  Improves test scenarios and tweaks the encode and decode functions to handle
  strings better.

- **Event Info/Contribution Page Smarty templates are inconsistent and ugly
  ([dev/core#1225](https://lab.civicrm.org/dev/core/issues/1225):
  [15168](https://github.com/civicrm/civicrm-core/pull/15168))**

  Improves the HTML of the smarty templates that power the "Event Info" and
  "Contribution Page". The pages appear the same to the end user but the
  underlying HTML is cleaner.

### CiviContribute

- **Update Online Contributions section of configuration checklist
  ([dev/core#1259](https://lab.civicrm.org/dev/core/issues/1259):
  [15317](https://github.com/civicrm/civicrm-core/pull/15317))**

  Improves the user experience of the Configuration Checklist Online
  Contributions section, specifically: only shows this section if CiviContribute
  is enabled, removes the system workflow templates list item, improves links to
  documentation.

- **Add trxn_id as a parameter on Payment.get
  ([15417](https://github.com/civicrm/civicrm-core/pull/15417))**

  Adds `trxn_id` as a viable parameter to the API call `Payment.get`.

### CiviMail

- **Mailing API - Expose option list for `header_id` and `footer_id`
  ([15325](https://github.com/civicrm/civicrm-core/pull/15325))**

  Improves the Mailing API `getoptions` and `getfields` actions to work for the
  fields `header_id` and `footer_id`.

- **Add unique name to mailing_job.start_date
  ([15210](https://github.com/civicrm/civicrm-core/pull/15210))**

  Adds metadata to the `MailingJob.start_date` field to prepare this field to
  use datepicker.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Error during "Import Contribution" and not able to import
  ([dev/core#1269](https://lab.civicrm.org/dev/core/issues/1269):
  [15447](https://github.com/civicrm/civicrm-core/pull/15447))**

  Fixes an error 'Error: Class name must be a valid object or a string in
  CRM_Import_Parser->parsePseudoConstantField()'' when attempting to import a
  contribution spreadsheet with a custom field column.

- **PHP 7.3 warning on "Import contribution" page.
  ([dev/core#1272](https://lab.civicrm.org/dev/core/issues/1272):
  [15346](https://github.com/civicrm/civicrm-core/pull/15346))**

  Fixes a warning: 'Warning: "continue" targeting switch is equivalent to
  "break".' on the match fields screen of a Contributions import.

- **Undefined variable isLiveMode when using print/merge document action from
  search results ([dev/core#1281](https://lab.civicrm.org/dev/core/issues/1281):
  [15420](https://github.com/civicrm/civicrm-core/pull/15420))**

  Fixes an E-notice "Undefined variable: isLiveMode in
  CRM_Contact_Form_Task_PDFLetterCommon::postProcess() (line 183 of
  .../web/sites/all/modules/civicrm/CRM/Contact/Form/Task/PDFLetterCommon.php)"
  when using print/merge document action from search results.

- **Add Custom Fields to Logging Tables
  ([15642](https://github.com/civicrm/civicrm-core/pull/15642),
  [15726](https://github.com/civicrm/civicrm-core/pull/15726), and
  [15741](https://github.com/civicrm/civicrm-core/pull/15741); related to
  [dev/core#1093](https://lab.civicrm.org/dev/core/issues/1093))**

  This resolves a fatal error when a custom field is added via XML file upon
  installation of an extension, logging is turned on, and part of the
  installation process inserts information on that new field.

  In addition, it preserves a feature looking up option group IDs according to
  names provided in the XML.

- **Find Activities/Pledges not working in 5.19beta1 and master
  ([dev/core#1348](https://lab.civicrm.org/dev/core/issues/1348):
  [15655](https://github.com/civicrm/civicrm-core/pull/15655) and
  [15657](https://github.com/civicrm/civicrm-core/pull/15657))**

  This resolves a bug where the values set on activity and pledge search forms
  were not respected, instead returning all activities or pledges.

- **Programatic Installation of Extension after Upgrading CiviCRM causes Error
  ([dev/core#1360](https://lab.civicrm.org/dev/core/issues/1360):
  [15724](https://github.com/civicrm/civicrm-core/pull/15724))**

- **exported data truncated to 255 when alphanumeric field value
  ([dev/core#1283](https://lab.civicrm.org/dev/core/issues/1283):
  [15414](https://github.com/civicrm/civicrm-core/pull/15414))**

  Fixes a bug where custom fields longer than 255 chars were not being truncated
  to 255 characters when exported.

- **Importing campaigns only works with label
  ([dev/core#1285](https://lab.civicrm.org/dev/core/issues/1285):
  [15453](https://github.com/civicrm/civicrm-core/pull/15453))**

  Fixes a regression when importing Contributions where the campaign id stopped
  working as a valid option so that the contribution import accepts ids or
  labels for campaigns.

- **Blank screen with no errors if you choose "Exclude contacts with 'do not
  mail' privacy" during export where that causes it to have zero contacts
  ([dev/core#1293](https://lab.civicrm.org/dev/core/issues/1293):
  [15439](https://github.com/civicrm/civicrm-core/pull/15439) and
  [15440](https://github.com/civicrm/civicrm-core/pull/15440))**

  Improves the ui when outputting an empty csv file. Before this change
  attempting to export a csv with no rows would result in a white screen of
  death with this change an empty csv is exported.

- **Do not check for the extension we are trying to download itself
  ([15506](https://github.com/civicrm/civicrm-core/pull/15506))**

  Fixes an error when trying to add and install a new extension thru the ui.

- **Removing 'Array' from user dashboard contributions
  ([15365](https://github.com/civicrm/civicrm-core/pull/15365))**

  Ensures that the word "Array" never appears in the "Your Contribution's"
  section on the user dashboard.

- **Stop passing exportMode, componentTable and ids by reference in export hook
  ([15302](https://github.com/civicrm/civicrm-core/pull/15302))**

  Makes it easier to alter an exports `exportMode`, `componentTable` and ids
  variables.

- **Ensure Dashboard domain ID is set even when passed as a param
  ([15282](https://github.com/civicrm/civicrm-core/pull/15282))**

  Ensures the `domain_id` parameter is respected when creating a dashlet via the
  `Dashboard.create` API.

- **CRM-21777 - Set readonly for the smtp fields initialised in
  civicrm_settings.php
  ([15305](https://github.com/civicrm/civicrm-core/pull/15305))**

  Ensures that SMTP fields initialized in `civicrm.settings.php` are loaded as
  read only. Before this change SMTP fields initialized in `civicrm.settings.php`
  were loaded as editable but editing them would do nothing.

- **Fix php 7.2+ deprecation error
  ([15178](https://github.com/civicrm/civicrm-core/pull/15178))**

- **Update spelling of htmlpurifier to be correct spelling
  ([15342](https://github.com/civicrm/civicrm-core/pull/15342))**

- **Fix directory name spelling for htmlpurifier
  ([265](https://github.com/civicrm/civicrm-packages/pull/265))**

- **Fatal error in export when using "Merge All Contacts with the Same Address"
  and Selected Fields instead of Primary Fields
  ([dev/core#1302](https://lab.civicrm.org/dev/core/issues/1302):
  [15443](https://github.com/civicrm/civicrm-core/pull/15443))**

- **Fatal error when sorting on a custom field in a profile listing
  ([dev/core#1305](https://lab.civicrm.org/dev/core/issues/1305):
  [15454](https://github.com/civicrm/civicrm-core/pull/15454))**

- **Fix status check not rendering before 5.19 migrations
  ([15428](https://github.com/civicrm/civicrm-core/pull/15428))**

- **Fix height of select2 box (appears squished)
  ([15403](https://github.com/civicrm/civicrm-core/pull/15403))**

- **Regression: on translated site with Pending status being translated,
  membership are renewed twice
  ([dev/core#1291](https://lab.civicrm.org/dev/core/issues/1291):
  [15376](https://github.com/civicrm/civicrm-core/pull/15376))**

### CiviCase

- **Case statuses in case type configuration page are not ordered by their
  weight. ([dev/core#1262](https://lab.civicrm.org/dev/core/issues/1262):
  [15319](https://github.com/civicrm/civicrm-core/pull/15319))**

### CiviContribute

- **Fix a regression whereby payment details are not saved from the
  AdditionalPayment form
  ([15537](https://github.com/civicrm/civicrm-core/pull/15537))**

- **Contribution Summary report only shows first 50 entries
  ([dev/core#1252](https://lab.civicrm.org/dev/core/issues/1252):
  [15558](https://github.com/civicrm/civicrm-core/pull/15558))**

- **Notice error on contribution page
  ([dev/core#1264](https://lab.civicrm.org/dev/core/issues/1264):
  [15320](https://github.com/civicrm/civicrm-core/pull/15320))**

  Fixes an e-notice "undefined index receipt_from_name" on the
  contribution page.

- **Fix checking of isSubscriptionCancelled when label is changed
  ([15406](https://github.com/civicrm/civicrm-core/pull/15406))**

  Moves to comparing names instead of labels to prevent issues for multilingual
  users.

- **Check number doesn't show up if payment method name - Check changed to
  Cheque ([dev/financial#67](https://lab.civicrm.org/dev/financial/issues/67):
  [15263](https://github.com/civicrm/civicrm-core/pull/15263))**

- **Check number doesn't get stored in associated financial_trxn record, if the
  contribution is made using 'Contribution/Membership batch data Entry' form
  ([dev/financial#68](https://lab.civicrm.org/dev/financial/issues/68):
  [15272](https://github.com/civicrm/civicrm-core/pull/15272))**

- **Recording one payment against a "Pending (Incomplete Transaction)" results
  in two payments
  ([dev/financial#69](https://lab.civicrm.org/dev/financial/issues/69):
  [15502](https://github.com/civicrm/civicrm-core/pull/15502))**

- **Can't email a partially paid invoice
  ([dev/financial#71](https://lab.civicrm.org/dev/financial/issues/71):
  [15388](https://github.com/civicrm/civicrm-core/pull/15388))**

### CiviEvent

- **Enotice fix (unreleased enotice)
  ([15569](https://github.com/civicrm/civicrm-core/pull/15569))**

  This resolves a PHP notice reading "Notice: Undefined variable: eventID" when
  recording a payment linked to an event registration.

### CiviMail

- **Mail job stuck after contact marked deceased
  ([dev/core#861](https://lab.civicrm.org/dev/core/issues/861):
  [15404](https://github.com/civicrm/civicrm-core/pull/15404))**

  Ensures no bulk emails are sent to contacts changed to deceased or put on hold
  between when the mailing is scheduled and when it is sent.

- **jasmine test crmMailingRadioDateSpec.js always has a failure if west of GMT
  ([dev/core#1279](https://lab.civicrm.org/dev/core/issues/1279):
  [15366](https://github.com/civicrm/civicrm-core/pull/15366))**

### CiviMember

- **Fix 5.18 regression on membership handling
  ([15494](https://github.com/civicrm/civicrm-core/pull/15494))**

  Fixes a 5.18 regression where sites with labels for contribution status
  'Pending' that are NOT 'Pending' would result in the membership end date being
  inappropriately extended when the back end renewal form is submitted with a
  pending payment.

- **Prevent error on price set membership update
  ([15142](https://github.com/civicrm/civicrm-core/pull/15142))**

  Fixes a fatal error when the `repeattransaction` action is called for a
  transaction that includes two memberships of the same type.

- **Contributions not recording if selected membership is "none" when using a
  membership priceset
  ([dev/core#792](https://lab.civicrm.org/dev/core/issues/792):
  [15094](https://github.com/civicrm/civicrm-core/pull/15094))**

- **Regression fix on Paypal Std with memberships not being finalised correctly.
  ([15538](https://github.com/civicrm/civicrm-core/pull/15538))**

### Joomla Integration

- **[Joomla 4.0] CiviCRM pages don't work in Joomla frontend - Class 'JRequest'
  not found ([dev/joomla#22](https://lab.civicrm.org/dev/joomla/issues/22):
  [15132](https://github.com/civicrm/civicrm-core/pull/15132))**

  Fixes a bug where no CiviCRM Frontend page could be viewed on Joomla 4.0.

## <a name="misc"></a>Miscellany

- **Rename balanceTrxnParams to paymentTrxnParams [REF]
  ([15539](https://github.com/civicrm/civicrm-core/pull/15539))**

- **Remove legacy Yahoo references from the Mapping/Geocoding settings/code.
  ([15405](https://github.com/civicrm/civicrm-core/pull/15405))**

- **(DX) api/v3/examples - Rename `*.php` to `*.ex.php`
  ([15310](https://github.com/civicrm/civicrm-core/pull/15310))**

- **Update CiviCRM contributors.txt
  ([15303](https://github.com/civicrm/civicrm-core/pull/15303))**

- **Remove static caching of static on Contribution page tab
  ([15329](https://github.com/civicrm/civicrm-core/pull/15329))**

- **Extract the code to get the field name.
  ([15389](https://github.com/civicrm/civicrm-core/pull/15389))**

- **Don't use random parameters to detect if we should create MembershipPayment
  ([14897](https://github.com/civicrm/civicrm-core/pull/14897))**

- **Remove call to updateRecurMembership which is handled by Membership::create
  BAO ([15384](https://github.com/civicrm/civicrm-core/pull/15384))**

- **[REF] Pull out anonymous javascript function to make it testable
  ([15378](https://github.com/civicrm/civicrm-core/pull/15378))**

- **[REF] Consolidate getFormValues on contribution search
  ([15379](https://github.com/civicrm/civicrm-core/pull/15379))**

- **[REF] Fix path to htmlpurifier in IDS file
  ([15360](https://github.com/civicrm/civicrm-core/pull/15360))**

- **[REF] Remove call to depreacated getValue call in Mailing Preferences…
  ([15368](https://github.com/civicrm/civicrm-core/pull/15368))**

- **(REF) Remove unused functions, setTemplateMenuValues() and getNavigation()
  ([15274](https://github.com/civicrm/civicrm-core/pull/15274))**

- **REF Make the formatParamsForPaymentProcessor function more generic so it can
  be used more ([15280](https://github.com/civicrm/civicrm-core/pull/15280))**

- **REF Explicitly specify params so we can find problems with comparing
  translated labels
  ([15397](https://github.com/civicrm/civicrm-core/pull/15397))**

- **REF Remove some duplication in CRM_Utils_Type::escape/validate
  ([14577](https://github.com/civicrm/civicrm-core/pull/14577))**

- **[REF] don't handle non-array, pass by reference
  ([15413](https://github.com/civicrm/civicrm-core/pull/15413))**

- **(NFC) api4 - Apply standard headers
  ([15353](https://github.com/civicrm/civicrm-core/pull/15353))**

- **[NFC] code formatting & exceptions in doc blocks
  ([15402](https://github.com/civicrm/civicrm-core/pull/15402))**

- **[NFC] Rename local variable
  ([15377](https://github.com/civicrm/civicrm-core/pull/15377))**

- **[NFC] Reword event docs to clarify priority vs weight
  ([15308](https://github.com/civicrm/civicrm-core/pull/15308))**

- **[NFC] array formatting:
  ([15250](https://github.com/civicrm/civicrm-core/pull/15250))**

- **[NFC] Add in code comments about the column default issue with is_ema…
  ([15301](https://github.com/civicrm/civicrm-core/pull/15301))**

- **CRM-21677 Missing Summary
  ([15230](https://github.com/civicrm/civicrm-core/pull/15230))**

- **Add test for uF group one bug
  ([15381](https://github.com/civicrm/civicrm-core/pull/15381))**

- **Unit test for #15094 fix
  ([15228](https://github.com/civicrm/civicrm-core/pull/15228))**

- **[TEST] dev/core#1046 - tests for case type edit screen
  ([15385](https://github.com/civicrm/civicrm-core/pull/15385))**

- **Extend Export test to cover altering sqlColumns and headerRows via
  hook_civicrm_export
  ([15312](https://github.com/civicrm/civicrm-core/pull/15312))**

- **[NFC] Fix AuthorizeNet Test failure due to credit card being expired
  ([15690](https://github.com/civicrm/civicrm-core/pull/15690))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andrew Hunt, Eli Lisseck; Agileware - Justin Freeman; Andrew
Thompson; Australian Greens - Seamus Lee; Christian Wach; Circle Interactive -
Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
CompuCorp - Vinu Varshith Sekar; Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove;
Dave D; Fuzion - Jitendra Purohit; Greenpeace CEE - Patrick Figel; JMA
Consulting - Monish Deb; John Kingsnorth; Megaphone Technology Consulting - Jon
Goldberg; MJCO - Mikey O'Toole; MJW Consulting - Matthew Wire; Kilakwa
Associates - smaen123; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Artful Robot - Rich Lott; Circle Interactive -
Dave Jenkins; Community IT Academy - William Mortada; JMA Consulting - Joe
Murray; Korlon - Stuart Gaston; Nicol Wistreich; Tadpole Collective - Kevin
Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
