#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("get next quick menu entry")

    def run(self):
        menu = ""
        value = ""
        if self.env["runtime"]["QuickMenuManager"].next_entry():
            menu = self.env["runtime"]["QuickMenuManager"].get_current_entry()
            if menu != "":
                value = self.env["runtime"][
                    "QuickMenuManager"
                ].get_current_value()
                self.env["runtime"]["OutputManager"].present_text(
                    menu + " " + value, interrupt=True
                )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("Quick menu not available"), interrupt=True
            )

    def set_callback(self, callback):
        pass
