/*************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#if defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#pragma warning(disable : 4206) // empty translation unit in MSVC
#endif

/* Selftests are disabled for now, since rsa 1k scheme is not FIPS-approved */
#if 0

#ifdef MBX_FIPS_MODE

#include <crypto_mb/fips_cert.h>
#include <internal/fips_cert/common.h>
#include <internal/rsa/ifma_rsa_method.h>

#include <crypto_mb/rsa.h>

/* KAT TEST (generated via internal tests) */
/* moduli */
static const int8u moduli[MBX_RSA1K_DATA_BYTE_LEN] = {
  0xfb,0x67,0xa4,0x16,0x7c,0x47,0x3f,0xe4,0xa0,0x00,0x48,0xc1,0x5e,0x7f,0x84,0xcd,
  0x90,0x10,0x23,0x59,0xeb,0x0b,0x60,0x8b,0x70,0x8f,0xe7,0x6e,0x51,0xf2,0xcc,0xff,
  0x95,0x9f,0xdc,0xeb,0x6f,0xf6,0x85,0xa4,0x21,0xfe,0x3d,0x76,0x55,0xe6,0xed,0x58,
  0x3c,0x80,0xa3,0xd7,0x1a,0xf5,0xcf,0x74,0x82,0xc0,0x02,0x3e,0xdd,0xa4,0xc5,0xf6,
  0x06,0xd3,0xcd,0x23,0x45,0xa4,0x0e,0x51,0x16,0x49,0xc4,0xd1,0x71,0xed,0xe2,0x32,
  0xe7,0x77,0x31,0x7e,0xbb,0x09,0x18,0x54,0xd1,0xe4,0x86,0xfe,0x1b,0x5a,0xdd,0x94,
  0x96,0xa5,0x97,0xa8,0x95,0x40,0xa6,0x10,0x70,0xbc,0xc6,0xdb,0xef,0xe8,0xad,0x2f,
  0x75,0x81,0x7a,0xa3,0xbd,0x4c,0x38,0x6d,0x38,0x59,0x6b,0xf1,0x44,0xb3,0x35,0xce};
/* private exponent */
static const int8u d[MBX_RSA1K_DATA_BYTE_LEN] = {
  0xe1,0x47,0xd2,0x67,0x25,0xe6,0x18,0x4d,0xaf,0xf5,0x06,0x57,0x18,0x8e,0x5c,0xe9,
  0xbe,0xf4,0x37,0xe3,0xa6,0x35,0xd5,0xc4,0xb1,0x42,0x80,0xe6,0x12,0x59,0x46,0x6b,
  0xc7,0x55,0x8c,0x98,0xc8,0x2f,0x09,0x4c,0x39,0x61,0x20,0x86,0x29,0x38,0x91,0xe4,
  0x6c,0x95,0xc6,0xdb,0xbb,0x64,0x44,0x32,0x50,0x19,0x54,0x05,0x49,0xb4,0xb8,0xfe,
  0x03,0x7c,0xab,0x28,0x95,0x1a,0x90,0xc7,0x32,0x34,0x6d,0xdc,0xaf,0xaf,0x3b,0xe5,
  0xc8,0x0d,0x82,0x9e,0xe2,0x67,0x0b,0x86,0x68,0xbd,0xdc,0x00,0x71,0xd6,0x4c,0x30,
  0x91,0x27,0x25,0xe3,0x25,0xc8,0x18,0x30,0x78,0x5b,0xec,0xb9,0xbe,0xab,0xdd,0x92,
  0x1b,0x94,0x92,0x96,0x97,0xf0,0x77,0x66,0xbe,0x51,0x9b,0xef,0x72,0x43,0x1a,0x3a};
/* plaintext */
static const int8u plaintext[MBX_RSA1K_DATA_BYTE_LEN] = {
  0xc5,0x87,0x62,0x86,0x7f,0x60,0xa1,0x20,0xd1,0x8c,0x60,0xf6,0x9a,0xd5,0x5b,0x43,
  0x19,0x53,0xb9,0xb0,0x67,0xe6,0xb3,0x3b,0xd1,0x03,0x73,0x13,0x3e,0x25,0x20,0x47,
  0x44,0x9f,0xaa,0x6c,0xca,0x57,0xfd,0xcf,0xfd,0x2b,0x33,0x9b,0xb5,0x4f,0x4c,0xde,
  0x59,0x0a,0x7d,0xcb,0x80,0x47,0x6d,0x54,0x59,0x0e,0x2b,0x8b,0x43,0x19,0x43,0x7d,
  0x05,0x2d,0xd6,0x55,0xfe,0x08,0xe2,0x4f,0xda,0xae,0xf4,0xc1,0x3f,0x6e,0x61,0x30,
  0xc4,0xe6,0x02,0x36,0xfc,0xa7,0xbe,0xc5,0xff,0xdc,0xd0,0xe4,0x5e,0x27,0x32,0xa5,
  0xa9,0xde,0xca,0xd3,0x2d,0xaa,0x3f,0x7a,0x61,0x3f,0x6e,0xf7,0xf1,0x27,0xda,0x3a,
  0xd5,0x71,0x4f,0xf1,0xbf,0x2f,0xbb,0xa8,0x89,0xa1,0x06,0xad,0x73,0xd4,0x63,0x7d};
/* ciphertext */
static const int8u ciphertext[MBX_RSA1K_DATA_BYTE_LEN] = {
  0x91,0x43,0x4f,0x37,0xcb,0xf8,0x26,0xa6,0x74,0x2c,0xb9,0x9c,0x8b,0x09,0xfe,0x01,
  0x1f,0x3a,0x01,0xc5,0x1f,0xeb,0xd9,0xea,0xc7,0x8f,0xcb,0x4d,0xf3,0xfb,0xef,0xf3,
  0x73,0xe9,0xcf,0x16,0x8d,0xaf,0x05,0x60,0xd2,0x72,0x45,0xb1,0xc9,0xcd,0xb3,0x07,
  0xdc,0x3f,0x81,0x2e,0x96,0x63,0xe7,0xf2,0xc4,0x92,0x6e,0x96,0xfd,0x62,0x5d,0x6f,
  0xac,0xa5,0x2c,0x2e,0x21,0x91,0xe2,0xe1,0xb5,0x9a,0xb3,0xf7,0xc3,0x0c,0x1c,0x2f,
  0x84,0xea,0x1d,0xe8,0xc7,0xc3,0x5b,0xb6,0x1a,0x3c,0x0d,0x22,0xc0,0x23,0x2b,0xa2,
  0xb0,0x0a,0x7e,0x36,0x35,0x99,0xce,0x0d,0x0a,0xdf,0x34,0x9f,0xae,0x44,0x49,0xdb,
  0x4e,0x8d,0x8a,0x7a,0x57,0xda,0xf0,0x9b,0x53,0x94,0x29,0xf0,0x3a,0x62,0x01,0x6f};

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa1k_private_mb8(void) {
  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output plaintext */
  int8u out_plaintext[MBX_LANES][MBX_RSA1K_DATA_BYTE_LEN];
  /* key operation */
  const mbx_RSA_Method* method = mbx_RSA1K_private_Method();

  /* function input parameters */
  // ciphertext
  const int8u *pa_ciphertext[MBX_LANES] = {
    ciphertext, ciphertext, ciphertext, ciphertext,
    ciphertext, ciphertext, ciphertext, ciphertext};
  // plaintext
  int8u *pa_plaintext[MBX_LANES] = {
    out_plaintext[0], out_plaintext[1], out_plaintext[2], out_plaintext[3],
    out_plaintext[4], out_plaintext[5], out_plaintext[6], out_plaintext[7]};
  // private exponent
  const int64u *pa_d[MBX_LANES]= {
    (int64u *)d, (int64u *)d, (int64u *)d, (int64u *)d,
    (int64u *)d, (int64u *)d, (int64u *)d, (int64u *)d};
  // moduli
  const int64u *pa_moduli[MBX_LANES] = {
    (int64u *)moduli, (int64u *)moduli, (int64u *)moduli, (int64u *)moduli,
    (int64u *)moduli, (int64u *)moduli, (int64u *)moduli, (int64u *)moduli};

  /* test function */
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);

  mbx_status sts;
  sts = mbx_rsa_private_mb8(pa_ciphertext, pa_plaintext, pa_d, pa_moduli, MBX_RSA1K_DATA_BIT_LEN, method, NULL);
  if (expected_status_mb8 != sts) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
  }
  // compare output plaintext to known answer
  int output_status;
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_plaintext[i], MBX_RSA1K_DATA_BYTE_LEN, plaintext, MBX_RSA1K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  return test_result;
}

#ifndef BN_OPENSSL_DISABLE

// memory free macro
#define MEM_FREE(BN_PTR1, BN_PTR2) \
    {                              \
        BN_free(BN_PTR1);          \
        BN_free(BN_PTR2);          \
    }

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa1k_private_ssl_mb8(void) {

  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output plaintext */
  int8u out_plaintext[MBX_LANES][MBX_RSA1K_DATA_BYTE_LEN];
  /* ssl private exponent */
  BIGNUM* BN_d = BN_new();
  /* ssl moduli */
  BIGNUM* BN_moduli = BN_new();
  /* check if allocated memory is valid */
  if(NULL == BN_d || NULL == BN_moduli) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
    MEM_FREE(BN_d, BN_moduli)
    return test_result;
  }

  /* function status and expected status */
  mbx_status sts;
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);
  /* output validity status */
  int output_status;

  /* set ssl parameters */
  BN_lebin2bn(d, MBX_RSA1K_DATA_BYTE_LEN, BN_d);
  BN_lebin2bn(moduli, MBX_RSA1K_DATA_BYTE_LEN, BN_moduli);

  /* function input parameters */
  // ciphertext
  const int8u *pa_ciphertext[MBX_LANES] = {
    ciphertext, ciphertext, ciphertext, ciphertext,
    ciphertext, ciphertext, ciphertext, ciphertext};
  // plaintext
  int8u *pa_plaintext[MBX_LANES] = {
    out_plaintext[0], out_plaintext[1], out_plaintext[2], out_plaintext[3],
    out_plaintext[4], out_plaintext[5], out_plaintext[6], out_plaintext[7]};
  // moduli
  const BIGNUM *pa_moduli[MBX_LANES] = {
    (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli,
    (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli};
  // private exponent
  const BIGNUM *pa_d[MBX_LANES] = {
    (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d,
    (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d, (const BIGNUM *)BN_d};

  /* test function */
  sts = mbx_rsa_private_ssl_mb8(pa_ciphertext, pa_plaintext, pa_d, pa_moduli, MBX_RSA1K_DATA_BIT_LEN);
  if (expected_status_mb8 != sts) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
  }
  // compare output signature to known answer
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_plaintext[i], MBX_RSA1K_DATA_BYTE_LEN, plaintext, MBX_RSA1K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  // memory free
  MEM_FREE(BN_d, BN_moduli)

  return test_result;
}

#endif // BN_OPENSSL_DISABLE
#endif // MBX_FIPS_MODE
#endif // #if 0
