/*************************************************************************
 * Copyright (C) 2019-2024 Intel Corporation
 *
 * Licensed under the Apache License,  Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law  or agreed  to  in  writing,  software
 * distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the  specific  language  governing  permissions  and
 * limitations under the License.
 *************************************************************************/

#include <internal/common/ifma_defs.h>

#if (_MBX >= _MBX_K1)

#include <internal/common/ifma_math.h>

void AMS52x60_diagonal_mb8(int64u* out_mb,
                           const int64u* inpA_mb,
                           const int64u* inpM_mb,
                           const int64u* k0_mb)
{
    __ALIGN64 U64 res[120];
    __ALIGN64 U64 u[60];
    U64 k;
    U64* a = (U64*)inpA_mb;
    U64* m = (U64*)inpM_mb;
    U64* r = (U64*)out_mb;

    k = loadu64((U64*)k0_mb);
    int i;
    for (i = 0; i < 120; ++i)
        res[i] = get_zero64();

    res[1]   = fma52lo(res[1], a[0], a[1]);     // Sum(1)
    res[2]   = fma52hi(res[2], a[0], a[1]);     // Sum(1)
    res[2]   = fma52lo(res[2], a[0], a[2]);     // Sum(2)
    res[3]   = fma52hi(res[3], a[0], a[2]);     // Sum(2)
    res[3]   = fma52lo(res[3], a[1], a[2]);     // Sum(3)
    res[4]   = fma52hi(res[4], a[1], a[2]);     // Sum(3)
    res[3]   = fma52lo(res[3], a[0], a[3]);     // Sum(3)
    res[4]   = fma52hi(res[4], a[0], a[3]);     // Sum(3)
    res[4]   = fma52lo(res[4], a[1], a[3]);     // Sum(4)
    res[5]   = fma52hi(res[5], a[1], a[3]);     // Sum(4)
    res[5]   = fma52lo(res[5], a[2], a[3]);     // Sum(5)
    res[6]   = fma52hi(res[6], a[2], a[3]);     // Sum(5)
    res[4]   = fma52lo(res[4], a[0], a[4]);     // Sum(4)
    res[5]   = fma52hi(res[5], a[0], a[4]);     // Sum(4)
    res[5]   = fma52lo(res[5], a[1], a[4]);     // Sum(5)
    res[6]   = fma52hi(res[6], a[1], a[4]);     // Sum(5)
    res[6]   = fma52lo(res[6], a[2], a[4]);     // Sum(6)
    res[7]   = fma52hi(res[7], a[2], a[4]);     // Sum(6)
    res[7]   = fma52lo(res[7], a[3], a[4]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[3], a[4]);     // Sum(7)
    res[5]   = fma52lo(res[5], a[0], a[5]);     // Sum(5)
    res[6]   = fma52hi(res[6], a[0], a[5]);     // Sum(5)
    res[6]   = fma52lo(res[6], a[1], a[5]);     // Sum(6)
    res[7]   = fma52hi(res[7], a[1], a[5]);     // Sum(6)
    res[7]   = fma52lo(res[7], a[2], a[5]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[2], a[5]);     // Sum(7)
    res[8]   = fma52lo(res[8], a[3], a[5]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[3], a[5]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[4], a[5]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[4], a[5]);    // Sum(9)
    res[6]   = fma52lo(res[6], a[0], a[6]);     // Sum(6)
    res[7]   = fma52hi(res[7], a[0], a[6]);     // Sum(6)
    res[7]   = fma52lo(res[7], a[1], a[6]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[1], a[6]);     // Sum(7)
    res[8]   = fma52lo(res[8], a[2], a[6]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[2], a[6]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[3], a[6]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[3], a[6]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[4], a[6]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[4], a[6]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[5], a[6]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[5], a[6]);    // Sum(11)
    res[7]   = fma52lo(res[7], a[0], a[7]);     // Sum(7)
    res[8]   = fma52hi(res[8], a[0], a[7]);     // Sum(7)
    res[8]   = fma52lo(res[8], a[1], a[7]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[1], a[7]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[2], a[7]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[2], a[7]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[3], a[7]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[3], a[7]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[4], a[7]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[4], a[7]);    // Sum(11)
    res[8]   = fma52lo(res[8], a[0], a[8]);     // Sum(8)
    res[9]   = fma52hi(res[9], a[0], a[8]);     // Sum(8)
    res[9]   = fma52lo(res[9], a[1], a[8]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[1], a[8]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[2], a[8]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[2], a[8]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[3], a[8]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[3], a[8]);    // Sum(11)
    res[9]   = fma52lo(res[9], a[0], a[9]);     // Sum(9)
    res[10]  = fma52hi(res[10], a[0], a[9]);    // Sum(9)
    res[10]  = fma52lo(res[10], a[1], a[9]);    // Sum(10)
    res[11]  = fma52hi(res[11], a[1], a[9]);    // Sum(10)
    res[11]  = fma52lo(res[11], a[2], a[9]);    // Sum(11)
    res[12]  = fma52hi(res[12], a[2], a[9]);    // Sum(11)
    res[10]  = fma52lo(res[10], a[0], a[10]);   // Sum(10)
    res[11]  = fma52hi(res[11], a[0], a[10]);   // Sum(10)
    res[11]  = fma52lo(res[11], a[1], a[10]);   // Sum(11)
    res[12]  = fma52hi(res[12], a[1], a[10]);   // Sum(11)
    res[11]  = fma52lo(res[11], a[0], a[11]);   // Sum(11)
    res[12]  = fma52hi(res[12], a[0], a[11]);   // Sum(11)
    res[0]   = add64(res[0], res[0]);           // Double(0)
    res[1]   = add64(res[1], res[1]);           // Double(1)
    res[2]   = add64(res[2], res[2]);           // Double(2)
    res[3]   = add64(res[3], res[3]);           // Double(3)
    res[4]   = add64(res[4], res[4]);           // Double(4)
    res[5]   = add64(res[5], res[5]);           // Double(5)
    res[6]   = add64(res[6], res[6]);           // Double(6)
    res[7]   = add64(res[7], res[7]);           // Double(7)
    res[8]   = add64(res[8], res[8]);           // Double(8)
    res[9]   = add64(res[9], res[9]);           // Double(9)
    res[10]  = add64(res[10], res[10]);         // Double(10)
    res[11]  = add64(res[11], res[11]);         // Double(11)
    res[0]   = fma52lo(res[0], a[0], a[0]);     // Add sqr(0)
    res[1]   = fma52hi(res[1], a[0], a[0]);     // Add sqr(0)
    res[2]   = fma52lo(res[2], a[1], a[1]);     // Add sqr(2)
    res[3]   = fma52hi(res[3], a[1], a[1]);     // Add sqr(2)
    res[4]   = fma52lo(res[4], a[2], a[2]);     // Add sqr(4)
    res[5]   = fma52hi(res[5], a[2], a[2]);     // Add sqr(4)
    res[6]   = fma52lo(res[6], a[3], a[3]);     // Add sqr(6)
    res[7]   = fma52hi(res[7], a[3], a[3]);     // Add sqr(6)
    res[8]   = fma52lo(res[8], a[4], a[4]);     // Add sqr(8)
    res[9]   = fma52hi(res[9], a[4], a[4]);     // Add sqr(8)
    res[10]  = fma52lo(res[10], a[5], a[5]);    // Add sqr(10)
    res[11]  = fma52hi(res[11], a[5], a[5]);    // Add sqr(10)
    res[12]  = fma52lo(res[12], a[5], a[7]);    // Sum(12)
    res[13]  = fma52hi(res[13], a[5], a[7]);    // Sum(12)
    res[13]  = fma52lo(res[13], a[6], a[7]);    // Sum(13)
    res[14]  = fma52hi(res[14], a[6], a[7]);    // Sum(13)
    res[12]  = fma52lo(res[12], a[4], a[8]);    // Sum(12)
    res[13]  = fma52hi(res[13], a[4], a[8]);    // Sum(12)
    res[13]  = fma52lo(res[13], a[5], a[8]);    // Sum(13)
    res[14]  = fma52hi(res[14], a[5], a[8]);    // Sum(13)
    res[14]  = fma52lo(res[14], a[6], a[8]);    // Sum(14)
    res[15]  = fma52hi(res[15], a[6], a[8]);    // Sum(14)
    res[15]  = fma52lo(res[15], a[7], a[8]);    // Sum(15)
    res[16]  = fma52hi(res[16], a[7], a[8]);    // Sum(15)
    res[12]  = fma52lo(res[12], a[3], a[9]);    // Sum(12)
    res[13]  = fma52hi(res[13], a[3], a[9]);    // Sum(12)
    res[13]  = fma52lo(res[13], a[4], a[9]);    // Sum(13)
    res[14]  = fma52hi(res[14], a[4], a[9]);    // Sum(13)
    res[14]  = fma52lo(res[14], a[5], a[9]);    // Sum(14)
    res[15]  = fma52hi(res[15], a[5], a[9]);    // Sum(14)
    res[15]  = fma52lo(res[15], a[6], a[9]);    // Sum(15)
    res[16]  = fma52hi(res[16], a[6], a[9]);    // Sum(15)
    res[16]  = fma52lo(res[16], a[7], a[9]);    // Sum(16)
    res[17]  = fma52hi(res[17], a[7], a[9]);    // Sum(16)
    res[17]  = fma52lo(res[17], a[8], a[9]);    // Sum(17)
    res[18]  = fma52hi(res[18], a[8], a[9]);    // Sum(17)
    res[12]  = fma52lo(res[12], a[2], a[10]);   // Sum(12)
    res[13]  = fma52hi(res[13], a[2], a[10]);   // Sum(12)
    res[13]  = fma52lo(res[13], a[3], a[10]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[3], a[10]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[4], a[10]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[4], a[10]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[5], a[10]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[5], a[10]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[6], a[10]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[6], a[10]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[7], a[10]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[7], a[10]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[8], a[10]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[8], a[10]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[9], a[10]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[9], a[10]);   // Sum(19)
    res[12]  = fma52lo(res[12], a[1], a[11]);   // Sum(12)
    res[13]  = fma52hi(res[13], a[1], a[11]);   // Sum(12)
    res[13]  = fma52lo(res[13], a[2], a[11]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[2], a[11]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[3], a[11]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[3], a[11]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[4], a[11]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[4], a[11]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[5], a[11]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[5], a[11]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[6], a[11]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[6], a[11]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[7], a[11]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[7], a[11]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[8], a[11]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[8], a[11]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[9], a[11]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[9], a[11]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[10], a[11]);  // Sum(21)
    res[22]  = fma52hi(res[22], a[10], a[11]);  // Sum(21)
    res[12]  = fma52lo(res[12], a[0], a[12]);   // Sum(12)
    res[13]  = fma52hi(res[13], a[0], a[12]);   // Sum(12)
    res[13]  = fma52lo(res[13], a[1], a[12]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[1], a[12]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[2], a[12]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[2], a[12]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[3], a[12]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[3], a[12]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[4], a[12]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[4], a[12]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[5], a[12]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[5], a[12]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[6], a[12]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[6], a[12]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[7], a[12]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[7], a[12]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[8], a[12]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[8], a[12]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[9], a[12]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[9], a[12]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[10], a[12]);  // Sum(22)
    res[23]  = fma52hi(res[23], a[10], a[12]);  // Sum(22)
    res[23]  = fma52lo(res[23], a[11], a[12]);  // Sum(23)
    res[24]  = fma52hi(res[24], a[11], a[12]);  // Sum(23)
    res[13]  = fma52lo(res[13], a[0], a[13]);   // Sum(13)
    res[14]  = fma52hi(res[14], a[0], a[13]);   // Sum(13)
    res[14]  = fma52lo(res[14], a[1], a[13]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[1], a[13]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[2], a[13]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[2], a[13]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[3], a[13]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[3], a[13]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[4], a[13]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[4], a[13]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[5], a[13]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[5], a[13]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[6], a[13]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[6], a[13]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[7], a[13]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[7], a[13]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[8], a[13]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[8], a[13]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[9], a[13]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[9], a[13]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[10], a[13]);  // Sum(23)
    res[24]  = fma52hi(res[24], a[10], a[13]);  // Sum(23)
    res[14]  = fma52lo(res[14], a[0], a[14]);   // Sum(14)
    res[15]  = fma52hi(res[15], a[0], a[14]);   // Sum(14)
    res[15]  = fma52lo(res[15], a[1], a[14]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[1], a[14]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[2], a[14]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[2], a[14]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[3], a[14]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[3], a[14]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[4], a[14]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[4], a[14]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[5], a[14]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[5], a[14]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[6], a[14]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[6], a[14]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[7], a[14]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[7], a[14]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[8], a[14]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[8], a[14]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[9], a[14]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[9], a[14]);   // Sum(23)
    res[15]  = fma52lo(res[15], a[0], a[15]);   // Sum(15)
    res[16]  = fma52hi(res[16], a[0], a[15]);   // Sum(15)
    res[16]  = fma52lo(res[16], a[1], a[15]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[1], a[15]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[2], a[15]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[2], a[15]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[3], a[15]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[3], a[15]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[4], a[15]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[4], a[15]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[5], a[15]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[5], a[15]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[6], a[15]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[6], a[15]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[7], a[15]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[7], a[15]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[8], a[15]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[8], a[15]);   // Sum(23)
    res[16]  = fma52lo(res[16], a[0], a[16]);   // Sum(16)
    res[17]  = fma52hi(res[17], a[0], a[16]);   // Sum(16)
    res[17]  = fma52lo(res[17], a[1], a[16]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[1], a[16]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[2], a[16]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[2], a[16]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[3], a[16]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[3], a[16]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[4], a[16]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[4], a[16]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[5], a[16]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[5], a[16]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[6], a[16]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[6], a[16]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[7], a[16]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[7], a[16]);   // Sum(23)
    res[17]  = fma52lo(res[17], a[0], a[17]);   // Sum(17)
    res[18]  = fma52hi(res[18], a[0], a[17]);   // Sum(17)
    res[18]  = fma52lo(res[18], a[1], a[17]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[1], a[17]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[2], a[17]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[2], a[17]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[3], a[17]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[3], a[17]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[4], a[17]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[4], a[17]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[5], a[17]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[5], a[17]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[6], a[17]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[6], a[17]);   // Sum(23)
    res[18]  = fma52lo(res[18], a[0], a[18]);   // Sum(18)
    res[19]  = fma52hi(res[19], a[0], a[18]);   // Sum(18)
    res[19]  = fma52lo(res[19], a[1], a[18]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[1], a[18]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[2], a[18]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[2], a[18]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[3], a[18]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[3], a[18]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[4], a[18]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[4], a[18]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[5], a[18]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[5], a[18]);   // Sum(23)
    res[19]  = fma52lo(res[19], a[0], a[19]);   // Sum(19)
    res[20]  = fma52hi(res[20], a[0], a[19]);   // Sum(19)
    res[20]  = fma52lo(res[20], a[1], a[19]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[1], a[19]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[2], a[19]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[2], a[19]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[3], a[19]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[3], a[19]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[4], a[19]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[4], a[19]);   // Sum(23)
    res[20]  = fma52lo(res[20], a[0], a[20]);   // Sum(20)
    res[21]  = fma52hi(res[21], a[0], a[20]);   // Sum(20)
    res[21]  = fma52lo(res[21], a[1], a[20]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[1], a[20]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[2], a[20]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[2], a[20]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[3], a[20]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[3], a[20]);   // Sum(23)
    res[21]  = fma52lo(res[21], a[0], a[21]);   // Sum(21)
    res[22]  = fma52hi(res[22], a[0], a[21]);   // Sum(21)
    res[22]  = fma52lo(res[22], a[1], a[21]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[1], a[21]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[2], a[21]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[2], a[21]);   // Sum(23)
    res[22]  = fma52lo(res[22], a[0], a[22]);   // Sum(22)
    res[23]  = fma52hi(res[23], a[0], a[22]);   // Sum(22)
    res[23]  = fma52lo(res[23], a[1], a[22]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[1], a[22]);   // Sum(23)
    res[23]  = fma52lo(res[23], a[0], a[23]);   // Sum(23)
    res[24]  = fma52hi(res[24], a[0], a[23]);   // Sum(23)
    res[12]  = add64(res[12], res[12]);         // Double(12)
    res[13]  = add64(res[13], res[13]);         // Double(13)
    res[14]  = add64(res[14], res[14]);         // Double(14)
    res[15]  = add64(res[15], res[15]);         // Double(15)
    res[16]  = add64(res[16], res[16]);         // Double(16)
    res[17]  = add64(res[17], res[17]);         // Double(17)
    res[18]  = add64(res[18], res[18]);         // Double(18)
    res[19]  = add64(res[19], res[19]);         // Double(19)
    res[20]  = add64(res[20], res[20]);         // Double(20)
    res[21]  = add64(res[21], res[21]);         // Double(21)
    res[22]  = add64(res[22], res[22]);         // Double(22)
    res[23]  = add64(res[23], res[23]);         // Double(23)
    res[12]  = fma52lo(res[12], a[6], a[6]);    // Add sqr(12)
    res[13]  = fma52hi(res[13], a[6], a[6]);    // Add sqr(12)
    res[14]  = fma52lo(res[14], a[7], a[7]);    // Add sqr(14)
    res[15]  = fma52hi(res[15], a[7], a[7]);    // Add sqr(14)
    res[16]  = fma52lo(res[16], a[8], a[8]);    // Add sqr(16)
    res[17]  = fma52hi(res[17], a[8], a[8]);    // Add sqr(16)
    res[18]  = fma52lo(res[18], a[9], a[9]);    // Add sqr(18)
    res[19]  = fma52hi(res[19], a[9], a[9]);    // Add sqr(18)
    res[20]  = fma52lo(res[20], a[10], a[10]);  // Add sqr(20)
    res[21]  = fma52hi(res[21], a[10], a[10]);  // Add sqr(20)
    res[22]  = fma52lo(res[22], a[11], a[11]);  // Add sqr(22)
    res[23]  = fma52hi(res[23], a[11], a[11]);  // Add sqr(22)
    res[24]  = fma52lo(res[24], a[11], a[13]);  // Sum(24)
    res[25]  = fma52hi(res[25], a[11], a[13]);  // Sum(24)
    res[25]  = fma52lo(res[25], a[12], a[13]);  // Sum(25)
    res[26]  = fma52hi(res[26], a[12], a[13]);  // Sum(25)
    res[24]  = fma52lo(res[24], a[10], a[14]);  // Sum(24)
    res[25]  = fma52hi(res[25], a[10], a[14]);  // Sum(24)
    res[25]  = fma52lo(res[25], a[11], a[14]);  // Sum(25)
    res[26]  = fma52hi(res[26], a[11], a[14]);  // Sum(25)
    res[26]  = fma52lo(res[26], a[12], a[14]);  // Sum(26)
    res[27]  = fma52hi(res[27], a[12], a[14]);  // Sum(26)
    res[27]  = fma52lo(res[27], a[13], a[14]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[13], a[14]);  // Sum(27)
    res[24]  = fma52lo(res[24], a[9], a[15]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[9], a[15]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[10], a[15]);  // Sum(25)
    res[26]  = fma52hi(res[26], a[10], a[15]);  // Sum(25)
    res[26]  = fma52lo(res[26], a[11], a[15]);  // Sum(26)
    res[27]  = fma52hi(res[27], a[11], a[15]);  // Sum(26)
    res[27]  = fma52lo(res[27], a[12], a[15]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[12], a[15]);  // Sum(27)
    res[28]  = fma52lo(res[28], a[13], a[15]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[13], a[15]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[14], a[15]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[14], a[15]);  // Sum(29)
    res[24]  = fma52lo(res[24], a[8], a[16]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[8], a[16]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[9], a[16]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[9], a[16]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[10], a[16]);  // Sum(26)
    res[27]  = fma52hi(res[27], a[10], a[16]);  // Sum(26)
    res[27]  = fma52lo(res[27], a[11], a[16]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[11], a[16]);  // Sum(27)
    res[28]  = fma52lo(res[28], a[12], a[16]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[12], a[16]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[13], a[16]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[13], a[16]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[14], a[16]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[14], a[16]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[15], a[16]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[15], a[16]);  // Sum(31)
    res[24]  = fma52lo(res[24], a[7], a[17]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[7], a[17]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[8], a[17]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[8], a[17]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[9], a[17]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[9], a[17]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[10], a[17]);  // Sum(27)
    res[28]  = fma52hi(res[28], a[10], a[17]);  // Sum(27)
    res[28]  = fma52lo(res[28], a[11], a[17]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[11], a[17]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[12], a[17]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[12], a[17]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[13], a[17]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[13], a[17]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[14], a[17]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[14], a[17]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[15], a[17]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[15], a[17]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[16], a[17]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[16], a[17]);  // Sum(33)
    res[24]  = fma52lo(res[24], a[6], a[18]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[6], a[18]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[7], a[18]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[7], a[18]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[8], a[18]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[8], a[18]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[9], a[18]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[9], a[18]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[10], a[18]);  // Sum(28)
    res[29]  = fma52hi(res[29], a[10], a[18]);  // Sum(28)
    res[29]  = fma52lo(res[29], a[11], a[18]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[11], a[18]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[12], a[18]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[12], a[18]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[13], a[18]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[13], a[18]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[14], a[18]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[14], a[18]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[15], a[18]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[15], a[18]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[16], a[18]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[16], a[18]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[17], a[18]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[17], a[18]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[5], a[19]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[5], a[19]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[6], a[19]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[6], a[19]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[7], a[19]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[7], a[19]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[8], a[19]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[8], a[19]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[9], a[19]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[9], a[19]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[10], a[19]);  // Sum(29)
    res[30]  = fma52hi(res[30], a[10], a[19]);  // Sum(29)
    res[30]  = fma52lo(res[30], a[11], a[19]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[11], a[19]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[12], a[19]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[12], a[19]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[13], a[19]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[13], a[19]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[14], a[19]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[14], a[19]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[15], a[19]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[15], a[19]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[16], a[19]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[16], a[19]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[4], a[20]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[4], a[20]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[5], a[20]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[5], a[20]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[6], a[20]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[6], a[20]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[7], a[20]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[7], a[20]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[8], a[20]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[8], a[20]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[9], a[20]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[9], a[20]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[10], a[20]);  // Sum(30)
    res[31]  = fma52hi(res[31], a[10], a[20]);  // Sum(30)
    res[31]  = fma52lo(res[31], a[11], a[20]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[11], a[20]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[12], a[20]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[12], a[20]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[13], a[20]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[13], a[20]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[14], a[20]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[14], a[20]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[15], a[20]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[15], a[20]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[3], a[21]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[3], a[21]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[4], a[21]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[4], a[21]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[5], a[21]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[5], a[21]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[6], a[21]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[6], a[21]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[7], a[21]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[7], a[21]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[8], a[21]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[8], a[21]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[9], a[21]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[9], a[21]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[10], a[21]);  // Sum(31)
    res[32]  = fma52hi(res[32], a[10], a[21]);  // Sum(31)
    res[32]  = fma52lo(res[32], a[11], a[21]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[11], a[21]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[12], a[21]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[12], a[21]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[13], a[21]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[13], a[21]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[14], a[21]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[14], a[21]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[2], a[22]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[2], a[22]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[3], a[22]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[3], a[22]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[4], a[22]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[4], a[22]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[5], a[22]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[5], a[22]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[6], a[22]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[6], a[22]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[7], a[22]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[7], a[22]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[8], a[22]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[8], a[22]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[9], a[22]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[9], a[22]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[10], a[22]);  // Sum(32)
    res[33]  = fma52hi(res[33], a[10], a[22]);  // Sum(32)
    res[33]  = fma52lo(res[33], a[11], a[22]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[11], a[22]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[12], a[22]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[12], a[22]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[13], a[22]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[13], a[22]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[1], a[23]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[1], a[23]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[2], a[23]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[2], a[23]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[3], a[23]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[3], a[23]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[4], a[23]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[4], a[23]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[5], a[23]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[5], a[23]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[6], a[23]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[6], a[23]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[7], a[23]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[7], a[23]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[8], a[23]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[8], a[23]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[9], a[23]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[9], a[23]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[10], a[23]);  // Sum(33)
    res[34]  = fma52hi(res[34], a[10], a[23]);  // Sum(33)
    res[34]  = fma52lo(res[34], a[11], a[23]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[11], a[23]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[12], a[23]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[12], a[23]);  // Sum(35)
    res[24]  = fma52lo(res[24], a[0], a[24]);   // Sum(24)
    res[25]  = fma52hi(res[25], a[0], a[24]);   // Sum(24)
    res[25]  = fma52lo(res[25], a[1], a[24]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[1], a[24]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[2], a[24]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[2], a[24]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[3], a[24]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[3], a[24]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[4], a[24]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[4], a[24]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[5], a[24]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[5], a[24]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[6], a[24]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[6], a[24]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[7], a[24]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[7], a[24]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[8], a[24]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[8], a[24]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[9], a[24]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[9], a[24]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[10], a[24]);  // Sum(34)
    res[35]  = fma52hi(res[35], a[10], a[24]);  // Sum(34)
    res[35]  = fma52lo(res[35], a[11], a[24]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[11], a[24]);  // Sum(35)
    res[25]  = fma52lo(res[25], a[0], a[25]);   // Sum(25)
    res[26]  = fma52hi(res[26], a[0], a[25]);   // Sum(25)
    res[26]  = fma52lo(res[26], a[1], a[25]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[1], a[25]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[2], a[25]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[2], a[25]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[3], a[25]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[3], a[25]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[4], a[25]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[4], a[25]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[5], a[25]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[5], a[25]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[6], a[25]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[6], a[25]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[7], a[25]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[7], a[25]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[8], a[25]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[8], a[25]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[9], a[25]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[9], a[25]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[10], a[25]);  // Sum(35)
    res[36]  = fma52hi(res[36], a[10], a[25]);  // Sum(35)
    res[26]  = fma52lo(res[26], a[0], a[26]);   // Sum(26)
    res[27]  = fma52hi(res[27], a[0], a[26]);   // Sum(26)
    res[27]  = fma52lo(res[27], a[1], a[26]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[1], a[26]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[2], a[26]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[2], a[26]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[3], a[26]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[3], a[26]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[4], a[26]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[4], a[26]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[5], a[26]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[5], a[26]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[6], a[26]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[6], a[26]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[7], a[26]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[7], a[26]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[8], a[26]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[8], a[26]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[9], a[26]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[9], a[26]);   // Sum(35)
    res[27]  = fma52lo(res[27], a[0], a[27]);   // Sum(27)
    res[28]  = fma52hi(res[28], a[0], a[27]);   // Sum(27)
    res[28]  = fma52lo(res[28], a[1], a[27]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[1], a[27]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[2], a[27]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[2], a[27]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[3], a[27]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[3], a[27]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[4], a[27]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[4], a[27]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[5], a[27]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[5], a[27]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[6], a[27]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[6], a[27]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[7], a[27]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[7], a[27]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[8], a[27]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[8], a[27]);   // Sum(35)
    res[28]  = fma52lo(res[28], a[0], a[28]);   // Sum(28)
    res[29]  = fma52hi(res[29], a[0], a[28]);   // Sum(28)
    res[29]  = fma52lo(res[29], a[1], a[28]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[1], a[28]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[2], a[28]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[2], a[28]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[3], a[28]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[3], a[28]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[4], a[28]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[4], a[28]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[5], a[28]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[5], a[28]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[6], a[28]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[6], a[28]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[7], a[28]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[7], a[28]);   // Sum(35)
    res[29]  = fma52lo(res[29], a[0], a[29]);   // Sum(29)
    res[30]  = fma52hi(res[30], a[0], a[29]);   // Sum(29)
    res[30]  = fma52lo(res[30], a[1], a[29]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[1], a[29]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[2], a[29]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[2], a[29]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[3], a[29]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[3], a[29]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[4], a[29]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[4], a[29]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[5], a[29]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[5], a[29]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[6], a[29]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[6], a[29]);   // Sum(35)
    res[30]  = fma52lo(res[30], a[0], a[30]);   // Sum(30)
    res[31]  = fma52hi(res[31], a[0], a[30]);   // Sum(30)
    res[31]  = fma52lo(res[31], a[1], a[30]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[1], a[30]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[2], a[30]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[2], a[30]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[3], a[30]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[3], a[30]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[4], a[30]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[4], a[30]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[5], a[30]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[5], a[30]);   // Sum(35)
    res[31]  = fma52lo(res[31], a[0], a[31]);   // Sum(31)
    res[32]  = fma52hi(res[32], a[0], a[31]);   // Sum(31)
    res[32]  = fma52lo(res[32], a[1], a[31]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[1], a[31]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[2], a[31]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[2], a[31]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[3], a[31]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[3], a[31]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[4], a[31]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[4], a[31]);   // Sum(35)
    res[32]  = fma52lo(res[32], a[0], a[32]);   // Sum(32)
    res[33]  = fma52hi(res[33], a[0], a[32]);   // Sum(32)
    res[33]  = fma52lo(res[33], a[1], a[32]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[1], a[32]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[2], a[32]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[2], a[32]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[3], a[32]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[3], a[32]);   // Sum(35)
    res[33]  = fma52lo(res[33], a[0], a[33]);   // Sum(33)
    res[34]  = fma52hi(res[34], a[0], a[33]);   // Sum(33)
    res[34]  = fma52lo(res[34], a[1], a[33]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[1], a[33]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[2], a[33]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[2], a[33]);   // Sum(35)
    res[34]  = fma52lo(res[34], a[0], a[34]);   // Sum(34)
    res[35]  = fma52hi(res[35], a[0], a[34]);   // Sum(34)
    res[35]  = fma52lo(res[35], a[1], a[34]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[1], a[34]);   // Sum(35)
    res[35]  = fma52lo(res[35], a[0], a[35]);   // Sum(35)
    res[36]  = fma52hi(res[36], a[0], a[35]);   // Sum(35)
    res[24]  = add64(res[24], res[24]);         // Double(24)
    res[25]  = add64(res[25], res[25]);         // Double(25)
    res[26]  = add64(res[26], res[26]);         // Double(26)
    res[27]  = add64(res[27], res[27]);         // Double(27)
    res[28]  = add64(res[28], res[28]);         // Double(28)
    res[29]  = add64(res[29], res[29]);         // Double(29)
    res[30]  = add64(res[30], res[30]);         // Double(30)
    res[31]  = add64(res[31], res[31]);         // Double(31)
    res[32]  = add64(res[32], res[32]);         // Double(32)
    res[33]  = add64(res[33], res[33]);         // Double(33)
    res[34]  = add64(res[34], res[34]);         // Double(34)
    res[35]  = add64(res[35], res[35]);         // Double(35)
    res[24]  = fma52lo(res[24], a[12], a[12]);  // Add sqr(24)
    res[25]  = fma52hi(res[25], a[12], a[12]);  // Add sqr(24)
    res[26]  = fma52lo(res[26], a[13], a[13]);  // Add sqr(26)
    res[27]  = fma52hi(res[27], a[13], a[13]);  // Add sqr(26)
    res[28]  = fma52lo(res[28], a[14], a[14]);  // Add sqr(28)
    res[29]  = fma52hi(res[29], a[14], a[14]);  // Add sqr(28)
    res[30]  = fma52lo(res[30], a[15], a[15]);  // Add sqr(30)
    res[31]  = fma52hi(res[31], a[15], a[15]);  // Add sqr(30)
    res[32]  = fma52lo(res[32], a[16], a[16]);  // Add sqr(32)
    res[33]  = fma52hi(res[33], a[16], a[16]);  // Add sqr(32)
    res[34]  = fma52lo(res[34], a[17], a[17]);  // Add sqr(34)
    res[35]  = fma52hi(res[35], a[17], a[17]);  // Add sqr(34)
    res[36]  = fma52lo(res[36], a[17], a[19]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[17], a[19]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[18], a[19]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[18], a[19]);  // Sum(37)
    res[36]  = fma52lo(res[36], a[16], a[20]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[16], a[20]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[17], a[20]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[17], a[20]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[18], a[20]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[18], a[20]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[19], a[20]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[19], a[20]);  // Sum(39)
    res[36]  = fma52lo(res[36], a[15], a[21]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[15], a[21]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[16], a[21]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[16], a[21]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[17], a[21]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[17], a[21]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[18], a[21]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[18], a[21]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[19], a[21]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[19], a[21]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[20], a[21]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[20], a[21]);  // Sum(41)
    res[36]  = fma52lo(res[36], a[14], a[22]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[14], a[22]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[15], a[22]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[15], a[22]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[16], a[22]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[16], a[22]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[17], a[22]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[17], a[22]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[18], a[22]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[18], a[22]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[19], a[22]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[19], a[22]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[20], a[22]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[20], a[22]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[21], a[22]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[21], a[22]);  // Sum(43)
    res[36]  = fma52lo(res[36], a[13], a[23]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[13], a[23]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[14], a[23]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[14], a[23]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[15], a[23]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[15], a[23]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[16], a[23]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[16], a[23]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[17], a[23]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[17], a[23]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[18], a[23]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[18], a[23]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[19], a[23]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[19], a[23]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[20], a[23]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[20], a[23]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[21], a[23]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[21], a[23]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[22], a[23]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[22], a[23]);  // Sum(45)
    res[36]  = fma52lo(res[36], a[12], a[24]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[12], a[24]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[13], a[24]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[13], a[24]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[14], a[24]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[14], a[24]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[15], a[24]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[15], a[24]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[16], a[24]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[16], a[24]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[17], a[24]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[17], a[24]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[18], a[24]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[18], a[24]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[19], a[24]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[19], a[24]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[20], a[24]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[20], a[24]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[21], a[24]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[21], a[24]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[22], a[24]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[22], a[24]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[23], a[24]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[23], a[24]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[11], a[25]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[11], a[25]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[12], a[25]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[12], a[25]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[13], a[25]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[13], a[25]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[14], a[25]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[14], a[25]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[15], a[25]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[15], a[25]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[16], a[25]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[16], a[25]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[17], a[25]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[17], a[25]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[18], a[25]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[18], a[25]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[19], a[25]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[19], a[25]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[20], a[25]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[20], a[25]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[21], a[25]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[21], a[25]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[22], a[25]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[22], a[25]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[10], a[26]);  // Sum(36)
    res[37]  = fma52hi(res[37], a[10], a[26]);  // Sum(36)
    res[37]  = fma52lo(res[37], a[11], a[26]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[11], a[26]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[12], a[26]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[12], a[26]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[13], a[26]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[13], a[26]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[14], a[26]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[14], a[26]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[15], a[26]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[15], a[26]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[16], a[26]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[16], a[26]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[17], a[26]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[17], a[26]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[18], a[26]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[18], a[26]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[19], a[26]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[19], a[26]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[20], a[26]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[20], a[26]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[21], a[26]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[21], a[26]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[9], a[27]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[9], a[27]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[10], a[27]);  // Sum(37)
    res[38]  = fma52hi(res[38], a[10], a[27]);  // Sum(37)
    res[38]  = fma52lo(res[38], a[11], a[27]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[11], a[27]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[12], a[27]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[12], a[27]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[13], a[27]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[13], a[27]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[14], a[27]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[14], a[27]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[15], a[27]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[15], a[27]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[16], a[27]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[16], a[27]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[17], a[27]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[17], a[27]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[18], a[27]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[18], a[27]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[19], a[27]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[19], a[27]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[20], a[27]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[20], a[27]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[8], a[28]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[8], a[28]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[9], a[28]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[9], a[28]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[10], a[28]);  // Sum(38)
    res[39]  = fma52hi(res[39], a[10], a[28]);  // Sum(38)
    res[39]  = fma52lo(res[39], a[11], a[28]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[11], a[28]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[12], a[28]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[12], a[28]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[13], a[28]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[13], a[28]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[14], a[28]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[14], a[28]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[15], a[28]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[15], a[28]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[16], a[28]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[16], a[28]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[17], a[28]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[17], a[28]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[18], a[28]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[18], a[28]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[19], a[28]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[19], a[28]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[7], a[29]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[7], a[29]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[8], a[29]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[8], a[29]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[9], a[29]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[9], a[29]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[10], a[29]);  // Sum(39)
    res[40]  = fma52hi(res[40], a[10], a[29]);  // Sum(39)
    res[40]  = fma52lo(res[40], a[11], a[29]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[11], a[29]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[12], a[29]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[12], a[29]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[13], a[29]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[13], a[29]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[14], a[29]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[14], a[29]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[15], a[29]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[15], a[29]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[16], a[29]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[16], a[29]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[17], a[29]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[17], a[29]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[18], a[29]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[18], a[29]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[6], a[30]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[6], a[30]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[7], a[30]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[7], a[30]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[8], a[30]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[8], a[30]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[9], a[30]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[9], a[30]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[10], a[30]);  // Sum(40)
    res[41]  = fma52hi(res[41], a[10], a[30]);  // Sum(40)
    res[41]  = fma52lo(res[41], a[11], a[30]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[11], a[30]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[12], a[30]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[12], a[30]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[13], a[30]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[13], a[30]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[14], a[30]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[14], a[30]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[15], a[30]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[15], a[30]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[16], a[30]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[16], a[30]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[17], a[30]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[17], a[30]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[5], a[31]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[5], a[31]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[6], a[31]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[6], a[31]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[7], a[31]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[7], a[31]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[8], a[31]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[8], a[31]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[9], a[31]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[9], a[31]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[10], a[31]);  // Sum(41)
    res[42]  = fma52hi(res[42], a[10], a[31]);  // Sum(41)
    res[42]  = fma52lo(res[42], a[11], a[31]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[11], a[31]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[12], a[31]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[12], a[31]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[13], a[31]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[13], a[31]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[14], a[31]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[14], a[31]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[15], a[31]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[15], a[31]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[16], a[31]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[16], a[31]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[4], a[32]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[4], a[32]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[5], a[32]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[5], a[32]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[6], a[32]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[6], a[32]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[7], a[32]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[7], a[32]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[8], a[32]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[8], a[32]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[9], a[32]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[9], a[32]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[10], a[32]);  // Sum(42)
    res[43]  = fma52hi(res[43], a[10], a[32]);  // Sum(42)
    res[43]  = fma52lo(res[43], a[11], a[32]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[11], a[32]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[12], a[32]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[12], a[32]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[13], a[32]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[13], a[32]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[14], a[32]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[14], a[32]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[15], a[32]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[15], a[32]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[3], a[33]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[3], a[33]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[4], a[33]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[4], a[33]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[5], a[33]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[5], a[33]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[6], a[33]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[6], a[33]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[7], a[33]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[7], a[33]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[8], a[33]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[8], a[33]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[9], a[33]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[9], a[33]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[10], a[33]);  // Sum(43)
    res[44]  = fma52hi(res[44], a[10], a[33]);  // Sum(43)
    res[44]  = fma52lo(res[44], a[11], a[33]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[11], a[33]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[12], a[33]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[12], a[33]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[13], a[33]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[13], a[33]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[14], a[33]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[14], a[33]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[2], a[34]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[2], a[34]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[3], a[34]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[3], a[34]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[4], a[34]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[4], a[34]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[5], a[34]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[5], a[34]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[6], a[34]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[6], a[34]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[7], a[34]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[7], a[34]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[8], a[34]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[8], a[34]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[9], a[34]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[9], a[34]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[10], a[34]);  // Sum(44)
    res[45]  = fma52hi(res[45], a[10], a[34]);  // Sum(44)
    res[45]  = fma52lo(res[45], a[11], a[34]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[11], a[34]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[12], a[34]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[12], a[34]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[13], a[34]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[13], a[34]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[1], a[35]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[1], a[35]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[2], a[35]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[2], a[35]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[3], a[35]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[3], a[35]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[4], a[35]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[4], a[35]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[5], a[35]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[5], a[35]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[6], a[35]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[6], a[35]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[7], a[35]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[7], a[35]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[8], a[35]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[8], a[35]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[9], a[35]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[9], a[35]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[10], a[35]);  // Sum(45)
    res[46]  = fma52hi(res[46], a[10], a[35]);  // Sum(45)
    res[46]  = fma52lo(res[46], a[11], a[35]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[11], a[35]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[12], a[35]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[12], a[35]);  // Sum(47)
    res[36]  = fma52lo(res[36], a[0], a[36]);   // Sum(36)
    res[37]  = fma52hi(res[37], a[0], a[36]);   // Sum(36)
    res[37]  = fma52lo(res[37], a[1], a[36]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[1], a[36]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[2], a[36]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[2], a[36]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[3], a[36]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[3], a[36]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[4], a[36]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[4], a[36]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[5], a[36]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[5], a[36]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[6], a[36]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[6], a[36]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[7], a[36]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[7], a[36]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[8], a[36]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[8], a[36]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[9], a[36]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[9], a[36]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[10], a[36]);  // Sum(46)
    res[47]  = fma52hi(res[47], a[10], a[36]);  // Sum(46)
    res[47]  = fma52lo(res[47], a[11], a[36]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[11], a[36]);  // Sum(47)
    res[37]  = fma52lo(res[37], a[0], a[37]);   // Sum(37)
    res[38]  = fma52hi(res[38], a[0], a[37]);   // Sum(37)
    res[38]  = fma52lo(res[38], a[1], a[37]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[1], a[37]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[2], a[37]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[2], a[37]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[3], a[37]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[3], a[37]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[4], a[37]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[4], a[37]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[5], a[37]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[5], a[37]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[6], a[37]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[6], a[37]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[7], a[37]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[7], a[37]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[8], a[37]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[8], a[37]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[9], a[37]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[9], a[37]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[10], a[37]);  // Sum(47)
    res[48]  = fma52hi(res[48], a[10], a[37]);  // Sum(47)
    res[38]  = fma52lo(res[38], a[0], a[38]);   // Sum(38)
    res[39]  = fma52hi(res[39], a[0], a[38]);   // Sum(38)
    res[39]  = fma52lo(res[39], a[1], a[38]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[1], a[38]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[2], a[38]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[2], a[38]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[3], a[38]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[3], a[38]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[4], a[38]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[4], a[38]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[5], a[38]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[5], a[38]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[6], a[38]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[6], a[38]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[7], a[38]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[7], a[38]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[8], a[38]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[8], a[38]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[9], a[38]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[9], a[38]);   // Sum(47)
    res[39]  = fma52lo(res[39], a[0], a[39]);   // Sum(39)
    res[40]  = fma52hi(res[40], a[0], a[39]);   // Sum(39)
    res[40]  = fma52lo(res[40], a[1], a[39]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[1], a[39]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[2], a[39]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[2], a[39]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[3], a[39]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[3], a[39]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[4], a[39]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[4], a[39]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[5], a[39]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[5], a[39]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[6], a[39]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[6], a[39]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[7], a[39]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[7], a[39]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[8], a[39]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[8], a[39]);   // Sum(47)
    res[40]  = fma52lo(res[40], a[0], a[40]);   // Sum(40)
    res[41]  = fma52hi(res[41], a[0], a[40]);   // Sum(40)
    res[41]  = fma52lo(res[41], a[1], a[40]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[1], a[40]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[2], a[40]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[2], a[40]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[3], a[40]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[3], a[40]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[4], a[40]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[4], a[40]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[5], a[40]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[5], a[40]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[6], a[40]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[6], a[40]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[7], a[40]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[7], a[40]);   // Sum(47)
    res[41]  = fma52lo(res[41], a[0], a[41]);   // Sum(41)
    res[42]  = fma52hi(res[42], a[0], a[41]);   // Sum(41)
    res[42]  = fma52lo(res[42], a[1], a[41]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[1], a[41]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[2], a[41]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[2], a[41]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[3], a[41]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[3], a[41]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[4], a[41]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[4], a[41]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[5], a[41]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[5], a[41]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[6], a[41]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[6], a[41]);   // Sum(47)
    res[42]  = fma52lo(res[42], a[0], a[42]);   // Sum(42)
    res[43]  = fma52hi(res[43], a[0], a[42]);   // Sum(42)
    res[43]  = fma52lo(res[43], a[1], a[42]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[1], a[42]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[2], a[42]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[2], a[42]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[3], a[42]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[3], a[42]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[4], a[42]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[4], a[42]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[5], a[42]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[5], a[42]);   // Sum(47)
    res[43]  = fma52lo(res[43], a[0], a[43]);   // Sum(43)
    res[44]  = fma52hi(res[44], a[0], a[43]);   // Sum(43)
    res[44]  = fma52lo(res[44], a[1], a[43]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[1], a[43]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[2], a[43]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[2], a[43]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[3], a[43]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[3], a[43]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[4], a[43]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[4], a[43]);   // Sum(47)
    res[44]  = fma52lo(res[44], a[0], a[44]);   // Sum(44)
    res[45]  = fma52hi(res[45], a[0], a[44]);   // Sum(44)
    res[45]  = fma52lo(res[45], a[1], a[44]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[1], a[44]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[2], a[44]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[2], a[44]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[3], a[44]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[3], a[44]);   // Sum(47)
    res[45]  = fma52lo(res[45], a[0], a[45]);   // Sum(45)
    res[46]  = fma52hi(res[46], a[0], a[45]);   // Sum(45)
    res[46]  = fma52lo(res[46], a[1], a[45]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[1], a[45]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[2], a[45]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[2], a[45]);   // Sum(47)
    res[46]  = fma52lo(res[46], a[0], a[46]);   // Sum(46)
    res[47]  = fma52hi(res[47], a[0], a[46]);   // Sum(46)
    res[47]  = fma52lo(res[47], a[1], a[46]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[1], a[46]);   // Sum(47)
    res[47]  = fma52lo(res[47], a[0], a[47]);   // Sum(47)
    res[48]  = fma52hi(res[48], a[0], a[47]);   // Sum(47)
    res[36]  = add64(res[36], res[36]);         // Double(36)
    res[37]  = add64(res[37], res[37]);         // Double(37)
    res[38]  = add64(res[38], res[38]);         // Double(38)
    res[39]  = add64(res[39], res[39]);         // Double(39)
    res[40]  = add64(res[40], res[40]);         // Double(40)
    res[41]  = add64(res[41], res[41]);         // Double(41)
    res[42]  = add64(res[42], res[42]);         // Double(42)
    res[43]  = add64(res[43], res[43]);         // Double(43)
    res[44]  = add64(res[44], res[44]);         // Double(44)
    res[45]  = add64(res[45], res[45]);         // Double(45)
    res[46]  = add64(res[46], res[46]);         // Double(46)
    res[47]  = add64(res[47], res[47]);         // Double(47)
    res[36]  = fma52lo(res[36], a[18], a[18]);  // Add sqr(36)
    res[37]  = fma52hi(res[37], a[18], a[18]);  // Add sqr(36)
    res[38]  = fma52lo(res[38], a[19], a[19]);  // Add sqr(38)
    res[39]  = fma52hi(res[39], a[19], a[19]);  // Add sqr(38)
    res[40]  = fma52lo(res[40], a[20], a[20]);  // Add sqr(40)
    res[41]  = fma52hi(res[41], a[20], a[20]);  // Add sqr(40)
    res[42]  = fma52lo(res[42], a[21], a[21]);  // Add sqr(42)
    res[43]  = fma52hi(res[43], a[21], a[21]);  // Add sqr(42)
    res[44]  = fma52lo(res[44], a[22], a[22]);  // Add sqr(44)
    res[45]  = fma52hi(res[45], a[22], a[22]);  // Add sqr(44)
    res[46]  = fma52lo(res[46], a[23], a[23]);  // Add sqr(46)
    res[47]  = fma52hi(res[47], a[23], a[23]);  // Add sqr(46)
    res[48]  = fma52lo(res[48], a[23], a[25]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[23], a[25]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[24], a[25]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[24], a[25]);  // Sum(49)
    res[48]  = fma52lo(res[48], a[22], a[26]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[22], a[26]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[23], a[26]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[23], a[26]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[24], a[26]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[24], a[26]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[25], a[26]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[25], a[26]);  // Sum(51)
    res[48]  = fma52lo(res[48], a[21], a[27]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[21], a[27]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[22], a[27]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[22], a[27]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[23], a[27]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[23], a[27]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[24], a[27]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[24], a[27]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[25], a[27]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[25], a[27]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[26], a[27]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[26], a[27]);  // Sum(53)
    res[48]  = fma52lo(res[48], a[20], a[28]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[20], a[28]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[21], a[28]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[21], a[28]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[22], a[28]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[22], a[28]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[23], a[28]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[23], a[28]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[24], a[28]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[24], a[28]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[25], a[28]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[25], a[28]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[26], a[28]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[26], a[28]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[27], a[28]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[27], a[28]);  // Sum(55)
    res[48]  = fma52lo(res[48], a[19], a[29]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[19], a[29]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[20], a[29]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[20], a[29]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[21], a[29]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[21], a[29]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[22], a[29]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[22], a[29]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[23], a[29]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[23], a[29]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[24], a[29]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[24], a[29]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[25], a[29]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[25], a[29]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[26], a[29]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[26], a[29]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[27], a[29]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[27], a[29]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[28], a[29]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[28], a[29]);  // Sum(57)
    res[48]  = fma52lo(res[48], a[18], a[30]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[18], a[30]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[19], a[30]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[19], a[30]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[20], a[30]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[20], a[30]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[21], a[30]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[21], a[30]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[22], a[30]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[22], a[30]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[23], a[30]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[23], a[30]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[24], a[30]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[24], a[30]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[25], a[30]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[25], a[30]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[26], a[30]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[26], a[30]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[27], a[30]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[27], a[30]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[28], a[30]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[28], a[30]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[29], a[30]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[29], a[30]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[17], a[31]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[17], a[31]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[18], a[31]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[18], a[31]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[19], a[31]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[19], a[31]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[20], a[31]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[20], a[31]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[21], a[31]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[21], a[31]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[22], a[31]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[22], a[31]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[23], a[31]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[23], a[31]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[24], a[31]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[24], a[31]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[25], a[31]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[25], a[31]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[26], a[31]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[26], a[31]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[27], a[31]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[27], a[31]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[28], a[31]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[28], a[31]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[16], a[32]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[16], a[32]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[17], a[32]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[17], a[32]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[18], a[32]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[18], a[32]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[19], a[32]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[19], a[32]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[20], a[32]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[20], a[32]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[21], a[32]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[21], a[32]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[22], a[32]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[22], a[32]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[23], a[32]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[23], a[32]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[24], a[32]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[24], a[32]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[25], a[32]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[25], a[32]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[26], a[32]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[26], a[32]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[27], a[32]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[27], a[32]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[15], a[33]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[15], a[33]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[16], a[33]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[16], a[33]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[17], a[33]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[17], a[33]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[18], a[33]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[18], a[33]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[19], a[33]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[19], a[33]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[20], a[33]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[20], a[33]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[21], a[33]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[21], a[33]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[22], a[33]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[22], a[33]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[23], a[33]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[23], a[33]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[24], a[33]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[24], a[33]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[25], a[33]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[25], a[33]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[26], a[33]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[26], a[33]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[14], a[34]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[14], a[34]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[15], a[34]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[15], a[34]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[16], a[34]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[16], a[34]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[17], a[34]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[17], a[34]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[18], a[34]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[18], a[34]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[19], a[34]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[19], a[34]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[20], a[34]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[20], a[34]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[21], a[34]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[21], a[34]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[22], a[34]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[22], a[34]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[23], a[34]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[23], a[34]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[24], a[34]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[24], a[34]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[25], a[34]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[25], a[34]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[13], a[35]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[13], a[35]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[14], a[35]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[14], a[35]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[15], a[35]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[15], a[35]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[16], a[35]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[16], a[35]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[17], a[35]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[17], a[35]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[18], a[35]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[18], a[35]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[19], a[35]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[19], a[35]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[20], a[35]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[20], a[35]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[21], a[35]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[21], a[35]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[22], a[35]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[22], a[35]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[23], a[35]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[23], a[35]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[24], a[35]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[24], a[35]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[12], a[36]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[12], a[36]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[13], a[36]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[13], a[36]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[14], a[36]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[14], a[36]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[15], a[36]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[15], a[36]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[16], a[36]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[16], a[36]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[17], a[36]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[17], a[36]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[18], a[36]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[18], a[36]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[19], a[36]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[19], a[36]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[20], a[36]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[20], a[36]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[21], a[36]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[21], a[36]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[22], a[36]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[22], a[36]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[23], a[36]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[23], a[36]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[11], a[37]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[11], a[37]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[12], a[37]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[12], a[37]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[13], a[37]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[13], a[37]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[14], a[37]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[14], a[37]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[15], a[37]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[15], a[37]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[16], a[37]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[16], a[37]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[17], a[37]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[17], a[37]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[18], a[37]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[18], a[37]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[19], a[37]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[19], a[37]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[20], a[37]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[20], a[37]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[21], a[37]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[21], a[37]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[22], a[37]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[22], a[37]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[10], a[38]);  // Sum(48)
    res[49]  = fma52hi(res[49], a[10], a[38]);  // Sum(48)
    res[49]  = fma52lo(res[49], a[11], a[38]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[11], a[38]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[12], a[38]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[12], a[38]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[13], a[38]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[13], a[38]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[14], a[38]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[14], a[38]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[15], a[38]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[15], a[38]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[16], a[38]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[16], a[38]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[17], a[38]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[17], a[38]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[18], a[38]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[18], a[38]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[19], a[38]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[19], a[38]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[20], a[38]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[20], a[38]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[21], a[38]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[21], a[38]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[9], a[39]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[9], a[39]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[10], a[39]);  // Sum(49)
    res[50]  = fma52hi(res[50], a[10], a[39]);  // Sum(49)
    res[50]  = fma52lo(res[50], a[11], a[39]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[11], a[39]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[12], a[39]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[12], a[39]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[13], a[39]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[13], a[39]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[14], a[39]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[14], a[39]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[15], a[39]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[15], a[39]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[16], a[39]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[16], a[39]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[17], a[39]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[17], a[39]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[18], a[39]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[18], a[39]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[19], a[39]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[19], a[39]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[20], a[39]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[20], a[39]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[8], a[40]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[8], a[40]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[9], a[40]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[9], a[40]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[10], a[40]);  // Sum(50)
    res[51]  = fma52hi(res[51], a[10], a[40]);  // Sum(50)
    res[51]  = fma52lo(res[51], a[11], a[40]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[11], a[40]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[12], a[40]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[12], a[40]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[13], a[40]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[13], a[40]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[14], a[40]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[14], a[40]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[15], a[40]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[15], a[40]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[16], a[40]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[16], a[40]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[17], a[40]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[17], a[40]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[18], a[40]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[18], a[40]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[19], a[40]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[19], a[40]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[7], a[41]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[7], a[41]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[8], a[41]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[8], a[41]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[9], a[41]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[9], a[41]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[10], a[41]);  // Sum(51)
    res[52]  = fma52hi(res[52], a[10], a[41]);  // Sum(51)
    res[52]  = fma52lo(res[52], a[11], a[41]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[11], a[41]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[12], a[41]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[12], a[41]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[13], a[41]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[13], a[41]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[14], a[41]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[14], a[41]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[15], a[41]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[15], a[41]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[16], a[41]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[16], a[41]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[17], a[41]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[17], a[41]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[18], a[41]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[18], a[41]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[6], a[42]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[6], a[42]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[7], a[42]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[7], a[42]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[8], a[42]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[8], a[42]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[9], a[42]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[9], a[42]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[10], a[42]);  // Sum(52)
    res[53]  = fma52hi(res[53], a[10], a[42]);  // Sum(52)
    res[53]  = fma52lo(res[53], a[11], a[42]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[11], a[42]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[12], a[42]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[12], a[42]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[13], a[42]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[13], a[42]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[14], a[42]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[14], a[42]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[15], a[42]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[15], a[42]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[16], a[42]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[16], a[42]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[17], a[42]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[17], a[42]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[5], a[43]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[5], a[43]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[6], a[43]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[6], a[43]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[7], a[43]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[7], a[43]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[8], a[43]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[8], a[43]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[9], a[43]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[9], a[43]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[10], a[43]);  // Sum(53)
    res[54]  = fma52hi(res[54], a[10], a[43]);  // Sum(53)
    res[54]  = fma52lo(res[54], a[11], a[43]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[11], a[43]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[12], a[43]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[12], a[43]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[13], a[43]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[13], a[43]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[14], a[43]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[14], a[43]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[15], a[43]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[15], a[43]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[16], a[43]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[16], a[43]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[4], a[44]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[4], a[44]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[5], a[44]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[5], a[44]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[6], a[44]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[6], a[44]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[7], a[44]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[7], a[44]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[8], a[44]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[8], a[44]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[9], a[44]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[9], a[44]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[10], a[44]);  // Sum(54)
    res[55]  = fma52hi(res[55], a[10], a[44]);  // Sum(54)
    res[55]  = fma52lo(res[55], a[11], a[44]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[11], a[44]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[12], a[44]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[12], a[44]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[13], a[44]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[13], a[44]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[14], a[44]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[14], a[44]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[15], a[44]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[15], a[44]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[3], a[45]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[3], a[45]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[4], a[45]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[4], a[45]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[5], a[45]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[5], a[45]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[6], a[45]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[6], a[45]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[7], a[45]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[7], a[45]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[8], a[45]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[8], a[45]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[9], a[45]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[9], a[45]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[10], a[45]);  // Sum(55)
    res[56]  = fma52hi(res[56], a[10], a[45]);  // Sum(55)
    res[56]  = fma52lo(res[56], a[11], a[45]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[11], a[45]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[12], a[45]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[12], a[45]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[13], a[45]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[13], a[45]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[14], a[45]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[14], a[45]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[2], a[46]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[2], a[46]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[3], a[46]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[3], a[46]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[4], a[46]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[4], a[46]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[5], a[46]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[5], a[46]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[6], a[46]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[6], a[46]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[7], a[46]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[7], a[46]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[8], a[46]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[8], a[46]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[9], a[46]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[9], a[46]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[10], a[46]);  // Sum(56)
    res[57]  = fma52hi(res[57], a[10], a[46]);  // Sum(56)
    res[57]  = fma52lo(res[57], a[11], a[46]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[11], a[46]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[12], a[46]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[12], a[46]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[13], a[46]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[13], a[46]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[1], a[47]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[1], a[47]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[2], a[47]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[2], a[47]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[3], a[47]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[3], a[47]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[4], a[47]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[4], a[47]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[5], a[47]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[5], a[47]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[6], a[47]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[6], a[47]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[7], a[47]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[7], a[47]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[8], a[47]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[8], a[47]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[9], a[47]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[9], a[47]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[10], a[47]);  // Sum(57)
    res[58]  = fma52hi(res[58], a[10], a[47]);  // Sum(57)
    res[58]  = fma52lo(res[58], a[11], a[47]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[11], a[47]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[12], a[47]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[12], a[47]);  // Sum(59)
    res[48]  = fma52lo(res[48], a[0], a[48]);   // Sum(48)
    res[49]  = fma52hi(res[49], a[0], a[48]);   // Sum(48)
    res[49]  = fma52lo(res[49], a[1], a[48]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[1], a[48]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[2], a[48]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[2], a[48]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[3], a[48]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[3], a[48]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[4], a[48]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[4], a[48]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[5], a[48]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[5], a[48]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[6], a[48]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[6], a[48]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[7], a[48]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[7], a[48]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[8], a[48]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[8], a[48]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[9], a[48]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[9], a[48]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[10], a[48]);  // Sum(58)
    res[59]  = fma52hi(res[59], a[10], a[48]);  // Sum(58)
    res[59]  = fma52lo(res[59], a[11], a[48]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[11], a[48]);  // Sum(59)
    res[49]  = fma52lo(res[49], a[0], a[49]);   // Sum(49)
    res[50]  = fma52hi(res[50], a[0], a[49]);   // Sum(49)
    res[50]  = fma52lo(res[50], a[1], a[49]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[1], a[49]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[2], a[49]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[2], a[49]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[3], a[49]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[3], a[49]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[4], a[49]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[4], a[49]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[5], a[49]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[5], a[49]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[6], a[49]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[6], a[49]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[7], a[49]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[7], a[49]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[8], a[49]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[8], a[49]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[9], a[49]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[9], a[49]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[10], a[49]);  // Sum(59)
    res[60]  = fma52hi(res[60], a[10], a[49]);  // Sum(59)
    res[50]  = fma52lo(res[50], a[0], a[50]);   // Sum(50)
    res[51]  = fma52hi(res[51], a[0], a[50]);   // Sum(50)
    res[51]  = fma52lo(res[51], a[1], a[50]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[1], a[50]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[2], a[50]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[2], a[50]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[3], a[50]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[3], a[50]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[4], a[50]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[4], a[50]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[5], a[50]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[5], a[50]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[6], a[50]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[6], a[50]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[7], a[50]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[7], a[50]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[8], a[50]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[8], a[50]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[9], a[50]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[9], a[50]);   // Sum(59)
    res[51]  = fma52lo(res[51], a[0], a[51]);   // Sum(51)
    res[52]  = fma52hi(res[52], a[0], a[51]);   // Sum(51)
    res[52]  = fma52lo(res[52], a[1], a[51]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[1], a[51]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[2], a[51]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[2], a[51]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[3], a[51]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[3], a[51]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[4], a[51]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[4], a[51]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[5], a[51]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[5], a[51]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[6], a[51]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[6], a[51]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[7], a[51]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[7], a[51]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[8], a[51]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[8], a[51]);   // Sum(59)
    res[52]  = fma52lo(res[52], a[0], a[52]);   // Sum(52)
    res[53]  = fma52hi(res[53], a[0], a[52]);   // Sum(52)
    res[53]  = fma52lo(res[53], a[1], a[52]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[1], a[52]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[2], a[52]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[2], a[52]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[3], a[52]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[3], a[52]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[4], a[52]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[4], a[52]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[5], a[52]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[5], a[52]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[6], a[52]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[6], a[52]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[7], a[52]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[7], a[52]);   // Sum(59)
    res[53]  = fma52lo(res[53], a[0], a[53]);   // Sum(53)
    res[54]  = fma52hi(res[54], a[0], a[53]);   // Sum(53)
    res[54]  = fma52lo(res[54], a[1], a[53]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[1], a[53]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[2], a[53]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[2], a[53]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[3], a[53]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[3], a[53]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[4], a[53]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[4], a[53]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[5], a[53]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[5], a[53]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[6], a[53]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[6], a[53]);   // Sum(59)
    res[54]  = fma52lo(res[54], a[0], a[54]);   // Sum(54)
    res[55]  = fma52hi(res[55], a[0], a[54]);   // Sum(54)
    res[55]  = fma52lo(res[55], a[1], a[54]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[1], a[54]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[2], a[54]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[2], a[54]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[3], a[54]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[3], a[54]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[4], a[54]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[4], a[54]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[5], a[54]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[5], a[54]);   // Sum(59)
    res[55]  = fma52lo(res[55], a[0], a[55]);   // Sum(55)
    res[56]  = fma52hi(res[56], a[0], a[55]);   // Sum(55)
    res[56]  = fma52lo(res[56], a[1], a[55]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[1], a[55]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[2], a[55]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[2], a[55]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[3], a[55]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[3], a[55]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[4], a[55]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[4], a[55]);   // Sum(59)
    res[56]  = fma52lo(res[56], a[0], a[56]);   // Sum(56)
    res[57]  = fma52hi(res[57], a[0], a[56]);   // Sum(56)
    res[57]  = fma52lo(res[57], a[1], a[56]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[1], a[56]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[2], a[56]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[2], a[56]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[3], a[56]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[3], a[56]);   // Sum(59)
    res[57]  = fma52lo(res[57], a[0], a[57]);   // Sum(57)
    res[58]  = fma52hi(res[58], a[0], a[57]);   // Sum(57)
    res[58]  = fma52lo(res[58], a[1], a[57]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[1], a[57]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[2], a[57]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[2], a[57]);   // Sum(59)
    res[58]  = fma52lo(res[58], a[0], a[58]);   // Sum(58)
    res[59]  = fma52hi(res[59], a[0], a[58]);   // Sum(58)
    res[59]  = fma52lo(res[59], a[1], a[58]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[1], a[58]);   // Sum(59)
    res[59]  = fma52lo(res[59], a[0], a[59]);   // Sum(59)
    res[60]  = fma52hi(res[60], a[0], a[59]);   // Sum(59)
    res[48]  = add64(res[48], res[48]);         // Double(48)
    res[49]  = add64(res[49], res[49]);         // Double(49)
    res[50]  = add64(res[50], res[50]);         // Double(50)
    res[51]  = add64(res[51], res[51]);         // Double(51)
    res[52]  = add64(res[52], res[52]);         // Double(52)
    res[53]  = add64(res[53], res[53]);         // Double(53)
    res[54]  = add64(res[54], res[54]);         // Double(54)
    res[55]  = add64(res[55], res[55]);         // Double(55)
    res[56]  = add64(res[56], res[56]);         // Double(56)
    res[57]  = add64(res[57], res[57]);         // Double(57)
    res[58]  = add64(res[58], res[58]);         // Double(58)
    res[59]  = add64(res[59], res[59]);         // Double(59)
    res[48]  = fma52lo(res[48], a[24], a[24]);  // Add sqr(48)
    res[49]  = fma52hi(res[49], a[24], a[24]);  // Add sqr(48)
    res[50]  = fma52lo(res[50], a[25], a[25]);  // Add sqr(50)
    res[51]  = fma52hi(res[51], a[25], a[25]);  // Add sqr(50)
    res[52]  = fma52lo(res[52], a[26], a[26]);  // Add sqr(52)
    res[53]  = fma52hi(res[53], a[26], a[26]);  // Add sqr(52)
    res[54]  = fma52lo(res[54], a[27], a[27]);  // Add sqr(54)
    res[55]  = fma52hi(res[55], a[27], a[27]);  // Add sqr(54)
    res[56]  = fma52lo(res[56], a[28], a[28]);  // Add sqr(56)
    res[57]  = fma52hi(res[57], a[28], a[28]);  // Add sqr(56)
    res[58]  = fma52lo(res[58], a[29], a[29]);  // Add sqr(58)
    res[59]  = fma52hi(res[59], a[29], a[29]);  // Add sqr(58)
    res[60]  = fma52lo(res[60], a[29], a[31]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[29], a[31]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[30], a[31]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[30], a[31]);  // Sum(61)
    res[60]  = fma52lo(res[60], a[28], a[32]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[28], a[32]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[29], a[32]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[29], a[32]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[30], a[32]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[30], a[32]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[31], a[32]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[31], a[32]);  // Sum(63)
    res[60]  = fma52lo(res[60], a[27], a[33]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[27], a[33]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[28], a[33]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[28], a[33]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[29], a[33]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[29], a[33]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[30], a[33]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[30], a[33]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[31], a[33]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[31], a[33]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[32], a[33]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[32], a[33]);  // Sum(65)
    res[60]  = fma52lo(res[60], a[26], a[34]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[26], a[34]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[27], a[34]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[27], a[34]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[28], a[34]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[28], a[34]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[29], a[34]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[29], a[34]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[30], a[34]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[30], a[34]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[31], a[34]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[31], a[34]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[32], a[34]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[32], a[34]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[33], a[34]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[33], a[34]);  // Sum(67)
    res[60]  = fma52lo(res[60], a[25], a[35]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[25], a[35]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[26], a[35]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[26], a[35]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[27], a[35]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[27], a[35]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[28], a[35]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[28], a[35]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[29], a[35]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[29], a[35]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[30], a[35]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[30], a[35]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[31], a[35]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[31], a[35]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[32], a[35]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[32], a[35]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[33], a[35]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[33], a[35]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[34], a[35]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[34], a[35]);  // Sum(69)
    res[60]  = fma52lo(res[60], a[24], a[36]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[24], a[36]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[25], a[36]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[25], a[36]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[26], a[36]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[26], a[36]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[27], a[36]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[27], a[36]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[28], a[36]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[28], a[36]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[29], a[36]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[29], a[36]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[30], a[36]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[30], a[36]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[31], a[36]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[31], a[36]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[32], a[36]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[32], a[36]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[33], a[36]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[33], a[36]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[34], a[36]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[34], a[36]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[35], a[36]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[35], a[36]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[23], a[37]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[23], a[37]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[24], a[37]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[24], a[37]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[25], a[37]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[25], a[37]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[26], a[37]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[26], a[37]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[27], a[37]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[27], a[37]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[28], a[37]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[28], a[37]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[29], a[37]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[29], a[37]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[30], a[37]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[30], a[37]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[31], a[37]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[31], a[37]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[32], a[37]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[32], a[37]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[33], a[37]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[33], a[37]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[34], a[37]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[34], a[37]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[22], a[38]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[22], a[38]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[23], a[38]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[23], a[38]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[24], a[38]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[24], a[38]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[25], a[38]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[25], a[38]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[26], a[38]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[26], a[38]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[27], a[38]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[27], a[38]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[28], a[38]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[28], a[38]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[29], a[38]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[29], a[38]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[30], a[38]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[30], a[38]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[31], a[38]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[31], a[38]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[32], a[38]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[32], a[38]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[33], a[38]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[33], a[38]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[21], a[39]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[21], a[39]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[22], a[39]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[22], a[39]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[23], a[39]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[23], a[39]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[24], a[39]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[24], a[39]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[25], a[39]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[25], a[39]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[26], a[39]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[26], a[39]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[27], a[39]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[27], a[39]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[28], a[39]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[28], a[39]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[29], a[39]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[29], a[39]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[30], a[39]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[30], a[39]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[31], a[39]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[31], a[39]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[32], a[39]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[32], a[39]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[20], a[40]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[20], a[40]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[21], a[40]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[21], a[40]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[22], a[40]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[22], a[40]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[23], a[40]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[23], a[40]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[24], a[40]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[24], a[40]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[25], a[40]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[25], a[40]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[26], a[40]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[26], a[40]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[27], a[40]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[27], a[40]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[28], a[40]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[28], a[40]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[29], a[40]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[29], a[40]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[30], a[40]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[30], a[40]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[31], a[40]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[31], a[40]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[19], a[41]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[19], a[41]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[20], a[41]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[20], a[41]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[21], a[41]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[21], a[41]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[22], a[41]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[22], a[41]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[23], a[41]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[23], a[41]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[24], a[41]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[24], a[41]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[25], a[41]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[25], a[41]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[26], a[41]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[26], a[41]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[27], a[41]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[27], a[41]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[28], a[41]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[28], a[41]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[29], a[41]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[29], a[41]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[30], a[41]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[30], a[41]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[18], a[42]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[18], a[42]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[19], a[42]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[19], a[42]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[20], a[42]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[20], a[42]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[21], a[42]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[21], a[42]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[22], a[42]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[22], a[42]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[23], a[42]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[23], a[42]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[24], a[42]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[24], a[42]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[25], a[42]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[25], a[42]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[26], a[42]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[26], a[42]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[27], a[42]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[27], a[42]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[28], a[42]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[28], a[42]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[29], a[42]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[29], a[42]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[17], a[43]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[17], a[43]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[18], a[43]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[18], a[43]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[19], a[43]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[19], a[43]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[20], a[43]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[20], a[43]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[21], a[43]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[21], a[43]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[22], a[43]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[22], a[43]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[23], a[43]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[23], a[43]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[24], a[43]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[24], a[43]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[25], a[43]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[25], a[43]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[26], a[43]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[26], a[43]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[27], a[43]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[27], a[43]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[28], a[43]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[28], a[43]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[16], a[44]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[16], a[44]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[17], a[44]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[17], a[44]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[18], a[44]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[18], a[44]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[19], a[44]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[19], a[44]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[20], a[44]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[20], a[44]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[21], a[44]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[21], a[44]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[22], a[44]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[22], a[44]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[23], a[44]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[23], a[44]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[24], a[44]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[24], a[44]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[25], a[44]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[25], a[44]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[26], a[44]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[26], a[44]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[27], a[44]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[27], a[44]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[15], a[45]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[15], a[45]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[16], a[45]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[16], a[45]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[17], a[45]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[17], a[45]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[18], a[45]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[18], a[45]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[19], a[45]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[19], a[45]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[20], a[45]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[20], a[45]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[21], a[45]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[21], a[45]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[22], a[45]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[22], a[45]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[23], a[45]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[23], a[45]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[24], a[45]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[24], a[45]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[25], a[45]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[25], a[45]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[26], a[45]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[26], a[45]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[14], a[46]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[14], a[46]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[15], a[46]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[15], a[46]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[16], a[46]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[16], a[46]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[17], a[46]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[17], a[46]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[18], a[46]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[18], a[46]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[19], a[46]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[19], a[46]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[20], a[46]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[20], a[46]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[21], a[46]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[21], a[46]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[22], a[46]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[22], a[46]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[23], a[46]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[23], a[46]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[24], a[46]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[24], a[46]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[25], a[46]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[25], a[46]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[13], a[47]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[13], a[47]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[14], a[47]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[14], a[47]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[15], a[47]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[15], a[47]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[16], a[47]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[16], a[47]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[17], a[47]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[17], a[47]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[18], a[47]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[18], a[47]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[19], a[47]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[19], a[47]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[20], a[47]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[20], a[47]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[21], a[47]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[21], a[47]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[22], a[47]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[22], a[47]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[23], a[47]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[23], a[47]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[24], a[47]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[24], a[47]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[12], a[48]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[12], a[48]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[13], a[48]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[13], a[48]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[14], a[48]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[14], a[48]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[15], a[48]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[15], a[48]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[16], a[48]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[16], a[48]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[17], a[48]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[17], a[48]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[18], a[48]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[18], a[48]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[19], a[48]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[19], a[48]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[20], a[48]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[20], a[48]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[21], a[48]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[21], a[48]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[22], a[48]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[22], a[48]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[23], a[48]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[23], a[48]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[11], a[49]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[11], a[49]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[12], a[49]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[12], a[49]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[13], a[49]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[13], a[49]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[14], a[49]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[14], a[49]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[15], a[49]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[15], a[49]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[16], a[49]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[16], a[49]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[17], a[49]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[17], a[49]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[18], a[49]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[18], a[49]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[19], a[49]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[19], a[49]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[20], a[49]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[20], a[49]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[21], a[49]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[21], a[49]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[22], a[49]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[22], a[49]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[10], a[50]);  // Sum(60)
    res[61]  = fma52hi(res[61], a[10], a[50]);  // Sum(60)
    res[61]  = fma52lo(res[61], a[11], a[50]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[11], a[50]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[12], a[50]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[12], a[50]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[13], a[50]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[13], a[50]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[14], a[50]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[14], a[50]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[15], a[50]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[15], a[50]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[16], a[50]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[16], a[50]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[17], a[50]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[17], a[50]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[18], a[50]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[18], a[50]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[19], a[50]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[19], a[50]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[20], a[50]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[20], a[50]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[21], a[50]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[21], a[50]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[9], a[51]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[9], a[51]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[10], a[51]);  // Sum(61)
    res[62]  = fma52hi(res[62], a[10], a[51]);  // Sum(61)
    res[62]  = fma52lo(res[62], a[11], a[51]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[11], a[51]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[12], a[51]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[12], a[51]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[13], a[51]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[13], a[51]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[14], a[51]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[14], a[51]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[15], a[51]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[15], a[51]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[16], a[51]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[16], a[51]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[17], a[51]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[17], a[51]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[18], a[51]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[18], a[51]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[19], a[51]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[19], a[51]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[20], a[51]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[20], a[51]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[8], a[52]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[8], a[52]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[9], a[52]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[9], a[52]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[10], a[52]);  // Sum(62)
    res[63]  = fma52hi(res[63], a[10], a[52]);  // Sum(62)
    res[63]  = fma52lo(res[63], a[11], a[52]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[11], a[52]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[12], a[52]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[12], a[52]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[13], a[52]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[13], a[52]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[14], a[52]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[14], a[52]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[15], a[52]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[15], a[52]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[16], a[52]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[16], a[52]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[17], a[52]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[17], a[52]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[18], a[52]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[18], a[52]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[19], a[52]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[19], a[52]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[7], a[53]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[7], a[53]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[8], a[53]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[8], a[53]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[9], a[53]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[9], a[53]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[10], a[53]);  // Sum(63)
    res[64]  = fma52hi(res[64], a[10], a[53]);  // Sum(63)
    res[64]  = fma52lo(res[64], a[11], a[53]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[11], a[53]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[12], a[53]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[12], a[53]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[13], a[53]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[13], a[53]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[14], a[53]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[14], a[53]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[15], a[53]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[15], a[53]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[16], a[53]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[16], a[53]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[17], a[53]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[17], a[53]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[18], a[53]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[18], a[53]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[6], a[54]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[6], a[54]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[7], a[54]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[7], a[54]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[8], a[54]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[8], a[54]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[9], a[54]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[9], a[54]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[10], a[54]);  // Sum(64)
    res[65]  = fma52hi(res[65], a[10], a[54]);  // Sum(64)
    res[65]  = fma52lo(res[65], a[11], a[54]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[11], a[54]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[12], a[54]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[12], a[54]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[13], a[54]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[13], a[54]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[14], a[54]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[14], a[54]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[15], a[54]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[15], a[54]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[16], a[54]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[16], a[54]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[17], a[54]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[17], a[54]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[5], a[55]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[5], a[55]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[6], a[55]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[6], a[55]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[7], a[55]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[7], a[55]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[8], a[55]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[8], a[55]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[9], a[55]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[9], a[55]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[10], a[55]);  // Sum(65)
    res[66]  = fma52hi(res[66], a[10], a[55]);  // Sum(65)
    res[66]  = fma52lo(res[66], a[11], a[55]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[11], a[55]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[12], a[55]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[12], a[55]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[13], a[55]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[13], a[55]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[14], a[55]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[14], a[55]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[15], a[55]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[15], a[55]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[16], a[55]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[16], a[55]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[4], a[56]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[4], a[56]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[5], a[56]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[5], a[56]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[6], a[56]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[6], a[56]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[7], a[56]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[7], a[56]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[8], a[56]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[8], a[56]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[9], a[56]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[9], a[56]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[10], a[56]);  // Sum(66)
    res[67]  = fma52hi(res[67], a[10], a[56]);  // Sum(66)
    res[67]  = fma52lo(res[67], a[11], a[56]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[11], a[56]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[12], a[56]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[12], a[56]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[13], a[56]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[13], a[56]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[14], a[56]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[14], a[56]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[15], a[56]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[15], a[56]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[3], a[57]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[3], a[57]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[4], a[57]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[4], a[57]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[5], a[57]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[5], a[57]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[6], a[57]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[6], a[57]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[7], a[57]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[7], a[57]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[8], a[57]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[8], a[57]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[9], a[57]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[9], a[57]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[10], a[57]);  // Sum(67)
    res[68]  = fma52hi(res[68], a[10], a[57]);  // Sum(67)
    res[68]  = fma52lo(res[68], a[11], a[57]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[11], a[57]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[12], a[57]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[12], a[57]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[13], a[57]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[13], a[57]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[14], a[57]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[14], a[57]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[2], a[58]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[2], a[58]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[3], a[58]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[3], a[58]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[4], a[58]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[4], a[58]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[5], a[58]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[5], a[58]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[6], a[58]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[6], a[58]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[7], a[58]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[7], a[58]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[8], a[58]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[8], a[58]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[9], a[58]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[9], a[58]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[10], a[58]);  // Sum(68)
    res[69]  = fma52hi(res[69], a[10], a[58]);  // Sum(68)
    res[69]  = fma52lo(res[69], a[11], a[58]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[11], a[58]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[12], a[58]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[12], a[58]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[13], a[58]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[13], a[58]);  // Sum(71)
    res[60]  = fma52lo(res[60], a[1], a[59]);   // Sum(60)
    res[61]  = fma52hi(res[61], a[1], a[59]);   // Sum(60)
    res[61]  = fma52lo(res[61], a[2], a[59]);   // Sum(61)
    res[62]  = fma52hi(res[62], a[2], a[59]);   // Sum(61)
    res[62]  = fma52lo(res[62], a[3], a[59]);   // Sum(62)
    res[63]  = fma52hi(res[63], a[3], a[59]);   // Sum(62)
    res[63]  = fma52lo(res[63], a[4], a[59]);   // Sum(63)
    res[64]  = fma52hi(res[64], a[4], a[59]);   // Sum(63)
    res[64]  = fma52lo(res[64], a[5], a[59]);   // Sum(64)
    res[65]  = fma52hi(res[65], a[5], a[59]);   // Sum(64)
    res[65]  = fma52lo(res[65], a[6], a[59]);   // Sum(65)
    res[66]  = fma52hi(res[66], a[6], a[59]);   // Sum(65)
    res[66]  = fma52lo(res[66], a[7], a[59]);   // Sum(66)
    res[67]  = fma52hi(res[67], a[7], a[59]);   // Sum(66)
    res[67]  = fma52lo(res[67], a[8], a[59]);   // Sum(67)
    res[68]  = fma52hi(res[68], a[8], a[59]);   // Sum(67)
    res[68]  = fma52lo(res[68], a[9], a[59]);   // Sum(68)
    res[69]  = fma52hi(res[69], a[9], a[59]);   // Sum(68)
    res[69]  = fma52lo(res[69], a[10], a[59]);  // Sum(69)
    res[70]  = fma52hi(res[70], a[10], a[59]);  // Sum(69)
    res[70]  = fma52lo(res[70], a[11], a[59]);  // Sum(70)
    res[71]  = fma52hi(res[71], a[11], a[59]);  // Sum(70)
    res[71]  = fma52lo(res[71], a[12], a[59]);  // Sum(71)
    res[72]  = fma52hi(res[72], a[12], a[59]);  // Sum(71)
    res[60]  = add64(res[60], res[60]);         // Double(60)
    res[61]  = add64(res[61], res[61]);         // Double(61)
    res[62]  = add64(res[62], res[62]);         // Double(62)
    res[63]  = add64(res[63], res[63]);         // Double(63)
    res[64]  = add64(res[64], res[64]);         // Double(64)
    res[65]  = add64(res[65], res[65]);         // Double(65)
    res[66]  = add64(res[66], res[66]);         // Double(66)
    res[67]  = add64(res[67], res[67]);         // Double(67)
    res[68]  = add64(res[68], res[68]);         // Double(68)
    res[69]  = add64(res[69], res[69]);         // Double(69)
    res[70]  = add64(res[70], res[70]);         // Double(70)
    res[71]  = add64(res[71], res[71]);         // Double(71)
    res[60]  = fma52lo(res[60], a[30], a[30]);  // Add sqr(60)
    res[61]  = fma52hi(res[61], a[30], a[30]);  // Add sqr(60)
    res[62]  = fma52lo(res[62], a[31], a[31]);  // Add sqr(62)
    res[63]  = fma52hi(res[63], a[31], a[31]);  // Add sqr(62)
    res[64]  = fma52lo(res[64], a[32], a[32]);  // Add sqr(64)
    res[65]  = fma52hi(res[65], a[32], a[32]);  // Add sqr(64)
    res[66]  = fma52lo(res[66], a[33], a[33]);  // Add sqr(66)
    res[67]  = fma52hi(res[67], a[33], a[33]);  // Add sqr(66)
    res[68]  = fma52lo(res[68], a[34], a[34]);  // Add sqr(68)
    res[69]  = fma52hi(res[69], a[34], a[34]);  // Add sqr(68)
    res[70]  = fma52lo(res[70], a[35], a[35]);  // Add sqr(70)
    res[71]  = fma52hi(res[71], a[35], a[35]);  // Add sqr(70)
    res[72]  = fma52lo(res[72], a[35], a[37]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[35], a[37]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[36], a[37]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[36], a[37]);  // Sum(73)
    res[72]  = fma52lo(res[72], a[34], a[38]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[34], a[38]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[35], a[38]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[35], a[38]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[36], a[38]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[36], a[38]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[37], a[38]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[37], a[38]);  // Sum(75)
    res[72]  = fma52lo(res[72], a[33], a[39]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[33], a[39]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[34], a[39]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[34], a[39]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[35], a[39]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[35], a[39]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[36], a[39]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[36], a[39]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[37], a[39]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[37], a[39]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[38], a[39]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[38], a[39]);  // Sum(77)
    res[72]  = fma52lo(res[72], a[32], a[40]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[32], a[40]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[33], a[40]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[33], a[40]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[34], a[40]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[34], a[40]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[35], a[40]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[35], a[40]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[36], a[40]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[36], a[40]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[37], a[40]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[37], a[40]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[38], a[40]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[38], a[40]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[39], a[40]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[39], a[40]);  // Sum(79)
    res[72]  = fma52lo(res[72], a[31], a[41]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[31], a[41]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[32], a[41]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[32], a[41]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[33], a[41]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[33], a[41]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[34], a[41]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[34], a[41]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[35], a[41]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[35], a[41]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[36], a[41]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[36], a[41]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[37], a[41]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[37], a[41]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[38], a[41]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[38], a[41]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[39], a[41]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[39], a[41]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[40], a[41]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[40], a[41]);  // Sum(81)
    res[72]  = fma52lo(res[72], a[30], a[42]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[30], a[42]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[31], a[42]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[31], a[42]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[32], a[42]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[32], a[42]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[33], a[42]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[33], a[42]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[34], a[42]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[34], a[42]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[35], a[42]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[35], a[42]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[36], a[42]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[36], a[42]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[37], a[42]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[37], a[42]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[38], a[42]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[38], a[42]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[39], a[42]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[39], a[42]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[40], a[42]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[40], a[42]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[41], a[42]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[41], a[42]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[29], a[43]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[29], a[43]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[30], a[43]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[30], a[43]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[31], a[43]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[31], a[43]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[32], a[43]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[32], a[43]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[33], a[43]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[33], a[43]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[34], a[43]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[34], a[43]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[35], a[43]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[35], a[43]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[36], a[43]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[36], a[43]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[37], a[43]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[37], a[43]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[38], a[43]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[38], a[43]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[39], a[43]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[39], a[43]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[40], a[43]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[40], a[43]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[28], a[44]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[28], a[44]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[29], a[44]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[29], a[44]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[30], a[44]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[30], a[44]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[31], a[44]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[31], a[44]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[32], a[44]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[32], a[44]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[33], a[44]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[33], a[44]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[34], a[44]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[34], a[44]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[35], a[44]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[35], a[44]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[36], a[44]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[36], a[44]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[37], a[44]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[37], a[44]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[38], a[44]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[38], a[44]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[39], a[44]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[39], a[44]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[27], a[45]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[27], a[45]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[28], a[45]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[28], a[45]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[29], a[45]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[29], a[45]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[30], a[45]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[30], a[45]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[31], a[45]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[31], a[45]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[32], a[45]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[32], a[45]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[33], a[45]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[33], a[45]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[34], a[45]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[34], a[45]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[35], a[45]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[35], a[45]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[36], a[45]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[36], a[45]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[37], a[45]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[37], a[45]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[38], a[45]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[38], a[45]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[26], a[46]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[26], a[46]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[27], a[46]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[27], a[46]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[28], a[46]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[28], a[46]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[29], a[46]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[29], a[46]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[30], a[46]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[30], a[46]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[31], a[46]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[31], a[46]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[32], a[46]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[32], a[46]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[33], a[46]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[33], a[46]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[34], a[46]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[34], a[46]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[35], a[46]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[35], a[46]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[36], a[46]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[36], a[46]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[37], a[46]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[37], a[46]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[25], a[47]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[25], a[47]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[26], a[47]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[26], a[47]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[27], a[47]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[27], a[47]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[28], a[47]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[28], a[47]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[29], a[47]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[29], a[47]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[30], a[47]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[30], a[47]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[31], a[47]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[31], a[47]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[32], a[47]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[32], a[47]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[33], a[47]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[33], a[47]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[34], a[47]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[34], a[47]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[35], a[47]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[35], a[47]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[36], a[47]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[36], a[47]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[24], a[48]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[24], a[48]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[25], a[48]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[25], a[48]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[26], a[48]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[26], a[48]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[27], a[48]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[27], a[48]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[28], a[48]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[28], a[48]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[29], a[48]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[29], a[48]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[30], a[48]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[30], a[48]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[31], a[48]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[31], a[48]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[32], a[48]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[32], a[48]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[33], a[48]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[33], a[48]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[34], a[48]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[34], a[48]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[35], a[48]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[35], a[48]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[23], a[49]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[23], a[49]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[24], a[49]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[24], a[49]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[25], a[49]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[25], a[49]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[26], a[49]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[26], a[49]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[27], a[49]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[27], a[49]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[28], a[49]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[28], a[49]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[29], a[49]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[29], a[49]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[30], a[49]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[30], a[49]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[31], a[49]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[31], a[49]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[32], a[49]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[32], a[49]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[33], a[49]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[33], a[49]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[34], a[49]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[34], a[49]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[22], a[50]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[22], a[50]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[23], a[50]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[23], a[50]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[24], a[50]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[24], a[50]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[25], a[50]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[25], a[50]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[26], a[50]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[26], a[50]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[27], a[50]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[27], a[50]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[28], a[50]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[28], a[50]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[29], a[50]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[29], a[50]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[30], a[50]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[30], a[50]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[31], a[50]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[31], a[50]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[32], a[50]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[32], a[50]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[33], a[50]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[33], a[50]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[21], a[51]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[21], a[51]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[22], a[51]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[22], a[51]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[23], a[51]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[23], a[51]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[24], a[51]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[24], a[51]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[25], a[51]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[25], a[51]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[26], a[51]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[26], a[51]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[27], a[51]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[27], a[51]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[28], a[51]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[28], a[51]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[29], a[51]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[29], a[51]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[30], a[51]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[30], a[51]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[31], a[51]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[31], a[51]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[32], a[51]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[32], a[51]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[20], a[52]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[20], a[52]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[21], a[52]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[21], a[52]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[22], a[52]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[22], a[52]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[23], a[52]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[23], a[52]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[24], a[52]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[24], a[52]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[25], a[52]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[25], a[52]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[26], a[52]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[26], a[52]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[27], a[52]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[27], a[52]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[28], a[52]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[28], a[52]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[29], a[52]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[29], a[52]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[30], a[52]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[30], a[52]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[31], a[52]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[31], a[52]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[19], a[53]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[19], a[53]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[20], a[53]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[20], a[53]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[21], a[53]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[21], a[53]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[22], a[53]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[22], a[53]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[23], a[53]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[23], a[53]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[24], a[53]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[24], a[53]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[25], a[53]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[25], a[53]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[26], a[53]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[26], a[53]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[27], a[53]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[27], a[53]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[28], a[53]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[28], a[53]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[29], a[53]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[29], a[53]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[30], a[53]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[30], a[53]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[18], a[54]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[18], a[54]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[19], a[54]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[19], a[54]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[20], a[54]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[20], a[54]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[21], a[54]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[21], a[54]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[22], a[54]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[22], a[54]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[23], a[54]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[23], a[54]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[24], a[54]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[24], a[54]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[25], a[54]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[25], a[54]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[26], a[54]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[26], a[54]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[27], a[54]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[27], a[54]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[28], a[54]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[28], a[54]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[29], a[54]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[29], a[54]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[17], a[55]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[17], a[55]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[18], a[55]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[18], a[55]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[19], a[55]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[19], a[55]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[20], a[55]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[20], a[55]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[21], a[55]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[21], a[55]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[22], a[55]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[22], a[55]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[23], a[55]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[23], a[55]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[24], a[55]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[24], a[55]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[25], a[55]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[25], a[55]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[26], a[55]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[26], a[55]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[27], a[55]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[27], a[55]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[28], a[55]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[28], a[55]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[16], a[56]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[16], a[56]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[17], a[56]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[17], a[56]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[18], a[56]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[18], a[56]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[19], a[56]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[19], a[56]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[20], a[56]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[20], a[56]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[21], a[56]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[21], a[56]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[22], a[56]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[22], a[56]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[23], a[56]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[23], a[56]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[24], a[56]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[24], a[56]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[25], a[56]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[25], a[56]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[26], a[56]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[26], a[56]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[27], a[56]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[27], a[56]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[15], a[57]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[15], a[57]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[16], a[57]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[16], a[57]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[17], a[57]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[17], a[57]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[18], a[57]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[18], a[57]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[19], a[57]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[19], a[57]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[20], a[57]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[20], a[57]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[21], a[57]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[21], a[57]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[22], a[57]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[22], a[57]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[23], a[57]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[23], a[57]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[24], a[57]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[24], a[57]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[25], a[57]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[25], a[57]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[26], a[57]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[26], a[57]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[14], a[58]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[14], a[58]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[15], a[58]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[15], a[58]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[16], a[58]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[16], a[58]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[17], a[58]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[17], a[58]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[18], a[58]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[18], a[58]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[19], a[58]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[19], a[58]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[20], a[58]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[20], a[58]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[21], a[58]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[21], a[58]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[22], a[58]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[22], a[58]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[23], a[58]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[23], a[58]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[24], a[58]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[24], a[58]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[25], a[58]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[25], a[58]);  // Sum(83)
    res[72]  = fma52lo(res[72], a[13], a[59]);  // Sum(72)
    res[73]  = fma52hi(res[73], a[13], a[59]);  // Sum(72)
    res[73]  = fma52lo(res[73], a[14], a[59]);  // Sum(73)
    res[74]  = fma52hi(res[74], a[14], a[59]);  // Sum(73)
    res[74]  = fma52lo(res[74], a[15], a[59]);  // Sum(74)
    res[75]  = fma52hi(res[75], a[15], a[59]);  // Sum(74)
    res[75]  = fma52lo(res[75], a[16], a[59]);  // Sum(75)
    res[76]  = fma52hi(res[76], a[16], a[59]);  // Sum(75)
    res[76]  = fma52lo(res[76], a[17], a[59]);  // Sum(76)
    res[77]  = fma52hi(res[77], a[17], a[59]);  // Sum(76)
    res[77]  = fma52lo(res[77], a[18], a[59]);  // Sum(77)
    res[78]  = fma52hi(res[78], a[18], a[59]);  // Sum(77)
    res[78]  = fma52lo(res[78], a[19], a[59]);  // Sum(78)
    res[79]  = fma52hi(res[79], a[19], a[59]);  // Sum(78)
    res[79]  = fma52lo(res[79], a[20], a[59]);  // Sum(79)
    res[80]  = fma52hi(res[80], a[20], a[59]);  // Sum(79)
    res[80]  = fma52lo(res[80], a[21], a[59]);  // Sum(80)
    res[81]  = fma52hi(res[81], a[21], a[59]);  // Sum(80)
    res[81]  = fma52lo(res[81], a[22], a[59]);  // Sum(81)
    res[82]  = fma52hi(res[82], a[22], a[59]);  // Sum(81)
    res[82]  = fma52lo(res[82], a[23], a[59]);  // Sum(82)
    res[83]  = fma52hi(res[83], a[23], a[59]);  // Sum(82)
    res[83]  = fma52lo(res[83], a[24], a[59]);  // Sum(83)
    res[84]  = fma52hi(res[84], a[24], a[59]);  // Sum(83)
    res[72]  = add64(res[72], res[72]);         // Double(72)
    res[73]  = add64(res[73], res[73]);         // Double(73)
    res[74]  = add64(res[74], res[74]);         // Double(74)
    res[75]  = add64(res[75], res[75]);         // Double(75)
    res[76]  = add64(res[76], res[76]);         // Double(76)
    res[77]  = add64(res[77], res[77]);         // Double(77)
    res[78]  = add64(res[78], res[78]);         // Double(78)
    res[79]  = add64(res[79], res[79]);         // Double(79)
    res[80]  = add64(res[80], res[80]);         // Double(80)
    res[81]  = add64(res[81], res[81]);         // Double(81)
    res[82]  = add64(res[82], res[82]);         // Double(82)
    res[83]  = add64(res[83], res[83]);         // Double(83)
    res[72]  = fma52lo(res[72], a[36], a[36]);  // Add sqr(72)
    res[73]  = fma52hi(res[73], a[36], a[36]);  // Add sqr(72)
    res[74]  = fma52lo(res[74], a[37], a[37]);  // Add sqr(74)
    res[75]  = fma52hi(res[75], a[37], a[37]);  // Add sqr(74)
    res[76]  = fma52lo(res[76], a[38], a[38]);  // Add sqr(76)
    res[77]  = fma52hi(res[77], a[38], a[38]);  // Add sqr(76)
    res[78]  = fma52lo(res[78], a[39], a[39]);  // Add sqr(78)
    res[79]  = fma52hi(res[79], a[39], a[39]);  // Add sqr(78)
    res[80]  = fma52lo(res[80], a[40], a[40]);  // Add sqr(80)
    res[81]  = fma52hi(res[81], a[40], a[40]);  // Add sqr(80)
    res[82]  = fma52lo(res[82], a[41], a[41]);  // Add sqr(82)
    res[83]  = fma52hi(res[83], a[41], a[41]);  // Add sqr(82)
    res[84]  = fma52lo(res[84], a[41], a[43]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[41], a[43]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[42], a[43]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[42], a[43]);  // Sum(85)
    res[84]  = fma52lo(res[84], a[40], a[44]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[40], a[44]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[41], a[44]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[41], a[44]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[42], a[44]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[42], a[44]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[43], a[44]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[43], a[44]);  // Sum(87)
    res[84]  = fma52lo(res[84], a[39], a[45]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[39], a[45]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[40], a[45]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[40], a[45]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[41], a[45]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[41], a[45]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[42], a[45]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[42], a[45]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[43], a[45]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[43], a[45]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[44], a[45]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[44], a[45]);  // Sum(89)
    res[84]  = fma52lo(res[84], a[38], a[46]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[38], a[46]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[39], a[46]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[39], a[46]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[40], a[46]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[40], a[46]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[41], a[46]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[41], a[46]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[42], a[46]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[42], a[46]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[43], a[46]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[43], a[46]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[44], a[46]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[44], a[46]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[45], a[46]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[45], a[46]);  // Sum(91)
    res[84]  = fma52lo(res[84], a[37], a[47]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[37], a[47]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[38], a[47]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[38], a[47]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[39], a[47]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[39], a[47]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[40], a[47]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[40], a[47]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[41], a[47]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[41], a[47]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[42], a[47]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[42], a[47]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[43], a[47]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[43], a[47]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[44], a[47]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[44], a[47]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[45], a[47]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[45], a[47]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[46], a[47]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[46], a[47]);  // Sum(93)
    res[84]  = fma52lo(res[84], a[36], a[48]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[36], a[48]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[37], a[48]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[37], a[48]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[38], a[48]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[38], a[48]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[39], a[48]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[39], a[48]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[40], a[48]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[40], a[48]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[41], a[48]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[41], a[48]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[42], a[48]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[42], a[48]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[43], a[48]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[43], a[48]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[44], a[48]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[44], a[48]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[45], a[48]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[45], a[48]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[46], a[48]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[46], a[48]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[47], a[48]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[47], a[48]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[35], a[49]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[35], a[49]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[36], a[49]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[36], a[49]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[37], a[49]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[37], a[49]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[38], a[49]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[38], a[49]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[39], a[49]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[39], a[49]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[40], a[49]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[40], a[49]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[41], a[49]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[41], a[49]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[42], a[49]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[42], a[49]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[43], a[49]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[43], a[49]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[44], a[49]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[44], a[49]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[45], a[49]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[45], a[49]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[46], a[49]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[46], a[49]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[34], a[50]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[34], a[50]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[35], a[50]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[35], a[50]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[36], a[50]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[36], a[50]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[37], a[50]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[37], a[50]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[38], a[50]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[38], a[50]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[39], a[50]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[39], a[50]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[40], a[50]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[40], a[50]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[41], a[50]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[41], a[50]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[42], a[50]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[42], a[50]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[43], a[50]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[43], a[50]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[44], a[50]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[44], a[50]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[45], a[50]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[45], a[50]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[33], a[51]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[33], a[51]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[34], a[51]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[34], a[51]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[35], a[51]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[35], a[51]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[36], a[51]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[36], a[51]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[37], a[51]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[37], a[51]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[38], a[51]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[38], a[51]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[39], a[51]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[39], a[51]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[40], a[51]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[40], a[51]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[41], a[51]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[41], a[51]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[42], a[51]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[42], a[51]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[43], a[51]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[43], a[51]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[44], a[51]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[44], a[51]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[32], a[52]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[32], a[52]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[33], a[52]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[33], a[52]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[34], a[52]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[34], a[52]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[35], a[52]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[35], a[52]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[36], a[52]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[36], a[52]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[37], a[52]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[37], a[52]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[38], a[52]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[38], a[52]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[39], a[52]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[39], a[52]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[40], a[52]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[40], a[52]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[41], a[52]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[41], a[52]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[42], a[52]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[42], a[52]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[43], a[52]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[43], a[52]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[31], a[53]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[31], a[53]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[32], a[53]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[32], a[53]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[33], a[53]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[33], a[53]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[34], a[53]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[34], a[53]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[35], a[53]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[35], a[53]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[36], a[53]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[36], a[53]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[37], a[53]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[37], a[53]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[38], a[53]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[38], a[53]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[39], a[53]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[39], a[53]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[40], a[53]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[40], a[53]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[41], a[53]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[41], a[53]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[42], a[53]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[42], a[53]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[30], a[54]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[30], a[54]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[31], a[54]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[31], a[54]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[32], a[54]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[32], a[54]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[33], a[54]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[33], a[54]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[34], a[54]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[34], a[54]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[35], a[54]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[35], a[54]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[36], a[54]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[36], a[54]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[37], a[54]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[37], a[54]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[38], a[54]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[38], a[54]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[39], a[54]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[39], a[54]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[40], a[54]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[40], a[54]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[41], a[54]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[41], a[54]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[29], a[55]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[29], a[55]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[30], a[55]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[30], a[55]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[31], a[55]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[31], a[55]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[32], a[55]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[32], a[55]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[33], a[55]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[33], a[55]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[34], a[55]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[34], a[55]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[35], a[55]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[35], a[55]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[36], a[55]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[36], a[55]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[37], a[55]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[37], a[55]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[38], a[55]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[38], a[55]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[39], a[55]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[39], a[55]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[40], a[55]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[40], a[55]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[28], a[56]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[28], a[56]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[29], a[56]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[29], a[56]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[30], a[56]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[30], a[56]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[31], a[56]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[31], a[56]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[32], a[56]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[32], a[56]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[33], a[56]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[33], a[56]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[34], a[56]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[34], a[56]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[35], a[56]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[35], a[56]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[36], a[56]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[36], a[56]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[37], a[56]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[37], a[56]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[38], a[56]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[38], a[56]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[39], a[56]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[39], a[56]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[27], a[57]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[27], a[57]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[28], a[57]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[28], a[57]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[29], a[57]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[29], a[57]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[30], a[57]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[30], a[57]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[31], a[57]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[31], a[57]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[32], a[57]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[32], a[57]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[33], a[57]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[33], a[57]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[34], a[57]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[34], a[57]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[35], a[57]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[35], a[57]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[36], a[57]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[36], a[57]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[37], a[57]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[37], a[57]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[38], a[57]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[38], a[57]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[26], a[58]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[26], a[58]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[27], a[58]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[27], a[58]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[28], a[58]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[28], a[58]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[29], a[58]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[29], a[58]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[30], a[58]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[30], a[58]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[31], a[58]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[31], a[58]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[32], a[58]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[32], a[58]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[33], a[58]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[33], a[58]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[34], a[58]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[34], a[58]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[35], a[58]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[35], a[58]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[36], a[58]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[36], a[58]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[37], a[58]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[37], a[58]);  // Sum(95)
    res[84]  = fma52lo(res[84], a[25], a[59]);  // Sum(84)
    res[85]  = fma52hi(res[85], a[25], a[59]);  // Sum(84)
    res[85]  = fma52lo(res[85], a[26], a[59]);  // Sum(85)
    res[86]  = fma52hi(res[86], a[26], a[59]);  // Sum(85)
    res[86]  = fma52lo(res[86], a[27], a[59]);  // Sum(86)
    res[87]  = fma52hi(res[87], a[27], a[59]);  // Sum(86)
    res[87]  = fma52lo(res[87], a[28], a[59]);  // Sum(87)
    res[88]  = fma52hi(res[88], a[28], a[59]);  // Sum(87)
    res[88]  = fma52lo(res[88], a[29], a[59]);  // Sum(88)
    res[89]  = fma52hi(res[89], a[29], a[59]);  // Sum(88)
    res[89]  = fma52lo(res[89], a[30], a[59]);  // Sum(89)
    res[90]  = fma52hi(res[90], a[30], a[59]);  // Sum(89)
    res[90]  = fma52lo(res[90], a[31], a[59]);  // Sum(90)
    res[91]  = fma52hi(res[91], a[31], a[59]);  // Sum(90)
    res[91]  = fma52lo(res[91], a[32], a[59]);  // Sum(91)
    res[92]  = fma52hi(res[92], a[32], a[59]);  // Sum(91)
    res[92]  = fma52lo(res[92], a[33], a[59]);  // Sum(92)
    res[93]  = fma52hi(res[93], a[33], a[59]);  // Sum(92)
    res[93]  = fma52lo(res[93], a[34], a[59]);  // Sum(93)
    res[94]  = fma52hi(res[94], a[34], a[59]);  // Sum(93)
    res[94]  = fma52lo(res[94], a[35], a[59]);  // Sum(94)
    res[95]  = fma52hi(res[95], a[35], a[59]);  // Sum(94)
    res[95]  = fma52lo(res[95], a[36], a[59]);  // Sum(95)
    res[96]  = fma52hi(res[96], a[36], a[59]);  // Sum(95)
    res[84]  = add64(res[84], res[84]);         // Double(84)
    res[85]  = add64(res[85], res[85]);         // Double(85)
    res[86]  = add64(res[86], res[86]);         // Double(86)
    res[87]  = add64(res[87], res[87]);         // Double(87)
    res[88]  = add64(res[88], res[88]);         // Double(88)
    res[89]  = add64(res[89], res[89]);         // Double(89)
    res[90]  = add64(res[90], res[90]);         // Double(90)
    res[91]  = add64(res[91], res[91]);         // Double(91)
    res[92]  = add64(res[92], res[92]);         // Double(92)
    res[93]  = add64(res[93], res[93]);         // Double(93)
    res[94]  = add64(res[94], res[94]);         // Double(94)
    res[95]  = add64(res[95], res[95]);         // Double(95)
    res[84]  = fma52lo(res[84], a[42], a[42]);  // Add sqr(84)
    res[85]  = fma52hi(res[85], a[42], a[42]);  // Add sqr(84)
    res[86]  = fma52lo(res[86], a[43], a[43]);  // Add sqr(86)
    res[87]  = fma52hi(res[87], a[43], a[43]);  // Add sqr(86)
    res[88]  = fma52lo(res[88], a[44], a[44]);  // Add sqr(88)
    res[89]  = fma52hi(res[89], a[44], a[44]);  // Add sqr(88)
    res[90]  = fma52lo(res[90], a[45], a[45]);  // Add sqr(90)
    res[91]  = fma52hi(res[91], a[45], a[45]);  // Add sqr(90)
    res[92]  = fma52lo(res[92], a[46], a[46]);  // Add sqr(92)
    res[93]  = fma52hi(res[93], a[46], a[46]);  // Add sqr(92)
    res[94]  = fma52lo(res[94], a[47], a[47]);  // Add sqr(94)
    res[95]  = fma52hi(res[95], a[47], a[47]);  // Add sqr(94)
    res[96]  = fma52lo(res[96], a[47], a[49]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[47], a[49]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[48], a[49]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[48], a[49]);  // Sum(97)
    res[96]  = fma52lo(res[96], a[46], a[50]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[46], a[50]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[47], a[50]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[47], a[50]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[48], a[50]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[48], a[50]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[49], a[50]);  // Sum(99)
    res[100] = fma52hi(res[100], a[49], a[50]); // Sum(99)
    res[96]  = fma52lo(res[96], a[45], a[51]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[45], a[51]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[46], a[51]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[46], a[51]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[47], a[51]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[47], a[51]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[48], a[51]);  // Sum(99)
    res[100] = fma52hi(res[100], a[48], a[51]); // Sum(99)
    res[100] = fma52lo(res[100], a[49], a[51]); // Sum(100)
    res[101] = fma52hi(res[101], a[49], a[51]); // Sum(100)
    res[101] = fma52lo(res[101], a[50], a[51]); // Sum(101)
    res[102] = fma52hi(res[102], a[50], a[51]); // Sum(101)
    res[96]  = fma52lo(res[96], a[44], a[52]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[44], a[52]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[45], a[52]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[45], a[52]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[46], a[52]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[46], a[52]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[47], a[52]);  // Sum(99)
    res[100] = fma52hi(res[100], a[47], a[52]); // Sum(99)
    res[100] = fma52lo(res[100], a[48], a[52]); // Sum(100)
    res[101] = fma52hi(res[101], a[48], a[52]); // Sum(100)
    res[101] = fma52lo(res[101], a[49], a[52]); // Sum(101)
    res[102] = fma52hi(res[102], a[49], a[52]); // Sum(101)
    res[102] = fma52lo(res[102], a[50], a[52]); // Sum(102)
    res[103] = fma52hi(res[103], a[50], a[52]); // Sum(102)
    res[103] = fma52lo(res[103], a[51], a[52]); // Sum(103)
    res[104] = fma52hi(res[104], a[51], a[52]); // Sum(103)
    res[96]  = fma52lo(res[96], a[43], a[53]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[43], a[53]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[44], a[53]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[44], a[53]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[45], a[53]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[45], a[53]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[46], a[53]);  // Sum(99)
    res[100] = fma52hi(res[100], a[46], a[53]); // Sum(99)
    res[100] = fma52lo(res[100], a[47], a[53]); // Sum(100)
    res[101] = fma52hi(res[101], a[47], a[53]); // Sum(100)
    res[101] = fma52lo(res[101], a[48], a[53]); // Sum(101)
    res[102] = fma52hi(res[102], a[48], a[53]); // Sum(101)
    res[102] = fma52lo(res[102], a[49], a[53]); // Sum(102)
    res[103] = fma52hi(res[103], a[49], a[53]); // Sum(102)
    res[103] = fma52lo(res[103], a[50], a[53]); // Sum(103)
    res[104] = fma52hi(res[104], a[50], a[53]); // Sum(103)
    res[104] = fma52lo(res[104], a[51], a[53]); // Sum(104)
    res[105] = fma52hi(res[105], a[51], a[53]); // Sum(104)
    res[105] = fma52lo(res[105], a[52], a[53]); // Sum(105)
    res[106] = fma52hi(res[106], a[52], a[53]); // Sum(105)
    res[96]  = fma52lo(res[96], a[42], a[54]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[42], a[54]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[43], a[54]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[43], a[54]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[44], a[54]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[44], a[54]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[45], a[54]);  // Sum(99)
    res[100] = fma52hi(res[100], a[45], a[54]); // Sum(99)
    res[100] = fma52lo(res[100], a[46], a[54]); // Sum(100)
    res[101] = fma52hi(res[101], a[46], a[54]); // Sum(100)
    res[101] = fma52lo(res[101], a[47], a[54]); // Sum(101)
    res[102] = fma52hi(res[102], a[47], a[54]); // Sum(101)
    res[102] = fma52lo(res[102], a[48], a[54]); // Sum(102)
    res[103] = fma52hi(res[103], a[48], a[54]); // Sum(102)
    res[103] = fma52lo(res[103], a[49], a[54]); // Sum(103)
    res[104] = fma52hi(res[104], a[49], a[54]); // Sum(103)
    res[104] = fma52lo(res[104], a[50], a[54]); // Sum(104)
    res[105] = fma52hi(res[105], a[50], a[54]); // Sum(104)
    res[105] = fma52lo(res[105], a[51], a[54]); // Sum(105)
    res[106] = fma52hi(res[106], a[51], a[54]); // Sum(105)
    res[106] = fma52lo(res[106], a[52], a[54]); // Sum(106)
    res[107] = fma52hi(res[107], a[52], a[54]); // Sum(106)
    res[107] = fma52lo(res[107], a[53], a[54]); // Sum(107)
    res[108] = fma52hi(res[108], a[53], a[54]); // Sum(107)
    res[96]  = fma52lo(res[96], a[41], a[55]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[41], a[55]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[42], a[55]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[42], a[55]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[43], a[55]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[43], a[55]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[44], a[55]);  // Sum(99)
    res[100] = fma52hi(res[100], a[44], a[55]); // Sum(99)
    res[100] = fma52lo(res[100], a[45], a[55]); // Sum(100)
    res[101] = fma52hi(res[101], a[45], a[55]); // Sum(100)
    res[101] = fma52lo(res[101], a[46], a[55]); // Sum(101)
    res[102] = fma52hi(res[102], a[46], a[55]); // Sum(101)
    res[102] = fma52lo(res[102], a[47], a[55]); // Sum(102)
    res[103] = fma52hi(res[103], a[47], a[55]); // Sum(102)
    res[103] = fma52lo(res[103], a[48], a[55]); // Sum(103)
    res[104] = fma52hi(res[104], a[48], a[55]); // Sum(103)
    res[104] = fma52lo(res[104], a[49], a[55]); // Sum(104)
    res[105] = fma52hi(res[105], a[49], a[55]); // Sum(104)
    res[105] = fma52lo(res[105], a[50], a[55]); // Sum(105)
    res[106] = fma52hi(res[106], a[50], a[55]); // Sum(105)
    res[106] = fma52lo(res[106], a[51], a[55]); // Sum(106)
    res[107] = fma52hi(res[107], a[51], a[55]); // Sum(106)
    res[107] = fma52lo(res[107], a[52], a[55]); // Sum(107)
    res[108] = fma52hi(res[108], a[52], a[55]); // Sum(107)
    res[96]  = fma52lo(res[96], a[40], a[56]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[40], a[56]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[41], a[56]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[41], a[56]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[42], a[56]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[42], a[56]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[43], a[56]);  // Sum(99)
    res[100] = fma52hi(res[100], a[43], a[56]); // Sum(99)
    res[100] = fma52lo(res[100], a[44], a[56]); // Sum(100)
    res[101] = fma52hi(res[101], a[44], a[56]); // Sum(100)
    res[101] = fma52lo(res[101], a[45], a[56]); // Sum(101)
    res[102] = fma52hi(res[102], a[45], a[56]); // Sum(101)
    res[102] = fma52lo(res[102], a[46], a[56]); // Sum(102)
    res[103] = fma52hi(res[103], a[46], a[56]); // Sum(102)
    res[103] = fma52lo(res[103], a[47], a[56]); // Sum(103)
    res[104] = fma52hi(res[104], a[47], a[56]); // Sum(103)
    res[104] = fma52lo(res[104], a[48], a[56]); // Sum(104)
    res[105] = fma52hi(res[105], a[48], a[56]); // Sum(104)
    res[105] = fma52lo(res[105], a[49], a[56]); // Sum(105)
    res[106] = fma52hi(res[106], a[49], a[56]); // Sum(105)
    res[106] = fma52lo(res[106], a[50], a[56]); // Sum(106)
    res[107] = fma52hi(res[107], a[50], a[56]); // Sum(106)
    res[107] = fma52lo(res[107], a[51], a[56]); // Sum(107)
    res[108] = fma52hi(res[108], a[51], a[56]); // Sum(107)
    res[96]  = fma52lo(res[96], a[39], a[57]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[39], a[57]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[40], a[57]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[40], a[57]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[41], a[57]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[41], a[57]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[42], a[57]);  // Sum(99)
    res[100] = fma52hi(res[100], a[42], a[57]); // Sum(99)
    res[100] = fma52lo(res[100], a[43], a[57]); // Sum(100)
    res[101] = fma52hi(res[101], a[43], a[57]); // Sum(100)
    res[101] = fma52lo(res[101], a[44], a[57]); // Sum(101)
    res[102] = fma52hi(res[102], a[44], a[57]); // Sum(101)
    res[102] = fma52lo(res[102], a[45], a[57]); // Sum(102)
    res[103] = fma52hi(res[103], a[45], a[57]); // Sum(102)
    res[103] = fma52lo(res[103], a[46], a[57]); // Sum(103)
    res[104] = fma52hi(res[104], a[46], a[57]); // Sum(103)
    res[104] = fma52lo(res[104], a[47], a[57]); // Sum(104)
    res[105] = fma52hi(res[105], a[47], a[57]); // Sum(104)
    res[105] = fma52lo(res[105], a[48], a[57]); // Sum(105)
    res[106] = fma52hi(res[106], a[48], a[57]); // Sum(105)
    res[106] = fma52lo(res[106], a[49], a[57]); // Sum(106)
    res[107] = fma52hi(res[107], a[49], a[57]); // Sum(106)
    res[107] = fma52lo(res[107], a[50], a[57]); // Sum(107)
    res[108] = fma52hi(res[108], a[50], a[57]); // Sum(107)
    res[96]  = fma52lo(res[96], a[38], a[58]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[38], a[58]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[39], a[58]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[39], a[58]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[40], a[58]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[40], a[58]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[41], a[58]);  // Sum(99)
    res[100] = fma52hi(res[100], a[41], a[58]); // Sum(99)
    res[100] = fma52lo(res[100], a[42], a[58]); // Sum(100)
    res[101] = fma52hi(res[101], a[42], a[58]); // Sum(100)
    res[101] = fma52lo(res[101], a[43], a[58]); // Sum(101)
    res[102] = fma52hi(res[102], a[43], a[58]); // Sum(101)
    res[102] = fma52lo(res[102], a[44], a[58]); // Sum(102)
    res[103] = fma52hi(res[103], a[44], a[58]); // Sum(102)
    res[103] = fma52lo(res[103], a[45], a[58]); // Sum(103)
    res[104] = fma52hi(res[104], a[45], a[58]); // Sum(103)
    res[104] = fma52lo(res[104], a[46], a[58]); // Sum(104)
    res[105] = fma52hi(res[105], a[46], a[58]); // Sum(104)
    res[105] = fma52lo(res[105], a[47], a[58]); // Sum(105)
    res[106] = fma52hi(res[106], a[47], a[58]); // Sum(105)
    res[106] = fma52lo(res[106], a[48], a[58]); // Sum(106)
    res[107] = fma52hi(res[107], a[48], a[58]); // Sum(106)
    res[107] = fma52lo(res[107], a[49], a[58]); // Sum(107)
    res[108] = fma52hi(res[108], a[49], a[58]); // Sum(107)
    res[96]  = fma52lo(res[96], a[37], a[59]);  // Sum(96)
    res[97]  = fma52hi(res[97], a[37], a[59]);  // Sum(96)
    res[97]  = fma52lo(res[97], a[38], a[59]);  // Sum(97)
    res[98]  = fma52hi(res[98], a[38], a[59]);  // Sum(97)
    res[98]  = fma52lo(res[98], a[39], a[59]);  // Sum(98)
    res[99]  = fma52hi(res[99], a[39], a[59]);  // Sum(98)
    res[99]  = fma52lo(res[99], a[40], a[59]);  // Sum(99)
    res[100] = fma52hi(res[100], a[40], a[59]); // Sum(99)
    res[100] = fma52lo(res[100], a[41], a[59]); // Sum(100)
    res[101] = fma52hi(res[101], a[41], a[59]); // Sum(100)
    res[101] = fma52lo(res[101], a[42], a[59]); // Sum(101)
    res[102] = fma52hi(res[102], a[42], a[59]); // Sum(101)
    res[102] = fma52lo(res[102], a[43], a[59]); // Sum(102)
    res[103] = fma52hi(res[103], a[43], a[59]); // Sum(102)
    res[103] = fma52lo(res[103], a[44], a[59]); // Sum(103)
    res[104] = fma52hi(res[104], a[44], a[59]); // Sum(103)
    res[104] = fma52lo(res[104], a[45], a[59]); // Sum(104)
    res[105] = fma52hi(res[105], a[45], a[59]); // Sum(104)
    res[105] = fma52lo(res[105], a[46], a[59]); // Sum(105)
    res[106] = fma52hi(res[106], a[46], a[59]); // Sum(105)
    res[106] = fma52lo(res[106], a[47], a[59]); // Sum(106)
    res[107] = fma52hi(res[107], a[47], a[59]); // Sum(106)
    res[107] = fma52lo(res[107], a[48], a[59]); // Sum(107)
    res[108] = fma52hi(res[108], a[48], a[59]); // Sum(107)
    res[96]  = add64(res[96], res[96]);         // Double(96)
    res[97]  = add64(res[97], res[97]);         // Double(97)
    res[98]  = add64(res[98], res[98]);         // Double(98)
    res[99]  = add64(res[99], res[99]);         // Double(99)
    res[100] = add64(res[100], res[100]);       // Double(100)
    res[101] = add64(res[101], res[101]);       // Double(101)
    res[102] = add64(res[102], res[102]);       // Double(102)
    res[103] = add64(res[103], res[103]);       // Double(103)
    res[104] = add64(res[104], res[104]);       // Double(104)
    res[105] = add64(res[105], res[105]);       // Double(105)
    res[106] = add64(res[106], res[106]);       // Double(106)
    res[107] = add64(res[107], res[107]);       // Double(107)
    res[96]  = fma52lo(res[96], a[48], a[48]);  // Add sqr(96)
    res[97]  = fma52hi(res[97], a[48], a[48]);  // Add sqr(96)
    res[98]  = fma52lo(res[98], a[49], a[49]);  // Add sqr(98)
    res[99]  = fma52hi(res[99], a[49], a[49]);  // Add sqr(98)
    res[100] = fma52lo(res[100], a[50], a[50]); // Add sqr(100)
    res[101] = fma52hi(res[101], a[50], a[50]); // Add sqr(100)
    res[102] = fma52lo(res[102], a[51], a[51]); // Add sqr(102)
    res[103] = fma52hi(res[103], a[51], a[51]); // Add sqr(102)
    res[104] = fma52lo(res[104], a[52], a[52]); // Add sqr(104)
    res[105] = fma52hi(res[105], a[52], a[52]); // Add sqr(104)
    res[106] = fma52lo(res[106], a[53], a[53]); // Add sqr(106)
    res[107] = fma52hi(res[107], a[53], a[53]); // Add sqr(106)
    res[108] = fma52lo(res[108], a[53], a[55]); // Sum(108)
    res[109] = fma52hi(res[109], a[53], a[55]); // Sum(108)
    res[109] = fma52lo(res[109], a[54], a[55]); // Sum(109)
    res[110] = fma52hi(res[110], a[54], a[55]); // Sum(109)
    res[108] = fma52lo(res[108], a[52], a[56]); // Sum(108)
    res[109] = fma52hi(res[109], a[52], a[56]); // Sum(108)
    res[109] = fma52lo(res[109], a[53], a[56]); // Sum(109)
    res[110] = fma52hi(res[110], a[53], a[56]); // Sum(109)
    res[110] = fma52lo(res[110], a[54], a[56]); // Sum(110)
    res[111] = fma52hi(res[111], a[54], a[56]); // Sum(110)
    res[111] = fma52lo(res[111], a[55], a[56]); // Sum(111)
    res[112] = fma52hi(res[112], a[55], a[56]); // Sum(111)
    res[108] = fma52lo(res[108], a[51], a[57]); // Sum(108)
    res[109] = fma52hi(res[109], a[51], a[57]); // Sum(108)
    res[109] = fma52lo(res[109], a[52], a[57]); // Sum(109)
    res[110] = fma52hi(res[110], a[52], a[57]); // Sum(109)
    res[110] = fma52lo(res[110], a[53], a[57]); // Sum(110)
    res[111] = fma52hi(res[111], a[53], a[57]); // Sum(110)
    res[111] = fma52lo(res[111], a[54], a[57]); // Sum(111)
    res[112] = fma52hi(res[112], a[54], a[57]); // Sum(111)
    res[112] = fma52lo(res[112], a[55], a[57]); // Sum(112)
    res[113] = fma52hi(res[113], a[55], a[57]); // Sum(112)
    res[113] = fma52lo(res[113], a[56], a[57]); // Sum(113)
    res[114] = fma52hi(res[114], a[56], a[57]); // Sum(113)
    res[108] = fma52lo(res[108], a[50], a[58]); // Sum(108)
    res[109] = fma52hi(res[109], a[50], a[58]); // Sum(108)
    res[109] = fma52lo(res[109], a[51], a[58]); // Sum(109)
    res[110] = fma52hi(res[110], a[51], a[58]); // Sum(109)
    res[110] = fma52lo(res[110], a[52], a[58]); // Sum(110)
    res[111] = fma52hi(res[111], a[52], a[58]); // Sum(110)
    res[111] = fma52lo(res[111], a[53], a[58]); // Sum(111)
    res[112] = fma52hi(res[112], a[53], a[58]); // Sum(111)
    res[112] = fma52lo(res[112], a[54], a[58]); // Sum(112)
    res[113] = fma52hi(res[113], a[54], a[58]); // Sum(112)
    res[113] = fma52lo(res[113], a[55], a[58]); // Sum(113)
    res[114] = fma52hi(res[114], a[55], a[58]); // Sum(113)
    res[114] = fma52lo(res[114], a[56], a[58]); // Sum(114)
    res[115] = fma52hi(res[115], a[56], a[58]); // Sum(114)
    res[115] = fma52lo(res[115], a[57], a[58]); // Sum(115)
    res[116] = fma52hi(res[116], a[57], a[58]); // Sum(115)
    res[108] = fma52lo(res[108], a[49], a[59]); // Sum(108)
    res[109] = fma52hi(res[109], a[49], a[59]); // Sum(108)
    res[109] = fma52lo(res[109], a[50], a[59]); // Sum(109)
    res[110] = fma52hi(res[110], a[50], a[59]); // Sum(109)
    res[110] = fma52lo(res[110], a[51], a[59]); // Sum(110)
    res[111] = fma52hi(res[111], a[51], a[59]); // Sum(110)
    res[111] = fma52lo(res[111], a[52], a[59]); // Sum(111)
    res[112] = fma52hi(res[112], a[52], a[59]); // Sum(111)
    res[112] = fma52lo(res[112], a[53], a[59]); // Sum(112)
    res[113] = fma52hi(res[113], a[53], a[59]); // Sum(112)
    res[113] = fma52lo(res[113], a[54], a[59]); // Sum(113)
    res[114] = fma52hi(res[114], a[54], a[59]); // Sum(113)
    res[114] = fma52lo(res[114], a[55], a[59]); // Sum(114)
    res[115] = fma52hi(res[115], a[55], a[59]); // Sum(114)
    res[115] = fma52lo(res[115], a[56], a[59]); // Sum(115)
    res[116] = fma52hi(res[116], a[56], a[59]); // Sum(115)
    res[116] = fma52lo(res[116], a[57], a[59]); // Sum(116)
    res[117] = fma52hi(res[117], a[57], a[59]); // Sum(116)
    res[117] = fma52lo(res[117], a[58], a[59]); // Sum(117)
    res[118] = fma52hi(res[118], a[58], a[59]); // Sum(117)
    res[108] = add64(res[108], res[108]);       // Double(108)
    res[109] = add64(res[109], res[109]);       // Double(109)
    res[110] = add64(res[110], res[110]);       // Double(110)
    res[111] = add64(res[111], res[111]);       // Double(111)
    res[112] = add64(res[112], res[112]);       // Double(112)
    res[113] = add64(res[113], res[113]);       // Double(113)
    res[114] = add64(res[114], res[114]);       // Double(114)
    res[115] = add64(res[115], res[115]);       // Double(115)
    res[116] = add64(res[116], res[116]);       // Double(116)
    res[117] = add64(res[117], res[117]);       // Double(117)
    res[118] = add64(res[118], res[118]);       // Double(118)
    res[108] = fma52lo(res[108], a[54], a[54]); // Add sqr(108)
    res[109] = fma52hi(res[109], a[54], a[54]); // Add sqr(108)
    res[110] = fma52lo(res[110], a[55], a[55]); // Add sqr(110)
    res[111] = fma52hi(res[111], a[55], a[55]); // Add sqr(110)
    res[112] = fma52lo(res[112], a[56], a[56]); // Add sqr(112)
    res[113] = fma52hi(res[113], a[56], a[56]); // Add sqr(112)
    res[114] = fma52lo(res[114], a[57], a[57]); // Add sqr(114)
    res[115] = fma52hi(res[115], a[57], a[57]); // Add sqr(114)
    res[116] = fma52lo(res[116], a[58], a[58]); // Add sqr(116)
    res[117] = fma52hi(res[117], a[58], a[58]); // Add sqr(116)
    res[118] = fma52lo(res[118], a[59], a[59]); // Add sqr(118)
    res[119] = fma52hi(res[119], a[59], a[59]); // Add sqr(118)

    // Montgomery Reduction
    int it;
    for (it = 0; it < 60; it += 10) { // Reduction step
        int jt = 0;
        if ((it + 0) > 0)
            res[it + 0] = add64(res[it + 0], srli64(res[it + -1], DIGIT_SIZE));
        u[it + 0]         = mul52lo(res[it + 0], k);
        res[it + jt + 0]  = fma52lo(res[it + jt + 0], u[it + 0], m[jt + 0]);
        res[it + jt + 1]  = fma52hi(res[it + jt + 1], u[it + 0], m[jt + 0]);
        res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 0], m[jt + 1]);
        res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 0], m[jt + 1]);
        res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 0], m[jt + 2]);
        res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 0], m[jt + 2]);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 0], m[jt + 3]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 0], m[jt + 3]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 0], m[jt + 4]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 0], m[jt + 4]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 0], m[jt + 5]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 0], m[jt + 5]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 0], m[jt + 6]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 0], m[jt + 6]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 0], m[jt + 7]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 0], m[jt + 7]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 0], m[jt + 8]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 0], m[jt + 8]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 0], m[jt + 9]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 0], m[jt + 9]);
        res[it + 1]       = add64(res[it + 1], srli64(res[it + 0], DIGIT_SIZE));
        u[it + 1]         = mul52lo(res[it + 1], k);
        res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 1], m[jt + 0]);
        res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 1], m[jt + 0]);
        res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 1], m[jt + 1]);
        res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 1], m[jt + 1]);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 1], m[jt + 2]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 1], m[jt + 2]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 1], m[jt + 3]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 1], m[jt + 3]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 1], m[jt + 4]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 1], m[jt + 4]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 1], m[jt + 5]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 1], m[jt + 5]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 1], m[jt + 6]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 1], m[jt + 6]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 1], m[jt + 7]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 1], m[jt + 7]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 1], m[jt + 8]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 1], m[jt + 8]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 1], m[jt + 9]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 1], m[jt + 9]);
        res[it + 2]       = add64(res[it + 2], srli64(res[it + 1], DIGIT_SIZE));
        u[it + 2]         = mul52lo(res[it + 2], k);
        res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 2], m[jt + 0]);
        res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 2], m[jt + 0]);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 2], m[jt + 1]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 2], m[jt + 1]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 2], m[jt + 2]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 2], m[jt + 2]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 2], m[jt + 3]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 2], m[jt + 3]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 2], m[jt + 4]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 2], m[jt + 4]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 2], m[jt + 5]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 2], m[jt + 5]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 2], m[jt + 6]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 2], m[jt + 6]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 2], m[jt + 7]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 2], m[jt + 7]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 2], m[jt + 8]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 2], m[jt + 8]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 2], m[jt + 9]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 2], m[jt + 9]);
        res[it + 3]       = add64(res[it + 3], srli64(res[it + 2], DIGIT_SIZE));
        u[it + 3]         = mul52lo(res[it + 3], k);
        res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 3], m[jt + 0]);
        res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 3], m[jt + 0]);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 3], m[jt + 1]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 3], m[jt + 1]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 3], m[jt + 2]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 3], m[jt + 2]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 3], m[jt + 3]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 3], m[jt + 3]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 3], m[jt + 4]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 3], m[jt + 4]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 3], m[jt + 5]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 3], m[jt + 5]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 3], m[jt + 6]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 3], m[jt + 6]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 3], m[jt + 7]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 3], m[jt + 7]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 3], m[jt + 8]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 3], m[jt + 8]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 3], m[jt + 9]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 3], m[jt + 9]);
        res[it + 4]       = add64(res[it + 4], srli64(res[it + 3], DIGIT_SIZE));
        u[it + 4]         = mul52lo(res[it + 4], k);
        res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 4], m[jt + 0]);
        res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 4], m[jt + 0]);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 4], m[jt + 1]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 4], m[jt + 1]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 4], m[jt + 2]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 4], m[jt + 2]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 4], m[jt + 3]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 4], m[jt + 3]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 4], m[jt + 4]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 4], m[jt + 4]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 4], m[jt + 5]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 4], m[jt + 5]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 4], m[jt + 6]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 4], m[jt + 6]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 4], m[jt + 7]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 4], m[jt + 7]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 4], m[jt + 8]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 4], m[jt + 8]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 4], m[jt + 9]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 4], m[jt + 9]);
        res[it + 5]       = add64(res[it + 5], srli64(res[it + 4], DIGIT_SIZE));
        u[it + 5]         = mul52lo(res[it + 5], k);
        res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 5], m[jt + 0]);
        res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 5], m[jt + 0]);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 5], m[jt + 1]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 5], m[jt + 1]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 5], m[jt + 2]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 5], m[jt + 2]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 5], m[jt + 3]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 5], m[jt + 3]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 5], m[jt + 4]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 5], m[jt + 4]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 5], m[jt + 5]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 5], m[jt + 5]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 5], m[jt + 6]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 5], m[jt + 6]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 5], m[jt + 7]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 5], m[jt + 7]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 5], m[jt + 8]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 5], m[jt + 8]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 5], m[jt + 9]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 5], m[jt + 9]);
        res[it + 6]       = add64(res[it + 6], srli64(res[it + 5], DIGIT_SIZE));
        u[it + 6]         = mul52lo(res[it + 6], k);
        res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 6], m[jt + 0]);
        res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 6], m[jt + 0]);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 6], m[jt + 1]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 6], m[jt + 1]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 6], m[jt + 2]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 6], m[jt + 2]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 6], m[jt + 3]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 6], m[jt + 3]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 6], m[jt + 4]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 6], m[jt + 4]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 6], m[jt + 5]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 6], m[jt + 5]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 6], m[jt + 6]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 6], m[jt + 6]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 6], m[jt + 7]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 6], m[jt + 7]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 6], m[jt + 8]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 6], m[jt + 8]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 6], m[jt + 9]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 6], m[jt + 9]);
        res[it + 7]       = add64(res[it + 7], srli64(res[it + 6], DIGIT_SIZE));
        u[it + 7]         = mul52lo(res[it + 7], k);
        res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 7], m[jt + 0]);
        res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 7], m[jt + 0]);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 7], m[jt + 1]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 7], m[jt + 1]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 7], m[jt + 2]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 7], m[jt + 2]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 7], m[jt + 3]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 7], m[jt + 3]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 7], m[jt + 4]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 7], m[jt + 4]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 7], m[jt + 5]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 7], m[jt + 5]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 7], m[jt + 6]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 7], m[jt + 6]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 7], m[jt + 7]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 7], m[jt + 7]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 7], m[jt + 8]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 7], m[jt + 8]);
        res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 7], m[jt + 9]);
        res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 7], m[jt + 9]);
        res[it + 8]       = add64(res[it + 8], srli64(res[it + 7], DIGIT_SIZE));
        u[it + 8]         = mul52lo(res[it + 8], k);
        res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 8], m[jt + 0]);
        res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 8], m[jt + 0]);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 8], m[jt + 1]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 8], m[jt + 1]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 8], m[jt + 2]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 8], m[jt + 2]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 8], m[jt + 3]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 8], m[jt + 3]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 8], m[jt + 4]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 8], m[jt + 4]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 8], m[jt + 5]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 8], m[jt + 5]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 8], m[jt + 6]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 8], m[jt + 6]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 8], m[jt + 7]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 8], m[jt + 7]);
        res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 8], m[jt + 8]);
        res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 8], m[jt + 8]);
        res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 8], m[jt + 9]);
        res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 8], m[jt + 9]);
        res[it + 9]       = add64(res[it + 9], srli64(res[it + 8], DIGIT_SIZE));
        u[it + 9]         = mul52lo(res[it + 9], k);
        res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 9], m[jt + 0]);
        res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 9], m[jt + 0]);
        res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 9], m[jt + 1]);
        res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 9], m[jt + 1]);
        res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 9], m[jt + 2]);
        res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 9], m[jt + 2]);
        res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 9], m[jt + 3]);
        res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 9], m[jt + 3]);
        res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 9], m[jt + 4]);
        res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 9], m[jt + 4]);
        res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 9], m[jt + 5]);
        res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 9], m[jt + 5]);
        res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 9], m[jt + 6]);
        res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 9], m[jt + 6]);
        res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 9], m[jt + 7]);
        res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 9], m[jt + 7]);
        res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 9], m[jt + 8]);
        res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 9], m[jt + 8]);
        res[it + jt + 18] = fma52lo(res[it + jt + 18], u[it + 9], m[jt + 9]);
        res[it + jt + 19] = fma52hi(res[it + jt + 19], u[it + 9], m[jt + 9]);

        for (jt = 10; jt < 60; jt += 10) { // Poly tile
            res[it + jt + 0]  = fma52lo(res[it + jt + 0], u[it + 0], m[jt + 0]);
            res[it + jt + 1]  = fma52hi(res[it + jt + 1], u[it + 0], m[jt + 0]);
            res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 0], m[jt + 1]);
            res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 0], m[jt + 1]);
            res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 0], m[jt + 2]);
            res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 0], m[jt + 2]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 0], m[jt + 3]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 0], m[jt + 3]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 0], m[jt + 4]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 0], m[jt + 4]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 0], m[jt + 5]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 0], m[jt + 5]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 0], m[jt + 6]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 0], m[jt + 6]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 0], m[jt + 7]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 0], m[jt + 7]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 0], m[jt + 8]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 0], m[jt + 8]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 0], m[jt + 9]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 0], m[jt + 9]);
            res[it + jt + 1]  = fma52lo(res[it + jt + 1], u[it + 1], m[jt + 0]);
            res[it + jt + 2]  = fma52hi(res[it + jt + 2], u[it + 1], m[jt + 0]);
            res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 1], m[jt + 1]);
            res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 1], m[jt + 1]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 1], m[jt + 2]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 1], m[jt + 2]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 1], m[jt + 3]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 1], m[jt + 3]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 1], m[jt + 4]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 1], m[jt + 4]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 1], m[jt + 5]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 1], m[jt + 5]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 1], m[jt + 6]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 1], m[jt + 6]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 1], m[jt + 7]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 1], m[jt + 7]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 1], m[jt + 8]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 1], m[jt + 8]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 1], m[jt + 9]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 1], m[jt + 9]);
            res[it + jt + 2]  = fma52lo(res[it + jt + 2], u[it + 2], m[jt + 0]);
            res[it + jt + 3]  = fma52hi(res[it + jt + 3], u[it + 2], m[jt + 0]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 2], m[jt + 1]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 2], m[jt + 1]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 2], m[jt + 2]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 2], m[jt + 2]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 2], m[jt + 3]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 2], m[jt + 3]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 2], m[jt + 4]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 2], m[jt + 4]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 2], m[jt + 5]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 2], m[jt + 5]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 2], m[jt + 6]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 2], m[jt + 6]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 2], m[jt + 7]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 2], m[jt + 7]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 2], m[jt + 8]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 2], m[jt + 8]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 2], m[jt + 9]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 2], m[jt + 9]);
            res[it + jt + 3]  = fma52lo(res[it + jt + 3], u[it + 3], m[jt + 0]);
            res[it + jt + 4]  = fma52hi(res[it + jt + 4], u[it + 3], m[jt + 0]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 3], m[jt + 1]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 3], m[jt + 1]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 3], m[jt + 2]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 3], m[jt + 2]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 3], m[jt + 3]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 3], m[jt + 3]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 3], m[jt + 4]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 3], m[jt + 4]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 3], m[jt + 5]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 3], m[jt + 5]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 3], m[jt + 6]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 3], m[jt + 6]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 3], m[jt + 7]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 3], m[jt + 7]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 3], m[jt + 8]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 3], m[jt + 8]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 3], m[jt + 9]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 3], m[jt + 9]);
            res[it + jt + 4]  = fma52lo(res[it + jt + 4], u[it + 4], m[jt + 0]);
            res[it + jt + 5]  = fma52hi(res[it + jt + 5], u[it + 4], m[jt + 0]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 4], m[jt + 1]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 4], m[jt + 1]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 4], m[jt + 2]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 4], m[jt + 2]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 4], m[jt + 3]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 4], m[jt + 3]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 4], m[jt + 4]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 4], m[jt + 4]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 4], m[jt + 5]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 4], m[jt + 5]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 4], m[jt + 6]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 4], m[jt + 6]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 4], m[jt + 7]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 4], m[jt + 7]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 4], m[jt + 8]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 4], m[jt + 8]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 4], m[jt + 9]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 4], m[jt + 9]);
            res[it + jt + 5]  = fma52lo(res[it + jt + 5], u[it + 5], m[jt + 0]);
            res[it + jt + 6]  = fma52hi(res[it + jt + 6], u[it + 5], m[jt + 0]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 5], m[jt + 1]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 5], m[jt + 1]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 5], m[jt + 2]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 5], m[jt + 2]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 5], m[jt + 3]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 5], m[jt + 3]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 5], m[jt + 4]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 5], m[jt + 4]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 5], m[jt + 5]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 5], m[jt + 5]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 5], m[jt + 6]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 5], m[jt + 6]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 5], m[jt + 7]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 5], m[jt + 7]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 5], m[jt + 8]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 5], m[jt + 8]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 5], m[jt + 9]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 5], m[jt + 9]);
            res[it + jt + 6]  = fma52lo(res[it + jt + 6], u[it + 6], m[jt + 0]);
            res[it + jt + 7]  = fma52hi(res[it + jt + 7], u[it + 6], m[jt + 0]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 6], m[jt + 1]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 6], m[jt + 1]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 6], m[jt + 2]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 6], m[jt + 2]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 6], m[jt + 3]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 6], m[jt + 3]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 6], m[jt + 4]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 6], m[jt + 4]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 6], m[jt + 5]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 6], m[jt + 5]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 6], m[jt + 6]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 6], m[jt + 6]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 6], m[jt + 7]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 6], m[jt + 7]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 6], m[jt + 8]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 6], m[jt + 8]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 6], m[jt + 9]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 6], m[jt + 9]);
            res[it + jt + 7]  = fma52lo(res[it + jt + 7], u[it + 7], m[jt + 0]);
            res[it + jt + 8]  = fma52hi(res[it + jt + 8], u[it + 7], m[jt + 0]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 7], m[jt + 1]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 7], m[jt + 1]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 7], m[jt + 2]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 7], m[jt + 2]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 7], m[jt + 3]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 7], m[jt + 3]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 7], m[jt + 4]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 7], m[jt + 4]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 7], m[jt + 5]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 7], m[jt + 5]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 7], m[jt + 6]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 7], m[jt + 6]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 7], m[jt + 7]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 7], m[jt + 7]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 7], m[jt + 8]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 7], m[jt + 8]);
            res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 7], m[jt + 9]);
            res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 7], m[jt + 9]);
            res[it + jt + 8]  = fma52lo(res[it + jt + 8], u[it + 8], m[jt + 0]);
            res[it + jt + 9]  = fma52hi(res[it + jt + 9], u[it + 8], m[jt + 0]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 8], m[jt + 1]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 8], m[jt + 1]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 8], m[jt + 2]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 8], m[jt + 2]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 8], m[jt + 3]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 8], m[jt + 3]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 8], m[jt + 4]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 8], m[jt + 4]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 8], m[jt + 5]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 8], m[jt + 5]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 8], m[jt + 6]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 8], m[jt + 6]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 8], m[jt + 7]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 8], m[jt + 7]);
            res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 8], m[jt + 8]);
            res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 8], m[jt + 8]);
            res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 8], m[jt + 9]);
            res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 8], m[jt + 9]);
            res[it + jt + 9]  = fma52lo(res[it + jt + 9], u[it + 9], m[jt + 0]);
            res[it + jt + 10] = fma52hi(res[it + jt + 10], u[it + 9], m[jt + 0]);
            res[it + jt + 10] = fma52lo(res[it + jt + 10], u[it + 9], m[jt + 1]);
            res[it + jt + 11] = fma52hi(res[it + jt + 11], u[it + 9], m[jt + 1]);
            res[it + jt + 11] = fma52lo(res[it + jt + 11], u[it + 9], m[jt + 2]);
            res[it + jt + 12] = fma52hi(res[it + jt + 12], u[it + 9], m[jt + 2]);
            res[it + jt + 12] = fma52lo(res[it + jt + 12], u[it + 9], m[jt + 3]);
            res[it + jt + 13] = fma52hi(res[it + jt + 13], u[it + 9], m[jt + 3]);
            res[it + jt + 13] = fma52lo(res[it + jt + 13], u[it + 9], m[jt + 4]);
            res[it + jt + 14] = fma52hi(res[it + jt + 14], u[it + 9], m[jt + 4]);
            res[it + jt + 14] = fma52lo(res[it + jt + 14], u[it + 9], m[jt + 5]);
            res[it + jt + 15] = fma52hi(res[it + jt + 15], u[it + 9], m[jt + 5]);
            res[it + jt + 15] = fma52lo(res[it + jt + 15], u[it + 9], m[jt + 6]);
            res[it + jt + 16] = fma52hi(res[it + jt + 16], u[it + 9], m[jt + 6]);
            res[it + jt + 16] = fma52lo(res[it + jt + 16], u[it + 9], m[jt + 7]);
            res[it + jt + 17] = fma52hi(res[it + jt + 17], u[it + 9], m[jt + 7]);
            res[it + jt + 17] = fma52lo(res[it + jt + 17], u[it + 9], m[jt + 8]);
            res[it + jt + 18] = fma52hi(res[it + jt + 18], u[it + 9], m[jt + 8]);
            res[it + jt + 18] = fma52lo(res[it + jt + 18], u[it + 9], m[jt + 9]);
            res[it + jt + 19] = fma52hi(res[it + jt + 19], u[it + 9], m[jt + 9]);
        }
    }

    // Normalization
    res[60]  = add64(res[60], srli64(res[59], DIGIT_SIZE));
    r[0]     = and64_const(res[60], DIGIT_MASK);
    res[61]  = add64(res[61], srli64(res[60], DIGIT_SIZE));
    r[1]     = and64_const(res[61], DIGIT_MASK);
    res[62]  = add64(res[62], srli64(res[61], DIGIT_SIZE));
    r[2]     = and64_const(res[62], DIGIT_MASK);
    res[63]  = add64(res[63], srli64(res[62], DIGIT_SIZE));
    r[3]     = and64_const(res[63], DIGIT_MASK);
    res[64]  = add64(res[64], srli64(res[63], DIGIT_SIZE));
    r[4]     = and64_const(res[64], DIGIT_MASK);
    res[65]  = add64(res[65], srli64(res[64], DIGIT_SIZE));
    r[5]     = and64_const(res[65], DIGIT_MASK);
    res[66]  = add64(res[66], srli64(res[65], DIGIT_SIZE));
    r[6]     = and64_const(res[66], DIGIT_MASK);
    res[67]  = add64(res[67], srli64(res[66], DIGIT_SIZE));
    r[7]     = and64_const(res[67], DIGIT_MASK);
    res[68]  = add64(res[68], srli64(res[67], DIGIT_SIZE));
    r[8]     = and64_const(res[68], DIGIT_MASK);
    res[69]  = add64(res[69], srli64(res[68], DIGIT_SIZE));
    r[9]     = and64_const(res[69], DIGIT_MASK);
    res[70]  = add64(res[70], srli64(res[69], DIGIT_SIZE));
    r[10]    = and64_const(res[70], DIGIT_MASK);
    res[71]  = add64(res[71], srli64(res[70], DIGIT_SIZE));
    r[11]    = and64_const(res[71], DIGIT_MASK);
    res[72]  = add64(res[72], srli64(res[71], DIGIT_SIZE));
    r[12]    = and64_const(res[72], DIGIT_MASK);
    res[73]  = add64(res[73], srli64(res[72], DIGIT_SIZE));
    r[13]    = and64_const(res[73], DIGIT_MASK);
    res[74]  = add64(res[74], srli64(res[73], DIGIT_SIZE));
    r[14]    = and64_const(res[74], DIGIT_MASK);
    res[75]  = add64(res[75], srli64(res[74], DIGIT_SIZE));
    r[15]    = and64_const(res[75], DIGIT_MASK);
    res[76]  = add64(res[76], srli64(res[75], DIGIT_SIZE));
    r[16]    = and64_const(res[76], DIGIT_MASK);
    res[77]  = add64(res[77], srli64(res[76], DIGIT_SIZE));
    r[17]    = and64_const(res[77], DIGIT_MASK);
    res[78]  = add64(res[78], srli64(res[77], DIGIT_SIZE));
    r[18]    = and64_const(res[78], DIGIT_MASK);
    res[79]  = add64(res[79], srli64(res[78], DIGIT_SIZE));
    r[19]    = and64_const(res[79], DIGIT_MASK);
    res[80]  = add64(res[80], srli64(res[79], DIGIT_SIZE));
    r[20]    = and64_const(res[80], DIGIT_MASK);
    res[81]  = add64(res[81], srli64(res[80], DIGIT_SIZE));
    r[21]    = and64_const(res[81], DIGIT_MASK);
    res[82]  = add64(res[82], srli64(res[81], DIGIT_SIZE));
    r[22]    = and64_const(res[82], DIGIT_MASK);
    res[83]  = add64(res[83], srli64(res[82], DIGIT_SIZE));
    r[23]    = and64_const(res[83], DIGIT_MASK);
    res[84]  = add64(res[84], srli64(res[83], DIGIT_SIZE));
    r[24]    = and64_const(res[84], DIGIT_MASK);
    res[85]  = add64(res[85], srli64(res[84], DIGIT_SIZE));
    r[25]    = and64_const(res[85], DIGIT_MASK);
    res[86]  = add64(res[86], srli64(res[85], DIGIT_SIZE));
    r[26]    = and64_const(res[86], DIGIT_MASK);
    res[87]  = add64(res[87], srli64(res[86], DIGIT_SIZE));
    r[27]    = and64_const(res[87], DIGIT_MASK);
    res[88]  = add64(res[88], srli64(res[87], DIGIT_SIZE));
    r[28]    = and64_const(res[88], DIGIT_MASK);
    res[89]  = add64(res[89], srli64(res[88], DIGIT_SIZE));
    r[29]    = and64_const(res[89], DIGIT_MASK);
    res[90]  = add64(res[90], srli64(res[89], DIGIT_SIZE));
    r[30]    = and64_const(res[90], DIGIT_MASK);
    res[91]  = add64(res[91], srli64(res[90], DIGIT_SIZE));
    r[31]    = and64_const(res[91], DIGIT_MASK);
    res[92]  = add64(res[92], srli64(res[91], DIGIT_SIZE));
    r[32]    = and64_const(res[92], DIGIT_MASK);
    res[93]  = add64(res[93], srli64(res[92], DIGIT_SIZE));
    r[33]    = and64_const(res[93], DIGIT_MASK);
    res[94]  = add64(res[94], srli64(res[93], DIGIT_SIZE));
    r[34]    = and64_const(res[94], DIGIT_MASK);
    res[95]  = add64(res[95], srli64(res[94], DIGIT_SIZE));
    r[35]    = and64_const(res[95], DIGIT_MASK);
    res[96]  = add64(res[96], srli64(res[95], DIGIT_SIZE));
    r[36]    = and64_const(res[96], DIGIT_MASK);
    res[97]  = add64(res[97], srli64(res[96], DIGIT_SIZE));
    r[37]    = and64_const(res[97], DIGIT_MASK);
    res[98]  = add64(res[98], srli64(res[97], DIGIT_SIZE));
    r[38]    = and64_const(res[98], DIGIT_MASK);
    res[99]  = add64(res[99], srli64(res[98], DIGIT_SIZE));
    r[39]    = and64_const(res[99], DIGIT_MASK);
    res[100] = add64(res[100], srli64(res[99], DIGIT_SIZE));
    r[40]    = and64_const(res[100], DIGIT_MASK);
    res[101] = add64(res[101], srli64(res[100], DIGIT_SIZE));
    r[41]    = and64_const(res[101], DIGIT_MASK);
    res[102] = add64(res[102], srli64(res[101], DIGIT_SIZE));
    r[42]    = and64_const(res[102], DIGIT_MASK);
    res[103] = add64(res[103], srli64(res[102], DIGIT_SIZE));
    r[43]    = and64_const(res[103], DIGIT_MASK);
    res[104] = add64(res[104], srli64(res[103], DIGIT_SIZE));
    r[44]    = and64_const(res[104], DIGIT_MASK);
    res[105] = add64(res[105], srli64(res[104], DIGIT_SIZE));
    r[45]    = and64_const(res[105], DIGIT_MASK);
    res[106] = add64(res[106], srli64(res[105], DIGIT_SIZE));
    r[46]    = and64_const(res[106], DIGIT_MASK);
    res[107] = add64(res[107], srli64(res[106], DIGIT_SIZE));
    r[47]    = and64_const(res[107], DIGIT_MASK);
    res[108] = add64(res[108], srli64(res[107], DIGIT_SIZE));
    r[48]    = and64_const(res[108], DIGIT_MASK);
    res[109] = add64(res[109], srli64(res[108], DIGIT_SIZE));
    r[49]    = and64_const(res[109], DIGIT_MASK);
    res[110] = add64(res[110], srli64(res[109], DIGIT_SIZE));
    r[50]    = and64_const(res[110], DIGIT_MASK);
    res[111] = add64(res[111], srli64(res[110], DIGIT_SIZE));
    r[51]    = and64_const(res[111], DIGIT_MASK);
    res[112] = add64(res[112], srli64(res[111], DIGIT_SIZE));
    r[52]    = and64_const(res[112], DIGIT_MASK);
    res[113] = add64(res[113], srli64(res[112], DIGIT_SIZE));
    r[53]    = and64_const(res[113], DIGIT_MASK);
    res[114] = add64(res[114], srli64(res[113], DIGIT_SIZE));
    r[54]    = and64_const(res[114], DIGIT_MASK);
    res[115] = add64(res[115], srli64(res[114], DIGIT_SIZE));
    r[55]    = and64_const(res[115], DIGIT_MASK);
    res[116] = add64(res[116], srli64(res[115], DIGIT_SIZE));
    r[56]    = and64_const(res[116], DIGIT_MASK);
    res[117] = add64(res[117], srli64(res[116], DIGIT_SIZE));
    r[57]    = and64_const(res[117], DIGIT_MASK);
    res[118] = add64(res[118], srli64(res[117], DIGIT_SIZE));
    r[58]    = and64_const(res[118], DIGIT_MASK);
    res[119] = add64(res[119], srli64(res[118], DIGIT_SIZE));
    r[59]    = and64_const(res[119], DIGIT_MASK);
}

#endif /* #if (_MBX>=_MBX_K1) */
