/*
  ==============================================================================

   This file is part of the JUCE framework.
   Copyright (c) Raw Material Software Limited

   JUCE is an open source framework subject to commercial or open source
   licensing.

   By downloading, installing, or using the JUCE framework, or combining the
   JUCE framework with any other source code, object code, content or any other
   copyrightable work, you agree to the terms of the JUCE End User Licence
   Agreement, and all incorporated terms including the JUCE Privacy Policy and
   the JUCE Website Terms of Service, as applicable, which will bind you. If you
   do not agree to the terms of these agreements, we will not license the JUCE
   framework to you, and you must discontinue the installation or download
   process and cease use of the JUCE framework.

   JUCE End User Licence Agreement: https://juce.com/legal/juce-8-licence/
   JUCE Privacy Policy: https://juce.com/juce-privacy-policy
   JUCE Website Terms of Service: https://juce.com/juce-website-terms-of-service/

   Or:

   You may also use this code under the terms of the AGPLv3:
   https://www.gnu.org/licenses/agpl-3.0.en.html

   THE JUCE FRAMEWORK IS PROVIDED "AS IS" WITHOUT ANY WARRANTY, AND ALL
   WARRANTIES, WHETHER EXPRESSED OR IMPLIED, INCLUDING WARRANTY OF
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, ARE DISCLAIMED.

  ==============================================================================
*/

/*
    This header contains preprocessor config flags that would normally be
    generated by the build systems of the various LV2 libraries.

    Rather than using the generated platform-dependent headers, we use JUCE's
    platform detection macros to pick the right config values at build time.
*/

#pragma once

#define LILV_DYN_MANIFEST
#define LILV_STATIC
#define LV2_STATIC
#define SERD_STATIC
#define SORD_STATIC
#define SRATOM_STATIC
#define ZIX_STATIC

#define LILV_VERSION "0.24.12"
#define SERD_VERSION "0.30.10"
#define SORD_VERSION "0.16.9"

#define LILV_CXX 1

#if JUCE_WINDOWS
 #define LILV_DIR_SEP "\\"
 #define LILV_PATH_SEP ";"
#else
 #define LILV_DIR_SEP "/"
 #define LILV_PATH_SEP ":"
#endif

#ifndef LILV_DEFAULT_LV2_PATH
 #if JUCE_MAC || JUCE_IOS
  #define LILV_DEFAULT_LV2_PATH \
    "~/Library/Audio/Plug-Ins/LV2"  LILV_PATH_SEP \
    "~/.lv2"                        LILV_PATH_SEP \
    "/usr/local/lib/lv2"            LILV_PATH_SEP \
    "/usr/lib/lv2"                  LILV_PATH_SEP \
    "/Library/Audio/Plug-Ins/LV2"
 #elif JUCE_WINDOWS
  #define LILV_DEFAULT_LV2_PATH \
    "%APPDATA%\\LV2"                LILV_PATH_SEP \
    "%COMMONPROGRAMFILES%\\LV2"
 #elif JUCE_LINUX || JUCE_BSD || JUCE_ANDROID
  #define LILV_DEFAULT_LV2_PATH \
    "~/.lv2"                        LILV_PATH_SEP \
    "/usr/lib/lv2"                  LILV_PATH_SEP \
    "/usr/local/lib/lv2"
 #else
  #error "Unsupported platform"
 #endif
#endif
