"""This module defines groups of related tests that can be executed with the same test harness."""

CODEC_TESTS = [
    "SerializationTest.cpp",
    "SwizzlerTest.cpp",
    "ICCTest.cpp",
    "InvalidIndexedPngTest.cpp",
    "BadIcoTest.cpp",
    "SerialProcsTest.cpp",
    "CanvasStateTest.cpp",
]

CORE_TESTS = [
    "AAClipTest.cpp",
    "ArenaAllocTest.cpp",
    "AsADashTest.cpp",
    "AvifTest.cpp",
    "BRDTest.cpp",
    "BezierCurveTest.cpp",
    "BitSetTest.cpp",
    "BitmapCopyTest.cpp",
    "BitmapGetColorTest.cpp",
    "BitmapTest.cpp",
    "BlitMaskClip.cpp",
    "CachedDecodingPixelRefTest.cpp",
    "CanvasTest.cpp",
    "ChecksumTest.cpp",
    "ClipCubicTest.cpp",
    "ClipStackTest.cpp",
    "ClipperTest.cpp",
    "ColorMatrixTest.cpp",
    "ColorPrivTest.cpp",
    "ColorTest.cpp",
    "CtsEnforcement.cpp",
    "CubicMapTest.cpp",
    "DashPathEffectTest.cpp",
    "DataRefTest.cpp",
    "DequeTest.cpp",
    "DescriptorTest.cpp",
    "DrawBitmapRectTest.cpp",
    "DrawPathTest.cpp",
    "EmptyPathTest.cpp",
    "F16StagesTest.cpp",
    "FillPathTest.cpp",
    "FitsInTest.cpp",
    "FlattenableFactoryToName.cpp",
    "FlattenableNameToFactory.cpp",
    "Float16Test.cpp",
    "FloatingPointTest.cpp",
    "FontTest.cpp",
    "FrontBufferedStreamTest.cpp",
    "GeometryTest.cpp",
    "HSVRoundTripTest.cpp",
    "HashTest.cpp",
    "HighContrastFilterTest.cpp",
    "ImageBitmapTest.cpp",
    "ImageFrom565Bitmap.cpp",
    "ImageGeneratorTest.cpp",
    "IncrTopoSortTest.cpp",
    "InfRectTest.cpp",
    "InsetConvexPolyTest.cpp",
    "IsClosedSingleContourTest.cpp",
    "LListTest.cpp",
    "LRUCacheTest.cpp",
    "M44Test.cpp",
    "MD5Test.cpp",
    "MallocPixelRefTest.cpp",
    "MaskCacheTest.cpp",
    "MathTest.cpp",
    "MatrixProcsTest.cpp",
    "MatrixTest.cpp",
    "MemoryTest.cpp",
    "MemsetTest.cpp",
    "MeshTest.cpp",
    "MetaDataTest.cpp",
    "NdkDecodeTest.cpp",
    "NdkEncodeTest.cpp",
    "NonlinearBlendingTest.cpp",
    "OSPathTest.cpp",
    "OffsetSimplePolyTest.cpp",
    "OnceTest.cpp",
    "OverAlignedTest.cpp",
    "ParametricStageTest.cpp",
    "ParseColorTest.cpp",
    "ParsePathTest.cpp",
    "PathBuilderTest.cpp",
    "PathCoverageTest.cpp",
    "PathMeasureTest.cpp",
    "PictureBBHTest.cpp",
    "PictureShaderTest.cpp",
    "PixelRefTest.cpp",
    "Point3Test.cpp",
    "PointTest.cpp",
    "PolyUtilsTest.cpp",
    "QuickRejectTest.cpp",
    "RRectInPathTest.cpp",
    "RTreeTest.cpp",
    "RandomTest.cpp",
    "ReadPixelsTest.cpp",
    "RecorderTest.cpp",
    "RecordingXfermodeTest.cpp",
    "RectTest.cpp",
    "RefCntTest.cpp",
    "RegionTest.cpp",
    "SRGBTest.cpp",
    "SafeMathTest.cpp",
    "ScalarTest.cpp",
    "ScaleToSidesTest.cpp",
    "ShaderOpacityTest.cpp",
    "ShaderTest.cpp",
    "ShadowTest.cpp",
    "SizeTest.cpp",
    "SkBase64Test.cpp",
    "SkBlockAllocatorTest.cpp",
    "SkColor4fTest.cpp",
    "SkColorSpaceXformStepsTest.cpp",
    "SkContainersTest.cpp",
    "SkDOMTest.cpp",
    "SkEnumBitMaskTest.cpp",
    "SkGaussFilterTest.cpp",
    "SkGlyphTest.cpp",
    "SkImageTest.cpp",
    "SkMallocTest.cpp",
    "SkPathRangeIterTest.cpp",
    "SkSLErrorTest.cpp",
    "SkSLMemoryLayoutTest.cpp",
    "SkSLTypeTest.cpp",
    "SkSharedMutexTest.cpp",
    "SkSpanTest.cpp",
    "SkStrikeCacheTest.cpp",
    "SkStringViewTest.cpp",
    "SkTBlockListTest.cpp",
    "SkUTFTest.cpp",
    "SkVxTest.cpp",
    "SkXmpTest.cpp",
    "SortTest.cpp",
    "SrcOverTest.cpp",
    "StreamTest.cpp",
    "StringTest.cpp",
    "StrokeTest.cpp",
    "TArrayTest.cpp",
    "TDPQueueTest.cpp",
    "TLazyTest.cpp",
    "TemplatesTest.cpp",
    "TracingTest.cpp",
    "UtilsTest.cpp",
    "VerticesTest.cpp",
    "Writer32Test.cpp",
    "YUVCacheTest.cpp",
]

CORE_CODEC_TESTS = [
    "MipMapTest.cpp",
    "SamplingTest.cpp",
    "Skbug6389.cpp",
]

FONT_TESTS = [
    "FlattenDrawableTest.cpp",
    "FontHostTest.cpp",
    "FontNamesTest.cpp",
    "PaintTest.cpp",
    "PictureTest.cpp",
    "SkStrikeTest.cpp",
]

JSON_TESTS = [
    "JSONTest.cpp",
]

PATHOPS_TESTS = [
    "PathTest.cpp",
    "RoundRectTest.cpp",
    "CubicRootsTest.cpp",
    "QuadRootsTest.cpp",
]

RECORD_TESTS = [
    "RecordDrawTest.cpp",
    "RecordOptsTest.cpp",
    "RecordPatternTest.cpp",
    "RecordTest.cpp",
]

SKSL_MISC_TESTS = [
    "SkSLDebugTracePlayerTest.cpp",
    "SkSLDebugTraceTest.cpp",
]

TEXT_TESTS = [
    "DrawTextTest.cpp",
    "FontHostStreamTest.cpp",
    "TextBlobTest.cpp",
    "TypefaceTest.cpp",
    "UnicodeTest.cpp",
]
