/* $Id: Medline_entry.cpp 498027 2016-04-12 18:56:44Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'medline.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/medline/Medline_entry.hpp>
#include <objects/biblio/Cit_art.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CMedline_entry::~CMedline_entry(void)
{
}


bool CMedline_entry::GetLabelV1(string* label, TLabelFlags flags) const
{
    // Add Medline specific label, then treat as cit-art
    if ( IsSetPmid() ) {
        *label += "PM" + NStr::NumericToString(GetPmid().Get());
    }
    else if ( IsSetUid() ) {
        *label += "NLM" + NStr::NumericToString(GetUid());
    }
    else {
        *label += "No Medline found";
    }
    *label += " ";
    // GetCit().GetLabelV1(label, flags);
    GetCit().GetLabel(label, flags, eLabel_V1);
    return true;
}


bool CMedline_entry::GetLabelV2(string* label, TLabelFlags flags) const
{
    return GetCit().GetLabel(label, flags, eLabel_V2);
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1900, CRC32: 7e2163ea */
