# OpenRefine Governance Model

## Summary / Overview
OpenRefine is a free, open-source, powerful tool for working with messy data. OpenRefine has a plugin architecture and is distributed under the [new BSD license](http://opensource.org/licenses/BSD-3-Clause) allowing modification, distribution and name changes.

## Roles and responsibilities
OpenRefine development is based on user consensus and open discussion between users. Decision making must be done in a transparent, open fashion (i.e. using OpenRefine's discussion list and issue list). No decisions about the project’s direction, bug fixes or features may be done in private without community involvement and participation. Discussions must begin at the earliest possible point on a topic; the community’s participation is vital during the entire decision-making process.

All project participants abide by the [Code of Conduct](https://github.com/OpenRefine/OpenRefine/blob/master/CODE_OF_CONDUCT.md).

Anyone with an interest in the project can join the community, contribute to the project design, and participate in the decision making process. This document describes how that participation takes place.

### Users
Users are community members who have a need for the project. Through their usage, they give the project a purpose. Users are encouraged to participate in the project life by providing feedback on how their needs are satisfied.

Users can help the project by:

- Advertising and advocating for the project
- Informing developers of strengths and weaknesses of the tool through the [user discussion list](https://groups.google.com/forum/?fromgroups#!forum/openrefine) or the [issue list](https://github.com/OpenRefine/OpenRefine/issues?state=open)
- Providing moral support (a ‘thank you’ goes a long way)
- Writing tutorials

How to become an OpenRefine user? [Download OpenRefine](http://openrefine.org/download.html) and start refining!

### Contributors
Contributors are users getting involved in the project more closely. Contributions can take many forms:

- Supporting new users via the [user discussion list](https://groups.google.com/forum/?fromgroups#!forum/openrefine)
- Submitting patches to fix bugs or add features via pull requests
- Maintaining and improving the [website](https://openrefine.org/)
- Writing and maintaining the [documentation](https://github.com/OpenRefine/OpenRefine/tree/master/docs)

How to become an OpenRefine contributor? You will find more details in our [contributing guideline](https://github.com/OpenRefine/OpenRefine/blob/master/CONTRIBUTING.md)

### Committers
If you make regular contribution to OpenRefine, you will most likely become a Committer.

Committers have earned enough trust from the community to review and merge pull requests.

Therefore Committers:
- Help contributors via the [developer discussion list](https://groups.google.com/forum/?fromgroups#!forum/openrefine-dev).
- Triage issues, pull requests and [projects](https://github.com/OpenRefine/OpenRefine/projects)
- Have direct access to the code base to create new branches
- Organize the wiki
- Review and merge pull requests submitted by contributors
- Are part of the OpenRefine organization and have the OpenRefine badge on their GitHub profile

#### How to become a Committer?  

Be a contributor and be nominated as a Committer. Current Committers select and elect new Committers. You may nominate yourself. Nomination should be sent to the [developer discussion list](https://groups.google.com/forum/?fromgroups#!forum/openrefine-dev)

#### Current list of Committers
The list is available here: https://github.com/orgs/OpenRefine/people.

### Release Manager
The Release Manager is responsible to
* Coordinate with the community to select which issues and pull requests are part of new releases
* Prepare and coordinate publishing new releases

The current Release Manager is [Antonin Delpeuch](https://github.com/wetneb).

### Steering Committee
The steering committee oversees the general direction of the project and initiates connections and collaborations with other organizations and projects.

* Advise the Project’s staff on processes, strategy, and operations;
* Participate in decision making and/or review of roadmaps, as time allows;
* Participate to some Steering Committee meetings, when time allows;
* Help the Project build connections and partnerships by helping project leadership to steward relationships with funders and partners, making strategic introductions for project leadership, reviewing documents when needed, as time allows;
* Act as an advocate for the Project in events and support the project’s communication online, as time allows.

#### How to be part of the Steering Committee
Steering Committee members are invited by OpenRefine's Advisory Committee

#### Current list of Steering Committee members
* Chris Erdmann (University of North Carolina, RENCI)
* Alicia Fagerving (Wikimedia Sverige)
* Sandra Fauconnier (Wikimedia Foundation)
* Rufus Pollock (Datopian, Open Knowledge Foundation)
* Simon Rogers (Google News Initiative)
* Lozana Rossenova (Rhizome)
* Juliane Schneider (Harvard Catalyst, Clinical and Translational Science Center)
* Wesley Sherperd (Unifyd Insights)
* Fabio Tacchelli (Siren Solutions)

### Advisory Committee
The Advisory Committee runs the administrative aspect of the project on a day to day basis with the support of Code for Science and Society (CS&S). Its member are bound by the  fiscal sponsorship agreement with Code for Science and Society. They meet once per month with Code for Science and Society.

It is composed of at least three members. No more than 49 percent of the members of the Advisory Committee may be paid by the project.

Advisory Committee members:
* Represent OpenRefine with Code for Science and Society;
* Provide guidance and oversight of the Project’s staff and operations;
* Approve budgets, and contracts
* Vote to terminate contracts when necessary.
* Participate in at least one call per quarter;
* Help advocate for the Project;
* Help the Project build connections and partnerships;
* Can be part of the Admin team for the project on GitHub

#### Conflict of Interest
In the event of any conflict of interest (a Committee Member, their family member, or someone with whom the Committee Member has a close academic or employment relationship is involved in a decision), the Committee Member must immediately notify other Committee Members. The Committee Member will be asked to recuse themselves from ongoing conversations, and decision process regarding the Transaction.  

#### Current list of Advisory Committee members
* Martin Magdinier
* Jan Ainali
* Antonin Delpeuch

### Project Director
OpenRefine's Project Director (paid position) works closely with OpenRefine’s advisory and steering committees, and with its communities of users and contributors.

The Project Director:
* Helps to improve OpenRefine's governance and community diversity
* Helps build community-driven structures to formalize OpenRefine’s roadmap and keep it up to date
* Assists in finding and secure new sources of funding
* Supports the Advisory Committee in OpenRefine’s day-to-day operations.

The current Project Director is [Sandra Fauconnier](https://github.com/trnstlntk).

## Fiscal sponsorship: Code For Science and Society

Since January 2020, OpenRefine is a member project of [Code For Science and Society](https://codeforscience.org/) (CS&S).

CS&S provides administrative and fiscal infrastructure to receive and manage funds under the CS&S Fiscal Sponsorship Agreement. CS&S is a USA-based organization qualified as exempt from federal income tax under Section 501(c)(3) of the Internal Revenue Code (IRC) and classified as a public charity under IRC Sections 509(a)(1) and 170(b)(1)(A)(vi).

### Manage funds

While the vast majority of OpenRefine contributors are volunteers, we recognize the need to attract and retain contributors to help:
- perform time critical maintenance tasks for the project (for example release management, security update, pull request review and comments)
- address issues that will not be naturally done by the community (for example documentation or working on large or long term projects)

CS&S currently manages the current funding sources:
- **Grants**: Funds are allocated based on the grants requirements. Grants help to secure resources to achieve long term goal or supports software maintenance, growth, development, and community engagement.
- **Google Summer of Code**: Google Summer of Code mentors are eligible for USD 500 compensation for their work.
- **Donations made through GitHub Sponsors or made directly to CS&S on behalf of OpenRefine**: Decisions on usage of funds is made by the Advisory committee with guidance from the community.

Combined with CS&S, the Steering and Advisory committees have experience applying and managing grants. If you are interested in applying to a grant to improve OpenRefine, please share your idea early on the Developer mailing list. It will be a pleasure helping you through your grant application. New grants must be approved by the Advisory Committee. that CS&S retains a 15% handling fees on any donation to finance their operations (20% for government funding).

### Other assets

CS&S owns and manages the domain openrefine.org
