vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO Naios/continuable
    REF 4.1.0
    SHA512 b80b1c13b068382553b727fd3b346323e2051b1c92237efa151ba8ec92b6d722ca993ae4bbf0e6e308a92834ae92011a179e74fcf713a09beaa48676f7d08340
    HEAD_REF master
    PATCHES
        fix-cmakelists.patch
)

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS
        -DCTI_CONTINUABLE_WITH_INSTALL=ON
        -DCTI_CONTINUABLE_WITH_TESTS=OFF
        -DCTI_CONTINUABLE_WITH_EXAMPLES=OFF
        -DCTI_CONTINUABLE_WITH_BENCHMARKS=OFF
        -DCTI_CONTINUABLE_WITH_NO_EXCEPTIONS=OFF
        -DCTI_CONTINUABLE_WITH_UNHANDLED_EXCEPTIONS=ON
        -DCTI_CONTINUABLE_WITH_EXPERIMENTAL_COROUTINE=ON
        -DCTI_CONTINUABLE_WITH_CPP_LATEST=ON # requires cxx_std_17
)
vcpkg_install_cmake()
vcpkg_copy_pdbs()
vcpkg_fixup_cmake_targets(CONFIG_PATH lib/cmake/${PORT})

file(REMOVE_RECURSE ${CURRENT_PACKAGES_DIR}/lib 
                    ${CURRENT_PACKAGES_DIR}/debug
)
