﻿' Licensed to the .NET Foundation under one or more agreements.
' The .NET Foundation licenses this file to you under the MIT license.
' See the LICENSE file in the project root for more information.

Namespace Microsoft.CodeAnalysis.VisualBasic
    Partial Friend Module ErrorFacts
        ''' <summary>
        ''' Returns true if this is a build-only diagnostic that is never reported from
        ''' <see cref="SemanticModel.GetDiagnostics(Text.TextSpan?, System.Threading.CancellationToken)"/> API.
        ''' Diagnostics generated during compilation phases such as lowering, emit, etc.
        ''' are example of build-only diagnostics.
        ''' </summary>
        Public Function IsBuildOnlyDiagnostic(code As ERRID) As Boolean
            If code >= ERRID.WRN_NextAvailable Then
                Return False
            End If

            Select Case code
                Case ERRID.ERR_TypeRefResolutionError3,
                     ERRID.ERR_MissingRuntimeHelper,
                     ERRID.ERR_CannotGotoNonScopeBlocksWithClosure,
                     ERRID.ERR_SymbolDefinedInAssembly
                    ' Update src\EditorFeatures\VisualBasic\LanguageServer\VisualBasicLspBuildOnlyDiagnostics.vb
                    ' whenever new values are added here.
                    Return True
                Case ERRID.Void,
                     ERRID.Unknown,
                     ERRID.ERR_None,
                     ERRID.ERR_FileNotFound,
                     ERRID.ERR_ArgumentRequired,
                     ERRID.WRN_BadSwitch,
                     ERRID.ERR_NoSources,
                     ERRID.ERR_SwitchNeedsBool,
                     ERRID.ERR_NoResponseFile,
                     ERRID.ERR_CantOpenFileWrite,
                     ERRID.ERR_InvalidSwitchValue,
                     ERRID.ERR_BinaryFile,
                     ERRID.ERR_BadCodepage,
                     ERRID.ERR_LibNotFound,
                     ERRID.ERR_IconFileAndWin32ResFile,
                     ERRID.WRN_NoConfigInResponseFile,
                     ERRID.ERR_NoSourcesOut,
                     ERRID.ERR_NeedModule,
                     ERRID.ERR_InvalidAssemblyName,
                     ERRID.FTL_InvalidInputFileName,
                     ERRID.ERR_ConflictingManifestSwitches,
                     ERRID.WRN_IgnoreModuleManifest,
                     ERRID.WRN_BadUILang,
                     ERRID.ERR_VBCoreNetModuleConflict,
                     ERRID.ERR_InvalidFormatForGuidForOption,
                     ERRID.ERR_MissingGuidForOption,
                     ERRID.ERR_BadChecksumAlgorithm,
                     ERRID.ERR_MutuallyExclusiveOptions,
                     ERRID.ERR_BadSwitchValue,
                     ERRID.ERR_InvalidInNamespace,
                     ERRID.ERR_UndefinedType1,
                     ERRID.ERR_MissingNext,
                     ERRID.ERR_IllegalCharConstant,
                     ERRID.ERR_UnreferencedAssemblyEvent3,
                     ERRID.ERR_UnreferencedModuleEvent3,
                     ERRID.ERR_LbExpectedEndIf,
                     ERRID.ERR_LbNoMatchingIf,
                     ERRID.ERR_LbBadElseif,
                     ERRID.ERR_InheritsFromRestrictedType1,
                     ERRID.ERR_InvOutsideProc,
                     ERRID.ERR_DelegateCantImplement,
                     ERRID.ERR_DelegateCantHandleEvents,
                     ERRID.ERR_IsOperatorRequiresReferenceTypes1,
                     ERRID.ERR_TypeOfRequiresReferenceType1,
                     ERRID.ERR_ReadOnlyHasSet,
                     ERRID.ERR_WriteOnlyHasGet,
                     ERRID.ERR_InvInsideProc,
                     ERRID.ERR_EndProp,
                     ERRID.ERR_EndSubExpected,
                     ERRID.ERR_EndFunctionExpected,
                     ERRID.ERR_LbElseNoMatchingIf,
                     ERRID.ERR_CantRaiseBaseEvent,
                     ERRID.ERR_TryWithoutCatchOrFinally,
                     ERRID.ERR_EventsCantBeFunctions,
                     ERRID.ERR_MissingEndBrack,
                     ERRID.ERR_Syntax,
                     ERRID.ERR_Overflow,
                     ERRID.ERR_IllegalChar,
                     ERRID.ERR_StrictDisallowsObjectOperand1,
                     ERRID.ERR_LoopControlMustNotBeProperty,
                     ERRID.ERR_MethodBodyNotAtLineStart,
                     ERRID.ERR_MaximumNumberOfErrors,
                     ERRID.ERR_UseOfKeywordNotInInstanceMethod1,
                     ERRID.ERR_UseOfKeywordFromStructure1,
                     ERRID.ERR_BadAttributeConstructor1,
                     ERRID.ERR_ParamArrayWithOptArgs,
                     ERRID.ERR_ExpectedArray1,
                     ERRID.ERR_ParamArrayNotArray,
                     ERRID.ERR_ParamArrayRank,
                     ERRID.ERR_ArrayRankLimit,
                     ERRID.ERR_AsNewArray,
                     ERRID.ERR_TooManyArgs1,
                     ERRID.ERR_ExpectedCase,
                     ERRID.ERR_RequiredConstExpr,
                     ERRID.ERR_RequiredConstConversion2,
                     ERRID.ERR_InvalidMe,
                     ERRID.ERR_ReadOnlyAssignment,
                     ERRID.ERR_ExitSubOfFunc,
                     ERRID.ERR_ExitPropNot,
                     ERRID.ERR_ExitFuncOfSub,
                     ERRID.ERR_LValueRequired,
                     ERRID.ERR_ForIndexInUse1,
                     ERRID.ERR_NextForMismatch1,
                     ERRID.ERR_CaseElseNoSelect,
                     ERRID.ERR_CaseNoSelect,
                     ERRID.ERR_CantAssignToConst,
                     ERRID.ERR_NamedSubscript,
                     ERRID.ERR_ExpectedEndIf,
                     ERRID.ERR_ExpectedEndWhile,
                     ERRID.ERR_ExpectedLoop,
                     ERRID.ERR_ExpectedNext,
                     ERRID.ERR_ExpectedEndWith,
                     ERRID.ERR_ElseNoMatchingIf,
                     ERRID.ERR_EndIfNoMatchingIf,
                     ERRID.ERR_EndSelectNoSelect,
                     ERRID.ERR_ExitDoNotWithinDo,
                     ERRID.ERR_EndWhileNoWhile,
                     ERRID.ERR_LoopNoMatchingDo,
                     ERRID.ERR_NextNoMatchingFor,
                     ERRID.ERR_EndWithWithoutWith,
                     ERRID.ERR_MultiplyDefined1,
                     ERRID.ERR_ExpectedEndSelect,
                     ERRID.ERR_ExitForNotWithinFor,
                     ERRID.ERR_ExitWhileNotWithinWhile,
                     ERRID.ERR_ReadOnlyProperty1,
                     ERRID.ERR_ExitSelectNotWithinSelect,
                     ERRID.ERR_BranchOutOfFinally,
                     ERRID.ERR_QualNotObjectRecord1,
                     ERRID.ERR_TooFewIndices,
                     ERRID.ERR_TooManyIndices,
                     ERRID.ERR_EnumNotExpression1,
                     ERRID.ERR_TypeNotExpression1,
                     ERRID.ERR_ClassNotExpression1,
                     ERRID.ERR_StructureNotExpression1,
                     ERRID.ERR_InterfaceNotExpression1,
                     ERRID.ERR_NamespaceNotExpression1,
                     ERRID.ERR_BadNamespaceName1,
                     ERRID.ERR_XmlPrefixNotExpression,
                     ERRID.ERR_MultipleExtends,
                     ERRID.ERR_PropMustHaveGetSet,
                     ERRID.ERR_WriteOnlyHasNoWrite,
                     ERRID.ERR_ReadOnlyHasNoGet,
                     ERRID.ERR_BadAttribute1,
                     ERRID.ERR_LabelNotDefined1,
                     ERRID.ERR_ErrorCreatingWin32ResourceFile,
                     ERRID.ERR_UnableToCreateTempFile,
                     ERRID.ERR_RequiredNewCall2,
                     ERRID.ERR_UnimplementedMember3,
                     ERRID.ERR_BadWithRef,
                     ERRID.ERR_DuplicateAccessCategoryUsed,
                     ERRID.ERR_DuplicateModifierCategoryUsed,
                     ERRID.ERR_DuplicateSpecifier,
                     ERRID.ERR_TypeConflict6,
                     ERRID.ERR_UnrecognizedTypeKeyword,
                     ERRID.ERR_ExtraSpecifiers,
                     ERRID.ERR_UnrecognizedType,
                     ERRID.ERR_InvalidUseOfKeyword,
                     ERRID.ERR_InvalidEndEnum,
                     ERRID.ERR_MissingEndEnum,
                     ERRID.ERR_ExpectedDeclaration,
                     ERRID.ERR_ParamArrayMustBeLast,
                     ERRID.ERR_SpecifiersInvalidOnInheritsImplOpt,
                     ERRID.ERR_ExpectedSpecifier,
                     ERRID.ERR_ExpectedComma,
                     ERRID.ERR_ExpectedAs,
                     ERRID.ERR_ExpectedRparen,
                     ERRID.ERR_ExpectedLparen,
                     ERRID.ERR_InvalidNewInType,
                     ERRID.ERR_ExpectedExpression,
                     ERRID.ERR_ExpectedOptional,
                     ERRID.ERR_ExpectedIdentifier,
                     ERRID.ERR_ExpectedIntLiteral,
                     ERRID.ERR_ExpectedEOS,
                     ERRID.ERR_ExpectedForOptionStmt,
                     ERRID.ERR_InvalidOptionCompare,
                     ERRID.ERR_ExpectedOptionCompare,
                     ERRID.ERR_StrictDisallowImplicitObject,
                     ERRID.ERR_StrictDisallowsImplicitProc,
                     ERRID.ERR_StrictDisallowsImplicitArgs,
                     ERRID.ERR_InvalidParameterSyntax,
                     ERRID.ERR_ExpectedSubFunction,
                     ERRID.ERR_ExpectedStringLiteral,
                     ERRID.ERR_MissingLibInDeclare,
                     ERRID.ERR_DelegateNoInvoke1,
                     ERRID.ERR_MissingIsInTypeOf,
                     ERRID.ERR_DuplicateOption1,
                     ERRID.ERR_ModuleCantInherit,
                     ERRID.ERR_ModuleCantImplement,
                     ERRID.ERR_BadImplementsType,
                     ERRID.ERR_BadConstFlags1,
                     ERRID.ERR_BadWithEventsFlags1,
                     ERRID.ERR_BadDimFlags1,
                     ERRID.ERR_DuplicateParamName1,
                     ERRID.ERR_LoopDoubleCondition,
                     ERRID.ERR_ExpectedRelational,
                     ERRID.ERR_ExpectedExitKind,
                     ERRID.ERR_ExpectedNamedArgument,
                     ERRID.ERR_BadMethodFlags1,
                     ERRID.ERR_BadEventFlags1,
                     ERRID.ERR_BadDeclareFlags1,
                     ERRID.ERR_BadLocalConstFlags1,
                     ERRID.ERR_BadLocalDimFlags1,
                     ERRID.ERR_ExpectedConditionalDirective,
                     ERRID.ERR_ExpectedEQ,
                     ERRID.ERR_ConstructorNotFound1,
                     ERRID.ERR_InvalidEndInterface,
                     ERRID.ERR_MissingEndInterface,
                     ERRID.ERR_InheritsFrom2,
                     ERRID.ERR_InheritanceCycle1,
                     ERRID.ERR_InheritsFromNonClass,
                     ERRID.ERR_MultiplyDefinedType3,
                     ERRID.ERR_BadOverrideAccess2,
                     ERRID.ERR_CantOverrideNotOverridable2,
                     ERRID.ERR_DuplicateProcDef1,
                     ERRID.ERR_BadInterfaceMethodFlags1,
                     ERRID.ERR_NamedParamNotFound2,
                     ERRID.ERR_BadInterfacePropertyFlags1,
                     ERRID.ERR_NamedArgUsedTwice2,
                     ERRID.ERR_InterfaceCantUseEventSpecifier1,
                     ERRID.ERR_TypecharNoMatch2,
                     ERRID.ERR_ExpectedSubOrFunction,
                     ERRID.ERR_BadEmptyEnum1,
                     ERRID.ERR_InvalidConstructorCall,
                     ERRID.ERR_CantOverrideConstructor,
                     ERRID.ERR_OverrideNotNeeded3,
                     ERRID.ERR_ExpectedDot,
                     ERRID.ERR_DuplicateLocals1,
                     ERRID.ERR_InvInsideEndsProc,
                     ERRID.ERR_LocalSameAsFunc,
                     ERRID.ERR_RecordEmbeds2,
                     ERRID.ERR_RecordCycle2,
                     ERRID.ERR_InterfaceCycle1,
                     ERRID.ERR_SubNewCycle2,
                     ERRID.ERR_SubNewCycle1,
                     ERRID.ERR_InheritsFromCantInherit3,
                     ERRID.ERR_OverloadWithOptional2,
                     ERRID.ERR_OverloadWithReturnType2,
                     ERRID.ERR_TypeCharWithType1,
                     ERRID.ERR_TypeCharOnSub,
                     ERRID.ERR_OverloadWithDefault2,
                     ERRID.ERR_MissingSubscript,
                     ERRID.ERR_OverrideWithDefault2,
                     ERRID.ERR_OverrideWithOptional2,
                     ERRID.ERR_FieldOfValueFieldOfMarshalByRef3,
                     ERRID.ERR_TypeMismatch2,
                     ERRID.ERR_CaseAfterCaseElse,
                     ERRID.ERR_ConvertArrayMismatch4,
                     ERRID.ERR_ConvertObjectArrayMismatch3,
                     ERRID.ERR_ForLoopType1,
                     ERRID.ERR_OverloadWithByref2,
                     ERRID.ERR_InheritsFromNonInterface,
                     ERRID.ERR_BadInterfaceOrderOnInherits,
                     ERRID.ERR_DuplicateDefaultProps1,
                     ERRID.ERR_DefaultMissingFromProperty2,
                     ERRID.ERR_OverridingPropertyKind2,
                     ERRID.ERR_NewInInterface,
                     ERRID.ERR_BadFlagsOnNew1,
                     ERRID.ERR_OverloadingPropertyKind2,
                     ERRID.ERR_NoDefaultNotExtend1,
                     ERRID.ERR_OverloadWithArrayVsParamArray2,
                     ERRID.ERR_BadInstanceMemberAccess,
                     ERRID.ERR_ExpectedRbrace,
                     ERRID.ERR_ModuleAsType1,
                     ERRID.ERR_NewIfNullOnNonClass,
                     ERRID.ERR_CatchAfterFinally,
                     ERRID.ERR_CatchNoMatchingTry,
                     ERRID.ERR_FinallyAfterFinally,
                     ERRID.ERR_FinallyNoMatchingTry,
                     ERRID.ERR_EndTryNoTry,
                     ERRID.ERR_ExpectedEndTry,
                     ERRID.ERR_BadDelegateFlags1,
                     ERRID.ERR_NoConstructorOnBase2,
                     ERRID.ERR_InaccessibleSymbol2,
                     ERRID.ERR_InaccessibleMember3,
                     ERRID.ERR_CatchNotException1,
                     ERRID.ERR_ExitTryNotWithinTry,
                     ERRID.ERR_BadRecordFlags1,
                     ERRID.ERR_BadEnumFlags1,
                     ERRID.ERR_BadInterfaceFlags1,
                     ERRID.ERR_OverrideWithByref2,
                     ERRID.ERR_MyBaseAbstractCall1,
                     ERRID.ERR_IdentNotMemberOfInterface4,
                     ERRID.ERR_ImplementingInterfaceWithDifferentTupleNames5,
                     ERRID.ERR_WithEventsRequiresClass,
                     ERRID.ERR_WithEventsAsStruct,
                     ERRID.ERR_ConvertArrayRankMismatch2,
                     ERRID.ERR_RedimRankMismatch,
                     ERRID.ERR_StartupCodeNotFound1,
                     ERRID.ERR_ConstAsNonConstant,
                     ERRID.ERR_InvalidEndSub,
                     ERRID.ERR_InvalidEndFunction,
                     ERRID.ERR_InvalidEndProperty,
                     ERRID.ERR_ModuleCantUseMethodSpecifier1,
                     ERRID.ERR_ModuleCantUseEventSpecifier1,
                     ERRID.ERR_StructCantUseVarSpecifier1,
                     ERRID.ERR_InvalidOverrideDueToReturn2,
                     ERRID.ERR_ConstantWithNoValue,
                     ERRID.ERR_ExpressionOverflow1,
                     ERRID.ERR_DuplicatePropertyGet,
                     ERRID.ERR_DuplicatePropertySet,
                     ERRID.ERR_NameNotDeclared1,
                     ERRID.ERR_BinaryOperands3,
                     ERRID.ERR_ExpectedProcedure,
                     ERRID.ERR_OmittedArgument2,
                     ERRID.ERR_NameNotMember2,
                     ERRID.ERR_EndClassNoClass,
                     ERRID.ERR_BadClassFlags1,
                     ERRID.ERR_ImportsMustBeFirst,
                     ERRID.ERR_NonNamespaceOrClassOnImport2,
                     ERRID.ERR_TypecharNotallowed,
                     ERRID.ERR_ObjectReferenceNotSupplied,
                     ERRID.ERR_MyClassNotInClass,
                     ERRID.ERR_IndexedNotArrayOrProc,
                     ERRID.ERR_EventSourceIsArray,
                     ERRID.ERR_SharedConstructorWithParams,
                     ERRID.ERR_SharedConstructorIllegalSpec1,
                     ERRID.ERR_ExpectedEndClass,
                     ERRID.ERR_UnaryOperand2,
                     ERRID.ERR_BadFlagsWithDefault1,
                     ERRID.ERR_VoidValue,
                     ERRID.ERR_ConstructorFunction,
                     ERRID.ERR_InvalidLiteralExponent,
                     ERRID.ERR_NewCannotHandleEvents,
                     ERRID.ERR_CircularEvaluation1,
                     ERRID.ERR_BadFlagsOnSharedMeth1,
                     ERRID.ERR_BadFlagsOnSharedProperty1,
                     ERRID.ERR_BadFlagsOnStdModuleProperty1,
                     ERRID.ERR_SharedOnProcThatImpl,
                     ERRID.ERR_NoWithEventsVarOnHandlesList,
                     ERRID.ERR_AccessMismatch6,
                     ERRID.ERR_InheritanceAccessMismatch5,
                     ERRID.ERR_NarrowingConversionDisallowed2,
                     ERRID.ERR_NoArgumentCountOverloadCandidates1,
                     ERRID.ERR_NoViableOverloadCandidates1,
                     ERRID.ERR_NoCallableOverloadCandidates2,
                     ERRID.ERR_NoNonNarrowingOverloadCandidates2,
                     ERRID.ERR_ArgumentNarrowing3,
                     ERRID.ERR_NoMostSpecificOverload2,
                     ERRID.ERR_NotMostSpecificOverload,
                     ERRID.ERR_OverloadCandidate2,
                     ERRID.ERR_NoGetProperty1,
                     ERRID.ERR_NoSetProperty1,
                     ERRID.ERR_ParamTypingInconsistency,
                     ERRID.ERR_ParamNameFunctionNameCollision,
                     ERRID.ERR_DateToDoubleConversion,
                     ERRID.ERR_DoubleToDateConversion,
                     ERRID.ERR_ZeroDivide,
                     ERRID.ERR_TryAndOnErrorDoNotMix,
                     ERRID.ERR_PropertyAccessIgnored,
                     ERRID.ERR_InterfaceNoDefault1,
                     ERRID.ERR_InvalidAssemblyAttribute1,
                     ERRID.ERR_InvalidModuleAttribute1,
                     ERRID.ERR_AmbiguousInUnnamedNamespace1,
                     ERRID.ERR_DefaultMemberNotProperty1,
                     ERRID.ERR_AmbiguousInNamespace2,
                     ERRID.ERR_AmbiguousInImports2,
                     ERRID.ERR_AmbiguousInModules2,
                     ERRID.ERR_ArrayInitializerTooFewDimensions,
                     ERRID.ERR_ArrayInitializerTooManyDimensions,
                     ERRID.ERR_InitializerTooFewElements1,
                     ERRID.ERR_InitializerTooManyElements1,
                     ERRID.ERR_NewOnAbstractClass,
                     ERRID.ERR_DuplicateNamedImportAlias1,
                     ERRID.ERR_DuplicatePrefix,
                     ERRID.ERR_StrictDisallowsLateBinding,
                     ERRID.ERR_AddressOfOperandNotMethod,
                     ERRID.ERR_EndExternalSource,
                     ERRID.ERR_ExpectedEndExternalSource,
                     ERRID.ERR_NestedExternalSource,
                     ERRID.ERR_AddressOfNotDelegate1,
                     ERRID.ERR_SyncLockRequiresReferenceType1,
                     ERRID.ERR_MethodAlreadyImplemented2,
                     ERRID.ERR_DuplicateInInherits1,
                     ERRID.ERR_NamedParamArrayArgument,
                     ERRID.ERR_OmittedParamArrayArgument,
                     ERRID.ERR_ParamArrayArgumentMismatch,
                     ERRID.ERR_EventNotFound1,
                     ERRID.ERR_ModuleCantUseVariableSpecifier1,
                     ERRID.ERR_SharedEventNeedsSharedHandler,
                     ERRID.ERR_ExpectedMinus,
                     ERRID.ERR_InterfaceMemberSyntax,
                     ERRID.ERR_InvInsideInterface,
                     ERRID.ERR_InvInsideEndsInterface,
                     ERRID.ERR_BadFlagsInNotInheritableClass1,
                     ERRID.ERR_UnimplementedMustOverride,
                     ERRID.ERR_BaseOnlyClassesMustBeExplicit2,
                     ERRID.ERR_NegativeArraySize,
                     ERRID.ERR_MyClassAbstractCall1,
                     ERRID.ERR_EndDisallowedInDllProjects,
                     ERRID.ERR_BlockLocalShadowing1,
                     ERRID.ERR_ModuleNotAtNamespace,
                     ERRID.ERR_NamespaceNotAtNamespace,
                     ERRID.ERR_InvInsideEndsEnum,
                     ERRID.ERR_InvalidOptionStrict,
                     ERRID.ERR_EndStructureNoStructure,
                     ERRID.ERR_EndModuleNoModule,
                     ERRID.ERR_EndNamespaceNoNamespace,
                     ERRID.ERR_ExpectedEndStructure,
                     ERRID.ERR_ExpectedEndModule,
                     ERRID.ERR_ExpectedEndNamespace,
                     ERRID.ERR_OptionStmtWrongOrder,
                     ERRID.ERR_StructCantInherit,
                     ERRID.ERR_NewInStruct,
                     ERRID.ERR_InvalidEndGet,
                     ERRID.ERR_MissingEndGet,
                     ERRID.ERR_InvalidEndSet,
                     ERRID.ERR_MissingEndSet,
                     ERRID.ERR_InvInsideEndsProperty,
                     ERRID.ERR_DuplicateWriteabilityCategoryUsed,
                     ERRID.ERR_ExpectedGreater,
                     ERRID.ERR_AttributeStmtWrongOrder,
                     ERRID.ERR_NoExplicitArraySizes,
                     ERRID.ERR_BadPropertyFlags1,
                     ERRID.ERR_InvalidOptionExplicit,
                     ERRID.ERR_MultipleParameterSpecifiers,
                     ERRID.ERR_MultipleOptionalParameterSpecifiers,
                     ERRID.ERR_UnsupportedProperty1,
                     ERRID.ERR_InvalidOptionalParameterUsage1,
                     ERRID.ERR_ReturnFromNonFunction,
                     ERRID.ERR_UnterminatedStringLiteral,
                     ERRID.ERR_UnsupportedType1,
                     ERRID.ERR_InvalidEnumBase,
                     ERRID.ERR_ByRefIllegal1,
                     ERRID.ERR_UnreferencedAssembly3,
                     ERRID.ERR_UnreferencedModule3,
                     ERRID.ERR_ReturnWithoutValue,
                     ERRID.ERR_UnsupportedField1,
                     ERRID.ERR_UnsupportedMethod1,
                     ERRID.ERR_NoNonIndexProperty1,
                     ERRID.ERR_BadAttributePropertyType1,
                     ERRID.ERR_LocalsCannotHaveAttributes,
                     ERRID.ERR_PropertyOrFieldNotDefined1,
                     ERRID.ERR_InvalidAttributeUsage2,
                     ERRID.ERR_InvalidMultipleAttributeUsage1,
                     ERRID.ERR_CantThrowNonException,
                     ERRID.ERR_MustBeInCatchToRethrow,
                     ERRID.ERR_ParamArrayMustBeByVal,
                     ERRID.ERR_UseOfObsoleteSymbol2,
                     ERRID.ERR_RedimNoSizes,
                     ERRID.ERR_InitWithMultipleDeclarators,
                     ERRID.ERR_InitWithExplicitArraySizes,
                     ERRID.ERR_EndSyncLockNoSyncLock,
                     ERRID.ERR_ExpectedEndSyncLock,
                     ERRID.ERR_NameNotEvent2,
                     ERRID.ERR_AddOrRemoveHandlerEvent,
                     ERRID.ERR_UnrecognizedEnd,
                     ERRID.ERR_ArrayInitForNonArray2,
                     ERRID.ERR_EndRegionNoRegion,
                     ERRID.ERR_ExpectedEndRegion,
                     ERRID.ERR_InheritsStmtWrongOrder,
                     ERRID.ERR_AmbiguousAcrossInterfaces3,
                     ERRID.ERR_DefaultPropertyAmbiguousAcrossInterfaces4,
                     ERRID.ERR_InterfaceEventCantUse1,
                     ERRID.ERR_ExecutableAsDeclaration,
                     ERRID.ERR_StructureNoDefault1,
                     ERRID.ERR_MustShadow2,
                     ERRID.ERR_OverrideWithOptionalTypes2,
                     ERRID.ERR_ExpectedEndOfExpression,
                     ERRID.ERR_StructsCannotHandleEvents,
                     ERRID.ERR_OverridesImpliesOverridable,
                     ERRID.ERR_LocalNamedSameAsParam1,
                     ERRID.ERR_ModuleCantUseTypeSpecifier1,
                     ERRID.ERR_InValidSubMainsFound1,
                     ERRID.ERR_MoreThanOneValidMainWasFound2,
                     ERRID.ERR_CannotConvertValue2,
                     ERRID.ERR_OnErrorInSyncLock,
                     ERRID.ERR_NarrowingConversionCollection2,
                     ERRID.ERR_GotoIntoTryHandler,
                     ERRID.ERR_GotoIntoSyncLock,
                     ERRID.ERR_GotoIntoWith,
                     ERRID.ERR_GotoIntoFor,
                     ERRID.ERR_BadAttributeNonPublicConstructor,
                     ERRID.ERR_DefaultEventNotFound1,
                     ERRID.ERR_InvalidNonSerializedUsage,
                     ERRID.ERR_ExpectedContinueKind,
                     ERRID.ERR_ContinueDoNotWithinDo,
                     ERRID.ERR_ContinueForNotWithinFor,
                     ERRID.ERR_ContinueWhileNotWithinWhile,
                     ERRID.ERR_DuplicateParameterSpecifier,
                     ERRID.ERR_ModuleCantUseDLLDeclareSpecifier1,
                     ERRID.ERR_StructCantUseDLLDeclareSpecifier1,
                     ERRID.ERR_TryCastOfValueType1,
                     ERRID.ERR_TryCastOfUnconstrainedTypeParam1,
                     ERRID.ERR_AmbiguousDelegateBinding2,
                     ERRID.ERR_SharedStructMemberCannotSpecifyNew,
                     ERRID.ERR_GenericSubMainsFound1,
                     ERRID.ERR_GeneralProjectImportsError3,
                     ERRID.ERR_InvalidTypeForAliasesImport2,
                     ERRID.ERR_UnsupportedConstant2,
                     ERRID.ERR_ObsoleteArgumentsNeedParens,
                     ERRID.ERR_ObsoleteLineNumbersAreLabels,
                     ERRID.ERR_ObsoleteStructureNotType,
                     ERRID.ERR_ObsoleteObjectNotVariant,
                     ERRID.ERR_ObsoleteLetSetNotNeeded,
                     ERRID.ERR_ObsoletePropertyGetLetSet,
                     ERRID.ERR_ObsoleteWhileWend,
                     ERRID.ERR_ObsoleteRedimAs,
                     ERRID.ERR_ObsoleteOptionalWithoutValue,
                     ERRID.ERR_ObsoleteGosub,
                     ERRID.ERR_ObsoleteOnGotoGosub,
                     ERRID.ERR_ObsoleteEndIf,
                     ERRID.ERR_ObsoleteExponent,
                     ERRID.ERR_ObsoleteAsAny,
                     ERRID.ERR_ObsoleteGetStatement,
                     ERRID.ERR_OverrideWithArrayVsParamArray2,
                     ERRID.ERR_CircularBaseDependencies4,
                     ERRID.ERR_NestedBase2,
                     ERRID.ERR_AccessMismatchOutsideAssembly4,
                     ERRID.ERR_InheritanceAccessMismatchOutside3,
                     ERRID.ERR_UseOfObsoletePropertyAccessor3,
                     ERRID.ERR_UseOfObsoletePropertyAccessor2,
                     ERRID.ERR_AccessMismatchImplementedEvent6,
                     ERRID.ERR_AccessMismatchImplementedEvent4,
                     ERRID.ERR_InheritanceCycleInImportedType1,
                     ERRID.ERR_NoNonObsoleteConstructorOnBase3,
                     ERRID.ERR_NoNonObsoleteConstructorOnBase4,
                     ERRID.ERR_RequiredNonObsoleteNewCall3,
                     ERRID.ERR_RequiredNonObsoleteNewCall4,
                     ERRID.ERR_InheritsTypeArgAccessMismatch7,
                     ERRID.ERR_InheritsTypeArgAccessMismatchOutside5,
                     ERRID.ERR_PartialTypeAccessMismatch3,
                     ERRID.ERR_PartialTypeBadMustInherit1,
                     ERRID.ERR_MustOverOnNotInheritPartClsMem1,
                     ERRID.ERR_BaseMismatchForPartialClass3,
                     ERRID.ERR_PartialTypeTypeParamNameMismatch3,
                     ERRID.ERR_PartialTypeConstraintMismatch1,
                     ERRID.ERR_LateBoundOverloadInterfaceCall1,
                     ERRID.ERR_RequiredAttributeConstConversion2,
                     ERRID.ERR_AmbiguousOverrides3,
                     ERRID.ERR_OverriddenCandidate1,
                     ERRID.ERR_AmbiguousImplements3,
                     ERRID.ERR_AddressOfNotCreatableDelegate1,
                     ERRID.ERR_ComClassGenericMethod,
                     ERRID.ERR_SyntaxInCastOp,
                     ERRID.ERR_ArrayInitializerForNonConstDim,
                     ERRID.ERR_DelegateBindingFailure3,
                     ERRID.ERR_StructLayoutAttributeNotAllowed,
                     ERRID.ERR_IterationVariableShadowLocal1,
                     ERRID.ERR_InvalidOptionInfer,
                     ERRID.ERR_CircularInference1,
                     ERRID.ERR_InAccessibleOverridingMethod5,
                     ERRID.ERR_NoSuitableWidestType1,
                     ERRID.ERR_AmbiguousWidestType3,
                     ERRID.ERR_ExpectedAssignmentOperatorInInit,
                     ERRID.ERR_ExpectedQualifiedNameInInit,
                     ERRID.ERR_ExpectedLbrace,
                     ERRID.ERR_UnrecognizedTypeOrWith,
                     ERRID.ERR_DuplicateAggrMemberInit1,
                     ERRID.ERR_NonFieldPropertyAggrMemberInit1,
                     ERRID.ERR_SharedMemberAggrMemberInit1,
                     ERRID.ERR_ParameterizedPropertyInAggrInit1,
                     ERRID.ERR_NoZeroCountArgumentInitCandidates1,
                     ERRID.ERR_AggrInitInvalidForObject,
                     ERRID.ERR_InitializerExpected,
                     ERRID.ERR_LineContWithCommentOrNoPrecSpace,
                     ERRID.ERR_InvInsideEnum,
                     ERRID.ERR_InvInsideBlock,
                     ERRID.ERR_UnexpectedExpressionStatement,
                     ERRID.ERR_WinRTEventWithoutDelegate,
                     ERRID.ERR_SecurityCriticalAsyncInClassOrStruct,
                     ERRID.ERR_SecurityCriticalAsync,
                     ERRID.ERR_BadModuleFile1,
                     ERRID.ERR_BadRefLib1,
                     ERRID.ERR_EventHandlerSignatureIncompatible2,
                     ERRID.ERR_ConditionalCompilationConstantNotValid,
                     ERRID.ERR_InterfaceImplementedTwice1,
                     ERRID.ERR_InterfaceNotImplemented1,
                     ERRID.ERR_AmbiguousImplementsMember3,
                     ERRID.ERR_ImplementsOnNew,
                     ERRID.ERR_ArrayInitInStruct,
                     ERRID.ERR_EventTypeNotDelegate,
                     ERRID.ERR_ProtectedTypeOutsideClass,
                     ERRID.ERR_DefaultPropertyWithNoParams,
                     ERRID.ERR_InitializerInStruct,
                     ERRID.ERR_DuplicateImport1,
                     ERRID.ERR_BadModuleFlags1,
                     ERRID.ERR_ImplementsStmtWrongOrder,
                     ERRID.ERR_MemberConflictWithSynth4,
                     ERRID.ERR_SynthMemberClashesWithSynth7,
                     ERRID.ERR_SynthMemberClashesWithMember5,
                     ERRID.ERR_MemberClashesWithSynth6,
                     ERRID.ERR_SetHasOnlyOneParam,
                     ERRID.ERR_SetValueNotPropertyType,
                     ERRID.ERR_SetHasToBeByVal1,
                     ERRID.ERR_StructureCantUseProtected,
                     ERRID.ERR_BadInterfaceDelegateSpecifier1,
                     ERRID.ERR_BadInterfaceEnumSpecifier1,
                     ERRID.ERR_BadInterfaceClassSpecifier1,
                     ERRID.ERR_BadInterfaceStructSpecifier1,
                     ERRID.ERR_UseOfObsoleteSymbolNoMessage1,
                     ERRID.ERR_MetaDataIsNotAssembly,
                     ERRID.ERR_MetaDataIsNotModule,
                     ERRID.ERR_ReferenceComparison3,
                     ERRID.ERR_CatchVariableNotLocal1,
                     ERRID.ERR_ModuleMemberCantImplement,
                     ERRID.ERR_EventDelegatesCantBeFunctions,
                     ERRID.ERR_InvalidDate,
                     ERRID.ERR_CantOverride4,
                     ERRID.ERR_CantSpecifyArraysOnBoth,
                     ERRID.ERR_NotOverridableRequiresOverrides,
                     ERRID.ERR_PrivateTypeOutsideType,
                     ERRID.ERR_ParamArrayWrongType,
                     ERRID.ERR_CoClassMissing2,
                     ERRID.ERR_InvalidMeReference,
                     ERRID.ERR_InvalidImplicitMeReference,
                     ERRID.ERR_RuntimeMemberNotFound2,
                     ERRID.ERR_BadPropertyAccessorFlags,
                     ERRID.ERR_BadPropertyAccessorFlagsRestrict,
                     ERRID.ERR_OnlyOneAccessorForGetSet,
                     ERRID.ERR_NoAccessibleSet,
                     ERRID.ERR_NoAccessibleGet,
                     ERRID.ERR_WriteOnlyNoAccessorFlag,
                     ERRID.ERR_ReadOnlyNoAccessorFlag,
                     ERRID.ERR_BadPropertyAccessorFlags1,
                     ERRID.ERR_BadPropertyAccessorFlags2,
                     ERRID.ERR_BadPropertyAccessorFlags3,
                     ERRID.ERR_InAccessibleCoClass3,
                     ERRID.ERR_MissingValuesForArraysInApplAttrs,
                     ERRID.ERR_ExitEventMemberNotInvalid,
                     ERRID.ERR_InvInsideEndsEvent,
                     ERRID.ERR_MissingEndEvent,
                     ERRID.ERR_MissingEndAddHandler,
                     ERRID.ERR_MissingEndRemoveHandler,
                     ERRID.ERR_MissingEndRaiseEvent,
                     ERRID.ERR_CustomEventInvInInterface,
                     ERRID.ERR_CustomEventRequiresAs,
                     ERRID.ERR_InvalidEndEvent,
                     ERRID.ERR_InvalidEndAddHandler,
                     ERRID.ERR_InvalidEndRemoveHandler,
                     ERRID.ERR_InvalidEndRaiseEvent,
                     ERRID.ERR_DuplicateAddHandlerDef,
                     ERRID.ERR_DuplicateRemoveHandlerDef,
                     ERRID.ERR_DuplicateRaiseEventDef,
                     ERRID.ERR_MissingAddHandlerDef1,
                     ERRID.ERR_MissingRemoveHandlerDef1,
                     ERRID.ERR_MissingRaiseEventDef1,
                     ERRID.ERR_EventAddRemoveHasOnlyOneParam,
                     ERRID.ERR_EventAddRemoveByrefParamIllegal,
                     ERRID.ERR_SpecifiersInvOnEventMethod,
                     ERRID.ERR_AddRemoveParamNotEventType,
                     ERRID.ERR_RaiseEventShapeMismatch1,
                     ERRID.ERR_EventMethodOptionalParamIllegal1,
                     ERRID.ERR_CantReferToMyGroupInsideGroupType1,
                     ERRID.ERR_InvalidUseOfCustomModifier,
                     ERRID.ERR_InvalidOptionStrictCustom,
                     ERRID.ERR_ObsoleteInvalidOnEventMember,
                     ERRID.ERR_DelegateBindingIncompatible2,
                     ERRID.ERR_ExpectedXmlName,
                     ERRID.ERR_UndefinedXmlPrefix,
                     ERRID.ERR_DuplicateXmlAttribute,
                     ERRID.ERR_MismatchedXmlEndTag,
                     ERRID.ERR_MissingXmlEndTag,
                     ERRID.ERR_ReservedXmlPrefix,
                     ERRID.ERR_MissingVersionInXmlDecl,
                     ERRID.ERR_IllegalAttributeInXmlDecl,
                     ERRID.ERR_QuotedEmbeddedExpression,
                     ERRID.ERR_VersionMustBeFirstInXmlDecl,
                     ERRID.ERR_AttributeOrder,
                     ERRID.ERR_ExpectedXmlEndEmbedded,
                     ERRID.ERR_ExpectedXmlEndPI,
                     ERRID.ERR_ExpectedXmlEndComment,
                     ERRID.ERR_ExpectedXmlEndCData,
                     ERRID.ERR_ExpectedSQuote,
                     ERRID.ERR_ExpectedQuote,
                     ERRID.ERR_ExpectedLT,
                     ERRID.ERR_StartAttributeValue,
                     ERRID.ERR_ExpectedDiv,
                     ERRID.ERR_NoXmlAxesLateBinding,
                     ERRID.ERR_IllegalXmlStartNameChar,
                     ERRID.ERR_IllegalXmlNameChar,
                     ERRID.ERR_IllegalXmlCommentChar,
                     ERRID.ERR_EmbeddedExpression,
                     ERRID.ERR_ExpectedXmlWhiteSpace,
                     ERRID.ERR_IllegalProcessingInstructionName,
                     ERRID.ERR_DTDNotSupported,
                     ERRID.ERR_IllegalXmlWhiteSpace,
                     ERRID.ERR_ExpectedSColon,
                     ERRID.ERR_ExpectedXmlBeginEmbedded,
                     ERRID.ERR_XmlEntityReference,
                     ERRID.ERR_InvalidAttributeValue1,
                     ERRID.ERR_InvalidAttributeValue2,
                     ERRID.ERR_ReservedXmlNamespace,
                     ERRID.ERR_IllegalDefaultNamespace,
                     ERRID.ERR_QualifiedNameNotAllowed,
                     ERRID.ERR_ExpectedXmlns,
                     ERRID.ERR_IllegalXmlnsPrefix,
                     ERRID.ERR_XmlFeaturesNotAvailable,
                     ERRID.ERR_UnableToReadUacManifest2,
                     ERRID.ERR_TypeMismatchForXml3,
                     ERRID.ERR_BinaryOperandsForXml4,
                     ERRID.ERR_FullWidthAsXmlDelimiter,
                     ERRID.ERR_XmlEndCDataNotAllowedInContent,
                     ERRID.ERR_EventImplRemoveHandlerParamWrong,
                     ERRID.ERR_MixingWinRTAndNETEvents,
                     ERRID.ERR_AddParamWrongForWinRT,
                     ERRID.ERR_RemoveParamWrongForWinRT,
                     ERRID.ERR_ReImplementingWinRTInterface5,
                     ERRID.ERR_ReImplementingWinRTInterface4,
                     ERRID.ERR_XmlEndElementNoMatchingStart,
                     ERRID.ERR_UndefinedTypeOrNamespace1,
                     ERRID.ERR_BadInterfaceInterfaceSpecifier1,
                     ERRID.ERR_TypeClashesWithVbCoreType4,
                     ERRID.ERR_SecurityAttributeMissingAction,
                     ERRID.ERR_SecurityAttributeInvalidAction,
                     ERRID.ERR_SecurityAttributeInvalidActionAssembly,
                     ERRID.ERR_SecurityAttributeInvalidActionTypeOrMethod,
                     ERRID.ERR_PrincipalPermissionInvalidAction,
                     ERRID.ERR_PermissionSetAttributeInvalidFile,
                     ERRID.ERR_PermissionSetAttributeFileReadError,
                     ERRID.ERR_ExpectedWarningKeyword,
                     ERRID.ERR_InvalidHashAlgorithmName,
                     ERRID.ERR_InvalidSubsystemVersion,
                     ERRID.ERR_LibAnycpu32bitPreferredConflict,
                     ERRID.ERR_RestrictedAccess,
                     ERRID.ERR_RestrictedConversion1,
                     ERRID.ERR_NoTypecharInLabel,
                     ERRID.ERR_RestrictedType1,
                     ERRID.ERR_NoTypecharInAlias,
                     ERRID.ERR_NoAccessibleConstructorOnBase,
                     ERRID.ERR_BadStaticLocalInStruct,
                     ERRID.ERR_DuplicateLocalStatic1,
                     ERRID.ERR_ImportAliasConflictsWithType2,
                     ERRID.ERR_CantShadowAMustOverride1,
                     ERRID.ERR_MultipleEventImplMismatch3,
                     ERRID.ERR_BadSpecifierCombo2,
                     ERRID.ERR_MustBeOverloads2,
                     ERRID.ERR_MustOverridesInClass1,
                     ERRID.ERR_HandlesSyntaxInClass,
                     ERRID.ERR_SynthMemberShadowsMustOverride5,
                     ERRID.ERR_CannotOverrideInAccessibleMember,
                     ERRID.ERR_HandlesSyntaxInModule,
                     ERRID.ERR_IsNotOpRequiresReferenceTypes1,
                     ERRID.ERR_ClashWithReservedEnumMember1,
                     ERRID.ERR_MultiplyDefinedEnumMember2,
                     ERRID.ERR_BadUseOfVoid,
                     ERRID.ERR_EventImplMismatch5,
                     ERRID.ERR_ForwardedTypeUnavailable3,
                     ERRID.ERR_TypeFwdCycle2,
                     ERRID.ERR_BadTypeInCCExpression,
                     ERRID.ERR_BadCCExpression,
                     ERRID.ERR_VoidArrayDisallowed,
                     ERRID.ERR_MetadataMembersAmbiguous3,
                     ERRID.ERR_TypeOfExprAlwaysFalse2,
                     ERRID.ERR_OnlyPrivatePartialMethods1,
                     ERRID.ERR_PartialMethodsMustBePrivate,
                     ERRID.ERR_OnlyOnePartialMethodAllowed2,
                     ERRID.ERR_OnlyOneImplementingMethodAllowed3,
                     ERRID.ERR_PartialMethodMustBeEmpty,
                     ERRID.ERR_PartialMethodsMustBeSub1,
                     ERRID.ERR_PartialMethodGenericConstraints2,
                     ERRID.ERR_PartialDeclarationImplements1,
                     ERRID.ERR_NoPartialMethodInAddressOf1,
                     ERRID.ERR_ImplementationMustBePrivate2,
                     ERRID.ERR_PartialMethodParamNamesMustMatch3,
                     ERRID.ERR_PartialMethodTypeParamNameMismatch3,
                     ERRID.ERR_PropertyDoesntImplementAllAccessors,
                     ERRID.ERR_InvalidAttributeUsageOnAccessor,
                     ERRID.ERR_NestedTypeInInheritsClause2,
                     ERRID.ERR_TypeInItsInheritsClause1,
                     ERRID.ERR_BaseTypeReferences2,
                     ERRID.ERR_IllegalBaseTypeReferences3,
                     ERRID.ERR_InvalidCoClass1,
                     ERRID.ERR_InvalidOutputName,
                     ERRID.ERR_InvalidFileAlignment,
                     ERRID.ERR_InvalidDebugInformationFormat,
                     ERRID.ERR_ConstantStringTooLong,
                     ERRID.ERR_MustInheritEventNotOverridden,
                     ERRID.ERR_BadAttributeSharedProperty1,
                     ERRID.ERR_BadAttributeReadOnlyProperty1,
                     ERRID.ERR_DuplicateResourceName1,
                     ERRID.ERR_AttributeMustBeClassNotStruct1,
                     ERRID.ERR_AttributeMustInheritSysAttr,
                     ERRID.ERR_AttributeCannotBeAbstract,
                     ERRID.ERR_UnableToOpenResourceFile1,
                     ERRID.ERR_BadAttributeNonPublicProperty1,
                     ERRID.ERR_STAThreadAndMTAThread0,
                     ERRID.ERR_IndirectUnreferencedAssembly4,
                     ERRID.ERR_BadAttributeNonPublicType1,
                     ERRID.ERR_BadAttributeNonPublicContType2,
                     ERRID.ERR_BadMetaDataReference1,
                     ERRID.ERR_DllImportOnNonEmptySubOrFunction,
                     ERRID.ERR_DllImportNotLegalOnDeclare,
                     ERRID.ERR_DllImportNotLegalOnGetOrSet,
                     ERRID.ERR_DllImportOnGenericSubOrFunction,
                     ERRID.ERR_ComClassOnGeneric,
                     ERRID.ERR_DllImportOnInstanceMethod,
                     ERRID.ERR_DllImportOnInterfaceMethod,
                     ERRID.ERR_DllImportNotLegalOnEventMethod,
                     ERRID.ERR_FriendAssemblyBadArguments,
                     ERRID.ERR_FriendAssemblyStrongNameRequired,
                     ERRID.ERR_FriendAssemblyNameInvalid,
                     ERRID.ERR_FriendAssemblyBadAccessOverride2,
                     ERRID.ERR_AbsentReferenceToPIA1,
                     ERRID.ERR_CannotLinkClassWithNoPIA1,
                     ERRID.ERR_InvalidStructMemberNoPIA1,
                     ERRID.ERR_NoPIAAttributeMissing2,
                     ERRID.ERR_NestedGlobalNamespace,
                     ERRID.ERR_PIAHasNoAssemblyGuid1,
                     ERRID.ERR_DuplicateLocalTypes3,
                     ERRID.ERR_PIAHasNoTypeLibAttribute1,
                     ERRID.ERR_SourceInterfaceMustBeInterface,
                     ERRID.ERR_EventNoPIANoBackingMember,
                     ERRID.ERR_NestedInteropType,
                     ERRID.ERR_IsNestedIn2,
                     ERRID.ERR_LocalTypeNameClash2,
                     ERRID.ERR_InteropMethodWithBody1,
                     ERRID.ERR_UseOfLocalBeforeDeclaration1,
                     ERRID.ERR_UseOfKeywordFromModule1,
                     ERRID.ERR_BogusWithinLineIf,
                     ERRID.ERR_CharToIntegralTypeMismatch1,
                     ERRID.ERR_IntegralToCharTypeMismatch1,
                     ERRID.ERR_NoDirectDelegateConstruction1,
                     ERRID.ERR_MethodMustBeFirstStatementOnLine,
                     ERRID.ERR_AttrAssignmentNotFieldOrProp1,
                     ERRID.ERR_StrictDisallowsObjectComparison1,
                     ERRID.ERR_NoConstituentArraySizes,
                     ERRID.ERR_FileAttributeNotAssemblyOrModule,
                     ERRID.ERR_FunctionResultCannotBeIndexed1,
                     ERRID.ERR_ArgumentSyntax,
                     ERRID.ERR_ExpectedResumeOrGoto,
                     ERRID.ERR_ExpectedAssignmentOperator,
                     ERRID.ERR_NamedArgAlsoOmitted2,
                     ERRID.ERR_CannotCallEvent1,
                     ERRID.ERR_ForEachCollectionDesignPattern1,
                     ERRID.ERR_DefaultValueForNonOptionalParam,
                     ERRID.ERR_ExpectedDotAfterMyBase,
                     ERRID.ERR_ExpectedDotAfterMyClass,
                     ERRID.ERR_StrictArgumentCopyBackNarrowing3,
                     ERRID.ERR_LbElseifAfterElse,
                     ERRID.ERR_StandaloneAttribute,
                     ERRID.ERR_NoUniqueConstructorOnBase2,
                     ERRID.ERR_ExtraNextVariable,
                     ERRID.ERR_RequiredNewCallTooMany2,
                     ERRID.ERR_ForCtlVarArraySizesSpecified,
                     ERRID.ERR_BadFlagsOnNewOverloads,
                     ERRID.ERR_TypeCharOnGenericParam,
                     ERRID.ERR_TooFewGenericArguments1,
                     ERRID.ERR_TooManyGenericArguments1,
                     ERRID.ERR_GenericConstraintNotSatisfied2,
                     ERRID.ERR_TypeOrMemberNotGeneric1,
                     ERRID.ERR_NewIfNullOnGenericParam,
                     ERRID.ERR_MultipleClassConstraints1,
                     ERRID.ERR_ConstNotClassInterfaceOrTypeParam1,
                     ERRID.ERR_DuplicateTypeParamName1,
                     ERRID.ERR_UnboundTypeParam2,
                     ERRID.ERR_IsOperatorGenericParam1,
                     ERRID.ERR_ArgumentCopyBackNarrowing3,
                     ERRID.ERR_ShadowingGenericParamWithMember1,
                     ERRID.ERR_GenericParamBase2,
                     ERRID.ERR_ImplementsGenericParam,
                     ERRID.ERR_OnlyNullLowerBound,
                     ERRID.ERR_ClassConstraintNotInheritable1,
                     ERRID.ERR_ConstraintIsRestrictedType1,
                     ERRID.ERR_GenericParamsOnInvalidMember,
                     ERRID.ERR_GenericArgsOnAttributeSpecifier,
                     ERRID.ERR_AttrCannotBeGenerics,
                     ERRID.ERR_BadStaticLocalInGenericMethod,
                     ERRID.ERR_SyntMemberShadowsGenericParam3,
                     ERRID.ERR_ConstraintAlreadyExists1,
                     ERRID.ERR_InterfacePossiblyImplTwice2,
                     ERRID.ERR_ModulesCannotBeGeneric,
                     ERRID.ERR_GenericClassCannotInheritAttr,
                     ERRID.ERR_DeclaresCantBeInGeneric,
                     ERRID.ERR_OverrideWithConstraintMismatch2,
                     ERRID.ERR_ImplementsWithConstraintMismatch3,
                     ERRID.ERR_OpenTypeDisallowed,
                     ERRID.ERR_HandlesInvalidOnGenericMethod,
                     ERRID.ERR_MultipleNewConstraints,
                     ERRID.ERR_MustInheritForNewConstraint2,
                     ERRID.ERR_NoSuitableNewForNewConstraint2,
                     ERRID.ERR_BadGenericParamForNewConstraint2,
                     ERRID.ERR_NewArgsDisallowedForTypeParam,
                     ERRID.ERR_DuplicateRawGenericTypeImport1,
                     ERRID.ERR_NoTypeArgumentCountOverloadCand1,
                     ERRID.ERR_TypeArgsUnexpected,
                     ERRID.ERR_NameSameAsMethodTypeParam1,
                     ERRID.ERR_TypeParamNameFunctionNameCollision,
                     ERRID.ERR_BadConstraintSyntax,
                     ERRID.ERR_OfExpected,
                     ERRID.ERR_ArrayOfRawGenericInvalid,
                     ERRID.ERR_ForEachAmbiguousIEnumerable1,
                     ERRID.ERR_IsNotOperatorGenericParam1,
                     ERRID.ERR_TypeParamQualifierDisallowed,
                     ERRID.ERR_TypeParamMissingCommaOrRParen,
                     ERRID.ERR_TypeParamMissingAsCommaOrRParen,
                     ERRID.ERR_MultipleReferenceConstraints,
                     ERRID.ERR_MultipleValueConstraints,
                     ERRID.ERR_NewAndValueConstraintsCombined,
                     ERRID.ERR_RefAndValueConstraintsCombined,
                     ERRID.ERR_BadTypeArgForStructConstraint2,
                     ERRID.ERR_BadTypeArgForRefConstraint2,
                     ERRID.ERR_RefAndClassTypeConstrCombined,
                     ERRID.ERR_ValueAndClassTypeConstrCombined,
                     ERRID.ERR_ConstraintClashIndirectIndirect4,
                     ERRID.ERR_ConstraintClashDirectIndirect3,
                     ERRID.ERR_ConstraintClashIndirectDirect3,
                     ERRID.ERR_ConstraintCycleLink2,
                     ERRID.ERR_ConstraintCycle2,
                     ERRID.ERR_TypeParamWithStructConstAsConst,
                     ERRID.ERR_NullableDisallowedForStructConstr1,
                     ERRID.ERR_ConflictingDirectConstraints3,
                     ERRID.ERR_InterfaceUnifiesWithInterface2,
                     ERRID.ERR_BaseUnifiesWithInterfaces3,
                     ERRID.ERR_InterfaceBaseUnifiesWithBase4,
                     ERRID.ERR_InterfaceUnifiesWithBase3,
                     ERRID.ERR_OptionalsCantBeStructGenericParams,
                     ERRID.ERR_AddressOfNullableMethod,
                     ERRID.ERR_IsOperatorNullable1,
                     ERRID.ERR_IsNotOperatorNullable1,
                     ERRID.ERR_ClassInheritsBaseUnifiesWithInterfaces3,
                     ERRID.ERR_ClassInheritsInterfaceBaseUnifiesWithBase4,
                     ERRID.ERR_ClassInheritsInterfaceUnifiesWithBase3,
                     ERRID.ERR_ShadowingTypeOutsideClass1,
                     ERRID.ERR_PropertySetParamCollisionWithValue,
                     ERRID.ERR_SxSIndirectRefHigherThanDirectRef3,
                     ERRID.ERR_DuplicateReference2,
                     ERRID.ERR_DuplicateReferenceStrong,
                     ERRID.ERR_IllegalCallOrIndex,
                     ERRID.ERR_ConflictDefaultPropertyAttribute,
                     ERRID.ERR_BadAttributeUuid2,
                     ERRID.ERR_ComClassAndReservedAttribute1,
                     ERRID.ERR_ComClassRequiresPublicClass2,
                     ERRID.ERR_ComClassReservedDispIdZero1,
                     ERRID.ERR_ComClassReservedDispId1,
                     ERRID.ERR_ComClassDuplicateGuids1,
                     ERRID.ERR_ComClassCantBeAbstract0,
                     ERRID.ERR_ComClassRequiresPublicClass1,
                     ERRID.ERR_UnknownOperator,
                     ERRID.ERR_DuplicateConversionCategoryUsed,
                     ERRID.ERR_OperatorNotOverloadable,
                     ERRID.ERR_InvalidHandles,
                     ERRID.ERR_InvalidImplements,
                     ERRID.ERR_EndOperatorExpected,
                     ERRID.ERR_EndOperatorNotAtLineStart,
                     ERRID.ERR_InvalidEndOperator,
                     ERRID.ERR_ExitOperatorNotValid,
                     ERRID.ERR_ParamArrayIllegal1,
                     ERRID.ERR_OptionalIllegal1,
                     ERRID.ERR_OperatorMustBePublic,
                     ERRID.ERR_OperatorMustBeShared,
                     ERRID.ERR_BadOperatorFlags1,
                     ERRID.ERR_OneParameterRequired1,
                     ERRID.ERR_TwoParametersRequired1,
                     ERRID.ERR_OneOrTwoParametersRequired1,
                     ERRID.ERR_ConvMustBeWideningOrNarrowing,
                     ERRID.ERR_OperatorDeclaredInModule,
                     ERRID.ERR_InvalidSpecifierOnNonConversion1,
                     ERRID.ERR_UnaryParamMustBeContainingType1,
                     ERRID.ERR_BinaryParamMustBeContainingType1,
                     ERRID.ERR_ConvParamMustBeContainingType1,
                     ERRID.ERR_OperatorRequiresBoolReturnType1,
                     ERRID.ERR_ConversionToSameType,
                     ERRID.ERR_ConversionToInterfaceType,
                     ERRID.ERR_ConversionToBaseType,
                     ERRID.ERR_ConversionToDerivedType,
                     ERRID.ERR_ConversionToObject,
                     ERRID.ERR_ConversionFromInterfaceType,
                     ERRID.ERR_ConversionFromBaseType,
                     ERRID.ERR_ConversionFromDerivedType,
                     ERRID.ERR_ConversionFromObject,
                     ERRID.ERR_MatchingOperatorExpected2,
                     ERRID.ERR_UnacceptableLogicalOperator3,
                     ERRID.ERR_ConditionOperatorRequired3,
                     ERRID.ERR_CopyBackTypeMismatch3,
                     ERRID.ERR_ForLoopOperatorRequired2,
                     ERRID.ERR_UnacceptableForLoopOperator2,
                     ERRID.ERR_UnacceptableForLoopRelOperator2,
                     ERRID.ERR_OperatorRequiresIntegerParameter1,
                     ERRID.ERR_CantSpecifyNullableOnBoth,
                     ERRID.ERR_BadTypeArgForStructConstraintNull,
                     ERRID.ERR_CantSpecifyArrayAndNullableOnBoth,
                     ERRID.ERR_CantSpecifyTypeCharacterOnIIF,
                     ERRID.ERR_IllegalOperandInIIFCount,
                     ERRID.ERR_IllegalOperandInIIFName,
                     ERRID.ERR_IllegalOperandInIIFConversion,
                     ERRID.ERR_IllegalCondTypeInIIF,
                     ERRID.ERR_CantCallIIF,
                     ERRID.ERR_CantSpecifyAsNewAndNullable,
                     ERRID.ERR_IllegalOperandInIIFConversion2,
                     ERRID.ERR_BadNullTypeInCCExpression,
                     ERRID.ERR_NullableImplicit,
                     ERRID.ERR_DuplicateResourceFileName1,
                     ERRID.ERR_ExpectedDotAfterGlobalNameSpace,
                     ERRID.ERR_NoGlobalExpectedIdentifier,
                     ERRID.ERR_NoGlobalInHandles,
                     ERRID.ERR_ElseIfNoMatchingIf,
                     ERRID.ERR_BadAttributeConstructor2,
                     ERRID.ERR_EndUsingWithoutUsing,
                     ERRID.ERR_ExpectedEndUsing,
                     ERRID.ERR_GotoIntoUsing,
                     ERRID.ERR_UsingRequiresDisposePattern,
                     ERRID.ERR_UsingResourceVarNeedsInitializer,
                     ERRID.ERR_UsingResourceVarCantBeArray,
                     ERRID.ERR_OnErrorInUsing,
                     ERRID.ERR_PropertyNameConflictInMyCollection,
                     ERRID.ERR_InvalidImplicitVar,
                     ERRID.ERR_ObjectInitializerRequiresFieldName,
                     ERRID.ERR_ExpectedFrom,
                     ERRID.ERR_LambdaBindingMismatch1,
                     ERRID.ERR_CannotLiftByRefParamQuery1,
                     ERRID.ERR_ExpressionTreeNotSupported,
                     ERRID.ERR_CannotLiftStructureMeQuery,
                     ERRID.ERR_InferringNonArrayType1,
                     ERRID.ERR_ByRefParamInExpressionTree,
                     ERRID.ERR_DuplicateAnonTypeMemberName1,
                     ERRID.ERR_BadAnonymousTypeForExprTree,
                     ERRID.ERR_CannotLiftAnonymousType1,
                     ERRID.ERR_ExtensionOnlyAllowedOnModuleSubOrFunction,
                     ERRID.ERR_ExtensionMethodNotInModule,
                     ERRID.ERR_ExtensionMethodNoParams,
                     ERRID.ERR_ExtensionMethodOptionalFirstArg,
                     ERRID.ERR_ExtensionMethodParamArrayFirstArg,
                     ERRID.ERR_AnonymousTypeFieldNameInference,
                     ERRID.ERR_NameNotMemberOfAnonymousType2,
                     ERRID.ERR_ExtensionAttributeInvalid,
                     ERRID.ERR_AnonymousTypePropertyOutOfOrder1,
                     ERRID.ERR_AnonymousTypeDisallowsTypeChar,
                     ERRID.ERR_ExtensionMethodUncallable1,
                     ERRID.ERR_ExtensionMethodOverloadCandidate3,
                     ERRID.ERR_DelegateBindingMismatch,
                     ERRID.ERR_DelegateBindingTypeInferenceFails,
                     ERRID.ERR_TooManyArgs,
                     ERRID.ERR_NamedArgAlsoOmitted1,
                     ERRID.ERR_NamedArgUsedTwice1,
                     ERRID.ERR_NamedParamNotFound1,
                     ERRID.ERR_OmittedArgument1,
                     ERRID.ERR_UnboundTypeParam1,
                     ERRID.ERR_ExtensionMethodOverloadCandidate2,
                     ERRID.ERR_AnonymousTypeNeedField,
                     ERRID.ERR_AnonymousTypeNameWithoutPeriod,
                     ERRID.ERR_AnonymousTypeExpectedIdentifier,
                     ERRID.ERR_TooManyArgs2,
                     ERRID.ERR_NamedArgAlsoOmitted3,
                     ERRID.ERR_NamedArgUsedTwice3,
                     ERRID.ERR_NamedParamNotFound3,
                     ERRID.ERR_OmittedArgument3,
                     ERRID.ERR_UnboundTypeParam3,
                     ERRID.ERR_TooFewGenericArguments2,
                     ERRID.ERR_TooManyGenericArguments2,
                     ERRID.ERR_ExpectedInOrEq,
                     ERRID.ERR_ExpectedQueryableSource,
                     ERRID.ERR_QueryOperatorNotFound,
                     ERRID.ERR_CannotUseOnErrorGotoWithClosure,
                     ERRID.ERR_CannotLiftRestrictedTypeQuery,
                     ERRID.ERR_QueryAnonymousTypeFieldNameInference,
                     ERRID.ERR_QueryDuplicateAnonTypeMemberName1,
                     ERRID.ERR_QueryAnonymousTypeDisallowsTypeChar,
                     ERRID.ERR_ReadOnlyInClosure,
                     ERRID.ERR_ExprTreeNoMultiDimArrayCreation,
                     ERRID.ERR_ExprTreeNoLateBind,
                     ERRID.ERR_ExpectedBy,
                     ERRID.ERR_QueryInvalidControlVariableName1,
                     ERRID.ERR_ExpectedIn,
                     ERRID.ERR_QueryNameNotDeclared,
                     ERRID.ERR_SharedEventNeedsHandlerInTheSameType,
                     ERRID.ERR_NestedFunctionArgumentNarrowing3,
                     ERRID.ERR_AnonTypeFieldXMLNameInference,
                     ERRID.ERR_QueryAnonTypeFieldXMLNameInference,
                     ERRID.ERR_ExpectedInto,
                     ERRID.ERR_TypeCharOnAggregation,
                     ERRID.ERR_ExpectedOn,
                     ERRID.ERR_ExpectedEquals,
                     ERRID.ERR_ExpectedAnd,
                     ERRID.ERR_EqualsTypeMismatch,
                     ERRID.ERR_EqualsOperandIsBad,
                     ERRID.ERR_LambdaNotDelegate1,
                     ERRID.ERR_LambdaNotCreatableDelegate1,
                     ERRID.ERR_CannotInferNullableForVariable1,
                     ERRID.ERR_NullableTypeInferenceNotSupported,
                     ERRID.ERR_ExpectedJoin,
                     ERRID.ERR_NullableParameterMustSpecifyType,
                     ERRID.ERR_IterationVariableShadowLocal2,
                     ERRID.ERR_LambdasCannotHaveAttributes,
                     ERRID.ERR_LambdaInSelectCaseExpr,
                     ERRID.ERR_AddressOfInSelectCaseExpr,
                     ERRID.ERR_NullableCharNotSupported,
                     ERRID.ERR_CannotLiftStructureMeLambda,
                     ERRID.ERR_CannotLiftByRefParamLambda1,
                     ERRID.ERR_CannotLiftRestrictedTypeLambda,
                     ERRID.ERR_LambdaParamShadowLocal1,
                     ERRID.ERR_StrictDisallowImplicitObjectLambda,
                     ERRID.ERR_CantSpecifyParamsOnLambdaParamNoType,
                     ERRID.ERR_TypeInferenceFailure1,
                     ERRID.ERR_TypeInferenceFailure2,
                     ERRID.ERR_TypeInferenceFailure3,
                     ERRID.ERR_TypeInferenceFailureNoExplicit1,
                     ERRID.ERR_TypeInferenceFailureNoExplicit2,
                     ERRID.ERR_TypeInferenceFailureNoExplicit3,
                     ERRID.ERR_TypeInferenceFailureAmbiguous1,
                     ERRID.ERR_TypeInferenceFailureAmbiguous2,
                     ERRID.ERR_TypeInferenceFailureAmbiguous3,
                     ERRID.ERR_TypeInferenceFailureNoExplicitAmbiguous1,
                     ERRID.ERR_TypeInferenceFailureNoExplicitAmbiguous2,
                     ERRID.ERR_TypeInferenceFailureNoExplicitAmbiguous3,
                     ERRID.ERR_TypeInferenceFailureNoBest1,
                     ERRID.ERR_TypeInferenceFailureNoBest2,
                     ERRID.ERR_TypeInferenceFailureNoBest3,
                     ERRID.ERR_TypeInferenceFailureNoExplicitNoBest1,
                     ERRID.ERR_TypeInferenceFailureNoExplicitNoBest2,
                     ERRID.ERR_TypeInferenceFailureNoExplicitNoBest3,
                     ERRID.ERR_DelegateBindingMismatchStrictOff2,
                     ERRID.ERR_InaccessibleReturnTypeOfMember2,
                     ERRID.ERR_LocalNamedSameAsParamInLambda1,
                     ERRID.ERR_MultilineLambdasCannotContainOnError,
                     ERRID.ERR_LambdaBindingMismatch2,
                     ERRID.ERR_StaticInLambda,
                     ERRID.ERR_MultilineLambdaMissingSub,
                     ERRID.ERR_MultilineLambdaMissingFunction,
                     ERRID.ERR_StatementLambdaInExpressionTree,
                     ERRID.ERR_AttributeOnLambdaReturnType,
                     ERRID.ERR_ExpectedIdentifierOrGroup,
                     ERRID.ERR_UnexpectedGroup,
                     ERRID.ERR_DelegateBindingMismatchStrictOff3,
                     ERRID.ERR_DelegateBindingIncompatible3,
                     ERRID.ERR_ArgumentNarrowing2,
                     ERRID.ERR_OverloadCandidate1,
                     ERRID.ERR_AutoPropertyInitializedInStructure,
                     ERRID.ERR_InitializedExpandedProperty,
                     ERRID.ERR_LanguageVersion,
                     ERRID.ERR_ArrayInitNoType,
                     ERRID.ERR_NotACollection1,
                     ERRID.ERR_NoAddMethod1,
                     ERRID.ERR_CantCombineInitializers,
                     ERRID.ERR_EmptyAggregateInitializer,
                     ERRID.ERR_VarianceDisallowedHere,
                     ERRID.ERR_VarianceInterfaceNesting,
                     ERRID.ERR_VarianceOutParamDisallowed1,
                     ERRID.ERR_VarianceInParamDisallowed1,
                     ERRID.ERR_VarianceOutParamDisallowedForGeneric3,
                     ERRID.ERR_VarianceInParamDisallowedForGeneric3,
                     ERRID.ERR_VarianceOutParamDisallowedHere2,
                     ERRID.ERR_VarianceInParamDisallowedHere2,
                     ERRID.ERR_VarianceOutParamDisallowedHereForGeneric4,
                     ERRID.ERR_VarianceInParamDisallowedHereForGeneric4,
                     ERRID.ERR_VarianceTypeDisallowed2,
                     ERRID.ERR_VarianceTypeDisallowedForGeneric4,
                     ERRID.ERR_LambdaTooManyTypesObjectDisallowed,
                     ERRID.ERR_VarianceTypeDisallowedHere3,
                     ERRID.ERR_VarianceTypeDisallowedHereForGeneric5,
                     ERRID.ERR_AmbiguousCastConversion2,
                     ERRID.ERR_VariancePreventsSynthesizedEvents2,
                     ERRID.ERR_NestingViolatesCLS1,
                     ERRID.ERR_VarianceOutNullableDisallowed2,
                     ERRID.ERR_VarianceInNullableDisallowed2,
                     ERRID.ERR_VarianceOutByValDisallowed1,
                     ERRID.ERR_VarianceInReturnDisallowed1,
                     ERRID.ERR_VarianceOutConstraintDisallowed1,
                     ERRID.ERR_VarianceInReadOnlyPropertyDisallowed1,
                     ERRID.ERR_VarianceOutWriteOnlyPropertyDisallowed1,
                     ERRID.ERR_VarianceOutPropertyDisallowed1,
                     ERRID.ERR_VarianceInPropertyDisallowed1,
                     ERRID.ERR_VarianceOutByRefDisallowed1,
                     ERRID.ERR_VarianceInByRefDisallowed1,
                     ERRID.ERR_LambdaNoType,
                     ERRID.ERR_VarianceConversionFailedOut6,
                     ERRID.ERR_VarianceConversionFailedIn6,
                     ERRID.ERR_VarianceIEnumerableSuggestion3,
                     ERRID.ERR_VarianceConversionFailedTryOut4,
                     ERRID.ERR_VarianceConversionFailedTryIn4,
                     ERRID.ERR_AutoPropertyCantHaveParams,
                     ERRID.ERR_IdentityDirectCastForFloat,
                     ERRID.ERR_TypeDisallowsElements,
                     ERRID.ERR_TypeDisallowsAttributes,
                     ERRID.ERR_TypeDisallowsDescendants,
                     ERRID.ERR_TypeOrMemberNotGeneric2,
                     ERRID.ERR_ExtensionMethodCannotBeLateBound,
                     ERRID.ERR_TypeInferenceArrayRankMismatch1,
                     ERRID.ERR_QueryStrictDisallowImplicitObject,
                     ERRID.ERR_IfNoType,
                     ERRID.ERR_IfNoTypeObjectDisallowed,
                     ERRID.ERR_IfTooManyTypesObjectDisallowed,
                     ERRID.ERR_ArrayInitNoTypeObjectDisallowed,
                     ERRID.ERR_ArrayInitTooManyTypesObjectDisallowed,
                     ERRID.ERR_LambdaNoTypeObjectDisallowed,
                     ERRID.ERR_OverloadsModifierInModule,
                     ERRID.ERR_SubRequiresSingleStatement,
                     ERRID.ERR_SubDisallowsStatement,
                     ERRID.ERR_SubRequiresParenthesesLParen,
                     ERRID.ERR_SubRequiresParenthesesDot,
                     ERRID.ERR_SubRequiresParenthesesBang,
                     ERRID.ERR_CannotEmbedInterfaceWithGeneric,
                     ERRID.ERR_CannotUseGenericTypeAcrossAssemblyBoundaries,
                     ERRID.ERR_CannotUseGenericBaseTypeAcrossAssemblyBoundaries,
                     ERRID.ERR_BadAsyncByRefParam,
                     ERRID.ERR_BadIteratorByRefParam,
                     ERRID.ERR_BadAsyncInQuery,
                     ERRID.ERR_BadGetAwaiterMethod1,
                     ERRID.ERR_RestrictedResumableType1,
                     ERRID.ERR_BadAwaitNothing,
                     ERRID.ERR_AsyncSubMain,
                     ERRID.ERR_PartialMethodsMustNotBeAsync1,
                     ERRID.ERR_InvalidAsyncIteratorModifiers,
                     ERRID.ERR_BadAwaitNotInAsyncMethodOrLambda,
                     ERRID.ERR_BadIteratorReturn,
                     ERRID.ERR_BadYieldInTryHandler,
                     ERRID.ERR_BadYieldInNonIteratorMethod,
                     ERRID.ERR_BadReturnValueInIterator,
                     ERRID.ERR_BadAwaitInTryHandler,
                     ERRID.ERR_BadAsyncReturn,
                     ERRID.ERR_BadResumableAccessReturnVariable,
                     ERRID.ERR_BadIteratorExpressionLambda,
                     ERRID.ERR_ConstructorAsync,
                     ERRID.ERR_InvalidLambdaModifier,
                     ERRID.ERR_ReturnFromNonGenericTaskAsync,
                     ERRID.ERR_BadOverloadCandidates2,
                     ERRID.ERR_BadStaticInitializerInResumable,
                     ERRID.ERR_ResumablesCannotContainOnError,
                     ERRID.ERR_FriendRefNotEqualToThis,
                     ERRID.ERR_FriendRefSigningMismatch,
                     ERRID.ERR_FailureSigningAssembly,
                     ERRID.ERR_SignButNoPrivateKey,
                     ERRID.ERR_InvalidVersionFormat,
                     ERRID.ERR_ExpectedSingleScript,
                     ERRID.ERR_ReferenceDirectiveOnlyAllowedInScripts,
                     ERRID.ERR_NamespaceNotAllowedInScript,
                     ERRID.ERR_KeywordNotAllowedInScript,
                     ERRID.ERR_ReservedAssemblyName,
                     ERRID.ERR_ConstructorCannotBeDeclaredPartial,
                     ERRID.ERR_ModuleEmitFailure,
                     ERRID.ERR_ParameterNotValidForType,
                     ERRID.ERR_MarshalUnmanagedTypeNotValidForFields,
                     ERRID.ERR_MarshalUnmanagedTypeOnlyValidForFields,
                     ERRID.ERR_AttributeParameterRequired1,
                     ERRID.ERR_AttributeParameterRequired2,
                     ERRID.ERR_InvalidVersionFormat2,
                     ERRID.ERR_InvalidAssemblyCultureForExe,
                     ERRID.ERR_InvalidMultipleAttributeUsageInNetModule2,
                     ERRID.ERR_SecurityAttributeInvalidTarget,
                     ERRID.ERR_PublicKeyFileFailure,
                     ERRID.ERR_PublicKeyContainerFailure,
                     ERRID.ERR_InvalidAssemblyCulture,
                     ERRID.ERR_EncUpdateFailedMissingAttribute,
                     ERRID.ERR_CantAwaitAsyncSub1,
                     ERRID.ERR_ResumableLambdaInExpressionTree,
                     ERRID.ERR_DllImportOnResumableMethod,
                     ERRID.ERR_CannotLiftRestrictedTypeResumable1,
                     ERRID.ERR_BadIsCompletedOnCompletedGetResult2,
                     ERRID.ERR_SynchronizedAsyncMethod,
                     ERRID.ERR_BadAsyncReturnOperand1,
                     ERRID.ERR_DoesntImplementAwaitInterface2,
                     ERRID.ERR_BadAwaitInNonAsyncMethod,
                     ERRID.ERR_BadAwaitInNonAsyncVoidMethod,
                     ERRID.ERR_BadAwaitInNonAsyncLambda,
                     ERRID.ERR_LoopControlMustNotAwait,
                     ERRID.ERR_MyGroupCollectionAttributeCycle,
                     ERRID.ERR_LiteralExpected,
                     ERRID.ERR_PartialMethodDefaultParameterValueMismatch2,
                     ERRID.ERR_PartialMethodParamArrayMismatch2,
                     ERRID.ERR_NetModuleNameMismatch,
                     ERRID.ERR_BadModuleName,
                     ERRID.ERR_CmdOptionConflictsSource,
                     ERRID.ERR_TypeForwardedToMultipleAssemblies,
                     ERRID.ERR_InvalidSignaturePublicKey,
                     ERRID.ERR_CollisionWithPublicTypeInModule,
                     ERRID.ERR_ExportedTypeConflictsWithDeclaration,
                     ERRID.ERR_ExportedTypesConflict,
                     ERRID.ERR_AgnosticToMachineModule,
                     ERRID.ERR_ConflictingMachineModule,
                     ERRID.ERR_CryptoHashFailed,
                     ERRID.ERR_CantHaveWin32ResAndManifest,
                     ERRID.ERR_ForwardedTypeConflictsWithDeclaration,
                     ERRID.ERR_ForwardedTypeConflictsWithExportedType,
                     ERRID.ERR_ForwardedTypesConflict,
                     ERRID.ERR_TooLongMetadataName,
                     ERRID.ERR_MissingNetModuleReference,
                     ERRID.ERR_UnsupportedModule1,
                     ERRID.ERR_UnsupportedEvent1,
                     ERRID.ERR_NetModuleNameMustBeUnique,
                     ERRID.ERR_PDBWritingFailed,
                     ERRID.ERR_ParamDefaultValueDiffersFromAttribute,
                     ERRID.ERR_ResourceInModule,
                     ERRID.ERR_FieldHasMultipleDistinctConstantValues,
                     ERRID.ERR_AmbiguousInNamespaces2,
                     ERRID.ERR_EncNoPIAReference,
                     ERRID.ERR_LinkedNetmoduleMetadataMustProvideFullPEImage,
                     ERRID.ERR_CantReadRulesetFile,
                     ERRID.ERR_MetadataReferencesNotSupported,
                     ERRID.ERR_PlatformDoesntSupport,
                     ERRID.ERR_CantUseRequiredAttribute,
                     ERRID.ERR_EncodinglessSyntaxTree,
                     ERRID.ERR_InvalidFormatSpecifier,
                     ERRID.ERR_CannotBeMadeNullable1,
                     ERRID.ERR_BadConditionalWithRef,
                     ERRID.ERR_NullPropagatingOpInExpressionTree,
                     ERRID.ERR_TooLongOrComplexExpression,
                     ERRID.ERR_BadPdbData,
                     ERRID.ERR_AutoPropertyCantBeWriteOnly,
                     ERRID.ERR_ExpressionDoesntHaveName,
                     ERRID.ERR_InvalidNameOfSubExpression,
                     ERRID.ERR_MethodTypeArgsUnexpected,
                     ERRID.ERR_InReferencedAssembly,
                     ERRID.ERR_EncReferenceToAddedMember,
                     ERRID.ERR_InterpolationFormatWhitespace,
                     ERRID.ERR_InterpolationAlignmentOutOfRange,
                     ERRID.ERR_InterpolatedStringFactoryError,
                     ERRID.ERR_DebugEntryPointNotSourceMethodDefinition,
                     ERRID.ERR_InvalidPathMap,
                     ERRID.ERR_PublicSignNoKey,
                     ERRID.ERR_TooManyUserStrings,
                     ERRID.ERR_PeWritingFailure,
                     ERRID.ERR_OptionMustBeAbsolutePath,
                     ERRID.ERR_DocFileGen,
                     ERRID.ERR_TupleTooFewElements,
                     ERRID.ERR_TupleReservedElementNameAnyPosition,
                     ERRID.ERR_TupleReservedElementName,
                     ERRID.ERR_TupleDuplicateElementName,
                     ERRID.ERR_RefReturningCallInExpressionTree,
                     ERRID.ERR_SourceLinkRequiresPdb,
                     ERRID.ERR_CannotEmbedWithoutPdb,
                     ERRID.ERR_InvalidInstrumentationKind,
                     ERRID.ERR_ValueTupleTypeRefResolutionError1,
                     ERRID.ERR_TupleElementNamesAttributeMissing,
                     ERRID.ERR_ExplicitTupleElementNamesAttribute,
                     ERRID.ERR_TupleLiteralDisallowsTypeChar,
                     ERRID.ERR_DuplicateProcDefWithDifferentTupleNames2,
                     ERRID.ERR_InterfaceImplementedTwiceWithDifferentTupleNames2,
                     ERRID.ERR_InterfaceImplementedTwiceWithDifferentTupleNames3,
                     ERRID.ERR_InterfaceImplementedTwiceWithDifferentTupleNamesReverse3,
                     ERRID.ERR_InterfaceImplementedTwiceWithDifferentTupleNames4,
                     ERRID.ERR_InterfaceInheritedTwiceWithDifferentTupleNames2,
                     ERRID.ERR_InterfaceInheritedTwiceWithDifferentTupleNames3,
                     ERRID.ERR_InterfaceInheritedTwiceWithDifferentTupleNamesReverse3,
                     ERRID.ERR_InterfaceInheritedTwiceWithDifferentTupleNames4,
                     ERRID.ERR_NewWithTupleTypeSyntax,
                     ERRID.ERR_PredefinedValueTupleTypeMustBeStruct,
                     ERRID.ERR_PublicSignNetModule,
                     ERRID.ERR_BadAssemblyName,
                     ERRID.ERR_Merge_conflict_marker_encountered,
                     ERRID.ERR_BadSourceCodeKind,
                     ERRID.ERR_BadDocumentationMode,
                     ERRID.ERR_BadLanguageVersion,
                     ERRID.ERR_InvalidPreprocessorConstantType,
                     ERRID.ERR_TupleInferredNamesNotAvailable,
                     ERRID.ERR_InvalidDebugInfo,
                     ERRID.ERR_NoRefOutWhenRefOnly,
                     ERRID.ERR_NoNetModuleOutputWhenRefOutOrRefOnly,
                     ERRID.ERR_BadNonTrailingNamedArgument,
                     ERRID.ERR_ExpectedNamedArgumentInAttributeList,
                     ERRID.ERR_NamedArgumentSpecificationBeforeFixedArgumentInLateboundInvocation,
                     ERRID.ERR_ValueTupleResolutionAmbiguous3,
                     ERRID.ERR_CommentsAfterLineContinuationNotAvailable1,
                     ERRID.ERR_DefaultInterfaceImplementationInNoPIAType,
                     ERRID.ERR_ReAbstractionInNoPIAType,
                     ERRID.ERR_RuntimeDoesNotSupportDefaultInterfaceImplementation,
                     ERRID.ERR_RuntimeDoesNotSupportProtectedAccessForInterfaceMember,
                     ERRID.ERR_AssignmentInitOnly,
                     ERRID.ERR_OverridingInitOnlyProperty,
                     ERRID.ERR_PropertyDoesntImplementInitOnly,
                     ERRID.ERR_BadAbstractStaticMemberAccess,
                     ERRID.ERR_UnimplementedSharedMember,
                     ERRID.ERR_UnmanagedCallersOnlyNotSupported,
                     ERRID.ERR_MultipleAnalyzerConfigsInSameDir,
                     ERRID.ERR_StdInOptionProvidedButConsoleInputIsNotRedirected,
                     ERRID.ERR_UnsupportedCompilerFeature,
                     ERRID.ERR_DoNotUseCompilerFeatureRequired,
                     ERRID.ERR_RequiredMemberMustBeSet,
                     ERRID.ERR_CannotInheritFromTypeWithRequiredMembers,
                     ERRID.ERR_RequiredMembersInvalid,
                     ERRID.ERR_NewConstraintCannotHaveRequiredMembers,
                     ERRID.ERR_DoNotUseRequiredMember,
                     ERRID.ERR_UnsupportedRefReturningCallInWithStatement,
                     ERRID.ERR_NextAvailable,
                     ERRID.WRN_UseOfObsoleteSymbol2,
                     ERRID.WRN_InvalidOverrideDueToTupleNames2,
                     ERRID.WRN_MustOverloadBase4,
                     ERRID.WRN_OverrideType5,
                     ERRID.WRN_MustOverride2,
                     ERRID.WRN_DefaultnessShadowed4,
                     ERRID.WRN_UseOfObsoleteSymbolNoMessage1,
                     ERRID.WRN_AssemblyGeneration0,
                     ERRID.WRN_AssemblyGeneration1,
                     ERRID.WRN_ComClassNoMembers1,
                     ERRID.WRN_SynthMemberShadowsMember5,
                     ERRID.WRN_MemberShadowsSynthMember6,
                     ERRID.WRN_SynthMemberShadowsSynthMember7,
                     ERRID.WRN_UseOfObsoletePropertyAccessor3,
                     ERRID.WRN_UseOfObsoletePropertyAccessor2,
                     ERRID.WRN_FieldNotCLSCompliant1,
                     ERRID.WRN_BaseClassNotCLSCompliant2,
                     ERRID.WRN_ProcTypeNotCLSCompliant1,
                     ERRID.WRN_ParamNotCLSCompliant1,
                     ERRID.WRN_InheritedInterfaceNotCLSCompliant2,
                     ERRID.WRN_CLSMemberInNonCLSType3,
                     ERRID.WRN_NameNotCLSCompliant1,
                     ERRID.WRN_EnumUnderlyingTypeNotCLS1,
                     ERRID.WRN_NonCLSMemberInCLSInterface1,
                     ERRID.WRN_NonCLSMustOverrideInCLSType1,
                     ERRID.WRN_ArrayOverloadsNonCLS2,
                     ERRID.WRN_RootNamespaceNotCLSCompliant1,
                     ERRID.WRN_RootNamespaceNotCLSCompliant2,
                     ERRID.WRN_GenericConstraintNotCLSCompliant1,
                     ERRID.WRN_TypeNotCLSCompliant1,
                     ERRID.WRN_OptionalValueNotCLSCompliant1,
                     ERRID.WRN_CLSAttrInvalidOnGetSet,
                     ERRID.WRN_TypeConflictButMerged6,
                     ERRID.WRN_ShadowingGenericParamWithParam1,
                     ERRID.WRN_CannotFindStandardLibrary1,
                     ERRID.WRN_EventDelegateTypeNotCLSCompliant2,
                     ERRID.WRN_DebuggerHiddenIgnoredOnProperties,
                     ERRID.WRN_SelectCaseInvalidRange,
                     ERRID.WRN_CLSEventMethodInNonCLSType3,
                     ERRID.WRN_ExpectedInitComponentCall2,
                     ERRID.WRN_NamespaceCaseMismatch3,
                     ERRID.WRN_UndefinedOrEmptyNamespaceOrClass1,
                     ERRID.WRN_UndefinedOrEmptyProjectNamespaceOrClass1,
                     ERRID.WRN_IndirectRefToLinkedAssembly2,
                     ERRID.WRN_DelaySignButNoKey,
                     ERRID.WRN_UnimplementedCommandLineSwitch,
                     ERRID.WRN_NoNonObsoleteConstructorOnBase3,
                     ERRID.WRN_NoNonObsoleteConstructorOnBase4,
                     ERRID.WRN_RequiredNonObsoleteNewCall3,
                     ERRID.WRN_RequiredNonObsoleteNewCall4,
                     ERRID.WRN_MissingAsClauseinOperator,
                     ERRID.WRN_ConstraintsFailedForInferredArgs2,
                     ERRID.WRN_ConditionalNotValidOnFunction,
                     ERRID.WRN_UseSwitchInsteadOfAttribute,
                     ERRID.WRN_TupleLiteralNameMismatch,
                     ERRID.WRN_ReferencedAssemblyDoesNotHaveStrongName,
                     ERRID.WRN_RecursiveAddHandlerCall,
                     ERRID.WRN_ImplicitConversionCopyBack,
                     ERRID.WRN_MustShadowOnMultipleInheritance2,
                     ERRID.WRN_RecursiveOperatorCall,
                     ERRID.WRN_ImplicitConversionSubst1,
                     ERRID.WRN_LateBindingResolution,
                     ERRID.WRN_ObjectMath1,
                     ERRID.WRN_ObjectMath2,
                     ERRID.WRN_ObjectAssumedVar1,
                     ERRID.WRN_ObjectAssumed1,
                     ERRID.WRN_ObjectAssumedProperty1,
                     ERRID.WRN_UnusedLocal,
                     ERRID.WRN_SharedMemberThroughInstance,
                     ERRID.WRN_RecursivePropertyCall,
                     ERRID.WRN_OverlappingCatch,
                     ERRID.WRN_DefAsgUseNullRefByRef,
                     ERRID.WRN_DuplicateCatch,
                     ERRID.WRN_ObjectMath1Not,
                     ERRID.WRN_BadChecksumValExtChecksum,
                     ERRID.WRN_MultipleDeclFileExtChecksum,
                     ERRID.WRN_BadGUIDFormatExtChecksum,
                     ERRID.WRN_ObjectMathSelectCase,
                     ERRID.WRN_EqualToLiteralNothing,
                     ERRID.WRN_NotEqualToLiteralNothing,
                     ERRID.WRN_UnusedLocalConst,
                     ERRID.WRN_ComClassInterfaceShadows5,
                     ERRID.WRN_ComClassPropertySetObject1,
                     ERRID.WRN_DefAsgUseNullRef,
                     ERRID.WRN_DefAsgNoRetValFuncRef1,
                     ERRID.WRN_DefAsgNoRetValOpRef1,
                     ERRID.WRN_DefAsgNoRetValPropRef1,
                     ERRID.WRN_DefAsgUseNullRefByRefStr,
                     ERRID.WRN_DefAsgUseNullRefStr,
                     ERRID.WRN_StaticLocalNoInference,
                     ERRID.WRN_InvalidAssemblyName,
                     ERRID.WRN_XMLDocBadXMLLine,
                     ERRID.WRN_XMLDocMoreThanOneCommentBlock,
                     ERRID.WRN_XMLDocNotFirstOnLine,
                     ERRID.WRN_XMLDocInsideMethod,
                     ERRID.WRN_XMLDocParseError1,
                     ERRID.WRN_XMLDocDuplicateXMLNode1,
                     ERRID.WRN_XMLDocIllegalTagOnElement2,
                     ERRID.WRN_XMLDocBadParamTag2,
                     ERRID.WRN_XMLDocParamTagWithoutName,
                     ERRID.WRN_XMLDocCrefAttributeNotFound1,
                     ERRID.WRN_XMLMissingFileOrPathAttribute1,
                     ERRID.WRN_XMLCannotWriteToXMLDocFile2,
                     ERRID.WRN_XMLDocWithoutLanguageElement,
                     ERRID.WRN_XMLDocReturnsOnWriteOnlyProperty,
                     ERRID.WRN_XMLDocOnAPartialType,
                     ERRID.WRN_XMLDocReturnsOnADeclareSub,
                     ERRID.WRN_XMLDocStartTagWithNoEndTag,
                     ERRID.WRN_XMLDocBadGenericParamTag2,
                     ERRID.WRN_XMLDocGenericParamTagWithoutName,
                     ERRID.WRN_XMLDocExceptionTagWithoutCRef,
                     ERRID.WRN_XMLDocInvalidXMLFragment,
                     ERRID.WRN_XMLDocBadFormedXML,
                     ERRID.WRN_InterfaceConversion2,
                     ERRID.WRN_LiftControlVariableLambda,
                     ERRID.WRN_LambdaPassedToRemoveHandler,
                     ERRID.WRN_LiftControlVariableQuery,
                     ERRID.WRN_RelDelegatePassedToRemoveHandler,
                     ERRID.WRN_AmbiguousCastConversion2,
                     ERRID.WRN_VarianceDeclarationAmbiguous3,
                     ERRID.WRN_ArrayInitNoTypeObjectAssumed,
                     ERRID.WRN_TypeInferenceAssumed3,
                     ERRID.WRN_VarianceConversionFailedOut6,
                     ERRID.WRN_VarianceConversionFailedIn6,
                     ERRID.WRN_VarianceIEnumerableSuggestion3,
                     ERRID.WRN_VarianceConversionFailedTryOut4,
                     ERRID.WRN_VarianceConversionFailedTryIn4,
                     ERRID.WRN_IfNoTypeObjectAssumed,
                     ERRID.WRN_IfTooManyTypesObjectAssumed,
                     ERRID.WRN_ArrayInitTooManyTypesObjectAssumed,
                     ERRID.WRN_LambdaNoTypeObjectAssumed,
                     ERRID.WRN_LambdaTooManyTypesObjectAssumed,
                     ERRID.WRN_MissingAsClauseinVarDecl,
                     ERRID.WRN_MissingAsClauseinFunction,
                     ERRID.WRN_MissingAsClauseinProperty,
                     ERRID.WRN_ObsoleteIdentityDirectCastForValueType,
                     ERRID.WRN_ImplicitConversion2,
                     ERRID.WRN_MutableStructureInUsing,
                     ERRID.WRN_MutableGenericStructureInUsing,
                     ERRID.WRN_DefAsgNoRetValFuncVal1,
                     ERRID.WRN_DefAsgNoRetValOpVal1,
                     ERRID.WRN_DefAsgNoRetValPropVal1,
                     ERRID.WRN_AsyncLacksAwaits,
                     ERRID.WRN_AsyncSubCouldBeFunction,
                     ERRID.WRN_UnobservedAwaitableExpression,
                     ERRID.WRN_UnobservedAwaitableDelegate,
                     ERRID.WRN_PrefixAndXmlnsLocalName,
                     ERRID.WRN_UseValueForXmlExpression3,
                     ERRID.WRN_ReturnTypeAttributeOnWriteOnlyProperty,
                     ERRID.WRN_InvalidVersionFormat,
                     ERRID.WRN_MainIgnored,
                     ERRID.WRN_EmptyPrefixAndXmlnsLocalName,
                     ERRID.WRN_DefAsgNoRetValWinRtEventVal1,
                     ERRID.WRN_AssemblyAttributeFromModuleIsOverridden,
                     ERRID.WRN_RefCultureMismatch,
                     ERRID.WRN_ConflictingMachineAssembly,
                     ERRID.WRN_PdbLocalNameTooLong,
                     ERRID.WRN_PdbUsingNameTooLong,
                     ERRID.WRN_XMLDocCrefToTypeParameter,
                     ERRID.WRN_AnalyzerCannotBeCreated,
                     ERRID.WRN_NoAnalyzerInAssembly,
                     ERRID.WRN_UnableToLoadAnalyzer,
                     ERRID.WRN_AttributeIgnoredWhenPublicSigning,
                     ERRID.WRN_Experimental,
                     ERRID.WRN_AttributeNotSupportedInVB,
                     ERRID.WRN_GeneratorFailedDuringInitialization,
                     ERRID.WRN_GeneratorFailedDuringGeneration,
                     ERRID.WRN_AnalyzerReferencesFramework,
                     ERRID.WRN_CallerArgumentExpressionAttributeSelfReferential,
                     ERRID.WRN_CallerArgumentExpressionAttributeHasInvalidParameterName,
                     ERRID.WRN_AnalyzerReferencesNewerCompiler,
                     ERRID.WRN_DuplicateAnalyzerReference
                    Return False
                Case Else
                    ' NOTE: All error codes must be explicitly handled in the below select case statement
                    '       to ensure that we correctly classify all error codes as build-only or not.
                    Throw New NotImplementedException($"ERRID.{code}")
            End Select
        End Function
    End Module
End Namespace
