// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// This file was generated by a tool.
// See src/System.Text.Encodings.Web/tools/GenUnicodeRanges
// IF YOU NEED TO UPDATE UNICODE VERSION FOLLOW THE GUIDE AT src/libraries/System.Private.CoreLib/Tools/GenUnicodeProp/Updating-Unicode-Versions.md

#nullable restore

namespace System.Text.Unicode
{
    public static partial class UnicodeRanges
    {
        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Basic Latin' Unicode block (U+0000..U+007F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0000.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange BasicLatin => _u0000 ?? CreateRange(ref _u0000, first: '\u0000', last: '\u007F');
        private static UnicodeRange? _u0000;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin-1 Supplement' Unicode block (U+0080..U+00FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0080.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Latin1Supplement => _u0080 ?? CreateRange(ref _u0080, first: '\u0080', last: '\u00FF');
        private static UnicodeRange? _u0080;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin Extended-A' Unicode block (U+0100..U+017F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0100.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LatinExtendedA => _u0100 ?? CreateRange(ref _u0100, first: '\u0100', last: '\u017F');
        private static UnicodeRange? _u0100;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin Extended-B' Unicode block (U+0180..U+024F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0180.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LatinExtendedB => _u0180 ?? CreateRange(ref _u0180, first: '\u0180', last: '\u024F');
        private static UnicodeRange? _u0180;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'IPA Extensions' Unicode block (U+0250..U+02AF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0250.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange IpaExtensions => _u0250 ?? CreateRange(ref _u0250, first: '\u0250', last: '\u02AF');
        private static UnicodeRange? _u0250;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Spacing Modifier Letters' Unicode block (U+02B0..U+02FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U02B0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SpacingModifierLetters => _u02B0 ?? CreateRange(ref _u02B0, first: '\u02B0', last: '\u02FF');
        private static UnicodeRange? _u02B0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Combining Diacritical Marks' Unicode block (U+0300..U+036F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0300.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CombiningDiacriticalMarks => _u0300 ?? CreateRange(ref _u0300, first: '\u0300', last: '\u036F');
        private static UnicodeRange? _u0300;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Greek and Coptic' Unicode block (U+0370..U+03FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0370.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange GreekandCoptic => _u0370 ?? CreateRange(ref _u0370, first: '\u0370', last: '\u03FF');
        private static UnicodeRange? _u0370;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cyrillic' Unicode block (U+0400..U+04FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0400.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Cyrillic => _u0400 ?? CreateRange(ref _u0400, first: '\u0400', last: '\u04FF');
        private static UnicodeRange? _u0400;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cyrillic Supplement' Unicode block (U+0500..U+052F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0500.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CyrillicSupplement => _u0500 ?? CreateRange(ref _u0500, first: '\u0500', last: '\u052F');
        private static UnicodeRange? _u0500;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Armenian' Unicode block (U+0530..U+058F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0530.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Armenian => _u0530 ?? CreateRange(ref _u0530, first: '\u0530', last: '\u058F');
        private static UnicodeRange? _u0530;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hebrew' Unicode block (U+0590..U+05FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0590.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Hebrew => _u0590 ?? CreateRange(ref _u0590, first: '\u0590', last: '\u05FF');
        private static UnicodeRange? _u0590;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arabic' Unicode block (U+0600..U+06FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0600.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Arabic => _u0600 ?? CreateRange(ref _u0600, first: '\u0600', last: '\u06FF');
        private static UnicodeRange? _u0600;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Syriac' Unicode block (U+0700..U+074F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0700.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Syriac => _u0700 ?? CreateRange(ref _u0700, first: '\u0700', last: '\u074F');
        private static UnicodeRange? _u0700;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arabic Supplement' Unicode block (U+0750..U+077F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0750.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ArabicSupplement => _u0750 ?? CreateRange(ref _u0750, first: '\u0750', last: '\u077F');
        private static UnicodeRange? _u0750;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Thaana' Unicode block (U+0780..U+07BF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0780.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Thaana => _u0780 ?? CreateRange(ref _u0780, first: '\u0780', last: '\u07BF');
        private static UnicodeRange? _u0780;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'NKo' Unicode block (U+07C0..U+07FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U07C0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange NKo => _u07C0 ?? CreateRange(ref _u07C0, first: '\u07C0', last: '\u07FF');
        private static UnicodeRange? _u07C0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Samaritan' Unicode block (U+0800..U+083F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0800.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Samaritan => _u0800 ?? CreateRange(ref _u0800, first: '\u0800', last: '\u083F');
        private static UnicodeRange? _u0800;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Mandaic' Unicode block (U+0840..U+085F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0840.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Mandaic => _u0840 ?? CreateRange(ref _u0840, first: '\u0840', last: '\u085F');
        private static UnicodeRange? _u0840;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Syriac Supplement' Unicode block (U+0860..U+086F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0860.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SyriacSupplement => _u0860 ?? CreateRange(ref _u0860, first: '\u0860', last: '\u086F');
        private static UnicodeRange? _u0860;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arabic Extended-B' Unicode block (U+0870..U+089F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0870.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ArabicExtendedB => _u0870 ?? CreateRange(ref _u0870, first: '\u0870', last: '\u089F');
        private static UnicodeRange? _u0870;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arabic Extended-A' Unicode block (U+08A0..U+08FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U08A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ArabicExtendedA => _u08A0 ?? CreateRange(ref _u08A0, first: '\u08A0', last: '\u08FF');
        private static UnicodeRange? _u08A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Devanagari' Unicode block (U+0900..U+097F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0900.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Devanagari => _u0900 ?? CreateRange(ref _u0900, first: '\u0900', last: '\u097F');
        private static UnicodeRange? _u0900;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Bengali' Unicode block (U+0980..U+09FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0980.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Bengali => _u0980 ?? CreateRange(ref _u0980, first: '\u0980', last: '\u09FF');
        private static UnicodeRange? _u0980;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Gurmukhi' Unicode block (U+0A00..U+0A7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0A00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Gurmukhi => _u0A00 ?? CreateRange(ref _u0A00, first: '\u0A00', last: '\u0A7F');
        private static UnicodeRange? _u0A00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Gujarati' Unicode block (U+0A80..U+0AFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0A80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Gujarati => _u0A80 ?? CreateRange(ref _u0A80, first: '\u0A80', last: '\u0AFF');
        private static UnicodeRange? _u0A80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Oriya' Unicode block (U+0B00..U+0B7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0B00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Oriya => _u0B00 ?? CreateRange(ref _u0B00, first: '\u0B00', last: '\u0B7F');
        private static UnicodeRange? _u0B00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tamil' Unicode block (U+0B80..U+0BFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0B80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Tamil => _u0B80 ?? CreateRange(ref _u0B80, first: '\u0B80', last: '\u0BFF');
        private static UnicodeRange? _u0B80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Telugu' Unicode block (U+0C00..U+0C7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0C00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Telugu => _u0C00 ?? CreateRange(ref _u0C00, first: '\u0C00', last: '\u0C7F');
        private static UnicodeRange? _u0C00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Kannada' Unicode block (U+0C80..U+0CFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0C80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Kannada => _u0C80 ?? CreateRange(ref _u0C80, first: '\u0C80', last: '\u0CFF');
        private static UnicodeRange? _u0C80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Malayalam' Unicode block (U+0D00..U+0D7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0D00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Malayalam => _u0D00 ?? CreateRange(ref _u0D00, first: '\u0D00', last: '\u0D7F');
        private static UnicodeRange? _u0D00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Sinhala' Unicode block (U+0D80..U+0DFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0D80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Sinhala => _u0D80 ?? CreateRange(ref _u0D80, first: '\u0D80', last: '\u0DFF');
        private static UnicodeRange? _u0D80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Thai' Unicode block (U+0E00..U+0E7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0E00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Thai => _u0E00 ?? CreateRange(ref _u0E00, first: '\u0E00', last: '\u0E7F');
        private static UnicodeRange? _u0E00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Lao' Unicode block (U+0E80..U+0EFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0E80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Lao => _u0E80 ?? CreateRange(ref _u0E80, first: '\u0E80', last: '\u0EFF');
        private static UnicodeRange? _u0E80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tibetan' Unicode block (U+0F00..U+0FFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U0F00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Tibetan => _u0F00 ?? CreateRange(ref _u0F00, first: '\u0F00', last: '\u0FFF');
        private static UnicodeRange? _u0F00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Myanmar' Unicode block (U+1000..U+109F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1000.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Myanmar => _u1000 ?? CreateRange(ref _u1000, first: '\u1000', last: '\u109F');
        private static UnicodeRange? _u1000;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Georgian' Unicode block (U+10A0..U+10FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U10A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Georgian => _u10A0 ?? CreateRange(ref _u10A0, first: '\u10A0', last: '\u10FF');
        private static UnicodeRange? _u10A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hangul Jamo' Unicode block (U+1100..U+11FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1100.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange HangulJamo => _u1100 ?? CreateRange(ref _u1100, first: '\u1100', last: '\u11FF');
        private static UnicodeRange? _u1100;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ethiopic' Unicode block (U+1200..U+137F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1200.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Ethiopic => _u1200 ?? CreateRange(ref _u1200, first: '\u1200', last: '\u137F');
        private static UnicodeRange? _u1200;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ethiopic Supplement' Unicode block (U+1380..U+139F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1380.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange EthiopicSupplement => _u1380 ?? CreateRange(ref _u1380, first: '\u1380', last: '\u139F');
        private static UnicodeRange? _u1380;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cherokee' Unicode block (U+13A0..U+13FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U13A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Cherokee => _u13A0 ?? CreateRange(ref _u13A0, first: '\u13A0', last: '\u13FF');
        private static UnicodeRange? _u13A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Unified Canadian Aboriginal Syllabics' Unicode block (U+1400..U+167F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1400.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange UnifiedCanadianAboriginalSyllabics => _u1400 ?? CreateRange(ref _u1400, first: '\u1400', last: '\u167F');
        private static UnicodeRange? _u1400;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ogham' Unicode block (U+1680..U+169F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1680.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Ogham => _u1680 ?? CreateRange(ref _u1680, first: '\u1680', last: '\u169F');
        private static UnicodeRange? _u1680;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Runic' Unicode block (U+16A0..U+16FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U16A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Runic => _u16A0 ?? CreateRange(ref _u16A0, first: '\u16A0', last: '\u16FF');
        private static UnicodeRange? _u16A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tagalog' Unicode block (U+1700..U+171F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1700.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Tagalog => _u1700 ?? CreateRange(ref _u1700, first: '\u1700', last: '\u171F');
        private static UnicodeRange? _u1700;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hanunoo' Unicode block (U+1720..U+173F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1720.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Hanunoo => _u1720 ?? CreateRange(ref _u1720, first: '\u1720', last: '\u173F');
        private static UnicodeRange? _u1720;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Buhid' Unicode block (U+1740..U+175F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1740.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Buhid => _u1740 ?? CreateRange(ref _u1740, first: '\u1740', last: '\u175F');
        private static UnicodeRange? _u1740;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tagbanwa' Unicode block (U+1760..U+177F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1760.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Tagbanwa => _u1760 ?? CreateRange(ref _u1760, first: '\u1760', last: '\u177F');
        private static UnicodeRange? _u1760;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Khmer' Unicode block (U+1780..U+17FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1780.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Khmer => _u1780 ?? CreateRange(ref _u1780, first: '\u1780', last: '\u17FF');
        private static UnicodeRange? _u1780;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Mongolian' Unicode block (U+1800..U+18AF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1800.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Mongolian => _u1800 ?? CreateRange(ref _u1800, first: '\u1800', last: '\u18AF');
        private static UnicodeRange? _u1800;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Unified Canadian Aboriginal Syllabics Extended' Unicode block (U+18B0..U+18FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U18B0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange UnifiedCanadianAboriginalSyllabicsExtended => _u18B0 ?? CreateRange(ref _u18B0, first: '\u18B0', last: '\u18FF');
        private static UnicodeRange? _u18B0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Limbu' Unicode block (U+1900..U+194F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1900.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Limbu => _u1900 ?? CreateRange(ref _u1900, first: '\u1900', last: '\u194F');
        private static UnicodeRange? _u1900;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tai Le' Unicode block (U+1950..U+197F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1950.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange TaiLe => _u1950 ?? CreateRange(ref _u1950, first: '\u1950', last: '\u197F');
        private static UnicodeRange? _u1950;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'New Tai Lue' Unicode block (U+1980..U+19DF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1980.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange NewTaiLue => _u1980 ?? CreateRange(ref _u1980, first: '\u1980', last: '\u19DF');
        private static UnicodeRange? _u1980;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Khmer Symbols' Unicode block (U+19E0..U+19FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U19E0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange KhmerSymbols => _u19E0 ?? CreateRange(ref _u19E0, first: '\u19E0', last: '\u19FF');
        private static UnicodeRange? _u19E0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Buginese' Unicode block (U+1A00..U+1A1F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1A00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Buginese => _u1A00 ?? CreateRange(ref _u1A00, first: '\u1A00', last: '\u1A1F');
        private static UnicodeRange? _u1A00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tai Tham' Unicode block (U+1A20..U+1AAF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1A20.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange TaiTham => _u1A20 ?? CreateRange(ref _u1A20, first: '\u1A20', last: '\u1AAF');
        private static UnicodeRange? _u1A20;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Combining Diacritical Marks Extended' Unicode block (U+1AB0..U+1AFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1AB0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CombiningDiacriticalMarksExtended => _u1AB0 ?? CreateRange(ref _u1AB0, first: '\u1AB0', last: '\u1AFF');
        private static UnicodeRange? _u1AB0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Balinese' Unicode block (U+1B00..U+1B7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1B00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Balinese => _u1B00 ?? CreateRange(ref _u1B00, first: '\u1B00', last: '\u1B7F');
        private static UnicodeRange? _u1B00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Sundanese' Unicode block (U+1B80..U+1BBF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1B80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Sundanese => _u1B80 ?? CreateRange(ref _u1B80, first: '\u1B80', last: '\u1BBF');
        private static UnicodeRange? _u1B80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Batak' Unicode block (U+1BC0..U+1BFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1BC0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Batak => _u1BC0 ?? CreateRange(ref _u1BC0, first: '\u1BC0', last: '\u1BFF');
        private static UnicodeRange? _u1BC0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Lepcha' Unicode block (U+1C00..U+1C4F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1C00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Lepcha => _u1C00 ?? CreateRange(ref _u1C00, first: '\u1C00', last: '\u1C4F');
        private static UnicodeRange? _u1C00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ol Chiki' Unicode block (U+1C50..U+1C7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1C50.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange OlChiki => _u1C50 ?? CreateRange(ref _u1C50, first: '\u1C50', last: '\u1C7F');
        private static UnicodeRange? _u1C50;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cyrillic Extended-C' Unicode block (U+1C80..U+1C8F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1C80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CyrillicExtendedC => _u1C80 ?? CreateRange(ref _u1C80, first: '\u1C80', last: '\u1C8F');
        private static UnicodeRange? _u1C80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Georgian Extended' Unicode block (U+1C90..U+1CBF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1C90.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange GeorgianExtended => _u1C90 ?? CreateRange(ref _u1C90, first: '\u1C90', last: '\u1CBF');
        private static UnicodeRange? _u1C90;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Sundanese Supplement' Unicode block (U+1CC0..U+1CCF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1CC0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SundaneseSupplement => _u1CC0 ?? CreateRange(ref _u1CC0, first: '\u1CC0', last: '\u1CCF');
        private static UnicodeRange? _u1CC0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Vedic Extensions' Unicode block (U+1CD0..U+1CFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1CD0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange VedicExtensions => _u1CD0 ?? CreateRange(ref _u1CD0, first: '\u1CD0', last: '\u1CFF');
        private static UnicodeRange? _u1CD0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Phonetic Extensions' Unicode block (U+1D00..U+1D7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1D00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange PhoneticExtensions => _u1D00 ?? CreateRange(ref _u1D00, first: '\u1D00', last: '\u1D7F');
        private static UnicodeRange? _u1D00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Phonetic Extensions Supplement' Unicode block (U+1D80..U+1DBF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1D80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange PhoneticExtensionsSupplement => _u1D80 ?? CreateRange(ref _u1D80, first: '\u1D80', last: '\u1DBF');
        private static UnicodeRange? _u1D80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Combining Diacritical Marks Supplement' Unicode block (U+1DC0..U+1DFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1DC0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CombiningDiacriticalMarksSupplement => _u1DC0 ?? CreateRange(ref _u1DC0, first: '\u1DC0', last: '\u1DFF');
        private static UnicodeRange? _u1DC0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin Extended Additional' Unicode block (U+1E00..U+1EFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1E00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LatinExtendedAdditional => _u1E00 ?? CreateRange(ref _u1E00, first: '\u1E00', last: '\u1EFF');
        private static UnicodeRange? _u1E00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Greek Extended' Unicode block (U+1F00..U+1FFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U1F00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange GreekExtended => _u1F00 ?? CreateRange(ref _u1F00, first: '\u1F00', last: '\u1FFF');
        private static UnicodeRange? _u1F00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'General Punctuation' Unicode block (U+2000..U+206F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2000.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange GeneralPunctuation => _u2000 ?? CreateRange(ref _u2000, first: '\u2000', last: '\u206F');
        private static UnicodeRange? _u2000;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Superscripts and Subscripts' Unicode block (U+2070..U+209F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2070.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SuperscriptsandSubscripts => _u2070 ?? CreateRange(ref _u2070, first: '\u2070', last: '\u209F');
        private static UnicodeRange? _u2070;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Currency Symbols' Unicode block (U+20A0..U+20CF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U20A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CurrencySymbols => _u20A0 ?? CreateRange(ref _u20A0, first: '\u20A0', last: '\u20CF');
        private static UnicodeRange? _u20A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Combining Diacritical Marks for Symbols' Unicode block (U+20D0..U+20FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U20D0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CombiningDiacriticalMarksforSymbols => _u20D0 ?? CreateRange(ref _u20D0, first: '\u20D0', last: '\u20FF');
        private static UnicodeRange? _u20D0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Letterlike Symbols' Unicode block (U+2100..U+214F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2100.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LetterlikeSymbols => _u2100 ?? CreateRange(ref _u2100, first: '\u2100', last: '\u214F');
        private static UnicodeRange? _u2100;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Number Forms' Unicode block (U+2150..U+218F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2150.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange NumberForms => _u2150 ?? CreateRange(ref _u2150, first: '\u2150', last: '\u218F');
        private static UnicodeRange? _u2150;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arrows' Unicode block (U+2190..U+21FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2190.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Arrows => _u2190 ?? CreateRange(ref _u2190, first: '\u2190', last: '\u21FF');
        private static UnicodeRange? _u2190;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Mathematical Operators' Unicode block (U+2200..U+22FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2200.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MathematicalOperators => _u2200 ?? CreateRange(ref _u2200, first: '\u2200', last: '\u22FF');
        private static UnicodeRange? _u2200;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Miscellaneous Technical' Unicode block (U+2300..U+23FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2300.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MiscellaneousTechnical => _u2300 ?? CreateRange(ref _u2300, first: '\u2300', last: '\u23FF');
        private static UnicodeRange? _u2300;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Control Pictures' Unicode block (U+2400..U+243F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2400.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ControlPictures => _u2400 ?? CreateRange(ref _u2400, first: '\u2400', last: '\u243F');
        private static UnicodeRange? _u2400;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Optical Character Recognition' Unicode block (U+2440..U+245F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2440.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange OpticalCharacterRecognition => _u2440 ?? CreateRange(ref _u2440, first: '\u2440', last: '\u245F');
        private static UnicodeRange? _u2440;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Enclosed Alphanumerics' Unicode block (U+2460..U+24FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2460.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange EnclosedAlphanumerics => _u2460 ?? CreateRange(ref _u2460, first: '\u2460', last: '\u24FF');
        private static UnicodeRange? _u2460;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Box Drawing' Unicode block (U+2500..U+257F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2500.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange BoxDrawing => _u2500 ?? CreateRange(ref _u2500, first: '\u2500', last: '\u257F');
        private static UnicodeRange? _u2500;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Block Elements' Unicode block (U+2580..U+259F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2580.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange BlockElements => _u2580 ?? CreateRange(ref _u2580, first: '\u2580', last: '\u259F');
        private static UnicodeRange? _u2580;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Geometric Shapes' Unicode block (U+25A0..U+25FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U25A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange GeometricShapes => _u25A0 ?? CreateRange(ref _u25A0, first: '\u25A0', last: '\u25FF');
        private static UnicodeRange? _u25A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Miscellaneous Symbols' Unicode block (U+2600..U+26FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2600.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MiscellaneousSymbols => _u2600 ?? CreateRange(ref _u2600, first: '\u2600', last: '\u26FF');
        private static UnicodeRange? _u2600;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Dingbats' Unicode block (U+2700..U+27BF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2700.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Dingbats => _u2700 ?? CreateRange(ref _u2700, first: '\u2700', last: '\u27BF');
        private static UnicodeRange? _u2700;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Miscellaneous Mathematical Symbols-A' Unicode block (U+27C0..U+27EF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U27C0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MiscellaneousMathematicalSymbolsA => _u27C0 ?? CreateRange(ref _u27C0, first: '\u27C0', last: '\u27EF');
        private static UnicodeRange? _u27C0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Supplemental Arrows-A' Unicode block (U+27F0..U+27FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U27F0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SupplementalArrowsA => _u27F0 ?? CreateRange(ref _u27F0, first: '\u27F0', last: '\u27FF');
        private static UnicodeRange? _u27F0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Braille Patterns' Unicode block (U+2800..U+28FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2800.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange BraillePatterns => _u2800 ?? CreateRange(ref _u2800, first: '\u2800', last: '\u28FF');
        private static UnicodeRange? _u2800;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Supplemental Arrows-B' Unicode block (U+2900..U+297F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2900.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SupplementalArrowsB => _u2900 ?? CreateRange(ref _u2900, first: '\u2900', last: '\u297F');
        private static UnicodeRange? _u2900;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Miscellaneous Mathematical Symbols-B' Unicode block (U+2980..U+29FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2980.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MiscellaneousMathematicalSymbolsB => _u2980 ?? CreateRange(ref _u2980, first: '\u2980', last: '\u29FF');
        private static UnicodeRange? _u2980;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Supplemental Mathematical Operators' Unicode block (U+2A00..U+2AFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2A00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SupplementalMathematicalOperators => _u2A00 ?? CreateRange(ref _u2A00, first: '\u2A00', last: '\u2AFF');
        private static UnicodeRange? _u2A00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Miscellaneous Symbols and Arrows' Unicode block (U+2B00..U+2BFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2B00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MiscellaneousSymbolsandArrows => _u2B00 ?? CreateRange(ref _u2B00, first: '\u2B00', last: '\u2BFF');
        private static UnicodeRange? _u2B00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Glagolitic' Unicode block (U+2C00..U+2C5F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2C00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Glagolitic => _u2C00 ?? CreateRange(ref _u2C00, first: '\u2C00', last: '\u2C5F');
        private static UnicodeRange? _u2C00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin Extended-C' Unicode block (U+2C60..U+2C7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2C60.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LatinExtendedC => _u2C60 ?? CreateRange(ref _u2C60, first: '\u2C60', last: '\u2C7F');
        private static UnicodeRange? _u2C60;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Coptic' Unicode block (U+2C80..U+2CFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2C80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Coptic => _u2C80 ?? CreateRange(ref _u2C80, first: '\u2C80', last: '\u2CFF');
        private static UnicodeRange? _u2C80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Georgian Supplement' Unicode block (U+2D00..U+2D2F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2D00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange GeorgianSupplement => _u2D00 ?? CreateRange(ref _u2D00, first: '\u2D00', last: '\u2D2F');
        private static UnicodeRange? _u2D00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tifinagh' Unicode block (U+2D30..U+2D7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2D30.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Tifinagh => _u2D30 ?? CreateRange(ref _u2D30, first: '\u2D30', last: '\u2D7F');
        private static UnicodeRange? _u2D30;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ethiopic Extended' Unicode block (U+2D80..U+2DDF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2D80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange EthiopicExtended => _u2D80 ?? CreateRange(ref _u2D80, first: '\u2D80', last: '\u2DDF');
        private static UnicodeRange? _u2D80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cyrillic Extended-A' Unicode block (U+2DE0..U+2DFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2DE0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CyrillicExtendedA => _u2DE0 ?? CreateRange(ref _u2DE0, first: '\u2DE0', last: '\u2DFF');
        private static UnicodeRange? _u2DE0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Supplemental Punctuation' Unicode block (U+2E00..U+2E7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2E00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SupplementalPunctuation => _u2E00 ?? CreateRange(ref _u2E00, first: '\u2E00', last: '\u2E7F');
        private static UnicodeRange? _u2E00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Radicals Supplement' Unicode block (U+2E80..U+2EFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2E80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkRadicalsSupplement => _u2E80 ?? CreateRange(ref _u2E80, first: '\u2E80', last: '\u2EFF');
        private static UnicodeRange? _u2E80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Kangxi Radicals' Unicode block (U+2F00..U+2FDF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2F00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange KangxiRadicals => _u2F00 ?? CreateRange(ref _u2F00, first: '\u2F00', last: '\u2FDF');
        private static UnicodeRange? _u2F00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ideographic Description Characters' Unicode block (U+2FF0..U+2FFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U2FF0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange IdeographicDescriptionCharacters => _u2FF0 ?? CreateRange(ref _u2FF0, first: '\u2FF0', last: '\u2FFF');
        private static UnicodeRange? _u2FF0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Symbols and Punctuation' Unicode block (U+3000..U+303F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3000.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkSymbolsandPunctuation => _u3000 ?? CreateRange(ref _u3000, first: '\u3000', last: '\u303F');
        private static UnicodeRange? _u3000;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hiragana' Unicode block (U+3040..U+309F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3040.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Hiragana => _u3040 ?? CreateRange(ref _u3040, first: '\u3040', last: '\u309F');
        private static UnicodeRange? _u3040;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Katakana' Unicode block (U+30A0..U+30FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U30A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Katakana => _u30A0 ?? CreateRange(ref _u30A0, first: '\u30A0', last: '\u30FF');
        private static UnicodeRange? _u30A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Bopomofo' Unicode block (U+3100..U+312F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3100.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Bopomofo => _u3100 ?? CreateRange(ref _u3100, first: '\u3100', last: '\u312F');
        private static UnicodeRange? _u3100;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hangul Compatibility Jamo' Unicode block (U+3130..U+318F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3130.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange HangulCompatibilityJamo => _u3130 ?? CreateRange(ref _u3130, first: '\u3130', last: '\u318F');
        private static UnicodeRange? _u3130;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Kanbun' Unicode block (U+3190..U+319F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3190.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Kanbun => _u3190 ?? CreateRange(ref _u3190, first: '\u3190', last: '\u319F');
        private static UnicodeRange? _u3190;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Bopomofo Extended' Unicode block (U+31A0..U+31BF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U31A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange BopomofoExtended => _u31A0 ?? CreateRange(ref _u31A0, first: '\u31A0', last: '\u31BF');
        private static UnicodeRange? _u31A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Strokes' Unicode block (U+31C0..U+31EF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U31C0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkStrokes => _u31C0 ?? CreateRange(ref _u31C0, first: '\u31C0', last: '\u31EF');
        private static UnicodeRange? _u31C0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Katakana Phonetic Extensions' Unicode block (U+31F0..U+31FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U31F0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange KatakanaPhoneticExtensions => _u31F0 ?? CreateRange(ref _u31F0, first: '\u31F0', last: '\u31FF');
        private static UnicodeRange? _u31F0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Enclosed CJK Letters and Months' Unicode block (U+3200..U+32FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3200.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange EnclosedCjkLettersandMonths => _u3200 ?? CreateRange(ref _u3200, first: '\u3200', last: '\u32FF');
        private static UnicodeRange? _u3200;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Compatibility' Unicode block (U+3300..U+33FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3300.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkCompatibility => _u3300 ?? CreateRange(ref _u3300, first: '\u3300', last: '\u33FF');
        private static UnicodeRange? _u3300;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Unified Ideographs Extension A' Unicode block (U+3400..U+4DBF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U3400.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkUnifiedIdeographsExtensionA => _u3400 ?? CreateRange(ref _u3400, first: '\u3400', last: '\u4DBF');
        private static UnicodeRange? _u3400;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Yijing Hexagram Symbols' Unicode block (U+4DC0..U+4DFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U4DC0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange YijingHexagramSymbols => _u4DC0 ?? CreateRange(ref _u4DC0, first: '\u4DC0', last: '\u4DFF');
        private static UnicodeRange? _u4DC0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Unified Ideographs' Unicode block (U+4E00..U+9FFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/U4E00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkUnifiedIdeographs => _u4E00 ?? CreateRange(ref _u4E00, first: '\u4E00', last: '\u9FFF');
        private static UnicodeRange? _u4E00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Yi Syllables' Unicode block (U+A000..U+A48F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA000.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange YiSyllables => _uA000 ?? CreateRange(ref _uA000, first: '\uA000', last: '\uA48F');
        private static UnicodeRange? _uA000;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Yi Radicals' Unicode block (U+A490..U+A4CF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA490.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange YiRadicals => _uA490 ?? CreateRange(ref _uA490, first: '\uA490', last: '\uA4CF');
        private static UnicodeRange? _uA490;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Lisu' Unicode block (U+A4D0..U+A4FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA4D0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Lisu => _uA4D0 ?? CreateRange(ref _uA4D0, first: '\uA4D0', last: '\uA4FF');
        private static UnicodeRange? _uA4D0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Vai' Unicode block (U+A500..U+A63F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA500.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Vai => _uA500 ?? CreateRange(ref _uA500, first: '\uA500', last: '\uA63F');
        private static UnicodeRange? _uA500;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cyrillic Extended-B' Unicode block (U+A640..U+A69F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA640.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CyrillicExtendedB => _uA640 ?? CreateRange(ref _uA640, first: '\uA640', last: '\uA69F');
        private static UnicodeRange? _uA640;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Bamum' Unicode block (U+A6A0..U+A6FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA6A0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Bamum => _uA6A0 ?? CreateRange(ref _uA6A0, first: '\uA6A0', last: '\uA6FF');
        private static UnicodeRange? _uA6A0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Modifier Tone Letters' Unicode block (U+A700..U+A71F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA700.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ModifierToneLetters => _uA700 ?? CreateRange(ref _uA700, first: '\uA700', last: '\uA71F');
        private static UnicodeRange? _uA700;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin Extended-D' Unicode block (U+A720..U+A7FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA720.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LatinExtendedD => _uA720 ?? CreateRange(ref _uA720, first: '\uA720', last: '\uA7FF');
        private static UnicodeRange? _uA720;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Syloti Nagri' Unicode block (U+A800..U+A82F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA800.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SylotiNagri => _uA800 ?? CreateRange(ref _uA800, first: '\uA800', last: '\uA82F');
        private static UnicodeRange? _uA800;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Common Indic Number Forms' Unicode block (U+A830..U+A83F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA830.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CommonIndicNumberForms => _uA830 ?? CreateRange(ref _uA830, first: '\uA830', last: '\uA83F');
        private static UnicodeRange? _uA830;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Phags-pa' Unicode block (U+A840..U+A87F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA840.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Phagspa => _uA840 ?? CreateRange(ref _uA840, first: '\uA840', last: '\uA87F');
        private static UnicodeRange? _uA840;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Saurashtra' Unicode block (U+A880..U+A8DF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA880.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Saurashtra => _uA880 ?? CreateRange(ref _uA880, first: '\uA880', last: '\uA8DF');
        private static UnicodeRange? _uA880;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Devanagari Extended' Unicode block (U+A8E0..U+A8FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA8E0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange DevanagariExtended => _uA8E0 ?? CreateRange(ref _uA8E0, first: '\uA8E0', last: '\uA8FF');
        private static UnicodeRange? _uA8E0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Kayah Li' Unicode block (U+A900..U+A92F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA900.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange KayahLi => _uA900 ?? CreateRange(ref _uA900, first: '\uA900', last: '\uA92F');
        private static UnicodeRange? _uA900;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Rejang' Unicode block (U+A930..U+A95F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA930.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Rejang => _uA930 ?? CreateRange(ref _uA930, first: '\uA930', last: '\uA95F');
        private static UnicodeRange? _uA930;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hangul Jamo Extended-A' Unicode block (U+A960..U+A97F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA960.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange HangulJamoExtendedA => _uA960 ?? CreateRange(ref _uA960, first: '\uA960', last: '\uA97F');
        private static UnicodeRange? _uA960;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Javanese' Unicode block (U+A980..U+A9DF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA980.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Javanese => _uA980 ?? CreateRange(ref _uA980, first: '\uA980', last: '\uA9DF');
        private static UnicodeRange? _uA980;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Myanmar Extended-B' Unicode block (U+A9E0..U+A9FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UA9E0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MyanmarExtendedB => _uA9E0 ?? CreateRange(ref _uA9E0, first: '\uA9E0', last: '\uA9FF');
        private static UnicodeRange? _uA9E0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cham' Unicode block (U+AA00..U+AA5F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAA00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Cham => _uAA00 ?? CreateRange(ref _uAA00, first: '\uAA00', last: '\uAA5F');
        private static UnicodeRange? _uAA00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Myanmar Extended-A' Unicode block (U+AA60..U+AA7F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAA60.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MyanmarExtendedA => _uAA60 ?? CreateRange(ref _uAA60, first: '\uAA60', last: '\uAA7F');
        private static UnicodeRange? _uAA60;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Tai Viet' Unicode block (U+AA80..U+AADF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAA80.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange TaiViet => _uAA80 ?? CreateRange(ref _uAA80, first: '\uAA80', last: '\uAADF');
        private static UnicodeRange? _uAA80;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Meetei Mayek Extensions' Unicode block (U+AAE0..U+AAFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAAE0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MeeteiMayekExtensions => _uAAE0 ?? CreateRange(ref _uAAE0, first: '\uAAE0', last: '\uAAFF');
        private static UnicodeRange? _uAAE0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Ethiopic Extended-A' Unicode block (U+AB00..U+AB2F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAB00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange EthiopicExtendedA => _uAB00 ?? CreateRange(ref _uAB00, first: '\uAB00', last: '\uAB2F');
        private static UnicodeRange? _uAB00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Latin Extended-E' Unicode block (U+AB30..U+AB6F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAB30.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange LatinExtendedE => _uAB30 ?? CreateRange(ref _uAB30, first: '\uAB30', last: '\uAB6F');
        private static UnicodeRange? _uAB30;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Cherokee Supplement' Unicode block (U+AB70..U+ABBF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAB70.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CherokeeSupplement => _uAB70 ?? CreateRange(ref _uAB70, first: '\uAB70', last: '\uABBF');
        private static UnicodeRange? _uAB70;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Meetei Mayek' Unicode block (U+ABC0..U+ABFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UABC0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange MeeteiMayek => _uABC0 ?? CreateRange(ref _uABC0, first: '\uABC0', last: '\uABFF');
        private static UnicodeRange? _uABC0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hangul Syllables' Unicode block (U+AC00..U+D7AF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UAC00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange HangulSyllables => _uAC00 ?? CreateRange(ref _uAC00, first: '\uAC00', last: '\uD7AF');
        private static UnicodeRange? _uAC00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Hangul Jamo Extended-B' Unicode block (U+D7B0..U+D7FF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UD7B0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange HangulJamoExtendedB => _uD7B0 ?? CreateRange(ref _uD7B0, first: '\uD7B0', last: '\uD7FF');
        private static UnicodeRange? _uD7B0;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Compatibility Ideographs' Unicode block (U+F900..U+FAFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UF900.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkCompatibilityIdeographs => _uF900 ?? CreateRange(ref _uF900, first: '\uF900', last: '\uFAFF');
        private static UnicodeRange? _uF900;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Alphabetic Presentation Forms' Unicode block (U+FB00..U+FB4F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFB00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange AlphabeticPresentationForms => _uFB00 ?? CreateRange(ref _uFB00, first: '\uFB00', last: '\uFB4F');
        private static UnicodeRange? _uFB00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arabic Presentation Forms-A' Unicode block (U+FB50..U+FDFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFB50.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ArabicPresentationFormsA => _uFB50 ?? CreateRange(ref _uFB50, first: '\uFB50', last: '\uFDFF');
        private static UnicodeRange? _uFB50;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Variation Selectors' Unicode block (U+FE00..U+FE0F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFE00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange VariationSelectors => _uFE00 ?? CreateRange(ref _uFE00, first: '\uFE00', last: '\uFE0F');
        private static UnicodeRange? _uFE00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Vertical Forms' Unicode block (U+FE10..U+FE1F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFE10.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange VerticalForms => _uFE10 ?? CreateRange(ref _uFE10, first: '\uFE10', last: '\uFE1F');
        private static UnicodeRange? _uFE10;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Combining Half Marks' Unicode block (U+FE20..U+FE2F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFE20.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CombiningHalfMarks => _uFE20 ?? CreateRange(ref _uFE20, first: '\uFE20', last: '\uFE2F');
        private static UnicodeRange? _uFE20;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'CJK Compatibility Forms' Unicode block (U+FE30..U+FE4F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFE30.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange CjkCompatibilityForms => _uFE30 ?? CreateRange(ref _uFE30, first: '\uFE30', last: '\uFE4F');
        private static UnicodeRange? _uFE30;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Small Form Variants' Unicode block (U+FE50..U+FE6F).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFE50.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange SmallFormVariants => _uFE50 ?? CreateRange(ref _uFE50, first: '\uFE50', last: '\uFE6F');
        private static UnicodeRange? _uFE50;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Arabic Presentation Forms-B' Unicode block (U+FE70..U+FEFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFE70.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange ArabicPresentationFormsB => _uFE70 ?? CreateRange(ref _uFE70, first: '\uFE70', last: '\uFEFF');
        private static UnicodeRange? _uFE70;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Halfwidth and Fullwidth Forms' Unicode block (U+FF00..U+FFEF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFF00.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange HalfwidthandFullwidthForms => _uFF00 ?? CreateRange(ref _uFF00, first: '\uFF00', last: '\uFFEF');
        private static UnicodeRange? _uFF00;

        /// <summary>
        /// A <see cref="UnicodeRange"/> corresponding to the 'Specials' Unicode block (U+FFF0..U+FFFF).
        /// </summary>
        /// <remarks>
        /// See https://www.unicode.org/charts/PDF/UFFF0.pdf for the full set of characters in this block.
        /// </remarks>
        public static UnicodeRange Specials => _uFFF0 ?? CreateRange(ref _uFFF0, first: '\uFFF0', last: '\uFFFF');
        private static UnicodeRange? _uFFF0;
    }
}
