; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=amdgcn-amd-amdhsa -instcombine -S | FileCheck %s

; Simplify to +0.0 + z.
define float @test_zero(float %x, float %z) {
; CHECK-LABEL: @test_zero(
; CHECK-NEXT:    [[CALL:%.*]] = fadd float [[Z:%.*]], 0.000000e+00
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.amdgcn.fma.legacy(float %x, float 0.0, float %z)
  ret float %call
}

; Simplify to +0.0 + z, preserving fmf.
define float @test_zero_fmf(float %x, float %z) {
; CHECK-LABEL: @test_zero_fmf(
; CHECK-NEXT:    [[CALL:%.*]] = fadd contract float [[Z:%.*]], 0.000000e+00
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call contract float @llvm.amdgcn.fma.legacy(float %x, float 0.0, float %z)
  ret float %call
}

; Simplify to z.
define float @test_zero_nsz(float %x, float %z) {
; CHECK-LABEL: @test_zero_nsz(
; CHECK-NEXT:    ret float [[Z:%.*]]
;
  %call = call nsz float @llvm.amdgcn.fma.legacy(float %x, float 0.0, float %z)
  ret float %call
}

; Simplify to +0.0 + z.
define float @test_negzero(float %y, float %z) {
; CHECK-LABEL: @test_negzero(
; CHECK-NEXT:    [[CALL:%.*]] = fadd float [[Z:%.*]], 0.000000e+00
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.amdgcn.fma.legacy(float -0.0, float %y, float %z)
  ret float %call
}

; Simplify to z.
define float @test_negzero_nsz(float %y, float %z) {
; CHECK-LABEL: @test_negzero_nsz(
; CHECK-NEXT:    ret float [[Z:%.*]]
;
  %call = call nsz float @llvm.amdgcn.fma.legacy(float -0.0, float %y, float %z)
  ret float %call
}

; Combine to fma because the constant is finite and non-zero.
define float @test_const(float %x, float %z) {
; CHECK-LABEL: @test_const(
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.fma.f32(float [[X:%.*]], float 9.950000e+01, float [[Z:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.amdgcn.fma.legacy(float %x, float 99.5, float %z)
  ret float %call
}

; Combine to fma because the constant is finite and non-zero, preserving fmf.
define float @test_const_fmf(float %x, float %z) {
; CHECK-LABEL: @test_const_fmf(
; CHECK-NEXT:    [[CALL:%.*]] = call contract float @llvm.fma.f32(float [[X:%.*]], float 9.950000e+01, float [[Z:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call contract float @llvm.amdgcn.fma.legacy(float %x, float 99.5, float %z)
  ret float %call
}

; Combine to fma because neither argument can be infinity or NaN.
define float @test_finite(i32 %x, i32 %y, float %z) {
; CHECK-LABEL: @test_finite(
; CHECK-NEXT:    [[XF:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[YF:%.*]] = sitofp i32 [[Y:%.*]] to float
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.fma.f32(float [[XF]], float [[YF]], float [[Z:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %xf = sitofp i32 %x to float
  %yf = sitofp i32 %y to float
  %call = call float @llvm.amdgcn.fma.legacy(float %xf, float %yf, float %z)
  ret float %call
}

declare float @llvm.amdgcn.fma.legacy(float, float, float)
