/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.hashmap;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMap;
import com.github.andrewoma.dexx.collection.internal.hashmap.HashMapCollision1;
import com.github.andrewoma.dexx.collection.internal.hashmap.ListMap;
import java.util.Collections;
import java.util.Iterator;

class HashMap1<K, V>
extends CompactHashMap<K, V> {
    protected final K key;
    protected final int hash;
    protected final V value;
    protected Pair<K, V> kv;

    HashMap1(K key, int hash, V value, Pair<K, V> kv) {
        this.key = key;
        this.hash = hash;
        this.value = value;
        this.kv = kv;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    protected V get0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        return hash == this.hash && key.equals(this.key) ? (V)this.value : null;
    }

    @Override
    protected CompactHashMap<K, V> updated0(K key, int hash, int level, V value, Pair<K, V> kv, KeyFunction<K, V> keyFunction) {
        if (hash == this.hash && key.equals(this.key)) {
            return new HashMap1<K, V>(key, hash, value, kv);
        }
        if (hash != this.hash) {
            HashMap1<K, V> that = new HashMap1<K, V>(key, hash, value, kv);
            return HashMap1.makeHashTrieMap(this.hash, this, hash, that, level, 2);
        }
        return new HashMapCollision1(hash, ((ListMap)ListMap.empty().put((Object)this.key, (Object)this.value)).put((Object)key, (Object)value));
    }

    @Override
    protected CompactHashMap<K, V> removed0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        return hash == this.hash && key.equals(this.key) ? CompactHashMap.empty() : this;
    }

    @Override
    public <U> void forEach(Function<Pair<K, V>, U> f, KeyFunction<K, V> keyFunction) {
        f.invoke(new Pair<K, V>(this.key, this.value));
    }

    private Pair<K, V> ensureKv() {
        if (this.kv == null) {
            this.kv = new Pair<K, V>(this.key, this.value);
        }
        return this.kv;
    }

    @Override
    public Iterator<Pair<K, V>> iterator(KeyFunction<K, V> kf) {
        return Collections.singleton(this.ensureKv()).iterator();
    }
}

