/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.InputStream;
import java.io.Reader;
import org.odftoolkit.odfvalidator.InternalResources;
import org.odftoolkit.odfvalidator.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class SchemaResourceResolver
implements LSResourceResolver {
    private String m_aBaseURI = null;
    private Logger m_aLogger = null;
    private DOMImplementationLS m_aDOMImplLS = null;
    private boolean m_bGetDOMImplLSFailed = false;

    public SchemaResourceResolver(Logger aLogger, String aBaseURI) {
        this.m_aBaseURI = aBaseURI;
        this.m_aLogger = aLogger;
    }

    @Override
    public LSInput resolveResource(String aType, String aNamespaceURI, String aPublicId, String aSystemId, String aBaseURI) {
        LSInput aInput = null;
        if (aBaseURI == null) {
            aBaseURI = this.m_aBaseURI;
        }
        if (aSystemId != null && aBaseURI != null && InternalResources.isInternalResourceIdentifer(aBaseURI)) {
            String aURI = aBaseURI.substring(0, aBaseURI.lastIndexOf(47) + 1).concat(aSystemId);
            String aPath = InternalResources.getResourcePath(aURI);
            InputStream aInStream = this.getClass().getResourceAsStream(aPath);
            if (aInStream != null) {
                aInput = this.createLSInput();
                aInput.setSystemId(aURI);
                aInput.setByteStream(aInStream);
                String aMsg = "resolving '" + aURI + "'";
                this.m_aLogger.logInfo(aMsg, false);
            } else {
                this.m_aLogger.logFatalError("Missing internal schema file: ".concat(aPath));
            }
        }
        return aInput;
    }

    private LSInput createLSInput() {
        LSInput aLSInput = null;
        if (this.m_aDOMImplLS == null && !this.m_bGetDOMImplLSFailed) {
            DOMImplementationRegistry aDOMReg = null;
            try {
                aDOMReg = DOMImplementationRegistry.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.m_aLogger.logFatalError(e.getMessage());
            }
            catch (InstantiationException e) {
                this.m_aLogger.logFatalError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.m_aLogger.logFatalError(e.getMessage());
            }
            DOMImplementation aDOMImpl = aDOMReg.getDOMImplementation("LS 3.0");
            if (aDOMImpl != null) {
                this.m_aDOMImplLS = (DOMImplementationLS)((Object)aDOMImpl);
            } else {
                this.m_bGetDOMImplLSFailed = true;
                this.m_aLogger.logInfo("Could not find DOM LS 3.0 Implementation, using own implementation", false);
            }
        }
        aLSInput = this.m_aDOMImplLS != null ? this.m_aDOMImplLS.createLSInput() : new LSInputImpl();
        return aLSInput;
    }

    class LSInputImpl
    implements LSInput {
        private InputStream m_aInputStream = null;
        private String m_aSystemId = null;

        LSInputImpl() {
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader aCharacterStream) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public InputStream getByteStream() {
            return this.m_aInputStream;
        }

        @Override
        public void setByteStream(InputStream aByteStream) {
            this.m_aInputStream = aByteStream;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getSystemId() {
            return this.m_aSystemId;
        }

        @Override
        public void setSystemId(String aSystemId) {
            this.m_aSystemId = aSystemId;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

