/*
 * Decompiled with CFR 0.152.
 */
package org.xmlopen.zipspy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xmlopen.zipspy.Utils;
import org.xmlopen.zipspy.ZipHeaderBase;

public class ZipLocalHeader
extends ZipHeaderBase {
    static Logger logger = Logger.getLogger(ZipLocalHeader.class);
    static final short DATA_DESCRIPTOR_MASK = 8;

    public ZipLocalHeader(InputStream is) {
        try {
            is.read(this.extractVersion);
            this.general = Utils.readShortLittle(is);
            is.read(this.method);
            is.read(this.modTime);
            is.read(this.modDate);
            this.crc32 = Utils.readIntLittle(is);
            this.compressedSize = Utils.readIntLittle(is);
            this.uncompressedSize = Utils.readIntLittle(is);
            this.filenameLength = Utils.readShortLittle(is);
            this.extraFieldLength = Utils.readShortLittle(is);
            byte[] b = new byte[this.filenameLength];
            is.read(b);
            this.filename = new String(b);
            is.skip(this.extraFieldLength);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String asXmlString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<local-header>");
        sb.append(Utils.makeElement("filename", this.filename));
        sb.append(Utils.makeByteElement("version-needed-to-extract", this.extractVersion));
        sb.append(Utils.makeElement("general-flag", this.general));
        sb.append(Utils.makeByteElement("compression-method", this.method));
        sb.append(Utils.makeByteElement("mod-time", this.extractVersion));
        sb.append(Utils.makeByteElement("mod-date", this.extractVersion));
        sb.append(Utils.makeElement("crc-32", this.crc32));
        sb.append(Utils.makeElement("compressed-size", this.compressedSize));
        sb.append(Utils.makeElement("uncompressed-size", this.uncompressedSize));
        sb.append(Utils.makeElement("filename-length", this.filenameLength));
        sb.append(Utils.makeElement("extra-field-length", this.extraFieldLength));
        sb.append("</local-header>");
        return sb.toString();
    }
}

