/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.verifier.jaxp.validation;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.iso_relax.verifier.jaxp.validation.EntityResolverImpl;
import org.iso_relax.verifier.jaxp.validation.SchemaImpl;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SchemaFactoryImpl
extends SchemaFactory {
    private final VerifierFactory core = VerifierFactory.newInstance("http://relaxng.org/ns/structure/1.0");
    private ErrorHandler errorHandler;
    private LSResourceResolver resourceResolver;

    SchemaFactoryImpl() throws VerifierConfigurationException {
    }

    protected abstract String getLanguageName();

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.core.setEntityResolver(new EntityResolverImpl(resourceResolver));
        this.resourceResolver = resourceResolver;
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @Override
    public javax.xml.validation.Schema newSchema(Source[] schemas) throws SAXException {
        if (schemas.length != 1) {
            throw new UnsupportedOperationException();
        }
        try {
            return new SchemaImpl(this.compileSchema(schemas[0]));
        }
        catch (IOException e) {
            throw this.reportError(e);
        }
        catch (VerifierConfigurationException e) {
            throw this.reportError(e);
        }
        catch (TransformerException e) {
            throw this.reportError(e);
        }
    }

    private SAXException reportError(Exception e) throws SAXException {
        SAXParseException spe = new SAXParseException(e.getMessage(), null, null, -1, -1, e);
        if (this.errorHandler != null) {
            this.errorHandler.error(spe);
        }
        return spe;
    }

    private Schema compileSchema(Source s) throws IOException, VerifierConfigurationException, SAXException, TransformerException {
        if (s instanceof StreamSource) {
            StreamSource ss = (StreamSource)s;
            InputSource is = new InputSource();
            is.setByteStream(ss.getInputStream());
            is.setCharacterStream(ss.getReader());
            is.setSystemId(ss.getSystemId());
            is.setPublicId(ss.getPublicId());
            return this.core.compileSchema(is);
        }
        StringWriter w = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(s, new StreamResult(w));
        return this.compileSchema(new StreamSource(new StringReader(w.toString())));
    }

    @Override
    public javax.xml.validation.Schema newSchema() throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSchemaLanguageSupported(String schemaLanguage) {
        return schemaLanguage.equals(this.getLanguageName());
    }
}

