/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.pkg.OdfAlienAttribute;
import org.odftoolkit.odfdom.pkg.OdfAlienElement;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.w3c.dom.DOMException;

public class OdfXMLFactory {
    private static Map<OdfName, Class> mElementTypes = new HashMap<OdfName, Class>();
    private static Map<OdfName, Class> mAttributeTypes = new HashMap<OdfName, Class>();
    private static Map<String, String> mElementRenames = new HashMap<String, String>();
    private static Set<String> mIncubatorElements = new HashSet<String>();
    private static final String LOCAL_NAME_DELIMITER = "-";
    private static final String ELEMENT_NAME_DELIMITER = ":";
    private static final String ELEMENT_PACKAGE_NAME = "element";
    private static final String ATTRIBUTE_PACKAGE_NAME = "attribute";

    private static void setOdfElementClass(OdfName odfName, Class className) {
        mElementTypes.put(odfName, className);
    }

    private static void setOdfAttributeClass(OdfName odfName, Class className) {
        mAttributeTypes.put(odfName, className);
    }

    private static Class getOdfAttributeClass(OdfName odfName) {
        return OdfXMLFactory.getOdfNodeClass(odfName, ATTRIBUTE_PACKAGE_NAME, mAttributeTypes, true);
    }

    private static Class getOdfElementClass(OdfName odfName) {
        return OdfXMLFactory.getOdfNodeClass(odfName, ELEMENT_PACKAGE_NAME, mElementTypes, false);
    }

    private static Class getOdfNodeClass(OdfName odfName, String nodeType, Map<OdfName, Class> classCache, boolean isAttribute) {
        String prefix;
        Class<?> c = null;
        String className = "";
        c = classCache.get(odfName);
        if (!(c != null || (prefix = odfName.getPrefix()) == null || isAttribute && prefix.equals("xmlns"))) {
            String qName = odfName.getQName();
            String localName = odfName.getLocalName();
            if (mIncubatorElements.contains(qName) && !isAttribute) {
                if (mElementRenames.containsKey(qName)) {
                    String renameName = mElementRenames.get(qName);
                    StringTokenizer stok = new StringTokenizer(renameName, ELEMENT_NAME_DELIMITER);
                    prefix = stok.nextToken();
                    localName = stok.nextToken();
                }
                className = OdfXMLFactory.getOdfIncubatorNodeClassName(prefix, localName);
            } else {
                className = "manifest".equals(prefix) ? OdfXMLFactory.getOdfPKGNodeClassName(prefix, localName, nodeType) : OdfXMLFactory.getOdfDOMNodeClassName(prefix, localName, nodeType);
            }
            try {
                c = Class.forName(className);
                classCache.put(odfName, c);
            }
            catch (ClassNotFoundException renameName) {
            }
            catch (NoClassDefFoundError dex) {
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.INFO, "NoClassDefFoundError: " + className, dex.getMessage());
            }
        }
        return c;
    }

    private static String getOdfIncubatorNodeClassName(String prefix, String localName) {
        boolean contains = false;
        StringBuilder className = new StringBuilder();
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                String substr = stok.nextToken();
                if (substr.equals(prefix)) {
                    contains = true;
                }
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(substr));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        if (!(contains && !localName.endsWith("table") || localName.equals(prefix) || localName.startsWith(prefix) && prefix.equals("anim"))) {
            className = className.insert(0, OdfXMLFactory.toUpperCaseFirstCharacter(prefix));
        }
        className = className.insert(0, "org.odftoolkit.odfdom.incubator.doc." + prefix + ".Odf");
        return className.toString();
    }

    private static String getOdfPKGNodeClassName(String prefix, String localName, String nodeType) {
        StringBuilder className = new StringBuilder("org.odftoolkit.odfdom.pkg." + prefix + ".");
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(stok.nextToken()));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        className.append(OdfXMLFactory.toUpperCaseFirstCharacter(nodeType));
        return className.toString();
    }

    private static String getOdfDOMNodeClassName(String prefix, String localName, String nodeType) {
        StringBuilder className = new StringBuilder("org.odftoolkit.odfdom.dom." + nodeType + "." + prefix + ".");
        className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(prefix));
        if (localName.indexOf(LOCAL_NAME_DELIMITER) != -1) {
            StringTokenizer stok = new StringTokenizer(localName, LOCAL_NAME_DELIMITER);
            while (stok.hasMoreElements()) {
                className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(stok.nextToken()));
            }
        } else {
            className = className.append(OdfXMLFactory.toUpperCaseFirstCharacter(localName));
        }
        className.append(OdfXMLFactory.toUpperCaseFirstCharacter(nodeType));
        return className.toString();
    }

    private static String toUpperCaseFirstCharacter(String token) {
        return token.substring(0, 1).toUpperCase() + token.substring(1);
    }

    public static OdfElement newOdfElement(OdfFileDom dom, OdfName name) throws DOMException {
        OdfElement element = null;
        Class elementClass = OdfXMLFactory.getOdfElementClass(name);
        if (elementClass != null) {
            element = (OdfElement)OdfXMLFactory.getNodeFromClass(dom, elementClass);
        } else {
            String oldPrefix = name.getPrefix();
            if (oldPrefix != null) {
                OdfName adaptedName = OdfXMLFactory.addNamespaceToDom(name, dom);
                String newPrefix = adaptedName.getPrefix();
                if (oldPrefix != null && !oldPrefix.equals(newPrefix) && newPrefix.indexOf("__") == -1) {
                    element = OdfXMLFactory.newOdfElement(dom, adaptedName);
                } else {
                    element = new OdfAlienElement(dom, adaptedName);
                    Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINE, "None-ODF element created for {0}", adaptedName.getQName());
                }
            } else {
                element = new OdfAlienElement(dom, name);
                Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINE, "None-ODF element created for {0}", name.getQName());
            }
        }
        return element;
    }

    public static OdfAttribute newOdfAttribute(OdfFileDom dom, OdfName name) throws DOMException {
        OdfAttribute attr = null;
        Class attributeClass = OdfXMLFactory.getOdfAttributeClass(name);
        if (attributeClass != null) {
            attr = (OdfAttribute)OdfXMLFactory.getNodeFromClass(dom, attributeClass);
        } else {
            String prefix = name.getPrefix();
            if (prefix != null && !prefix.equals("xmlns")) {
                OdfName adaptedName = OdfXMLFactory.addNamespaceToDom(name, dom);
                String newPrefix = adaptedName.getPrefix();
                if (!prefix.equals(newPrefix) && newPrefix.indexOf("__") == -1) {
                    attr = OdfXMLFactory.newOdfAttribute(dom, adaptedName);
                } else {
                    attr = new OdfAlienAttribute(dom, name);
                    Logger.getLogger(OdfXMLFactory.class.getName()).log(Level.FINE, "None-ODF attribute created for {0}", adaptedName.getQName());
                }
            } else {
                attr = new OdfAlienAttribute(dom, name);
            }
        }
        return attr;
    }

    private static OdfName addNamespaceToDom(OdfName name, OdfFileDom dom) {
        OdfNamespace newNS = dom.setNamespace(name.getPrefix(), name.getUri());
        return OdfName.newName(newNS, name.getLocalName());
    }

    static Object getNodeFromClass(OdfFileDom dom, Class nodeClass) {
        Object o = null;
        try {
            Constructor ctor = nodeClass.getConstructor(OdfFileDom.class);
            o = ctor.newInstance(dom);
        }
        catch (Exception cause) {
            throw new Error("ODF DOM error in attribute factory", cause);
        }
        return o;
    }

    static {
        mElementRenames.put("text:h", "text:heading");
        mElementRenames.put("text:p", "text:paragraph");
        mIncubatorElements.add("draw:frame");
        mIncubatorElements.add("draw:image");
        mIncubatorElements.add("number:currency-style");
        mIncubatorElements.add("number:date-style");
        mIncubatorElements.add("number:percentage-style");
        mIncubatorElements.add("number:number-style");
        mIncubatorElements.add("number:time-style");
        mIncubatorElements.add("office:automatic-styles");
        mIncubatorElements.add("office:master-styles");
        mIncubatorElements.add("office:styles");
        mIncubatorElements.add("style:default-style");
        mIncubatorElements.add("style:style");
        mIncubatorElements.add("style:page-layout");
        mIncubatorElements.add("text:h");
        mIncubatorElements.add("text:list");
        mIncubatorElements.add("text:list-level-style-bullet");
        mIncubatorElements.add("text:list-level-style-image");
        mIncubatorElements.add("text:list-level-style-number");
        mIncubatorElements.add("text:list-style");
        mIncubatorElements.add("text:outline-level-style");
        mIncubatorElements.add("text:outline-style");
        mIncubatorElements.add("text:p");
        mIncubatorElements.add("text:span");
    }
}

