/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.probatron.officeotron.ODFValidationSession;
import org.probatron.officeotron.OOXMLValidationSession;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.Submission;
import org.probatron.officeotron.sessionstorage.ValidationSession;
import org.xml.sax.Attributes;

public class Utils {
    static Logger logger = Logger.getLogger(Utils.class);
    private static final int READ_BUFFER_SIZE = 32768;
    public static final int CLOSE_NONE = 0;
    public static final int CLOSE_IN = 1;
    public static final int CLOSE_OUT = 16;

    public static String getQAtt(Attributes attributes, String string, String string2) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getURI(i).equals(string) || !attributes.getLocalName(i).equals(string2)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public static byte[] getBytesToEndOfStream(InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.transferBytesToEndOfStream(inputStream, byteArrayOutputStream, bl ? 17 : 16);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public static byte[] derefUrl(URL uRL) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            byArray = Utils.getBytesToEndOfStream(inputStream, true);
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            return null;
        }
        return byArray;
    }

    public static void writeBytesToFile(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        file.createNewFile();
        FileOutputStream fileOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Utils.transferBytesToEndOfStream(byteArrayInputStream, fileOutputStream, 17);
            System.gc();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("File not found when writing: ", fileNotFoundException);
        }
    }

    public static void streamFromFile(String string, OutputStream outputStream, boolean bl) throws IOException {
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = 1;
            if (bl) {
                n |= 0x10;
            }
            Utils.transferBytesToEndOfStream(fileInputStream, outputStream, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("File not found when reading: ", fileNotFoundException);
        }
    }

    public static long streamToFile(InputStream inputStream, String string, boolean bl) throws IOException {
        File file = new File(string);
        file.createNewFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = bl ? 17 : 16;
            return Utils.transferBytesToEndOfStream(inputStream, fileOutputStream, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("File not found when writing: ", fileNotFoundException);
        }
    }

    public static ValidationSession autoCreateValidationSession(Submission submission, ReportFactory reportFactory) {
        ValidationSession validationSession = null;
        String string = new File(submission.getCandidateFile()).toURI().toASCIIString();
        logger.debug("auto-detecting package at: " + string);
        File file = submission.getEntryFile("/META-INF/manifest.xml");
        if (file.canRead()) {
            logger.info("Auto detected ODF package");
            validationSession = new ODFValidationSession(submission.uuid, submission.getOptionMap(), reportFactory);
        } else {
            File file2 = submission.getEntryFile("/_rels/.rels");
            if (file2.canRead()) {
                logger.info("Auto detected OOXML package");
                validationSession = new OOXMLValidationSession(submission.uuid, reportFactory);
            }
        }
        return validationSession;
    }

    public static long transferBytesToEndOfStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[32769];
        long l = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
        }
        if ((n & 1) != 0) {
            Utils.streamClose(inputStream);
        }
        if ((n & 0x10) != 0) {
            Utils.streamClose(outputStream);
        }
        byArray = null;
        return l;
    }

    public static void streamClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void streamClose(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void unzipArchive(File file, File file2) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                Utils.unzipEntry(zipFile, zipEntry, file2);
            }
        }
        catch (Exception exception) {
            logger.error("Error while extracting file " + file, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, File file) throws IOException {
        if (zipEntry.isDirectory()) {
            new File(file, zipEntry.getName()).mkdirs();
            return;
        }
        File file2 = new File(file, zipEntry.getName());
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            Utils.transferBytesToEndOfStream(bufferedInputStream, bufferedOutputStream, 0);
        }
        finally {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
    }

    public static boolean deleteDir(File file) {
        logger.info("Deleting folder " + file);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Utils.deleteDir(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
                System.gc();
            }
        }
        boolean bl = file.delete();
        return bl;
    }
}

