/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron.sessionstorage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.probatron.officeotron.Utils;

public class Store {
    static Logger logger = Logger.getLogger(Store.class);
    static String tmpFolder;
    static boolean webMode;
    static HashMap<UUID, String> localMap;

    public static void init(String string, boolean bl) {
        tmpFolder = string;
        File file = new File(string);
        if (!file.isDirectory()) {
            file.mkdirs();
            file.mkdir();
        }
        webMode = bl;
    }

    public static UUID putZippedResource(InputStream inputStream, String string) throws IOException {
        UUID uUID = UUID.randomUUID();
        String string2 = string;
        new File(Store.getDirectory(uUID)).mkdir();
        if (webMode) {
            string2 = Store.getDirectory(uUID) + File.separator + uUID + ".bin";
            long l = Utils.streamToFile(inputStream, string2, false);
            logger.debug("Wrote " + l + " bytes to file");
        }
        localMap.put(uUID, string2);
        Utils.unzipArchive(new File(string2), new File(Store.getDirectory(uUID)));
        return uUID;
    }

    public static InputStream getStream(UUID uUID) {
        String string = localMap.get(uUID);
        FileInputStream fileInputStream = null;
        if (string != null) {
            File file = new File(string);
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fileInputStream;
    }

    public static URI urlForEntry(UUID uUID, String string) {
        String string2 = Store.getDirectory(uUID) + File.separator + string;
        URI uRI = new File(string2).toURI();
        return uRI;
    }

    public static void delete(UUID uUID) {
        File file = new File(Store.getDirectory(uUID));
        Utils.deleteDir(file);
        localMap.remove(uUID);
    }

    public static String getDirectory(UUID uUID) {
        return tmpFolder + File.separator + uUID;
    }

    public static String getFilename(UUID uUID) {
        return localMap.get(uUID);
    }

    static {
        localMap = new HashMap();
    }
}

