# SPDX-License-Identifier: Apache-2.0
# Copyright 2020 The Meson development team

from __future__ import annotations
import typing as T

from ._qt import QtBaseModule
from . import ModuleInfo

if T.TYPE_CHECKING:
    from ..interpreter import Interpreter

class Qt6Module(QtBaseModule):

    INFO = ModuleInfo('qt6', '0.57.0')

    def __init__(self, interpreter: Interpreter):
        QtBaseModule.__init__(self, interpreter, qt_version=6)


def initialize(interp: Interpreter) -> Qt6Module:
    return Qt6Module(interp)
