#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from __future__ import absolute_import, division, unicode_literals

import gpg
import hkp4py
import os.path
import sys

# Copyright (C) 2018 Ben McGinnes <ben@gnupg.org>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free
# Software Foundation; either version 2.1 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License and the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License and the GNU
# Lesser General Public License along with this program; if not, see
# <https://www.gnu.org/licenses/>.

print("""
This script sends one or more public keys to the SKS keyservers and is
essentially a slight variation on the export-key.py script.

The default is to send all keys if there is no pattern or search term.
""")

c = gpg.Context(armor=True)
server = hkp4py.KeyServer("hkps://hkps.pool.sks-keyservers.net")

if len(sys.argv) >= 3:
    logrus = sys.argv[1]
    homedir = sys.argv[2]
elif len(sys.argv) == 2:
    logrus = sys.argv[1]
    homedir = input("Enter the GPG configuration directory path (optional): ")
else:
    logrus = input("Enter the UID matching the key(s) to export: ")
    homedir = input("Enter the GPG configuration directory path (optional): ")

if not homedir:
    homedir = None
elif homedir.startswith("~"):
    userdir = os.path.expanduser(homedir)
    if os.path.exists(userdir) is True:
        homedir = os.path.realpath(userdir)
    else:
        homedir = None
else:
    homedir = os.path.realpath(homedir)

if homedir is not None and os.path.exists(homedir) is False:
    homedir = None
elif homedir is not None and os.path.exists(homedir) is True:
    if os.path.isdir(homedir) is False:
        homedir = None
    else:
        pass

if homedir is not None:
    c.home_dir = homedir
else:
    pass

if logrus:
    try:
        export_result = c.key_export(pattern=logrus)
    except Exception as e:
        print(e)
        export_result = None
else:
    export_result = c.key_export(pattern=None)

if export_result is not None:
    try:
        try:
            send_result = server.add(export_result)
        except:
            send_result = server.add(export_result.decode())
        if send_result is not None:
            print(send_result)
        else:
            pass
    except Exception as e:
        print(e)
else:
    pass
