// WARNING: This file is auto-generated by crates/ast/generate_ast.py.

use crate::token::Token;
use ast::arena;
use ast::types::*;
use std::convert::Infallible;

pub type AstError = String;
type AstResult<'alloc, T> = Result<arena::Box<'alloc, T>, AstError>;

#[derive(Debug)]
pub enum StackValue<'alloc> {
    Argument(arena::Box<'alloc, Argument<'alloc>>),
    Arguments(arena::Box<'alloc, Arguments<'alloc>>),
    ArrayAssignmentTarget(arena::Box<'alloc, ArrayAssignmentTarget<'alloc>>),
    ArrayBinding(arena::Box<'alloc, ArrayBinding<'alloc>>),
    ArrayExpression(arena::Box<'alloc, ArrayExpression<'alloc>>),
    ArrayExpressionElement(arena::Box<'alloc, ArrayExpressionElement<'alloc>>),
    ArrowExpressionBody(arena::Box<'alloc, ArrowExpressionBody<'alloc>>),
    AssignmentTarget(arena::Box<'alloc, AssignmentTarget<'alloc>>),
    AssignmentTargetIdentifier(arena::Box<'alloc, AssignmentTargetIdentifier>),
    AssignmentTargetMaybeDefault(arena::Box<'alloc, AssignmentTargetMaybeDefault<'alloc>>),
    AssignmentTargetPattern(arena::Box<'alloc, AssignmentTargetPattern<'alloc>>),
    AssignmentTargetProperty(arena::Box<'alloc, AssignmentTargetProperty<'alloc>>),
    AssignmentTargetPropertyIdentifier(arena::Box<'alloc, AssignmentTargetPropertyIdentifier<'alloc>>),
    AssignmentTargetPropertyProperty(arena::Box<'alloc, AssignmentTargetPropertyProperty<'alloc>>),
    AssignmentTargetWithDefault(arena::Box<'alloc, AssignmentTargetWithDefault<'alloc>>),
    BinaryOperator(arena::Box<'alloc, BinaryOperator>),
    Binding(arena::Box<'alloc, Binding<'alloc>>),
    BindingIdentifier(arena::Box<'alloc, BindingIdentifier>),
    BindingPattern(arena::Box<'alloc, BindingPattern<'alloc>>),
    BindingProperty(arena::Box<'alloc, BindingProperty<'alloc>>),
    BindingPropertyIdentifier(arena::Box<'alloc, BindingPropertyIdentifier<'alloc>>),
    BindingPropertyProperty(arena::Box<'alloc, BindingPropertyProperty<'alloc>>),
    BindingWithDefault(arena::Box<'alloc, BindingWithDefault<'alloc>>),
    Block(arena::Box<'alloc, Block<'alloc>>),
    CallExpression(arena::Box<'alloc, CallExpression<'alloc>>),
    CatchClause(arena::Box<'alloc, CatchClause<'alloc>>),
    ClassDeclaration(arena::Box<'alloc, ClassDeclaration<'alloc>>),
    ClassElement(arena::Box<'alloc, ClassElement<'alloc>>),
    ClassElementName(arena::Box<'alloc, ClassElementName<'alloc>>),
    ClassExpression(arena::Box<'alloc, ClassExpression<'alloc>>),
    CompoundAssignmentOperator(arena::Box<'alloc, CompoundAssignmentOperator>),
    ComputedMemberAssignmentTarget(arena::Box<'alloc, ComputedMemberAssignmentTarget<'alloc>>),
    ComputedMemberExpression(arena::Box<'alloc, ComputedMemberExpression<'alloc>>),
    ComputedPropertyName(arena::Box<'alloc, ComputedPropertyName<'alloc>>),
    CoverParenthesized(arena::Box<'alloc, CoverParenthesized<'alloc>>),
    DataProperty(arena::Box<'alloc, DataProperty<'alloc>>),
    Directive(arena::Box<'alloc, Directive>),
    Export(arena::Box<'alloc, Export<'alloc>>),
    ExportAllFrom(arena::Box<'alloc, ExportAllFrom>),
    ExportDeclaration(arena::Box<'alloc, ExportDeclaration<'alloc>>),
    ExportDefault(arena::Box<'alloc, ExportDefault<'alloc>>),
    ExportFrom(arena::Box<'alloc, ExportFrom<'alloc>>),
    ExportFromSpecifier(arena::Box<'alloc, ExportFromSpecifier>),
    ExportLocalSpecifier(arena::Box<'alloc, ExportLocalSpecifier>),
    ExportLocals(arena::Box<'alloc, ExportLocals<'alloc>>),
    Expression(arena::Box<'alloc, Expression<'alloc>>),
    ExpressionOrSuper(arena::Box<'alloc, ExpressionOrSuper<'alloc>>),
    FormalParameters(arena::Box<'alloc, FormalParameters<'alloc>>),
    Function(arena::Box<'alloc, Function<'alloc>>),
    FunctionBody(arena::Box<'alloc, FunctionBody<'alloc>>),
    Getter(arena::Box<'alloc, Getter<'alloc>>),
    Identifier(arena::Box<'alloc, Identifier>),
    IdentifierExpression(arena::Box<'alloc, IdentifierExpression>),
    IdentifierName(arena::Box<'alloc, IdentifierName>),
    IfStatement(arena::Box<'alloc, IfStatement<'alloc>>),
    Import(arena::Box<'alloc, Import<'alloc>>),
    ImportDeclaration(arena::Box<'alloc, ImportDeclaration<'alloc>>),
    ImportNamespace(arena::Box<'alloc, ImportNamespace>),
    ImportSpecifier(arena::Box<'alloc, ImportSpecifier>),
    Label(arena::Box<'alloc, Label>),
    MemberAssignmentTarget(arena::Box<'alloc, MemberAssignmentTarget<'alloc>>),
    MemberExpression(arena::Box<'alloc, MemberExpression<'alloc>>),
    Method(arena::Box<'alloc, Method<'alloc>>),
    MethodDefinition(arena::Box<'alloc, MethodDefinition<'alloc>>),
    Module(arena::Box<'alloc, Module<'alloc>>),
    ModuleItems(arena::Box<'alloc, ModuleItems<'alloc>>),
    NamedObjectProperty(arena::Box<'alloc, NamedObjectProperty<'alloc>>),
    NumericLiteral(arena::Box<'alloc, NumericLiteral>),
    ObjectAssignmentTarget(arena::Box<'alloc, ObjectAssignmentTarget<'alloc>>),
    ObjectBinding(arena::Box<'alloc, ObjectBinding<'alloc>>),
    ObjectExpression(arena::Box<'alloc, ObjectExpression<'alloc>>),
    ObjectProperty(arena::Box<'alloc, ObjectProperty<'alloc>>),
    OptionalChain(arena::Box<'alloc, OptionalChain<'alloc>>),
    Parameter(arena::Box<'alloc, Parameter<'alloc>>),
    PrivateFieldAssignmentTarget(arena::Box<'alloc, PrivateFieldAssignmentTarget<'alloc>>),
    PrivateFieldExpression(arena::Box<'alloc, PrivateFieldExpression<'alloc>>),
    PrivateIdentifier(arena::Box<'alloc, PrivateIdentifier>),
    Program(arena::Box<'alloc, Program<'alloc>>),
    PropertyName(arena::Box<'alloc, PropertyName<'alloc>>),
    Script(arena::Box<'alloc, Script<'alloc>>),
    Setter(arena::Box<'alloc, Setter<'alloc>>),
    ShorthandProperty(arena::Box<'alloc, ShorthandProperty>),
    SimpleAssignmentTarget(arena::Box<'alloc, SimpleAssignmentTarget<'alloc>>),
    Statement(arena::Box<'alloc, Statement<'alloc>>),
    StaticMemberAssignmentTarget(arena::Box<'alloc, StaticMemberAssignmentTarget<'alloc>>),
    StaticMemberExpression(arena::Box<'alloc, StaticMemberExpression<'alloc>>),
    StaticPropertyName(arena::Box<'alloc, StaticPropertyName>),
    SwitchCase(arena::Box<'alloc, SwitchCase<'alloc>>),
    SwitchDefault(arena::Box<'alloc, SwitchDefault<'alloc>>),
    TemplateElement(arena::Box<'alloc, TemplateElement>),
    TemplateExpression(arena::Box<'alloc, TemplateExpression<'alloc>>),
    TemplateExpressionElement(arena::Box<'alloc, TemplateExpressionElement<'alloc>>),
    Token(arena::Box<'alloc, Token>),
    UnaryOperator(arena::Box<'alloc, UnaryOperator>),
    UpdateOperator(arena::Box<'alloc, UpdateOperator>),
    VariableDeclaration(arena::Box<'alloc, VariableDeclaration<'alloc>>),
    VariableDeclarationKind(arena::Box<'alloc, VariableDeclarationKind>),
    VariableDeclarationOrAssignmentTarget(arena::Box<'alloc, VariableDeclarationOrAssignmentTarget<'alloc>>),
    VariableDeclarationOrExpression(arena::Box<'alloc, VariableDeclarationOrExpression<'alloc>>),
    VariableDeclarator(arena::Box<'alloc, VariableDeclarator<'alloc>>),
    VariableReference(arena::Box<'alloc, VariableReference>),
    VecArrayExpressionElement(arena::Box<'alloc, arena::Vec<'alloc, ArrayExpressionElement<'alloc>>>),
    VecBindingProperty(arena::Box<'alloc, arena::Vec<'alloc, BindingProperty<'alloc>>>),
    VecClassElement(arena::Box<'alloc, arena::Vec<'alloc, arena::Box<'alloc, ClassElement<'alloc>>>>),
    VecOption(arena::Box<'alloc, arena::Vec<'alloc, Option<Parameter<'alloc>>>>),
    VecStatement(arena::Box<'alloc, arena::Vec<'alloc, Statement<'alloc>>>),
    VecSwitchCase(arena::Box<'alloc, arena::Vec<'alloc, SwitchCase<'alloc>>>),
    VecVariableDeclarator(arena::Box<'alloc, arena::Vec<'alloc, VariableDeclarator<'alloc>>>),
    Void(arena::Box<'alloc, Void>),
}

impl<'alloc> StackValue<'alloc> {
    pub fn to_ast<T: StackValueItem<'alloc>>(self) -> AstResult<'alloc, T> {
        T::to_ast(self)
    }
}

pub trait StackValueItem<'alloc>: Sized {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self>;
}

/// Values that can be converted to StackValues, fallibly.
pub trait TryIntoStack<'alloc> {
    type Error;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Self::Error>;
}
impl<'alloc> StackValueItem<'alloc> for Argument<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Argument(v) => Ok(v),
            _ => Err(format!("StackValue expected Argument, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Arguments<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Arguments(v) => Ok(v),
            _ => Err(format!("StackValue expected Arguments, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ArrayAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ArrayAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected ArrayAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ArrayBinding<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ArrayBinding(v) => Ok(v),
            _ => Err(format!("StackValue expected ArrayBinding, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ArrayExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ArrayExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected ArrayExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ArrayExpressionElement<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ArrayExpressionElement(v) => Ok(v),
            _ => Err(format!("StackValue expected ArrayExpressionElement, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ArrowExpressionBody<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ArrowExpressionBody(v) => Ok(v),
            _ => Err(format!("StackValue expected ArrowExpressionBody, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetIdentifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetIdentifier(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetIdentifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetMaybeDefault<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetMaybeDefault(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetMaybeDefault, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetPattern<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetPattern(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetPattern, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetPropertyIdentifier<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetPropertyIdentifier(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetPropertyIdentifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetPropertyProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetPropertyProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetPropertyProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for AssignmentTargetWithDefault<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::AssignmentTargetWithDefault(v) => Ok(v),
            _ => Err(format!("StackValue expected AssignmentTargetWithDefault, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BinaryOperator {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BinaryOperator(v) => Ok(v),
            _ => Err(format!("StackValue expected BinaryOperator, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Binding<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Binding(v) => Ok(v),
            _ => Err(format!("StackValue expected Binding, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BindingIdentifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BindingIdentifier(v) => Ok(v),
            _ => Err(format!("StackValue expected BindingIdentifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BindingPattern<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BindingPattern(v) => Ok(v),
            _ => Err(format!("StackValue expected BindingPattern, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BindingProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BindingProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected BindingProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BindingPropertyIdentifier<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BindingPropertyIdentifier(v) => Ok(v),
            _ => Err(format!("StackValue expected BindingPropertyIdentifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BindingPropertyProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BindingPropertyProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected BindingPropertyProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for BindingWithDefault<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::BindingWithDefault(v) => Ok(v),
            _ => Err(format!("StackValue expected BindingWithDefault, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Block<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Block(v) => Ok(v),
            _ => Err(format!("StackValue expected Block, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for CallExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::CallExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected CallExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for CatchClause<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::CatchClause(v) => Ok(v),
            _ => Err(format!("StackValue expected CatchClause, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ClassDeclaration<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ClassDeclaration(v) => Ok(v),
            _ => Err(format!("StackValue expected ClassDeclaration, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ClassElement<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ClassElement(v) => Ok(v),
            _ => Err(format!("StackValue expected ClassElement, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ClassElementName<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ClassElementName(v) => Ok(v),
            _ => Err(format!("StackValue expected ClassElementName, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ClassExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ClassExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected ClassExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for CompoundAssignmentOperator {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::CompoundAssignmentOperator(v) => Ok(v),
            _ => Err(format!("StackValue expected CompoundAssignmentOperator, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ComputedMemberAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ComputedMemberAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected ComputedMemberAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ComputedMemberExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ComputedMemberExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected ComputedMemberExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ComputedPropertyName<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ComputedPropertyName(v) => Ok(v),
            _ => Err(format!("StackValue expected ComputedPropertyName, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for CoverParenthesized<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::CoverParenthesized(v) => Ok(v),
            _ => Err(format!("StackValue expected CoverParenthesized, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for DataProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::DataProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected DataProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Directive {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Directive(v) => Ok(v),
            _ => Err(format!("StackValue expected Directive, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Export<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Export(v) => Ok(v),
            _ => Err(format!("StackValue expected Export, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportAllFrom {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportAllFrom(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportAllFrom, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportDeclaration<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportDeclaration(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportDeclaration, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportDefault<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportDefault(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportDefault, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportFrom<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportFrom(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportFrom, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportFromSpecifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportFromSpecifier(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportFromSpecifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportLocalSpecifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportLocalSpecifier(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportLocalSpecifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExportLocals<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExportLocals(v) => Ok(v),
            _ => Err(format!("StackValue expected ExportLocals, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Expression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Expression(v) => Ok(v),
            _ => Err(format!("StackValue expected Expression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ExpressionOrSuper<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ExpressionOrSuper(v) => Ok(v),
            _ => Err(format!("StackValue expected ExpressionOrSuper, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for FormalParameters<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::FormalParameters(v) => Ok(v),
            _ => Err(format!("StackValue expected FormalParameters, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Function<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Function(v) => Ok(v),
            _ => Err(format!("StackValue expected Function, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for FunctionBody<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::FunctionBody(v) => Ok(v),
            _ => Err(format!("StackValue expected FunctionBody, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Getter<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Getter(v) => Ok(v),
            _ => Err(format!("StackValue expected Getter, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Identifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Identifier(v) => Ok(v),
            _ => Err(format!("StackValue expected Identifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for IdentifierExpression {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::IdentifierExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected IdentifierExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for IdentifierName {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::IdentifierName(v) => Ok(v),
            _ => Err(format!("StackValue expected IdentifierName, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for IfStatement<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::IfStatement(v) => Ok(v),
            _ => Err(format!("StackValue expected IfStatement, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Import<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Import(v) => Ok(v),
            _ => Err(format!("StackValue expected Import, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ImportDeclaration<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ImportDeclaration(v) => Ok(v),
            _ => Err(format!("StackValue expected ImportDeclaration, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ImportNamespace {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ImportNamespace(v) => Ok(v),
            _ => Err(format!("StackValue expected ImportNamespace, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ImportSpecifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ImportSpecifier(v) => Ok(v),
            _ => Err(format!("StackValue expected ImportSpecifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Label {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Label(v) => Ok(v),
            _ => Err(format!("StackValue expected Label, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for MemberAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::MemberAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected MemberAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for MemberExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::MemberExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected MemberExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Method<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Method(v) => Ok(v),
            _ => Err(format!("StackValue expected Method, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for MethodDefinition<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::MethodDefinition(v) => Ok(v),
            _ => Err(format!("StackValue expected MethodDefinition, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Module<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Module(v) => Ok(v),
            _ => Err(format!("StackValue expected Module, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ModuleItems<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ModuleItems(v) => Ok(v),
            _ => Err(format!("StackValue expected ModuleItems, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for NamedObjectProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::NamedObjectProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected NamedObjectProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for NumericLiteral {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::NumericLiteral(v) => Ok(v),
            _ => Err(format!("StackValue expected NumericLiteral, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ObjectAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ObjectAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected ObjectAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ObjectBinding<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ObjectBinding(v) => Ok(v),
            _ => Err(format!("StackValue expected ObjectBinding, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ObjectExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ObjectExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected ObjectExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ObjectProperty<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ObjectProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected ObjectProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for OptionalChain<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::OptionalChain(v) => Ok(v),
            _ => Err(format!("StackValue expected OptionalChain, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Parameter<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Parameter(v) => Ok(v),
            _ => Err(format!("StackValue expected Parameter, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for PrivateFieldAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::PrivateFieldAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected PrivateFieldAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for PrivateFieldExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::PrivateFieldExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected PrivateFieldExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for PrivateIdentifier {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::PrivateIdentifier(v) => Ok(v),
            _ => Err(format!("StackValue expected PrivateIdentifier, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Program<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Program(v) => Ok(v),
            _ => Err(format!("StackValue expected Program, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for PropertyName<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::PropertyName(v) => Ok(v),
            _ => Err(format!("StackValue expected PropertyName, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Script<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Script(v) => Ok(v),
            _ => Err(format!("StackValue expected Script, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Setter<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Setter(v) => Ok(v),
            _ => Err(format!("StackValue expected Setter, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for ShorthandProperty {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::ShorthandProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected ShorthandProperty, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for SimpleAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::SimpleAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected SimpleAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Statement<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Statement(v) => Ok(v),
            _ => Err(format!("StackValue expected Statement, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for StaticMemberAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::StaticMemberAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected StaticMemberAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for StaticMemberExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::StaticMemberExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected StaticMemberExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for StaticPropertyName {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::StaticPropertyName(v) => Ok(v),
            _ => Err(format!("StackValue expected StaticPropertyName, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for SwitchCase<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::SwitchCase(v) => Ok(v),
            _ => Err(format!("StackValue expected SwitchCase, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for SwitchDefault<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::SwitchDefault(v) => Ok(v),
            _ => Err(format!("StackValue expected SwitchDefault, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for TemplateElement {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::TemplateElement(v) => Ok(v),
            _ => Err(format!("StackValue expected TemplateElement, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for TemplateExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::TemplateExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected TemplateExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for TemplateExpressionElement<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::TemplateExpressionElement(v) => Ok(v),
            _ => Err(format!("StackValue expected TemplateExpressionElement, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Token {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Token(v) => Ok(v),
            _ => Err(format!("StackValue expected Token, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for UnaryOperator {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::UnaryOperator(v) => Ok(v),
            _ => Err(format!("StackValue expected UnaryOperator, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for UpdateOperator {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::UpdateOperator(v) => Ok(v),
            _ => Err(format!("StackValue expected UpdateOperator, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for VariableDeclaration<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VariableDeclaration(v) => Ok(v),
            _ => Err(format!("StackValue expected VariableDeclaration, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for VariableDeclarationKind {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VariableDeclarationKind(v) => Ok(v),
            _ => Err(format!("StackValue expected VariableDeclarationKind, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for VariableDeclarationOrAssignmentTarget<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VariableDeclarationOrAssignmentTarget(v) => Ok(v),
            _ => Err(format!("StackValue expected VariableDeclarationOrAssignmentTarget, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for VariableDeclarationOrExpression<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VariableDeclarationOrExpression(v) => Ok(v),
            _ => Err(format!("StackValue expected VariableDeclarationOrExpression, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for VariableDeclarator<'alloc> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VariableDeclarator(v) => Ok(v),
            _ => Err(format!("StackValue expected VariableDeclarator, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for VariableReference {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VariableReference(v) => Ok(v),
            _ => Err(format!("StackValue expected VariableReference, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, ArrayExpressionElement<'alloc>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecArrayExpressionElement(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<ArrayExpressionElement>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, BindingProperty<'alloc>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecBindingProperty(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<BindingProperty>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, arena::Box<'alloc, ClassElement<'alloc>>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecClassElement(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<Box<ClassElement>>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, Option<Parameter<'alloc>>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecOption(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<Option<Parameter>>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, Statement<'alloc>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecStatement(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<Statement>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, SwitchCase<'alloc>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecSwitchCase(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<SwitchCase>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for arena::Vec<'alloc, VariableDeclarator<'alloc>> {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::VecVariableDeclarator(v) => Ok(v),
            _ => Err(format!("StackValue expected Vec<VariableDeclarator>, got {:?}", sv)),
        }
    }
}

impl<'alloc> StackValueItem<'alloc> for Void {
    fn to_ast(sv: StackValue<'alloc>) -> AstResult<'alloc, Self> {
        match sv {
            StackValue::Void(v) => Ok(v),
            _ => Err(format!("StackValue expected Void, got {:?}", sv)),
        }
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Argument<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Argument(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Arguments<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Arguments(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ArrayAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ArrayAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ArrayBinding<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ArrayBinding(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ArrayExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ArrayExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ArrayExpressionElement<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ArrayExpressionElement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ArrowExpressionBody<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ArrowExpressionBody(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetIdentifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetIdentifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetMaybeDefault<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetMaybeDefault(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetPattern<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetPattern(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetPropertyIdentifier<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetPropertyIdentifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetPropertyProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetPropertyProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, AssignmentTargetWithDefault<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::AssignmentTargetWithDefault(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BinaryOperator> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BinaryOperator(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Binding<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Binding(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BindingIdentifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BindingIdentifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BindingPattern<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BindingPattern(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BindingProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BindingProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BindingPropertyIdentifier<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BindingPropertyIdentifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BindingPropertyProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BindingPropertyProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, BindingWithDefault<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::BindingWithDefault(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Block<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Block(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, CallExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::CallExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, CatchClause<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::CatchClause(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ClassDeclaration<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ClassDeclaration(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ClassElement<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ClassElement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ClassElementName<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ClassElementName(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ClassExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ClassExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, CompoundAssignmentOperator> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::CompoundAssignmentOperator(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ComputedMemberAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ComputedMemberAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ComputedMemberExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ComputedMemberExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ComputedPropertyName<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ComputedPropertyName(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, CoverParenthesized<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::CoverParenthesized(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, DataProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::DataProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Directive> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Directive(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Export<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Export(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportAllFrom> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportAllFrom(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportDeclaration<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportDeclaration(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportDefault<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportDefault(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportFrom<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportFrom(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportFromSpecifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportFromSpecifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportLocalSpecifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportLocalSpecifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExportLocals<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExportLocals(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Expression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Expression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ExpressionOrSuper<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ExpressionOrSuper(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, FormalParameters<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::FormalParameters(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Function<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Function(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, FunctionBody<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::FunctionBody(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Getter<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Getter(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Identifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Identifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, IdentifierExpression> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::IdentifierExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, IdentifierName> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::IdentifierName(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, IfStatement<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::IfStatement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Import<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Import(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ImportDeclaration<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ImportDeclaration(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ImportNamespace> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ImportNamespace(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ImportSpecifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ImportSpecifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Label> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Label(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, MemberAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::MemberAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, MemberExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::MemberExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Method<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Method(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, MethodDefinition<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::MethodDefinition(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Module<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Module(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ModuleItems<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ModuleItems(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, NamedObjectProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::NamedObjectProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, NumericLiteral> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::NumericLiteral(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ObjectAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ObjectAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ObjectBinding<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ObjectBinding(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ObjectExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ObjectExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ObjectProperty<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ObjectProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, OptionalChain<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::OptionalChain(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Parameter<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Parameter(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, PrivateFieldAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::PrivateFieldAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, PrivateFieldExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::PrivateFieldExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, PrivateIdentifier> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::PrivateIdentifier(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Program<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Program(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, PropertyName<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::PropertyName(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Script<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Script(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Setter<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Setter(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, ShorthandProperty> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::ShorthandProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, SimpleAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::SimpleAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Statement<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Statement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, StaticMemberAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::StaticMemberAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, StaticMemberExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::StaticMemberExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, StaticPropertyName> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::StaticPropertyName(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, SwitchCase<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::SwitchCase(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, SwitchDefault<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::SwitchDefault(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, TemplateElement> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::TemplateElement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, TemplateExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::TemplateExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, TemplateExpressionElement<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::TemplateExpressionElement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Token> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Token(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, UnaryOperator> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::UnaryOperator(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, UpdateOperator> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::UpdateOperator(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, VariableDeclaration<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VariableDeclaration(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, VariableDeclarationKind> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VariableDeclarationKind(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, VariableDeclarationOrAssignmentTarget<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VariableDeclarationOrAssignmentTarget(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, VariableDeclarationOrExpression<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VariableDeclarationOrExpression(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, VariableDeclarator<'alloc>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VariableDeclarator(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, VariableReference> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VariableReference(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, ArrayExpressionElement<'alloc>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecArrayExpressionElement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, BindingProperty<'alloc>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecBindingProperty(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, arena::Box<'alloc, ClassElement<'alloc>>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecClassElement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, Option<Parameter<'alloc>>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecOption(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, Statement<'alloc>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecStatement(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, SwitchCase<'alloc>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecSwitchCase(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, arena::Vec<'alloc, VariableDeclarator<'alloc>>> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::VecVariableDeclarator(self))
    }
}

impl<'alloc> TryIntoStack<'alloc> for arena::Box<'alloc, Void> {
    type Error = Infallible;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, Infallible> {
        Ok(StackValue::Void(self))
    }
}

impl<'alloc, T, E> TryIntoStack<'alloc> for Result<T, E>
where
    T: TryIntoStack<'alloc>,
    E: From<T::Error>,
{
    type Error = E;
    fn try_into_stack(self) -> Result<StackValue<'alloc>, E> {
        Ok(self?.try_into_stack()?)
    }
}
