# J.6 What methods of child rearing do anarchists advocate?

Anarchists have long been aware of the importance of child rearing and
education. We are aware that child rearing should aim to develop _"a well-
rounded individuality"_ and not _"a patient work slave, professional
automaton, tax-paying citizen, or righteous moralist."_ In this section of the
FAQ we will discuss anarchist approaches to child rearing bearing in mind
_"that it is through the channel of the child that the development of the
mature man [or woman] must go, and that the present ideas of . . . educating
or training . . . are such as to stifle the natural growth of the child."_
[Emma Goldman, **Red Emma Speaks**, p. 132 and p. 131]

If one accepts the thesis that the authoritarian family is the breeding ground
for both individual psychological problems and political reaction, it follows
that anarchists should try to develop ways of raising children that will not
psychologically cripple them but instead enable them to accept freedom and
responsibility while developing natural self-regulation. We will refer to
children raised in such a way as **_"free children."_**

Work in this field is still in its infancy (no pun intended). Wilhelm Reich
was the main pioneer in this field (an excellent, short introduction to his
ideas can be found in Maurice Brinton's **The Irrational in Politics**). In
**Children of the Future**, Reich made numerous suggestions, based on his
research and clinical experience, for parents, psychologists, and educators
striving to develop libertarian methods of child rearing (although he did not
use the term "libertarian").

In this and the following sections we will summarise Reich's main ideas as
well as those of other libertarian psychologists and educators who have been
influenced by him, such as A.S. Neill and Alexander Lowen. We will examine the
theoretical principles involved in raising free children and will illustrate
their practical application with concrete examples. Finally, we will examine
the anarchist approach to the problems of adolescence.

Such an approach to child rearing is based upon the insight that children _"do
not constitute anyone's property: they are neither the property of the parents
nor even of society. They belong only to their own future freedom."_ [Michael
Bakunin, **The Political Philosophy of Bakunin**, p. 327] As such, what
happens to a child when they are growing up **shapes** the person they become
and the society they live in. The key question for people interested in
freedom is whether _"the child [is] to be considered as an individuality, or
as an object to be moulded according to the whims and fancies of those about
it?"_ [Emma Goldman, **Op. Cit.**, p. 131] Libertarian child rearing is the
means by which the individuality of the child is respected and developed.

This is in stark contrast to standard capitalist claim that children are the
**property** of their parents. If we accept that children **are** the property
of their parents then we are implicitly stating that a child's formative years
are spent in slavery, hardly a relationship which will promote the
individuality and freedom of the child or the wider society. Little wonder
that most anarchists reject such assertions. Instead we argue that the
_"rights of the parents shall be confined to loving their children and
exercising over them . . . authority [that] does not run counter to their
morality, their mental development, or their future freedom."_ Being someone's
property (i.e. slave) runs counter to all these and _"it follows that society,
the whole future of which depends upon adequate education and upbringing of
children . . . has not only the right but also the duty to watch over them."_
Hence child rearing should be **part** of society, a communal process by which
children learn what it means to be an individual by being respected as one by
others: _"real freedom -- that is, the full awareness and the realisation
thereof in every individual, pre-eminently based upon a feeling of one's
dignity and upon the genuine respect for someone else's freedom and dignity,
i.e. upon justice -- such freedom can develop in children only through the
rational development of their minds, character and will."_ [Bakunin, **Op.
Cit.**, p. 327]

We wish to re-iterate again that a great deal of work remains to be done in
this field. Therefore our comments should be regarded merely as tentative
bases for further reflection and research by those involved with raising and
educating children. There is, and cannot be, any "rule book" for raising free
children, because to follow an inflexible rule book is to ignore the fact that
each child and their environment is unique and therefore demands unique
responses from their parents. Hence the principles of libertarian child
rearing to which we will refer should not be thought of as rules, but rather,
as experimental hypotheses to be tested by parents within their own situation
by applying their intelligence and deriving their own individual conclusions.

Bringing up children must be like education, and based on similar principles,
namely _"upon the free growth and development of the innate forces and
tendencies of the child. In this way alone can we hope for the free individual
and eventually also for a free community, which shall make interference and
coercion of human growth impossible."_ [Goldman, **Op. Cit.**, p. 139] Indeed,
child rearing and education **cannot** be separated as life itself is an
education and so must share the same principles and be viewed as a process of
_"development and exploration, rather than as one of repressing a child's
instincts and inculcating obedience and discipline."_ [Martha A. Ackelsberg,
**Free Women of Spain**, p. 166]

Moreover, the role of parental example is very important to raising free
children. Children often learn by mimicking their parents -- children do what
their parents do, not as they say. If their mother and father lie to each
other, scream, fight and so on, then the child will probably do so as well.
Children's behaviour does not come out thin air, they are a product of the
environment they are brought up in. Children can only be encouraged by
example, not by threats and commands. So how parents act can be an obstacle to
the development of a free child. Parents must do more than just **say** the
right things, but also act as anarchists in order to produce free children.

The sad fact is that most modern people have lost the ability to raise free
children, and regaining this ability will be a long process of trial and error
as well as **parent** education in which it is to be hoped that each
succeeding generation will learn from the failures and successes of their
predecessors and so improve. In the best-case scenario, over the course of a
few generations the number of progressive parents will continue to grow and
raise ever freer children, who in turn will become even more progressive
parents themselves, thus gradually changing mass psychology in a libertarian
direction. Such changes **can** come about very fast, as can be seen from
various communes all over the world where society is organised according to
libertarian principles. As Reich put it:

> _"We have learned that instead of a jump into the realm of the Children of
the Future, we can hope for no more than a steady advance, in which the
healthy new overlaps the sick old structure, with the new slowly outgrowing
the old."_ [**Children of the Future**, pp. 38-39]

By means of freedom-based child rearing and education, along with other
methods of consciousness raising, as well as encouraging resistance to the
existing social order anarchists hope to prepare the psychological foundation
for a social paradigm shift, from authoritarian to libertarian institutions
and values. And indeed, a gradual cultural evolution toward increasing freedom
does seem to exist. For example, as A.S. Neill suggested there is _"a slow
trend to freedom, sexual and otherwise. In my boyhood, a woman went bathing
wearing stockings and a long dress. Today, women show legs and bodies.
Children are getting more freedom with every generation. Today, only a few
lunatics put cayenne pepper on a baby's thumb to stop sucking. Today, only a
few countries beat their children in school."_ [**Summerhill**, p. 115]

Most anarchists believe that we must practice what we preach and so the
anarchist revolution begins at home. As anarchists raise their own children in
capitalist society and/or are involved in the raising and education of the
children of other parents, we can practice in part libertarian principles even
before the revolution. As such, we think it is important to discuss
libertarian child rearing.

## J.6.1 What are the main obstacles to raising free children?

The biggest obstacle is the training and character of most parents,
physicians, and educators. Individuals within a hierarchical society create
psychological walls/defences around themselves and these will obviously have
an effect both on the mental and physical state of the individual and so their
capacity for living a free life and experiencing pleasure. Such parents then
try (often unconsciously) to stifle the life-energy in children. There are,
for example, the child's natural vocal expressions (shouting, screaming,
bellowing, crying, etc.) and natural body motility. As Reich noted:

> _"Small children go through a phase of development characterised by vigorous
activity of the voice musculature. The joy the infant derives from loud noises
(crying, shrieking, and forming a variety of sounds) is regarded by many
parents as pathological aggressiveness. The children are accordingly
admonished not to scream, to be 'still,' etc. The impulses of the voice
apparatus are inhibited, its musculature becomes chronically contracted, and
the child becomes quiet, 'well-brought-up,' and withdrawn. The effect of such
mistreatment is soon manifested in eating disturbances, general apathy, pallor
of the face, etc. Speech disturbances and retardation of speech development
are presumably caused in this manner. In the adult we see the effects of such
mistreatment in the form of spasms of the throat. The automatic constrictions
of the glottis and the deep throat musculature, with subsequent inhibition of
the aggressive impulses of the head and neck, seems to be particularly
characteristic."_ [**Children of the Future**, p. 128]

_"Clinical experience has taught us,"_ Reich concluded, _"that small children
must be allowed to 'shout themselves out' when the shouting is inspired by
pleasure. This might be disagreeable to some parents, but questions of
education must be decided **exclusively in the interests of the child,** not
in those of the adults."_ [**Op. Cit.**, p. 128]

Besides deadening life energy in the body, such stifling also inhibits the
anxiety generated by the presence of anti-social, cruel, and perverse impulses
within the psyche -- for example, destructiveness, sadism, greed, power
hunger, brutality, etc. (impulses referred to by Reich as _"secondary"_
drives). In other words, this reduces our ability to empathise with others and
so the internal ethical guidelines we all develop are blunted, making us more
likely to express such secondary, anti-social, drives. So, ironically, these
secondary drives result from the **suppression of the primary drives** and the
sensations of pleasure associated with them. These secondary drives develop
because the only emotional expressions that can get through a person's
defences are distorted, harsh, and/or mechanical. In other words, compulsive
morality (i.e. acting according to externally imposed rules) becomes necessary
to control the secondary drives **which compulsion itself creates.** By such
processes, authoritarian child-rearing becomes self-justifying:

> _"Psychoanalysts have failed to distinguish between primary natural and
secondary perverse, cruel drives, and they are continuously killing nature in
the new-born while they try to extinguish the 'brutish little animal.' They
are completely ignorant of the fact that it is **exactly this killing of the
natural principle which creates the secondary perverse and cruel nature,**
human nature so called, and that these artificial cultural creations in turn
make compulsive moralism and brutal laws necessary."_ [Reich, **Op. Cit.**, p.
17-18]

Moralism, however, can never get at the root of the problem of secondary
drives, but in fact only increases the pressure of crime and guilt. The real
solution is to let children develop what Reich calls **natural self-
regulation.** This can be done only by not subjecting them to punishment,
coercion, threats, moralistic lectures and admonitions, withdrawal of love,
etc. in an attempt to inhibit their spontaneous expression of natural life-
impulses. The systematic development of the emphatic tendencies of the young
infant is the best way to "socialise" and restrict activities that are harmful
to the others. As A.S. Neill pointed out _"self-regulation implies a belief in
the goodness of human nature; a belief that there is not, and never was,
original sin."_ [**Summerhill**, p. 103]

According to Neill, children who are given freedom from birth and not forced
to conform to parental expectations spontaneously learn how to keep themselves
clean and develop social qualities like courtesy, common sense, an interest in
learning, respect for the rights of others, and so forth. However, once the
child has been armoured through authoritarian methods intended to **force** it
to develop such qualities, it becomes out of touch with its living core and
therefore no longer able to develop self-regulation. In this stage it becomes
harder and harder for the pro-social emotions to shape the developing mode of
life of the new member of society. At that point, when the secondary drives
develop, parental authoritarianism becomes a **necessity.**

This oppression produces an inability to tolerate freedom. The vast majority
of people develop this **automatically** from the way they are raised and is
what makes the whole subject of bringing up children of crucial importance to
anarchists. Reich concluded that if parents do not suppress nature in the
first place, then no anti-social drives will be created and no
authoritarianism will be required to suppress them: _"**What you so
desperately and vainly try to achieve by way of compulsion and admonition is
there in the new-born infant ready to live and function. Let it grow as nature
requires, and change our institutions accordingly**."_ [**Op. Cit.**, p. 47]
So in order to raise psychologically healthy children, parents need to acquire
self-knowledge, particularly of how internal conflicts develop in family
relationships, and to free themselves as much as possible from neurotic forms
of behaviour. The difficulty of parents acquiring such self-knowledge and
sufficiently de-conditioning themselves is obviously another obstacle to
raising self-regulated children.

However, the greatest obstacle is the fact that twisting mechanisms set in so
very early in life, i.e. soon after birth. Hence it is important for parents
to obtain a thorough knowledge of what rigid suppressions are and how they
function, so that from the beginning they can prevent (or at least decrease)
them from forming in their children. Finally, Reich cautioned that it is
crucial to avoid any mixing of concepts: _"One cannot mix a bit of self-
regulation with a bit of moral demand. Either we trust nature as basically
decent and self-regulatory or we do not, and then there is only one way, that
of training by compulsion. It is essential to grasp the fact that the two ways
of upbringing do not go together."_ [**Op. Cit.**, p. 46]

## J.6.2. What are some examples of libertarian child-rearing methods?

According to Reich, the problems of parenting a free child actually begin
before conception, with the need for a prospective mother to free herself as
much as possible from chronic muscular tensions. It has been found in many
studies that not only the physical health of the mother can influence the
foetus. Various psychological stresses influence the chemical and hormonal
environment, affecting the foetus.

Immediately after birth it is important for the mother to establish contact
with her child. This means, basically, constant loving attention to the baby,
expressed by plenty of holding, cuddling, playing, etc., and especially by
breast feeding. By such _"orgonotic"_ contact (to use Reich's term), the
mother is able to establish the initial emotional bonding with the new born,
and a non-verbal understanding of the child's needs. This is only possible,
however, if she is in touch with her own emotional and cognitive internal
processes: _"**Orgonotic contact is the most essential experiential and
emotional element in the interrelationship between mother and child,**
particularly prenatally and during the first days and weeks of life. The
future fate of the child depends on it. It seems to be the core of the new-
born infant's emotional development."_ [**Children of the Future**, p. 99] It
is important for the father to establish orgonotic contact as well.

Reich maintained that the practice of bottle feeding is harmful, particularly
if it completely replaces breast feeding from the day of birth, because it
eliminates one of the most important forms of establishing physical and
emotional contact between mother and child. This lack of contact can then
contribute in later life to _"oral"_ forms of neurotic character structure or
traits (see Chapter 9 of Alexander Lowen's **Physical Dynamics of Character
Structure**). Another harmful practice in infant care is the compulsive-
neurotic method of feeding children on schedule, invented by Pirquet in
Vienna, which was devastatingly wrong and harmful to countless children.
Frustration of oral needs through this practice (which is fortunately less in
vogue now than it was fifty years ago), is guaranteed to produce neurotic
armouring in infants. As Reich put it: _"As long as parents, doctors, and
educators approach infants with false, unbending behaviour, inflexible
opinions, condescension, and officiousness, instead of with orgonotic contact,
infants will continue to be quiet, withdrawn, apathetic, 'autistic,'
'peculiar,' and, later, 'little wild animals,' whom the cultivated feel they
have to 'tame.'"_ [**Op. Cit.** p. 124]

Another harmful practice is allowing the baby to "cry itself out." Thus:
_"Parking a baby in a baby carriage in the garden, perhaps for hours at a
time, is a dangerous practice. No one can know what agonising feelings of fear
and loneliness a baby can experience on waking up suddenly to find himself
alone in a strange place. Those who have heard a baby's screams on such
occasions have some idea of the cruelty of this stupid custom."_ [Neill,
**Summerhill**, p. 336] Indeed, in **The Physical Dynamics of Character
Structure**, Alexander Lowen has traced specific neuroses, particularly
depression, to this practice. Hospitals also have been guilty of
psychologically damaging sick infants by isolating them from their mothers, a
practice that has undoubtedly produced untold numbers of neurotics and
psychopaths.

Neill summed up the libertarian attitude toward the care of infants as
follows: _"**Self-regulation means the right of a baby to live freely without
outside authority in things psychic and somatic**. It means that the baby
feeds when it is hungry; that it becomes clean in habits only when it wants
to; that it is never stormed at nor spanked; that it is always loved and
protected."_ Obviously self-regulation does not mean leaving the baby alone
when it heads toward a cliff or starts playing with an electrical socket.
Libertarians do not advocate a lack of common sense. We recognise that adults
must override an infant's will when it is a question of protecting their
physical safety: _"Only a fool in charge of young children would allow
unbarred bedroom windows or an unprotected fire in the nursery. Yet, too
often, young enthusiasts for self-regulation come to my school as visitors,
and exclaim at our lack of freedom in locking poison in a lab closet, or our
prohibition about playing on the fire escape. The whole freedom movement is
marred and despised because so many advocates of freedom have not got their
feet on the ground."_ [**Op. Cit.**, p. 105 and p. 106]

Nevertheless, the libertarian position does not imply that a child should be
**punished** for getting into a dangerous situation. Nor is the best thing to
do in such a case to shout in alarm (unless that is the only way to warn the
child before it is too late), but simply to remove the danger without any
fuss: _"Unless a child is mentally defective, he will soon discover what
interests him. Left free from excited cries and angry voices, he will be
unbelievably sensible in his dealing with material of all kinds."_ [Neil,
**Op. Cit.**, p. 108] Provided, of course, that he or she has been allowed
self-regulation from the beginning, and thus has not developed any irrational,
secondary drives.

The way to raise a free child becomes clear when one considers how an
**un**free child is raised. Thus imagine the typical infant whose upbringing
A.S. Neill described:

> _"His natural functions were left alone during the diaper period. But when
he began to crawl and perform on the floor, words like **naughty** and
**dirty** began to float about the house, and a grim beginning was made in
teaching him to be clean._

> _"Before this, his hand had been taken away every time it touched his
genitals; and he soon came to associate the genital prohibition with the
acquired disgust about faeces. Thus, years later, when he became a travelling
salesman, his story repertoire consisted of a balanced number of sex and
toilet jokes._

> _"Much of his training was conditioned by relatives and neighbours. Mother
and father were most anxious to be correct -- to do the proper thing -- so
that when relatives or next-door neighbours came, John had to show himself as
a well-trained child. He had to say **Thank you** when Auntie gave him a piece
of chocolate; and he had to be most careful about his table manners; and
especially, he had to refrain from speaking when adults were speaking . . . _

> _"All his curiosity about the origins of life were met with clumsy lies,
lies so effective that his curiosity about life and birth disappeared. The
lies about life became combined with fears when at the age of five his mother
found him having genital play with his sister of four and the girl next door.
The severe spanking that followed (Father added to it when he came home from
work) forever conveyed to John the lesson that sex is filthy and sinful,
something one must not even think of."_ [**Op. Cit.**, p. 96-7]

Of course, parents' ways of imparting negative messages about sex are not
necessarily this severe, especially in our allegedly enlightened age. However,
it is not necessary for a child to be spanked or even scolded or lectured in
order to acquire a sex-negative attitude. Children are very intuitive and will
receive the message "sex is bad" from subtle parental cues like facial
expressions, tone of voice, embarrassed silence, avoidance of certain topics,
etc. Mere "toleration" of sexual curiosity and play is far different in its
psychological effects from positive affirmation.

Along the same lines, to prevent the formation of sex-negative attitudes means
that nakedness should never be discouraged: _"The baby should see its parents
naked from the beginning. However, the child should be told when he is ready
to understand that some people don't like to see children naked and that, in
the presence of such people, he should wear clothes."_ Neill maintains that
not only should parents never spank or punish a child for genital play, but
that spanking and other forms of punishment should never be used in **any**
circumstances, because they instil fear, turning children into cowards and
often leading to phobias. _"Fear must be entirely eliminated -- fear of
adults, fear of punishment, fear of disapproval, fear of God. Only hate can
flourish in an atmosphere of fear."_ Punishment also turns children into
sadists: _"The cruelty of many children springs from the cruelty that has been
practised on them by adults. You cannot be beaten without wishing to beat
someone else."_ (_"Every beating makes a child sadistic in desire or
practice."_ [Neil **Op. Cit.**, p. 229, p. 124, p. 269 and p. 271] This is
obviously an important consideration to anarchists, as sadistic drives provide
the psychological ground for militarism, war, police brutality, and so on.
Such drives are undoubtedly also part of the desire to exercise hierarchical
authority, with its possibilities for using negative sanctions against
subordinates as an outlet for sadistic impulses.

Child beating is particularly cowardly because it is a way for adults to vent
their hatred, frustration, and sadism on those who are unable to defend
themselves. Such cruelty is, of course, always rationalised with excuse like
"it hurts me more than it does you," etc., or explained in moral terms, like
"I don't want my boy to be soft" or "I want him to prepare him for a harsh
world" or "I spank my children because my parents spanked me, and it did me a
hell of a lot of good." But despite such rationalisations, the fact remains
that punishment is always an act of hate. To this hate the child responds in
kind by hating the parents, followed by fantasy, guilt, and repression. For
example, the child may fantasise the father's death, which immediately causes
guilt, and so is repressed. Often the hatred induced by punishment emerges in
fantasies that are seemingly remote from the parents, such as stories of giant
killing -- always popular with children because the giant represents the
father. Obviously, the sense of guilt produced by such fantasies is very
advantageous to organised religions that promise redemption from "sin." It is
surely no coincidence that such religions are enthusiastic promoters of the
sex-negative morality and disciplinarian child rearing practices that keep
supplying them with recruits.

What is worse, however, is that punishment actually **creates** "problem
children." This is so because the parent arouses more and more hatred (and
diminishing trust in other human beings) in the child with each spanking,
which is expressed in still worse behaviour, calling for more spankings, and
so on, in a vicious circle. In contrast, the _"self-regulated child does not
need any punishment,"_ Neill argued, _"and he does not go through this hate
cycle. He is never punished and he does not need to behave badly. He has no
use for lying and for breaking things. His body has never been called filthy
or wicked. He has not needed to rebel against authority or to fear his
parents. Tantrums he will usually have, but they will be short-lived and not
tend toward neurosis."_ [**Op. Cit.**, p. 166]

We could cite many further examples of how libertarian principles of child-
rearing can be applied in practice, but we must limit ourselves to these few.
The basic principles can be summed up as follows: Get rid of authority,
moralising, and the desire to "improve" and "civilise" children. Allow them to
be themselves, without pushing them around, bribing, threatening, admonishing,
lecturing, or otherwise forcing them to do anything. Refrain from action
unless the child, by expressing their "freedom" restricts the freedom of
others and **explain** what is wrong about such actions and never mechanically
punish.

This is, of course, a radical philosophy, which few parents are willing to
follow. It is quite amazing how people who call themselves libertarians in
political and economic matters draw the line when it comes to their behaviour
within the family -- as if such behaviour had no wider social consequences!

## J.6.3 If children have nothing to fear, how can they be good?

Obedience that is based on fear of punishment, this-worldly or other-worldly,
is not really goodness, it is merely cowardice. True morality (i.e. respect
for others and one-self) comes from inner conviction based on experience, it
cannot be imposed from without by fear. Nor can it be inspired by hope of
reward, such as praise or the promise of heaven, which is simply bribery. If
children are given as much freedom as possible from the day of birth, if
parents respect them as individuals and give a positive example as well as not
being forced to conform to parental expectations, they will spontaneously
learn the basic principles of social behaviour, such as cleanliness, courtesy,
and so forth. But they must be allowed to develop them **at their own speed,**
at the natural stage of their growth, not when parents think they should
develop them. What is "natural" timing must be discovered by observation, not
by defining it a priori based on one's own expectations.

Can a child really be taught to keep themselves clean without being punished
for getting dirty? According to many psychologists, it is not only possible
but **vitally important** for the child's mental health to do so, since
punishment will give the child a fixed and repressed interest in their bodily
functions. As Reich and Lowen have shown various forms of compulsive and
obsessive neuroses can be traced back to the punishments used in toilet
training. As Neill observed: _"When the mother says **naughty** or **dirty**
or even **tut tut**, the element of right and wrong arises. The question
becomes a **moral** one -- when it should remain a **physical** one."_ He
suggested that the **wrong** way to deal with a child who likes to play with
faeces is to tell him he is being dirty. The right way _"is to allow him to
live out his interest in excrement by providing him with mud or clay. In this
way, he will sublimate his interest without repression. He will live through
his interest; and in doing so, kill it."_ [**Summerhill**, p. 174]

Similarly, sceptics will probably question how children can be induced to eat
a healthy diet without threats of punishment. The answer can be discovered by
a simple experiment: set out on the table all kinds of foods, from sweets and
ice cream to whole wheat bread, lettuce, sprouts, and so on, and allow the
child complete freedom to choose what is desired or to eat nothing at all if
he or she is not hungry. Parents will find that the average child will begin
choosing a balanced diet after about a week, after the desire for prohibited
or restricted foods has been satisfied. This is an example of what can be
called "trusting nature." That the question of how to "train" a child to eat
properly should even be an issue says volumes about how little the concept of
freedom for children is accepted or even understood, in our society.
Unfortunately, the concept of "training" still holds the field in this and
most other areas.

The disciplinarian argument that that children must be **forced** to respect
possessions is also defective, because it always requires some sacrifice of a
child's play life (and childhood should be devoted to play, not to "preparing
for adulthood," because playing is what children spontaneously do). The
libertarian view is that a child should arrive at a sense of value out of his
or her own free choice. This means not scolding or punishing them for breaking
or damaging things. As they grow out of the stage of preadolescent
indifference to possessions, they learn to respect it naturally.

"But shouldn't a child at least be punished for stealing?" it will be asked.
Once again, the answer lies in the idea of trusting nature. The concept of
"mine" and "yours" is adult, and children naturally develop it as they become
mature, but not before. This means that normal children will "steal" -- though
that is not how they regard it. They are simply trying to satisfy their
acquisitive impulses; or, if they are with friends, their desire for
adventure. In a society so thoroughly steeped in the idea of respect for
property as ours, it is no doubt difficult for parents to resist societal
pressure to punish children for "stealing." The reward for such trust,
however, will be a child who grows into a healthy adolescent who respects the
possessions of others, not out of a cowardly fear of punishment but from his
or her own self-nature.

Most parents believe that, besides taking care of their child's physical
needs, the teaching of ethical/moral values is their main responsibility and
that without such teaching the child will grow up to be a "little wild animal"
who acts on every whim, with no consideration for others. This idea arises
mainly from the fact that most people in our society believe, at least
passively, that human beings are naturally bad and that unless they are
"trained" to be good they will be lazy, mean, violent, or even murderous.
This, of course, is essentially the idea of "original sin" and because of its
widespread acceptance, nearly all adults believe that it is their job to
"improve" children. Yet according to libertarian psychologists there is no
original sin. In fact, it would be more accurate to say that there is
"original virtue." Wilhelm Reich found that externally imposed, compulsive
morality actually **causes** immoral behaviour by creating cruel and perverse
_"secondary drives."_ Neill put it this way: _"I find that when I smash the
moral instruction a bad boy has received, he becomes a good boy."_ [**Op.
Cit.**, p. 250]

Unconscious acceptance of some form of the idea of original sin is the main
recruiting tool of organised religions, as people who believe they are born
"sinners" feel a strong sense of guilt and need for redemption. Parents to
should eliminate any need for redemption, by telling the child that he is born
good, not born bad. This will help keep them from falling under the influence
of life-denying religions, which are inimical to the growth of a healthy
character structure. Citing ethnological studies, Reich argued the following:

> _"Among those primitive peoples who lead satisfactory, unimpaired sexual
lives, there is no sexual crime, no sexual perversion, no sexual brutality
between man and woman; rape is unthinkable because it is unnecessary in their
society. Their sexual activity flows in normal, well-ordered channels which
would fill any cleric with indignation and fear . . . They love the human body
and take pleasure in their sexuality. They do not understand why young men and
women should not enjoy their sexuality. But when their lives are invaded by
the ascetic, hypocritical morass and by the Church, which bring them 'culture'
along with exploitation, alcohol, and syphilis, they begin to suffer the same
wretchedness as ourselves. They begin to lead 'moral' lives, i.e. to suppress
their sexuality, and from then on they decline more and more into a state of
sexual distress, which is the result of sexual suppression. At the same time,
they become sexually dangerous; murders of spouses, sexual diseases, and
crimes of all sorts start to appear."_ [**Children of the Future**, p. 193]

Such crimes in our society would be greatly reduced if libertarian child
rearing practices were widely followed. These are obviously important
considerations for anarchists, who are frequently asked to explain how crime
can be prevented in an anarchist society. The answer is that if people are not
suppressed during childhood there will be far less anti-social behaviour,
because the secondary-drive structure that leads to it will not be created in
the first place. In other words, the solution to the so-called crime problem
is not more police, more laws, or a return to the disciplinarianism of
"traditional family values," as conservatives claim, but depends mainly on
**getting rid** of such values.

There are other problems as well with the moralism taught by organised
religions. One danger is making the child a hater: _"If a child is taught that
certain things are sinful, his love of life must be changed to hate. When
children are free, they never think of another child as being a sinner."_
[Neill, **Op. Cit.**, p. 245] From the idea that certain people are sinners,
it is a short step to the idea that certain classes or races of people are
more "sinful" than others, leading to prejudice, discrimination, and
persecution of minorities as an outlet for repressed anger and sadistic drives
-- drives that are created in the first place by moralistic training during
early childhood. Once again, the relevance for anarchism is obvious.

A further danger of religious instruction is the development of a fear of
life: _"Religion to a child most always means only fear. God is a mighty man
with holes in his eyelids: He can see you wherever you are. To a child, this
often means that God can see what is being done under the bedclothes. And to
introduce fear into a child's life is the worst of all crimes. Forever the
child says nay to life; forever he is an inferior; forever a coward."_ [Neill,
**Op. Cit.**, p. 246] People who have been threatened with fear of an
afterlife in hell can never be entirely free of neurotic anxiety about
security in **this** life. In turn, such people become easy targets of ruling-
class propaganda that plays upon their material and emotional insecurity, e.g.
the rationalisation of imperialist wars, the Military-Industrial Complex,
increased state powers, and so on as necessary to "preserve jobs", for
security against external threats and so forth.

## J.6.3 But how will a free child ever learn unselfishness?

Another common objection to self-regulation is that children can only be
taught to be **"unselfish"** through punishment and admonition. Again,
however, such a view comes from a distrust of nature and is part of the common
attitude that nature is mere "raw material" to be shaped by human beings
according to their own wishes. The libertarian attitude is that empathy for
others develops at the proper time:

> _"To ask a child to be unselfish is wrong. Every child is an egoist and the
world belongs to him. When he has an apple, his one wish is to eat that apple.
The chief result of mother's encouraging him to share it with his little
brother is to make him hate the little brother. Altruism comes later -- comes
naturally -- **if the child is not taught to be unselfish.** It probably never
comes at all if the child has been forced to be unselfish. By suppressing the
child's selfishness, the mother is fixing that selfishness forever."_ [Neill,
**Summerhill**, pp. 250-251]

Unfulfilled wishes live on in the unconscious so children who are pressured
too hard -- "taught" -- to be unselfish will, while conforming outwardly with
parental demands, unconsciously repress part of their real, selfish wishes,
and these repressed infantile desires will make the person selfish (and
possibly neurotic) throughout life. Moreover, telling children that what they
want to do is "wrong" or "bad" is equivalent to teaching them to hate
themselves, and it is a well-known principle of psychology that people who do
not love themselves cannot love others. Thus moral instruction, although it
aims to develop altruism and love for others, is actually self-defeating,
having just the opposite result. Moreover, such attempts to produce
"unselfish" children (and so adults) actually works **against** developing the
individuality of the child and they developing their own abilities (in
particular their ability of critical thought). As Erich Fromm put it:

> _"Not to be selfish implies not to do what one wishes, to give up one's own
wishes for the sake of those in authority . . . Aside from its obvious
implication, it means 'don't love yourself,' 'don't be yourself', but submit
yourself to something more important than yourself, to an outside power or its
internalisation, 'duty.' 'Don't be selfish' becomes one of the most powerful
ideological tools in suppressing spontaneity and the free development of
personality. Under the pressure of this slogan one is asked for every
sacrifice and for complete submission: only those acts are 'unselfish' which
do not serve the individual but somebody or something outside himself."_
[**Man for Himself**, p. 127]

While such "unselfishness" is ideal for creating "model citizens" and willing
wage slaves, it is not conducive for creating anarchists or even developing
individuality. Little wonder Bakunin celebrated the urge to rebel and saw it
as the key to human progress! Fromm goes on to note that selfishness and self-
love, _"far from being identical, are actually opposites"_ and that _"selfish
persons are incapable of loving others . . . [or] loving themselves."_ [**Op.
Cit.**, p. 131] Individuals who do not love themselves, and so others, will be
more willing to submit themselves to hierarchy than those who do love
themselves and are concerned for their own, and others, welfare. Thus the
contradictory nature of capitalism, with its contradictory appeals to selfish
and unselfish behaviour, can be understood as being based upon lack of self-
love, a lack which is promoted in childhood and one which libertarians should
be aware of and combat.

Indeed, much of the urge to "teach children unselfishness" is actually an
expression of adults' will to power. Whenever parents feel the urge to impose
directives on their children, they would be wise to ask themselves whether the
impulse comes from their own power drive or their own selfishness. For, since
our culture strongly conditions us to seek power over others, what could be
more convenient than having a small, weak person at hand who cannot resist
one's will to power? Instead of issuing directives, libertarians believe in
letting social behaviour develop naturally, which it will do after other
people's opinions becomes important **to the child.** As Neill pointed out:

> _"Everyone seeks the good opinion of his neighbours. Unless other forces
push him into unsocial behaviour, a child will naturally want to do that which
will cause him to be well-regarded, but this desire to please others develops
at a certain stage in his growth. The attempt by parents and teachers to
artificially accelerate this stage does the child irreparable damage."_ [**Op.
Cit.**, p. 256]

Therefore, parents should allow children to be "selfish" and "ungiving", free
to follow their own childish interests throughout their childhood. Every
interpersonal conflict of interest should be grounds for a lesson in dignity
on one side and consideration on the other. Only by this process can a child
develop their individuality. By so doing they will come to recognise the
individuality of others and this is the first step in developing ethical
concepts (which rest upon mutual respect for others and their individuality).

## J.6.4 Isn't "libertarian child-rearing" just another name for spoiling the
child?

No. This objection confuses the distinction between freedom and license. To
raise a child in freedom does not mean letting him or her walk all over you or
others; it does not mean never saying "no." It is true that free children are
not subjected to punishment, irrational authority, or moralistic admonitions,
but they are not "free" to violate the rights of others. As Neill put it: _"in
the disciplined home, the children have **no** rights. In the spoiled home,
they have **all** the rights. The proper home is one in which children and
adults have equal rights."_ Or again: _"To let a child have his own way, or do
what he wants to **at another's expense,** is bad for the child. It creates a
spoiled child, and the spoiled child is a bad citizen."_ [**Summerhill**, p.
107 and 167]

There will inevitably be conflicts of will between parents and children, and
the healthy way to resolve them is discussion and coming to an agreement. The
unhealthy ways are either to resort to authoritarian discipline or to spoil
the child by allowing them to have all the social rights. Libertarian
psychologists argue that no harm is done to children by insisting on one's
individual rights, but that the harm comes from moralism, i.e. when one
introduces the concepts of right and wrong or words like "naughty," "bad," or
"dirty," which produce guilt.

Therefore it should not be thought that free children are free to "do as they
please." Freedom means doing what one likes so long as it does not infringe on
the freedom of others. Thus there is a big difference between compelling a
child to stop throwing stones at others and compelling him or her to learn
geometry. Throwing stones infringes on others' rights, but learning geometry
involves only the child. The same goes for forcing children to eat with a fork
instead of their fingers; to say "please" and "thank you"; to tidy up their
rooms, and so on. Bad manners and untidiness may be annoying to adults, but
they are not a violation of adults' rights. One could, of course, define an
adult "right" to be free of annoyance from **anything** one's child does, but
this would simply be a license for authoritarianism, emptying the concept of
children's rights of all content.

As mentioned, giving children freedom does not mean allowing them to endanger
themselves physically. For example, a sick child should not be asked to decide
whether he wants to go outdoors or take his prescribed medicine, nor a run-
down and overtired child whether she wants to go to bed. But the imposition of
such forms of necessary authority is compatible with the idea that children
should be given as much responsibility as they can handle at their particular
age. Only in this way can they develop self-assurance. And, again, it is
important for parents to examine their own motives when deciding how much
responsibility to give their child. Parents who insist on choosing their
children's clothes for them, for example, are generally worried that the child
might select clothes that would reflect badly on their parents' social
standing.

As for those who equate "discipline" in the home with "obedience," the latter
is usually required of a child to satisfy the adults' desire for power. Self-
regulation means that there are no power games being played with children, no
loud voice saying "You'll do it because I say so, or else!" But, although this
irrational, power-seeking kind of authority is absent in the libertarian home,
there still remains what can be called a kind of "authority," namely adult
protection, care, and responsibility, as well as the insistence on one's own
rights. As Neill observed: _"Such authority sometimes demands obedience but at
other times gives obedience. Thus I can say to my daughter, 'You can't bring
that mud and water into our parlour.' That's no more than her saying to me,
'Get out of my room, Daddy. I don't want you here now,' a wish that I, of
course, obey without a word."_ [**Op. Cit.**, p. 156]. So there will still be
"discipline" in the libertarian home, but it will be of the kind that protects
the individual rights of each family member.

Raising children in freedom also does not imply giving them a lot of toys,
money, and so on. Reich's followers have argued that children should not be
given everything they ask for and that it is better to give them too little
than too much. Under constant bombardment by commercial advertising campaigns,
parents today generally tend to give their children far too much, with the
result that the children stop appreciating gifts and rarely value any of their
possessions. This same applies to money, which, if given in excess, can be
detrimental to children's' creativity and play life. If children are not given
too many toys, they will derive creative joy out of making their own toys out
of whatever free materials are at hand -- a joy of which they are robbed by
overindulgence. Psychologists point out that parents who give too many
presents are often trying to compensate for giving too little love.

There is less danger in rewarding children than there is in punishing them,
but rewards can still undermine a child's morale. This is because, firstly,
rewards are superfluous and in fact often **decrease** motivation and
creativity, as several psychological studies have shown (see [section
I.4.11](secI4.md#seci411)). Creative people work for the pleasure of
creating; monetary interests are not central (or necessary) to the creative
process. Secondly, rewards send the wrong message, namely, that doing the deed
for which the reward is offered is not worth doing for its own sake and the
pleasure associated with productive, creative activity. Thirdly, rewards tend
to reinforce the worst aspects of the competitive system, leading to the
attitude that money is the only thing which can motivate people to do the work
that needs doing in society.

These are just a few of the considerations that enter into the distinction
between spoiling children and raising them in freedom. In reality, it is the
punishment and fear of a disciplinarian home that **spoils** children in the
most literal sense, by destroying their childhood happiness and creating
warped personalities. As adults, the victims of disciplinarianism will
generally be burdened with one or more anti-social secondary drives such as
sadism, destructive urges, greed, sexual perversions, etc., as well as
repressed rage and fear. The presence of such impulses just below the surface
of consciousness causes anxiety, which is automatically defended against by
psychological walls which leave the person stiff, frustrated, bitter and
burdened with feelings of inner emptiness. In such a condition people easily
fall victim to the capitalist gospel of super-consumption, which promises that
money will enable them to fill the inner void by purchasing commodities -- a
promise that, of course, is hollow.

The neurotically enclosed person also tends to look for scapegoats on whom to
blame his or her frustration and anxiety and against whom repressed rage can
be vented. Reactionary politicians know very well how to direct such impulses
against minorities or "hostile nations" with propaganda designed to serve the
interests of the ruling elite. Most importantly, however, the respect for
authority combined with sadistic impulses which is acquired from a
disciplinarian upbringing typically produces a submissive/authoritarian
personality -- a man or woman who blindly follows the orders of "superiors"
while at the same time desiring to exercise authority on "subordinates,"
whether in the family, the state bureaucracy, or the company. Ervin Staub's
**Roots of Evil** includes interviews of imprisoned SS men, who, in the course
of extensive interviews (meant to determine how ostensibly "normal" people
could perform acts of untold ruthlessness and violence) revealed that they
overwhelmingly came from authoritarian, disciplinarian homes.

In this way, the "traditional" (e.g., authoritarian, disciplinarian,
patriarchal) family is the necessary foundation for authoritarian
civilisation, reproducing it and its attendant social evils from generation to
generation.

## J.6.5 What is the anarchist position on teenage sexual liberation?

One of the biggest problems of adolescence is sexual suppression by parents
and society in general. The teenage years are the time when sexual energy is
at its height. Why, then, the absurd demand that teenagers "wait until
marriage," or at least until leaving home, before becoming sexually active?
Why are there laws in "advanced" countries like the United States that allow a
19-year-old "boy" who makes love with his 17-year-old girlfriend, with her
full consent, to be **arrested** by the girl's parents (!) for "statutory
rape"?

To answer such questions, let us recall that the ruling class is not
interested in encouraging mass tendencies toward liberty, independence and
pleasure not derived from commodities but instead supports whatever
contributes to mass submissiveness, docility, dependence, helplessness, and
respect for authority -- traits that perpetuate the hierarchies on which
ruling-class power and privileges depend.

As sex is one of the most intense forms of pleasure and one of the most
prominent contributors for intimacy and bonding with people emotionally,
repression of sexuality is the most powerful means of psychologically
crippling people and giving them a submissive/authoritarian character
structure (as well as alienating people from each other). As Reich observed,
such a character is composed of a mixture of _"sexual impotence, helplessness,
a need for attachments, a nostalgia for a leader, fear of authority, timidity,
and mysticism"_ and _"people structured in this manner are incapable of
democracy. All attempts to build up or maintain genuine democratically
directed organisations come to grief when they encounter these character
structures. They form the psychological soil of the masses in which
dictatorial strivings and bureaucratic tendencies of democratically elected
leaders can develop."_ Sexual suppression _"produces the authority-fearing,
life-fearing vassal, and thus constantly creates new possibilities whereby a
handful of men in power can rule the masses."_ [**The Sexual Revolution**, p.
82]

No doubt most members of the ruling elite are not fully conscious that their
own power and privileges depend on the mass perpetuation of sex-negative
attitudes. Nevertheless, they unconsciously sense it. Sexual freedom is the
most basic and powerful kind, and every conservative or reactionary
instinctively shudders at the thought of the "social chaos" it would unleash
-- that is, the rebellious, authority-defying type of character it would
nourish. This is why "family values," and "religion" (i.e. discipline and
compulsive sexual morality) are the mainstays of the conservative/reactionary
agenda. Thus it is crucially important for anarchists to address every aspect
of sexual suppression in society. This means affirming the right of
adolescents to an unrestricted sex life.

There are numerous arguments for teenage sexual liberation. For example, many
teen suicides could be prevented by removing the restrictions on adolescent
sexuality. This becomes clear from ethnological studies of sexually
unrepressive tribal peoples:

> _"All reports, whether by missionaries or scholars, with or without the
proper indignation about the 'moral depravity' of 'savages,' state that the
puberty rites of adolescents lead them immediately into a sexual life; that
some of these primitive societies lay great emphasis on sexual pleasure; that
the puberty rite is an important social event; that some primitive peoples not
only do not hinder the sexual life of adolescents but encourage it is every
way, as, for instance, by arranging for community houses in which the
adolescents settle at the start of puberty in order to be able to enjoy sexual
intercourse. Even in those primitive societies in which the institution of
strict monogamous marriage exists, adolescents are given complete freedom to
enjoy sexual intercourse from the beginning of puberty to marriage. None of
these reports contains any indication of sexual misery or suicide by
adolescents suffering from unrequited love (although the latter does of course
occur). The contradiction between sexual maturity and the absence of genital
sexual gratification is non-existent."_ [Reich, **Op. Cit.**, p. 85]

Teenage sexual repression is also closely connected with crime. If there are
teenagers in a neighbourhood who have no place to pursue intimate sexual
relationships, they will do it in dark corners, in cars or vans, etc., always
on the alert and anxious lest someone discover them. Under such conditions,
full gratification is impossible, leading to a build-up of tension and
frustration. Thus they feel unsatisfied, disturb each other, become jealous
and angry, get into fights, turn to drugs as a substitute for a satisfying sex
life, vandalise property to let off "steam" (repressed rage), or even murder
someone. As Reich noted, _"juvenile delinquency is the visible expression of
the subterranean sexual crisis in the lives of children and adolescents. And
it may be predicted that no society will ever succeed in solving this problem,
the problem of juvenile psychopathology, unless that society can muster the
courage and acquire the knowledge to regulate the sexual life of its children
and adolescents in a sex-affirmative manner."_ [**Op. Cit.**, p. 271]

For these reasons, it is clear that a solution to the "gang problem" also
depends on adolescent sexual liberation. We are not suggesting, of course,
that gangs themselves suppress sexual activity. Indeed, one of their main
attractions to teens is undoubtedly the hope of more opportunities for sex as
a gang member. However, gangs' typical obsessiveness with the promiscuous,
pornographic, sadistic, and other "dark" aspects of sex shows that by the time
children reach gang age they have already developed unhealthy secondary drives
due to the generally sex-negative and repressive environment in which they
have grown up. The expression of such drives is **not** what anarchists mean
by "sexual freedom." Rather, anarchist proposals for teenage liberation are
based on the premise that a libertarian childhood is the necessary condition
for a **healthy** sexual freedom in adolescence.

Applying these insights to our own society, it is clear that teenagers should
have ample access to a private room where they can be undisturbed with their
sexual partners. Parents should also encourage the knowledge and use of
contraceptives and safe sex in general as well as respect for the other person
involved in the relationship. This does not mean encouraging promiscuity or
sex for the sake of it. Rather, it means encouraging teenagers to know their
own minds and desires, refusing to be pressured by anyone into anything. As
can be seen from experience of this anarchist activist during the 1930s:

> _"One time, a companero from the Juventudes [libertarian youth organisation]
came over to me and said, 'You, who say you're so liberated. You're not so
liberated.' (I'm telling you this so you’ll see the mentality of these men.)
'Because if I ask you to give me a kiss, you wouldn't._

> _"I just stood there staring at him, and thinking to myself, 'How do I get
out of this one?" And then I said to him, 'Listen, when I want to go to bed
with a guy, I'm the one that has to choose him. I don't go to bed with just
anyone. You don't interest me as a man. I don't feel anything for you... Why
should you want me to 'liberate myself,' as you put it, by going to bed with
you? That's no liberation for me. That's just making love simply for the sake
of making love.' 'No,' I said to him, 'love is something that has to be like
eating: if you're hungry, you eat, and if you want to go to bed with a guy,
then... Besides, I'm going to tell you something else . . . Your mouth doesn't
appeal to me... And I don't like to make love with a guy without kissing
him.'_

> _"He was left speechless! But I did it with a dual purpose in mind...
because I wanted to show him that that's not the way to educate companeros...
That's what the struggle of women was like in Spain -- even with men from our
own group -- and I'm not even talking about what it was like with other
guys."_ [quoted by Martha A. Ackelsberg, **Free Women of Spain**, pp. 116-7]

So respecting yourself and others, it must be stressed, is essential. As
Maurice Brinton pointed out, attempts at sexual liberation will encounter two
kinds of responses from established society -- direct opposition and attempts
at recuperation. The second response takes the form of _"first alienating and
reifying sexuality, and then of frenetically exploiting this empty shell for
commercial ends. As modern youth breaks out of the dual stranglehold of
repressive traditional morality and of the authoritarian patriarchal family it
encounters a projected image of free sexuality which is in fact a manipulatory
distortion of it."_ This can be seen from the use of sex in advertising to the
successful development of sex into a major consumer industry. However, such a
development is the opposite of the healthy sexuality desired by anarchists.
This is because _"sex is presented as something to be consumed. But the sexual
instinct differs from certain other instincts"_ as it can be satisfied only by
_"another human being, capable of thinking, acting, suffering. The alienation
of sexuality under the conditions of modern capitalism is very much part of
the general alienating process, in which people are converted into objects (in
this case, objects of sexual consumption) and relationships are drained of
human content. Undiscriminating, compulsive sexual activity, is not sexual
freedom -- although it may sometimes be a preparation for it (which repressive
morality can never be). The illusion that alienated sex is sexual freedom
constitutes yet another obstacle on the road to total emancipation. Sexual
freedom implies a realisation and understanding of the autonomy of others."_
[_"The Irrational in Politics"_, pp. 257-92, **For Workers' Power**, p. 277]

Therefore, anarchists see teenage sexual liberation as a means of developing
free individuals **as well as** reducing the evil effects of sexual repression
(which, we must note, also helps dehumanise individuals by encouraging the
objectification of others, and in a patriarchal society particularly of
women).

## J.6.6 But isn't this concern with sexual liberation just a distraction from
revolution?

It would be insulting to teenagers to suggest that sexual freedom is, or
should be, their **only** concern. Many teens have a well-developed social
conscience and are keenly interested in problems of economic exploitation,
poverty, social breakdown, environmental degradation, and the like. The same
can be said of people of any age!

It is essential for anarchists to guard against the attitude typically found
in Marxist-Leninist parties that spontaneous discussions about sexual problems
are a "diversion from the class struggle." Such an attitude is economistic
(not to mention covertly ascetic), because it is based on the premise that
economic class must be the focus of all revolutionary efforts toward social
change. No doubt transforming the economy is important, but without mass
sexual liberation no working class revolution can be complete as there will
not be enough people around with the character structures necessary to create
a **lasting** self-managed society and economy (i.e., people who are capable
of accepting freedom with responsibility). Instead, the attempt to force the
creation of such a system without preparing the necessary psychological soil
for its growth will lead to a reversion to some new form of hierarchy and
exploitation. Equally, society would be "free" in name only if repressive
social morals existed and people were not able to express themselves as they
so desire.

Moreover, for many people breaking free from the sexual suppression that
threatens to cripple them psychologically is a major issue in their lives. For
this reason, few of them are likely to be attracted to the anarchist "freedom"
movement if its exponents limit themselves to dry discussions of surplus
value, alienated labour, and so forth. Instead, addressing sexual questions
and problems must be integrated into a multi-faceted attack on the total
system of domination. People should feel confident that anarchists are on the
side of sexual pleasure and are not revolutionary ascetics demanding self-
denial for the "sake of the revolution." Rather, it should be stressed that
the capacity for full sexual enjoyment is an essential part of the revolution.
Indeed, _"incessant questioning and challenge to authority on the subject of
sex and of the compulsive family can only complement the questioning and
challenge to authority in other areas (for instance on the subject of who is
to dominate the work process -- or the purpose of work itself). Both
challenges stress the autonomy of individuals and their domination over
important aspects of their lives. Both expose the alienated concepts which
pass for rationality and which govern so much of our thinking and behaviour.
The task of the conscious revolutionary is to make both challenges explicit,
to point out their deeply subversive content, and to explain their inter-
relation."_ [Maurice Brinton, _"The Irrational in Politics"_, pp. 257-92,
**For Workers' Power**, p. 278]

We noted previously that in pre-patriarchal society, which rests on a
communistic/communal social order, children have complete sexual freedom and
that the idea of childhood asceticism develops as such societies turn toward
patriarchy in the economic and social structure (see [section
B.1.5](secB1.md#secb15)). This sea-change in social attitudes toward
sexuality allows the authority-oriented character structure to develop instead
of the formerly non-authoritarian ones. Ethnological research has shown that
in pre-patriarchal societies the general nature of work life in the community
corresponds with the free development of children and adolescents -- that is,
there are no rules coercing children and adolescents into specific forms of
sexual life, and this creates the psychological basis for voluntary
integration into the community and voluntary discipline in all forms of
collective activity. This supports the premise that widespread sex-positive
attitudes are a necessary condition of a viable libertarian socialism.

Psychology also clearly shows that every impediment to free expression of
children by parents, teachers, or administrative authorities must be stopped.
As anarchists, our preferred way of doing so is by direct action. Thus we
should encourage all to feel that they have every chance of building their own
personal lives. This will certainly not be an obstacle to or a distraction
from their involvement in the anarchist movement. On the contrary, if they can
gradually solve the problems facing their private lives, they will work on
other social projects with greatly increased pleasure and concentration.

Besides engaging in direct action, anarchists can also support legal
protection for free expression and sexuality (repeal of the insane statutory
rape laws and equal rights for gays, for example), just as they support
legislation that protects workers' right to strike, family leave, and so
forth. However, as Reich observed, _"under no circumstances will the new order
of sexual life be established by the decree of a central authority."_ [**The
Sexual Revolution**, p. 279] That was a Leninist illusion. Rather, it will be
established from the bottom up, by the gradual process of ever more widespread
dissemination of knowledge about the adverse personal and social effects of
sexual repression, and the benefits of libertarian child-rearing and
educational methods.

A society in which people are capable of sexual happiness will be one where
they prefer to _"make love, not war,"_ and so will provide the best guarantee
for the general security. Then the anarchist project of restructuring the
economic and political systems will proceed spontaneously, based on a spirit
of joy rather than hatred and revenge. Only then can it be defended against
reactionary threats, because the majority will be on the side of freedom and
capable of using it responsibly, rather than unconsciously longing for an
authoritarian father-figure to tell them what to do.

Therefore, concern and action upon sexual liberation, libertarian child
rearing and libertarian education are **key** parts of social struggle and
change. In no way can they be considered as "distractions" from "important"
political and economic issues as some "serious" revolutionaries like to claim.
As Martha A. Ackelsberg notes in relation to the practical work done by the
**_Mujeres Libres_** group during the Spanish Revolution:

> _"Respecting children and educating them well was vitally important to the
process of revolutionary change. Ignorance made people particularly vulnerable
to oppression and suffering. More importantly, education prepared people for
social life. Authoritarian schools (or families), based upon fear, prepared
people to be submissive to an authoritarian government [or within a capitalist
workplace]. Different schools and families would be necessary to prepare
people to live in a society without domination."_ [**Free Women of Spain**, p.
133]

The personal **is** political and there is little point in producing a free
economy if the people in it are not free to lead a full and pleasurable life!
As such, the issue of sexual freedom is as important as economic and social
freedom for anarchists. This can be seen when Emma Goldman recounted meeting
Kropotkin who praised a paper she was involved with but proclaimed _"it would
do more if it would not waste so much space discussing sex."_ She disagreed
and a heated argument ensued about _"the place of the sex problem in anarchist
propaganda."_ Finally, she remarked _"All right, dear comrade, when I have
reached your age, the sex question may no longer be of importance to me. But
it is now, and it is a tremendous factor for thousands, millions even, of
young people."_ This, Goldman recalled, made Kropotkin stop short with _"an
amused smile lighting up his kindly face. 'Fancy, I didn't think of that,' he
replied. 'Perhaps you are right, after all.' He beamed affectionately upon me,
with a humorous twinkle in his eye."_ [**Living My Life**, vol. 1, p. 253]

[‹ J.5 What alternative social organisations do anarchists create?](secJ5.md
"Go to previous page" ) [up](secJcon.md "Go to parent page" ) [J.7 What do
anarchists mean by "social revolution"? ›](secJ7.md "Go to next page" )

