/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:07:28 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.Collection;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class KeyVector_ESTest extends KeyVector_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Key key0 = new Key("");
      KeyVector keyVector0 = new KeyVector(key0);
      KeyVector keyVector1 = keyVector0.copy();
      assertNotSame(keyVector1, keyVector0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      keyVector0.add(0, (Object) null);
      keyVector0.add(0, (Object) null);
      // Undeclared exception!
      try { 
        keyVector0.mysort();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.KeyVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      KeyVector keyVector0 = null;
      try {
        keyVector0 = new KeyVector((Key) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Key key0 = new Key("");
      KeyVector keyVector0 = new KeyVector(key0);
      keyVector0.addAll(0, (Collection) keyVector0);
      keyVector0.mysort();
      assertEquals(2, keyVector0.size());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Key key0 = Key.CDS;
      KeyVector keyVector0 = new KeyVector(key0);
      MockJapaneseDate mockJapaneseDate0 = new MockJapaneseDate();
      keyVector0.insertElementAfter(key0, mockJapaneseDate0);
      // Undeclared exception!
      try { 
        keyVector0.mysort();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate cannot be cast to uk.ac.sanger.artemis.io.Key
         //
         verifyException("uk.ac.sanger.artemis.io.KeyVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      KeyVector keyVector1 = keyVector0.copy();
      assertNotSame(keyVector1, keyVector0);
  }
}
