/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:08:20 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.FuzzyRange;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseNode;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.UpperInteger;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Location_ESTest extends Location_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Range range0 = new Range(41, 41);
      Location location0 = new Location(range0);
      Location location1 = location0.getComplement();
      boolean boolean0 = location1.isComplement(range0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Range range0 = new Range(44, 78);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      Range range1 = location1.getTotalRange();
      assertNotSame(location1, location0);
      assertEquals(35, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Range range0 = new Range((-1081), (-1081));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      Range range1 = FuzzyRange.makeRange((Object) range0);
      Location location1 = location0.changeRange(range0, range1);
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Range range0 = new Range(44, 78);
      Location location0 = new Location(range0);
      String string0 = location0.toStringShort();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      Location location0 = new Location(rangeVector0, false);
      Location location1 = location0.removeRange(range0);
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Range range0 = new Range(0);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      int int0 = location0.getLastBase();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Range range0 = new Range(44, 78);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      boolean boolean0 = location1.equals(location0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RangeVector rangeVector0 = new RangeVector((Range) null);
      Location location0 = new Location(rangeVector0, true);
      UpperInteger upperInteger0 = new UpperInteger(2065);
      Range range0 = FuzzyRange.makeRange((Object) upperInteger0);
      // Undeclared exception!
      try { 
        location0.removeRange(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Range range0 = new Range(0);
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      Location location0 = new Location(rangeVector0, false);
      Location location1 = location0.getComplement();
      Location location2 = location1.addRange(range0);
      Location location3 = location2.reverseComplement((-1));
      // Undeclared exception!
      try { 
        location3.getLastBase();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      RangeVector rangeVector0 = new RangeVector();
      rangeVector0.add((Range) null);
      Location location0 = new Location(rangeVector0, true);
      // Undeclared exception!
      try { 
        location0.getComplement();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RangeVector rangeVector0 = new RangeVector((Range) null);
      Location location0 = new Location(rangeVector0, true);
      // Undeclared exception!
      try { 
        location0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location((RangeVector) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.LocationLexer$TokenEnumeration", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      Location location0 = new Location(rangeVector0, false);
      Location location1 = location0.getComplement();
      RangeVector rangeVector1 = location1.getRanges();
      assertNotSame(rangeVector1, rangeVector0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      Location location1 = location0.getComplement();
      Location location2 = location1.addRange(range0);
      RangeVector rangeVector1 = location2.getRanges();
      assertEquals("[-51, -51]", rangeVector1.toString());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      Location location0 = new Location(rangeVector0, false);
      RangeVector rangeVector1 = location0.getRanges();
      assertEquals("[-51, -51]", rangeVector1.toString());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Range range0 = new Range(44, 78);
      Location location0 = new Location(range0);
      RangeVector rangeVector0 = location0.getRanges();
      assertEquals("[44..78]", rangeVector0.toString());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Range range0 = new Range(0);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      int int0 = location0.getFirstBase();
      assertEquals(0, int0);
      
      Range range1 = location0.getTotalRange();
      assertEquals(0, range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Range range0 = new Range((-2268));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.reverseComplement((-1462));
      Location location2 = location1.addRange(range0);
      boolean boolean0 = location2.isComplement();
      assertNotSame(location2, location1);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Range range0 = new Range((-2268));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.addRange(range0);
      boolean boolean0 = location1.isComplement();
      assertTrue(boolean0);
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      String string0 = location0.toString();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Range range0 = new Range((-2984));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.addRange(range0);
      boolean boolean0 = location1.isComplement(range0);
      assertNotSame(location1, location0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      Location location2 = location1.reverseComplement(78, 3460);
      boolean boolean0 = location2.isComplement(range0);
      assertNotSame(location1, location0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Range range0 = new Range((-1081), (-1081));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      boolean boolean0 = location0.isComplement(range0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      boolean boolean0 = location1.isComplement(range0);
      assertNotSame(location1, location0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("join");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: : expected(
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("([^\\])\"");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: java.lang.String@0000000004java.lang.Character@0000000005java.lang.String@0000000006java.lang.String@0000000007java.lang.Character@0000000008java.lang.String@0000000009: expected an integer
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("4|bPzNQx8\"");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: java.lang.String@0000000006java.lang.String@0000000007java.lang.String@0000000008: garbage at the end of the location string
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("0#");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: java.lang.Integer@0000000004java.lang.String@0000000005: range bounds must be greater than 0
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("YpGY:H.");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: : parse error after reading \"H.\"
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("K 3Pe(37");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: java.lang.Integer@0000000004java.lang.String@0000000005java.lang.Character@0000000006java.lang.Integer@0000000007: parse error after reading \"K\"
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("complement(order(");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: : expected a range or a functional
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Location location0 = null;
      try {
        location0 = new Location("<1;05C/D3c)Zf@bSEs_");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: java.lang.String@0000000007java.lang.Integer@0000000008java.lang.String@0000000009java.lang.String@0000000010java.lang.String@0000000011java.lang.Character@0000000012java.lang.String@0000000013java.lang.String@0000000014java.lang.String@0000000015: garbage at the end of the location string
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      Location location0 = new Location(rangeVector0, false);
      Location location1 = location0.getComplement();
      int int0 = location1.getFirstBase();
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Range range0 = new Range((-2984));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.addRange(range0);
      Range range1 = location1.getTotalRange();
      assertEquals(2984, range1.getCount());
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      Range range1 = location0.getTotalRange();
      assertEquals(51, range1.getCount());
      
      int int0 = location0.getLastBase();
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      boolean boolean0 = location0.isComplement();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Range range0 = new Range((-2984));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      boolean boolean0 = location0.isComplement();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Range range0 = new Range(699);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      Location location2 = location1.reverseComplement(1);
      location2.isPartial(true);
      assertNotSame(location2, location1);
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      location1.isPartial(false);
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Range range0 = new Range((-1134));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      boolean boolean0 = location0.isPartial(false);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Range range0 = new Range(2917);
      RangeVector rangeVector0 = new RangeVector(range0);
      rangeVector0.add(range0);
      Location location0 = new Location(rangeVector0, true);
      String string0 = location0.toStringShort();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      Range range0 = new Range(44, 78);
      Location location0 = new Location(range0);
      Location location1 = location0.addRange(range0);
      location1.toStringShort();
      assertNotSame(location1, location0);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      Range range0 = new Range((-2268));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.reverseComplement((-1462));
      Location location2 = location1.addRange(range0);
      Location location3 = location2.truncate(range0);
      assertNotNull(location3);
      assertNotSame(location1, location2);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      RangeVector rangeVector0 = new RangeVector();
      Location location0 = null;
      try {
        location0 = new Location(rangeVector0, false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - ranges.size () == 0
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      Range range0 = new Range(0);
      Location location0 = null;
      try {
        location0 = new Location(range0);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // location out of range: 0
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      Range range0 = new Range((-51));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      LocationParseNode locationParseNode0 = location0.getParsedLocation();
      location0.setParsedLocation(locationParseNode0);
      assertEquals(4, locationParseNode0.getType());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      Range range0 = new Range((-2268));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      Location location1 = location0.copy();
      assertNotSame(location0, location1);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      Range range0 = new Range(44, 78);
      Location location0 = new Location(range0);
      boolean boolean0 = location0.equals(location0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      Range range0 = new Range((-2984));
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      String string0 = location0.toStringShort();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      int int0 = location0.getFirstBase();
      assertEquals(78, int0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      Range range0 = new Range(78, 78);
      Location location0 = new Location(range0);
      // Undeclared exception!
      try { 
        location0.removeRange(range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - inconsistent location
         //
         verifyException("uk.ac.sanger.artemis.io.LocationParseNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      Range range0 = new Range(132, 1932);
      Location location0 = new Location(range0);
      int int0 = location0.getLastBase();
      assertEquals(1932, int0);
  }
}
