/*
 * This file was automatically generated by EvoSuite
 * Fri Jun 08 18:51:37 GMT 2018
 */

package uk.ac.sanger.artemis.components.filetree;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.Date;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JProgressBar;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.filetree.FileList;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.j2ssh.FTProgress;
import uk.ac.sanger.artemis.j2ssh.SshFileManager;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class RemoteFileNode_ESTest extends RemoteFileNode_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      RemoteFileNode remoteFileNode1 = new RemoteFileNode(false);
      remoteFileNode1.setParentNode(remoteFileNode0);
      assertFalse(remoteFileNode1.isDirectory());
      assertFalse(remoteFileNode1.isExplored());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FileAttributes fileAttributes0 = new FileAttributes();
      UnsignedInteger32 unsignedInteger32_0 = new UnsignedInteger32(16384);
      fileAttributes0.setTimes(unsignedInteger32_0, unsignedInteger32_0);
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("@F_CqWv`{ZP5f3l", "@F_CqWv`{ZP5f3l", (FileList) null, "@F_CqWv`{ZP5f3l", fileAttributes0);
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("@F_CqWv`{ZP5f3l/@F_CqWv`{ZP5f3l", remoteFileNode0.getPathName());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FileAttributes fileAttributes0 = new FileAttributes();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("e", "e", (FileList) null, ".", fileAttributes0);
      remoteFileNode0.length();
      assertEquals("e", remoteFileNode0.getPathName());
      assertEquals("e", remoteFileNode0.getRootDir());
      assertEquals("e", remoteFileNode0.getFullName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      boolean boolean0 = remoteFileNode0.isDirectory();
      assertFalse(remoteFileNode0.isExplored());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("The server refused to open a session", "+V%Z=X", (FileList) null, "+V%Z=X", false);
      String string0 = remoteFileNode0.getRootDir();
      assertEquals("The server refused to open a session/+V%Z=X", remoteFileNode0.getPathName());
      assertEquals("+V%Z=X/+V%Z=X", remoteFileNode0.getFullName());
      assertEquals("The server refused to open a session", string0);
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("", "", (FileList) null, "", true);
      remoteFileNode0.getRootDir();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("/", remoteFileNode0.getPathName());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      remoteFileNode0.getPathName();
      assertFalse(remoteFileNode0.isExplored());
      assertFalse(remoteFileNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      remoteFileNode0.setParentNode(remoteFileNode0);
      RemoteFileNode remoteFileNode1 = remoteFileNode0.getParentNode();
      assertFalse(remoteFileNode1.isExplored());
      assertTrue(remoteFileNode1.isLeaf());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FileAttributes fileAttributes0 = new FileAttributes();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("r", "r", (FileList) null, "r", fileAttributes0);
      Date date0 = remoteFileNode0.getModifiedTime();
      assertEquals("Thu Jan 01 00:00:00 GMT 1970", date0.toString());
      assertEquals("r/r", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      remoteFileNode0.getFullName();
      assertFalse(remoteFileNode0.isExplored());
      assertTrue(remoteFileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      remoteFileNode0.getFile();
      assertFalse(remoteFileNode0.isExplored());
      assertFalse(remoteFileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("", "", (FileList) null, "", true);
      remoteFileNode0.getFile();
      assertEquals("/", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", true);
      remoteFileNode0.getAllowsChildren();
      assertEquals("^ ]YJOS/^ ]YJOS/", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("^ ]YJOS//^ ]YJOS/", remoteFileNode0.getFullName());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      MockFile mockFile0 = new MockFile("&p8@XE7+O#U_q|");
      JProgressBar jProgressBar0 = new JProgressBar(0, 0, 0);
      FTProgress fTProgress0 = new FTProgress(jProgressBar0, "");
      // Undeclared exception!
      try { 
        remoteFileNode0.put("", (File) mockFile0, fTProgress0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      // Undeclared exception!
      try { 
        remoteFileNode0.isDataFlavorSupported((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.RemoteFileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      // Undeclared exception!
      try { 
        remoteFileNode0.getTransferData((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.RemoteFileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      // Undeclared exception!
      try { 
        remoteFileNode0.getServerName();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      FileAttributes fileAttributes0 = new FileAttributes();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("@F_CqWv`{ZP5f3l", "@F_CqWv`{ZP5f3l", (FileList) null, "XlM", fileAttributes0);
      remoteFileNode0.setUserObject(remoteFileNode0);
      // Undeclared exception!
      try { 
        remoteFileNode0.getServerName();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.components.filetree.RemoteFileNode cannot be cast to java.lang.String
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.RemoteFileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("", "", (FileList) null, "", true);
      String string0 = remoteFileNode0.getServerName();
      assertEquals("/", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("/", string0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      RemoteFileNode remoteFileNode0 = null;
      try {
        remoteFileNode0 = new RemoteFileNode("TixA#^=wQg", "bT$1#MPv", fileList0, "com.sshtools.j2ssh.io.ByteArrayReader/.", true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode((String) null, (String) null, (FileList) null, (String) null, true);
      remoteFileNode0.getRootDir();
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      remoteFileNode0.isDirectory();
      assertEquals("^ ]YJOS//^ ]YJOS/", remoteFileNode0.getFullName());
      assertEquals("^ ]YJOS/^ ]YJOS/", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      DataFlavor dataFlavor0 = new DataFlavor();
      try { 
        remoteFileNode0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.RemoteFileNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("~^ ]YJOS(", "~^ ]YJOS(", (FileList) null, "~^ ]YJOS(", true);
      RemoteFileNode remoteFileNode1 = (RemoteFileNode)remoteFileNode0.getTransferData(remoteFileNode0.REMOTEFILENODE);
      assertEquals("~^ ]YJOS(/~^ ]YJOS(", remoteFileNode1.getPathName());
      assertFalse(remoteFileNode1.isExplored());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("~^ ]YJOS(", "~^ ]YJOS(", (FileList) null, "~^ ]YJOS(", true);
      DataFlavor dataFlavor0 = DataFlavor.imageFlavor;
      boolean boolean0 = remoteFileNode0.isDataFlavorSupported(dataFlavor0);
      assertFalse(boolean0);
      assertEquals("~^ ]YJOS(/~^ ]YJOS(", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("~^ ]YJOS(", "~^ ]YJOS(", (FileList) null, "~^ ]YJOS(", true);
      DataFlavor dataFlavor0 = DataFlavor.stringFlavor;
      boolean boolean0 = remoteFileNode0.isDataFlavorSupported(dataFlavor0);
      assertTrue(boolean0);
      assertEquals("~^ ]YJOS(/~^ ]YJOS(", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      boolean boolean0 = remoteFileNode0.isDataFlavorSupported(remoteFileNode0.REMOTEFILENODE);
      assertFalse(remoteFileNode0.isExplored());
      assertTrue(boolean0);
      assertTrue(remoteFileNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      JProgressBar jProgressBar0 = new JProgressBar();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("r", "r", (FileList) null, "r", false);
      MockFile mockFile0 = new MockFile("Rote file", "u+5N)uay|s7I");
      FTProgress fTProgress0 = new FTProgress(jProgressBar0, "Rote file");
      // Undeclared exception!
      try { 
        remoteFileNode0.put((File) mockFile0, fTProgress0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("Fie an]aHgr", "Fie an]aHgr", (FileList) null, "Fie an]aHgr", true);
      // Undeclared exception!
      try { 
        remoteFileNode0.getChildren();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(".", ".", (FileList) null, ".", false);
      assertTrue(remoteFileNode0.isLeaf());
      
      remoteFileNode0.getChildren();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals(".", remoteFileNode0.getPathName());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(".", ".", (FileList) null, ".", false);
      String string0 = remoteFileNode0.getServerName();
      assertFalse(remoteFileNode0.isExplored());
      assertFalse(remoteFileNode0.isDirectory());
      assertEquals("./", string0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("~^ ]YJOS(", "~^ ]YJOS(", (FileList) null, "~^ ]YJOS(", true);
      DataFlavor dataFlavor0 = DataFlavor.stringFlavor;
      Object object0 = remoteFileNode0.getTransferData(dataFlavor0);
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("~^ ]YJOS(/~^ ]YJOS(", remoteFileNode0.getPathName());
      assertEquals("~^ ]YJOS(/~^ ]YJOS(/~^ ]YJOS(", object0);
      assertTrue(remoteFileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      boolean boolean0 = remoteFileNode0.isLeaf();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("^ ]YJOS//^ ]YJOS/", remoteFileNode0.getFullName());
      assertEquals("^ ]YJOS/^ ]YJOS/", remoteFileNode0.getPathName());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("D0}pxNt{1{9~-5-nTz7", "D0}pxNt{1{9~-5-nTz7", (FileList) null, "uk.ac.sanger.artemis.components.filetree.FileList", true);
      boolean boolean0 = remoteFileNode0.isLeaf();
      assertFalse(boolean0);
      assertEquals("uk.ac.sanger.artemis.components.filetree.FileList/D0}pxNt{1{9~-5-nTz7", remoteFileNode0.getFullName());
      assertEquals("D0}pxNt{1{9~-5-nTz7/uk.ac.sanger.artemis.components.filetree.FileList", remoteFileNode0.getPathName());
      assertEquals("D0}pxNt{1{9~-5-nTz7", remoteFileNode0.getRootDir());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      FileList fileList0 = new FileList((SshFileManager) null);
      FileAttributes fileAttributes0 = new FileAttributes();
      RemoteFileNode remoteFileNode0 = null;
      try {
        remoteFileNode0 = new RemoteFileNode("k$>qFCZ VN.tPK\"r,-", (String) null, fileList0, "", fileAttributes0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.filetree.FileList", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("/.", "/.", (FileList) null, "/.", true);
      boolean boolean0 = remoteFileNode0.isExplored();
      assertEquals("/.//", remoteFileNode0.getPathName());
      assertEquals("///.", remoteFileNode0.getFullName());
      assertFalse(boolean0);
      assertTrue(remoteFileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("~^ ]YJOS(", "~^ ]YJOS(", (FileList) null, "~^ ]YJOS(", true);
      MockFile mockFile0 = new MockFile("~^ ]YJOS(/~^ ]YJOS(");
      // Undeclared exception!
      try { 
        remoteFileNode0.put((File) mockFile0, (FTProgress) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      Object[] objectArray0 = remoteFileNode0.getChildren();
      assertNotNull(objectArray0);
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      DefaultBoundedRangeModel defaultBoundedRangeModel0 = new DefaultBoundedRangeModel();
      JProgressBar jProgressBar0 = new JProgressBar(defaultBoundedRangeModel0);
      FTProgress fTProgress0 = new FTProgress(jProgressBar0, "|");
      // Undeclared exception!
      try { 
        remoteFileNode0.getFileContents(fTProgress0, "|");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("D0}pxNt{1{9~-5-nTz7", "D0}pxNt{1{9~-5-nTz7", (FileList) null, "uk.ac.sanger.artemis.components.filetree.FileList", true);
      // Undeclared exception!
      try { 
        remoteFileNode0.delete();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("=c", "=c", (FileList) null, "=c", false);
      // Undeclared exception!
      try { 
        remoteFileNode0.mkdir("=c");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {

      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(".", ".", (FileList) null, ".", false);
      String string0 = remoteFileNode0.getFullName();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals(".", string0);
      assertNotNull(string0);
      assertFalse(remoteFileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      boolean boolean0 = remoteFileNode0.getAllowsChildren();
      assertFalse(boolean0);
      assertEquals("^ ]YJOS//^ ]YJOS/", remoteFileNode0.getFullName());
      assertEquals("^ ]YJOS/^ ]YJOS/", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      remoteFileNode0.getTransferDataFlavors();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals("^ ]YJOS//^ ]YJOS/", remoteFileNode0.getFullName());
      assertEquals("^ ]YJOS/^ ]YJOS/", remoteFileNode0.getPathName());
      assertFalse(remoteFileNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(".", ".", (FileList) null, ".", false);
      String string0 = remoteFileNode0.getPathName();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals(".", string0);
      assertFalse(remoteFileNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      remoteFileNode0.length();
      assertFalse(remoteFileNode0.isLeaf());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      JProgressBar jProgressBar0 = new JProgressBar();
      FTProgress fTProgress0 = new FTProgress(jProgressBar0, "File Manager");
      // Undeclared exception!
      try { 
        remoteFileNode0.getFileContents(fTProgress0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      remoteFileNode0.getParentNode();
      assertFalse(remoteFileNode0.isExplored());
      assertTrue(remoteFileNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      // Undeclared exception!
      try { 
        remoteFileNode0.rename("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      remoteFileNode0.getModifiedTime();
      assertFalse(remoteFileNode0.isExplored());
      assertTrue(remoteFileNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(true);
      remoteFileNode0.setParentNode(remoteFileNode0);
      RemoteFileNode remoteFileNode1 = remoteFileNode0.getParentNode();
      assertFalse(remoteFileNode1.isExplored());
      assertTrue(remoteFileNode1.isDirectory());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      FileAttributes fileAttributes0 = new FileAttributes();
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("@F_CqWv`{ZP5f3l", "@F_CqWv`{ZP5f3l", (FileList) null, "XlM", fileAttributes0);
      remoteFileNode0.reset();
      assertEquals("@F_CqWv`{ZP5f3l/XlM", remoteFileNode0.getPathName());
      assertEquals("@F_CqWv`{ZP5f3l", remoteFileNode0.getRootDir());
      assertFalse(remoteFileNode0.isDirectory());
      assertEquals("XlM/@F_CqWv`{ZP5f3l", remoteFileNode0.getFullName());
      assertFalse(remoteFileNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode("^ ]YJOS/", "^ ]YJOS/", (FileList) null, "^ ]YJOS/", false);
      // Undeclared exception!
      try { 
        remoteFileNode0.stat();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(".", ".", (FileList) null, ".", false);
      remoteFileNode0.getFile();
      assertFalse(remoteFileNode0.isExplored());
      assertEquals(".", remoteFileNode0.getPathName());
      assertTrue(remoteFileNode0.isLeaf());
  }
}
