#include "support.h"
#include "conf.h"
#include "main.h"

GtkTreeView	*accel_tview = NULL;
GtkListStore	*accel_store = NULL;
GtkAccelGroup	*accel_group = NULL;

int		debug = 0;
double          zoom_factor = 1.0;

typedef struct {
  char	*legend,
	*widget;
  gint	 mods;
  guint	 accel;
} key_assignment;

key_assignment key_asg[] = {
  {N_("Zoom in"),	"zoom_in_btn",
			0,		GDK_KP_Add},
  {N_("Zoom out"),	"zoom_out_btn",
			0,		GDK_KP_Subtract},
  {N_("Fit width"),	"zoom_fit_btn",
			0,		GDK_w},
  {N_("Fit page"),	"zoom_width_btn",
			0,		GDK_p},
  {N_("Zoom 1:1"),	"zoom_orig_btn",
			0,		GDK_1},
  {N_("Scroll left"),	"scroll_left_btn",
			0,		GDK_Left},
  {N_("Scroll right"),	"scroll_right_btn",
			0,		GDK_Right},
  {N_("Scroll up"),	"scroll_up_btn",
			0,		GDK_Up},
  {N_("Scroll down"),	"scroll_down_btn",
			0,		GDK_Down},
  {N_("Next page"),	"next_btn",
			0,		GDK_Page_Down},
  {N_("Previous page"),	"back_btn",
			0,		GDK_Page_Up},
  {N_("Last page"),	"last_btn",
			0,		GDK_End},
  {N_("First page"),	"begin_btn",
			0,		GDK_Home},
  {N_("Open file"),	"open_btn",
			0,		GDK_o},
  {N_("Quit cbrPager"),	"quit_btn",
			0,		GDK_q},
  {NULL}	// Sentinel - don't remove
};

preferences pref = {
  ""
};

void
save_config(void)
{
  char path[120];
  int ka;

  sprintf(path, "%s/global/lastbook", prog_name);
  gnome_config_set_string(path, pref.lastbook);

  sprintf(path, "%s/global/fixed_dir", prog_name);
  gnome_config_set_string(path, pref.fixeddir);

  sprintf(path, "%s/global/nextpage", prog_name);
  gnome_config_set_int(path, pref.nextpage);

  sprintf(path, "%s/global/prevpage", prog_name);
  gnome_config_set_int(path, pref.prevpage);

  sprintf(path, "%s/global/nrpages", prog_name);
  gnome_config_set_int(path, pref.nrpages);

  sprintf(path, "%s/startup/width", prog_name);
  gnome_config_set_int(path, pref.initwidth);

  sprintf(path, "%s/startup/height", prog_name);
  gnome_config_set_int(path, pref.initheight);

  sprintf(path, "%s/global/nav_pos", prog_name);
  gnome_config_set_int(path, pref.nav_pos);

  sprintf(path, "%s/global/nav_hor", prog_name);
  gnome_config_set_int(path, pref.nav_hor);

  sprintf(path, "%s/global/dirmode", prog_name);
  gnome_config_set_int(path, pref.dirmode);

  sprintf(path, "%s/global/nav_hidden", prog_name);
  gnome_config_set_int(path, pref.nav_hidden);

  for (ka = 0; key_asg[ka].legend; ka++) {
    sprintf(path, "%s/accel/%s_mods", prog_name, key_asg[ka].widget);
    gnome_config_set_int(path, key_asg[ka].mods);
    sprintf(path, "%s/accel/%s_key", prog_name, key_asg[ka].widget);
    gnome_config_set_int(path, key_asg[ka].accel);
  }

  gnome_config_sync();
}


void
load_config(void)
{
  char path[120], *p;
  int def, ka;

  sprintf(path, "%s/global/lastbook=", prog_name);
  strcpy(pref.lastbook, p = gnome_config_get_string_with_default(path, &def));
  g_free(p);

  sprintf(path, "%s/global/fixed_dir=", prog_name);
  strcpy(pref.fixeddir, p = gnome_config_get_string_with_default(path, &def));
  g_free(p);

  sprintf(path, "%s/global/nextpage=0", prog_name);
  pref.nextpage = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/prevpage=0", prog_name);
  pref.prevpage = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nrpages=1", prog_name);
  pref.nrpages = gnome_config_get_int_with_default(path, &def);
    
  sprintf(path, "%s/startup/width=480", prog_name);
  pref.initwidth = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/startup/height=640", prog_name);
  pref.initheight = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nav_pos=%d", prog_name, NAV_SE);
  pref.nav_pos = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nav_hor=%d", prog_name, FALSE);
  pref.nav_hor = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/dirmode=0", prog_name);
  pref.dirmode = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nav_hidden=0", prog_name);
  pref.nav_hidden = gnome_config_get_int_with_default(path, &def);

  if (pref.dirmode == DIRM_FIXED)		// fixed startup directory
    strncpy(pref.lastbook, pref.fixeddir, sizeof(pref.lastbook));

  for (ka = 0; key_asg[ka].legend; ka++) {
    sprintf(path, "%s/accel/%s_mods=%d", prog_name, key_asg[ka].widget,
		key_asg[ka].mods);
    key_asg[ka].mods = gnome_config_get_int_with_default(path, &def);
    sprintf(path, "%s/accel/%s_key=%u", prog_name, key_asg[ka].widget,
		key_asg[ka].accel);
    key_asg[ka].accel = gnome_config_get_int_with_default(path, &def);
  }

}


void
show_config(GtkWidget *ref)
{
  GtkWidget *w;
  char bff[20];

  w = lookup_widget(ref, "conf_goto_entry");
  gtk_entry_set_text(GTK_ENTRY(w), pref.fixeddir);

  switch (pref.nextpage) {
    case 0: w = lookup_widget(ref, "fwd_top_rbtn"); break;
    case 1: w = lookup_widget(ref, "fwd_btm_rbtn"); break;
    case 2: w = lookup_widget(ref, "fwd_stay_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  switch (pref.prevpage) {
    case 0: w = lookup_widget(ref, "back_top_rbtn"); break;
    case 1: w = lookup_widget(ref, "back_btm_rbtn"); break;
    case 2: w = lookup_widget(ref, "back_stay_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  switch (pref.nrpages) {
    case 1: w = lookup_widget(ref, "conf_1page_rbtn"); break;
    case 2: w = lookup_widget(ref, "conf_2page_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  sprintf(bff, "%d", pref.initwidth);
  w = lookup_widget(ref, "conf_w_entry");
  gtk_entry_set_text(GTK_ENTRY(w), bff);

  sprintf(bff, "%d", pref.initheight);
  w = lookup_widget(ref, "conf_h_entry");
  gtk_entry_set_text(GTK_ENTRY(w), bff);

  switch (pref.dirmode) {
    case 0: w = lookup_widget(ref, "conf_prevdir_rbtn"); break;
    case 1: w = lookup_widget(ref, "conf_goto_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  switch (pref.nav_pos) {
    case NAV_NE: w = lookup_widget(ref, "conf_nav_ne_rbtn"); break;
    case NAV_SE: w = lookup_widget(ref, "conf_nav_se_rbtn"); break;
    case NAV_NW: w = lookup_widget(ref, "conf_nav_nw_rbtn"); break;
    case NAV_SW: w = lookup_widget(ref, "conf_nav_sw_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  w = lookup_widget(ref, "conf_nav_hide_cbtn");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), pref.nav_hidden);

  printf("sh: %d\n", pref.nav_hor);
  switch (pref.nav_hor) {
    case FALSE:
      w = lookup_widget(ref, "conf_nav_vert_rbtn"); 
      break;
    case TRUE:
      w = lookup_widget(ref, "conf_nav_hor_rbtn");
      break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
}


void
parse_config(GtkWidget *ref)
{
  GtkWidget *w;
  GtkRequisition req;
  GtkTreeIter iter;
  guint accel;
  gint mods;
  int ka;

  w = lookup_widget(ref, "conf_goto_entry");
  strncpy(pref.fixeddir,
		gtk_entry_get_text(GTK_ENTRY(w)),
		sizeof(pref.fixeddir));

  w = lookup_widget(ref, "fwd_top_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.nextpage = 0;
  else {
    w = lookup_widget(ref, "fwd_btm_rbtn");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
      pref.nextpage = 1;
    else
      pref.nextpage = 2;
  }

  w = lookup_widget(ref, "back_top_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.prevpage = 0;
  else {
    w = lookup_widget(ref, "back_btm_rbtn");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
      pref.prevpage = 1;
    else
      pref.prevpage = 2;
  }

  w = lookup_widget(ref, "conf_1page_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.nrpages = 1;
  else
    pref.nrpages = 2;

  w = lookup_widget(ref, "conf_w_entry");
  pref.initwidth = atol(gtk_entry_get_text(GTK_ENTRY(w)));

  w = lookup_widget(ref, "conf_h_entry");
  pref.initheight = atol(gtk_entry_get_text(GTK_ENTRY(w)));

  w = lookup_widget(ref, "conf_prevdir_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.dirmode = 0;
  else
    pref.dirmode = 1;

  w = lookup_widget(ref, "conf_nav_nw_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.nav_pos = NAV_NW;
  else {
    w = lookup_widget(ref, "conf_nav_ne_rbtn");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
      pref.nav_pos = NAV_NE;
    else {
      w = lookup_widget(ref, "conf_nav_se_rbtn");
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
        pref.nav_pos = NAV_SE;
      else
        pref.nav_pos = NAV_SW;
    }
  }
  
  w = lookup_widget(ref, "conf_nav_hide_cbtn");
  pref.nav_hidden = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
  if (pref.nav_hidden)
    gtk_widget_hide(nav_window);
  else
    gtk_widget_show(nav_window);

  w = lookup_widget(ref, "conf_nav_hor_rbtn");
  pref.nav_hor = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
  w = lookup_widget(nav_window, "nav_toolbar");
  gtk_toolbar_set_orientation(GTK_TOOLBAR(w),
	pref.nav_hor ? GTK_ORIENTATION_HORIZONTAL
		     : GTK_ORIENTATION_VERTICAL);
  printf("parse: %d\n", pref.nav_hor);

  gtk_tree_model_get_iter_first(GTK_TREE_MODEL(accel_store), &iter);
  for (ka = 0; key_asg[ka].legend; ka++) {
    gtk_tree_model_get(GTK_TREE_MODEL(accel_store), &iter,
	ACC_MODS, &mods,
	ACC_ACCEL, &accel,
	-1);
    w = lookup_widget(nav_window, key_asg[ka].widget);
    gtk_widget_remove_accelerator(w, accel_group,
		key_asg[ka].accel, key_asg[ka].mods);
    gtk_widget_add_accelerator(w, "clicked", accel_group,
		accel, mods, 0);
    key_asg[ka].mods = mods;
    key_asg[ka].accel = accel;
    gtk_tree_model_iter_next(GTK_TREE_MODEL(accel_store), &iter);
  }
}


void
conf_accel_tview_cursor_changed(void)
{
}


void
accel_edited(GtkCellRendererAccel *renderer, gchar *path, guint accel_key,
		GdkModifierType mask, guint hardware_keycode,
		GtkTreeView *treeview)
{
  GtkTreeModel *model;
  GtkTreeIter iter;

  model = gtk_tree_view_get_model(treeview);
  if (gtk_tree_model_get_iter_from_string(model, &iter, path))
    gtk_list_store_set (GTK_LIST_STORE(model), &iter,
		ACC_MODS, (gint) mask,
		ACC_ACCEL, accel_key,
		-1);
}


void
conf_accel_tview_realize(GtkTreeView *tview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *col;
  GtkTreeIter iter;
  int ka;

  accel_tview = tview;
  accel_store = gtk_list_store_new(ACC_COLS,
	G_TYPE_STRING,
	G_TYPE_INT,
	G_TYPE_UINT);

  gtk_tree_view_set_model(GTK_TREE_VIEW(accel_tview),                             
        GTK_TREE_MODEL(accel_store));
  g_object_unref(G_OBJECT(accel_store));

  // Accelerator function
  renderer = gtk_cell_renderer_text_new();
  gtk_object_set(GTK_OBJECT(renderer),
		"ypad", 0, NULL);
  col = gtk_tree_view_column_new_with_attributes(
		"Function", renderer,
		"text", 0, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(accel_tview), col);

  // Accelerator assignment
  renderer = gtk_cell_renderer_accel_new();
  g_object_set(renderer, "accel-mods", GTK_CELL_RENDERER_ACCEL_MODE_GTK,
		"editable", TRUE, NULL);
  g_signal_connect(G_OBJECT(renderer), "accel_edited",
		G_CALLBACK(accel_edited),
		(gpointer) accel_tview);
  col = gtk_tree_view_column_new_with_attributes(
		"Accelerator", renderer,
		"accel-mods", ACC_MODS,
		"accel-key", ACC_ACCEL,
		NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(accel_tview), col);
  gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(accel_tview), TRUE);

  for (ka = 0; key_asg[ka].legend; ka++) {
    gtk_list_store_append(accel_store, &iter);
    gtk_list_store_set(accel_store, &iter,
	ACC_FUNCTION, _(key_asg[ka].legend),
	ACC_MODS,       key_asg[ka].mods,
	ACC_ACCEL,      key_asg[ka].accel,
	-1);
  }
}

void
set_kay_accelerators(void)
{
  GtkWidget *w;
  int ka;

  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(MainWindow), accel_group);

  for (ka = 0; key_asg[ka].legend; ka++) {
    w = lookup_widget(nav_window, key_asg[ka].widget);
    gtk_widget_add_accelerator(w, "clicked", accel_group,
		key_asg[ka].accel,
		key_asg[ka].mods, 0);
  }
}
