{
  Implementations of BLAKE2b, BLAKE2s,
  optimized for speed on CPUs supporting SSE2
}

const
  blake2s_IV_2: array[0..3] of cuint32 =
  (
    $510E527F, $9B05688C, $1F83D9AB, $5BE0CD19
  );

  blake2b_IV_2: array[0..1] of cint64 =
  (
    $3c6ef372fe94f82b, $a54ff53a5f1d36f1
  );

  blake2b_IV_3: array[0..1] of cint64 =
  (
    $510e527fade682d1, $9b05688c2b3e6c1f
  );

  blake2b_IV_4: array[0..1] of cint64 =
  (
    $1f83d9abfb41bd6b, $5be0cd19137e2179
  );

function blake2s_compress( S: Pblake2s_state; const block: pcuint8 ): cint; assembler; nostackframe;
asm
{$IF DEFINED(WINDOWS)}
  pushq	%rdi
  pushq	%rsi
{$ELSE IF DEFINED(UNIX)}
  pushq	%rcx
  movq	%rdi,	%rcx
  pushq	%rdx
  movq	%rsi,	%rdx
{$ENDIF}
  pushq	%r15
  pushq	%r14
  pushq	%r12
  pushq	%rbp
  pushq	%rbx
  subq	$208, %rsp
  movaps	%xmm6, 48(%rsp)
  movaps	%xmm7, 64(%rsp)
  movaps	%xmm8, 80(%rsp)
  movaps	%xmm9, 96(%rsp)
  movaps	%xmm10, 112(%rsp)
  movaps	%xmm11, 128(%rsp)
  movaps	%xmm12, 144(%rsp)
  movaps	%xmm13, 160(%rsp)
  movaps	%xmm14, 176(%rsp)
  movaps	%xmm15, 192(%rsp)
  movdqu	blake2s_IV(%rip), %xmm5
  movdqu	(%rcx), %xmm0
  movl	16(%rdx), %ebx
  movdqa	%xmm0, %xmm14
  movdqu	16(%rcx), %xmm0
  movd	(%rdx), %xmm4
  movdqa	%xmm0, %xmm13
  movd	8(%rdx), %xmm1
  movaps	%xmm14, (%rsp)
  movd	24(%rdx), %xmm7
  movdqa	%xmm13, %xmm15
  paddd	(%rsp), %xmm15
  movd	%ebx, %xmm12
  movdqu	32(%rcx), %xmm2
  movdqa	%xmm4, %xmm14
  movaps	%xmm13, 16(%rsp)
  punpckldq	%xmm7, %xmm12
  punpckldq	%xmm1, %xmm14
  punpcklqdq	%xmm12, %xmm14
  movdqu	blake2s_IV_2(%rip), %xmm0
  paddd	%xmm15, %xmm14
  movl	12(%rdx), %eax
  pxor	%xmm2, %xmm0
  pxor	%xmm14, %xmm0
  movdqa	%xmm0, %xmm12
  movl	20(%rdx), %r9d
  pslld	$16, %xmm12
  movd	4(%rdx), %xmm11
  movdqa	%xmm13, %xmm2
  movdqa	%xmm14, %xmm15
  psrld	$16, %xmm0
  movd	28(%rdx), %xmm10
  pxor	%xmm12, %xmm0
  paddd	%xmm0, %xmm5
  movd	%eax, %xmm13
  movdqa	%xmm11, %xmm14
  pxor	%xmm5, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  movl	56(%rdx), %edi
  pslld	$20, %xmm12
  punpckldq	%xmm13, %xmm14
  movdqa	%xmm14, %xmm13
  movl	32(%rdx), %r11d
  pxor	%xmm12, %xmm2
  movd	%r9d, %xmm12
  paddd	%xmm2, %xmm15
  movl	40(%rdx), %r10d
  punpckldq	%xmm10, %xmm12
  punpcklqdq	%xmm12, %xmm13
  paddd	%xmm15, %xmm13
  movd	48(%rdx), %xmm6
  pxor	%xmm13, %xmm0
  movdqa	%xmm0, %xmm12
  movl	60(%rdx), %ebp
  psrld	$8, %xmm0
  pslld	$24, %xmm12
  movdqa	%xmm6, %xmm15
  movd	36(%rdx), %xmm3
  pxor	%xmm12, %xmm0
  paddd	%xmm0, %xmm5
  movd	52(%rdx), %xmm9
  pshufd	$147, %xmm0, %xmm0
  pxor	%xmm5, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  movd	44(%rdx), %xmm8
  pslld	$25, %xmm12
  pshufd	$78, %xmm5, %xmm5
  pxor	%xmm12, %xmm2
  movd	%edi, %xmm12
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm12, %xmm15
  movd	%r11d, %xmm12
  movq	%xmm15, %rdx
  movd	%r10d, %xmm15
  punpckldq	%xmm15, %xmm12
  movq	%rdx, %xmm15
  punpcklqdq	%xmm15, %xmm12
  paddd	%xmm2, %xmm12
  movdqa	%xmm9, %xmm15
  paddd	%xmm13, %xmm12
  movd	%ebx, %xmm13
  movdqa	%xmm12, %xmm14
  pxor	%xmm12, %xmm0
  movdqa	%xmm0, %xmm12
  pslld	$16, %xmm12
  psrld	$16, %xmm0
  pxor	%xmm12, %xmm0
  paddd	%xmm0, %xmm5
  pxor	%xmm5, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movd	%ebp, %xmm12
  punpckldq	%xmm12, %xmm15
  movdqa	%xmm3, %xmm12
  punpckldq	%xmm8, %xmm12
  punpcklqdq	%xmm15, %xmm12
  paddd	%xmm2, %xmm12
  paddd	%xmm14, %xmm12
  pxor	%xmm12, %xmm0
  movdqa	%xmm0, %xmm15
  psrld	$8, %xmm0
  pslld	$24, %xmm15
  pxor	%xmm15, %xmm0
  paddd	%xmm0, %xmm5
  pshufd	$57, %xmm0, %xmm14
  movdqa	%xmm3, %xmm0
  pxor	%xmm5, %xmm2
  movdqa	%xmm2, %xmm15
  psrld	$7, %xmm2
  punpckldq	%xmm9, %xmm0
  pslld	$25, %xmm15
  pshufd	$78, %xmm5, %xmm5
  pxor	%xmm15, %xmm2
  movd	%edi, %xmm15
  pshufd	$147, %xmm2, %xmm2
  punpckldq	%xmm13, %xmm15
  movdqa	%xmm15, %xmm13
  movq	%xmm15, %r14
  punpcklqdq	%xmm0, %xmm13
  movdqa	%xmm13, %xmm0
  paddd	%xmm2, %xmm0
  paddd	%xmm0, %xmm12
  movdqa	%xmm14, %xmm0
  pxor	%xmm12, %xmm0
  movdqa	%xmm0, %xmm15
  pslld	$16, %xmm15
  movdqa	%xmm15, %xmm13
  movdqa	%xmm0, %xmm15
  psrld	$16, %xmm15
  movdqa	%xmm15, %xmm14
  movd	%r10d, %xmm15
  pxor	%xmm13, %xmm14
  paddd	%xmm14, %xmm5
  movd	%r11d, %xmm13
  pxor	%xmm5, %xmm2
  movdqa	%xmm2, %xmm0
  psrld	$12, %xmm2
  punpckldq	%xmm13, %xmm15
  pslld	$20, %xmm0
  movq	%xmm15, %rsi
  pxor	%xmm0, %xmm2
  movd	%ebp, %xmm0
  punpckldq	%xmm7, %xmm0
  punpcklqdq	%xmm0, %xmm15
  movdqa	%xmm15, %xmm0
  paddd	%xmm2, %xmm0
  paddd	%xmm0, %xmm12
  pxor	%xmm12, %xmm14
  movdqa	%xmm14, %xmm15
  psrld	$8, %xmm14
  pslld	$24, %xmm15
  pxor	%xmm15, %xmm14
  paddd	%xmm14, %xmm5
  pshufd	$147, %xmm14, %xmm14
  pxor	%xmm5, %xmm2
  movdqa	%xmm2, %xmm0
  psrld	$7, %xmm2
  pshufd	$78, %xmm5, %xmm15
  pslld	$25, %xmm0
  movdqa	%xmm8, %xmm5
  pxor	%xmm0, %xmm2
  movd	%r9d, %xmm0
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm0, %xmm5
  movdqa	%xmm11, %xmm0
  punpckldq	%xmm4, %xmm0
  punpcklqdq	%xmm5, %xmm0
  paddd	%xmm2, %xmm0
  paddd	%xmm12, %xmm0
  pxor	%xmm0, %xmm14
  movdqa	%xmm14, %xmm12
  psrld	$16, %xmm14
  pslld	$16, %xmm12
  movdqa	%xmm14, %xmm5
  movdqa	%xmm10, %xmm14
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movd	%eax, %xmm12
  punpckldq	%xmm12, %xmm14
  movq	%xmm14, %r8
  movdqa	%xmm14, %xmm13
  movdqa	%xmm6, %xmm14
  punpckldq	%xmm1, %xmm14
  punpcklqdq	%xmm13, %xmm14
  paddd	%xmm2, %xmm14
  movdqa	%xmm8, %xmm13
  paddd	%xmm0, %xmm14
  punpckldq	%xmm6, %xmm13
  pxor	%xmm14, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$57, %xmm5, %xmm5
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  pshufd	$78, %xmm15, %xmm0
  pslld	$25, %xmm12
  movd	%r9d, %xmm15
  pxor	%xmm12, %xmm2
  movd	%ebp, %xmm12
  pshufd	$147, %xmm2, %xmm2
  punpckldq	%xmm12, %xmm15
  punpcklqdq	%xmm15, %xmm13
  paddd	%xmm2, %xmm13
  movq	%xmm15, %r15
  paddd	%xmm14, %xmm13
  movdqa	%xmm1, %xmm14
  movd	%eax, %xmm15
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  punpckldq	%xmm9, %xmm14
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movd	%r11d, %xmm12
  punpckldq	%xmm4, %xmm12
  punpcklqdq	%xmm14, %xmm12
  paddd	%xmm2, %xmm12
  movdqa	%xmm10, %xmm14
  paddd	%xmm12, %xmm13
  punpckldq	%xmm3, %xmm14
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$8, %xmm5
  pslld	$24, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$147, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm0
  pslld	$25, %xmm12
  pxor	%xmm12, %xmm2
  movd	%r10d, %xmm12
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm15, %xmm12
  punpcklqdq	%xmm14, %xmm12
  paddd	%xmm2, %xmm12
  movdqa	%xmm11, %xmm14
  paddd	%xmm13, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm15
  psrld	$16, %xmm5
  pslld	$16, %xmm15
  pxor	%xmm15, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm15
  psrld	$12, %xmm2
  pslld	$20, %xmm15
  pxor	%xmm15, %xmm2
  movd	%ebx, %xmm15
  punpckldq	%xmm15, %xmm14
  movd	%edi, %xmm15
  punpckldq	%xmm7, %xmm15
  movdqa	%xmm15, %xmm13
  punpcklqdq	%xmm14, %xmm13
  paddd	%xmm2, %xmm13
  movq	%r8, %xmm14
  paddd	%xmm13, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm15
  psrld	$8, %xmm5
  pslld	$24, %xmm15
  pxor	%xmm15, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$57, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm15
  psrld	$7, %xmm2
  pslld	$25, %xmm15
  movdqa	%xmm15, %xmm13
  pshufd	$78, %xmm0, %xmm15
  movdqa	%xmm9, %xmm0
  punpckldq	%xmm8, %xmm0
  punpcklqdq	%xmm0, %xmm14
  movdqa	%xmm14, %xmm0
  pxor	%xmm13, %xmm2
  pshufd	$147, %xmm2, %xmm2
  paddd	%xmm2, %xmm0
  movq	%rdx, %xmm14
  paddd	%xmm0, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$16, %xmm5
  pslld	$16, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm0
  psrld	$12, %xmm2
  pslld	$20, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm3, %xmm0
  punpckldq	%xmm11, %xmm0
  punpcklqdq	%xmm14, %xmm0
  paddd	%xmm2, %xmm0
  movd	%ebx, %xmm14
  paddd	%xmm0, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$147, %xmm5, %xmm5
  movdqa	%xmm15, %xmm0
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm15
  pslld	$25, %xmm15
  movdqa	%xmm15, %xmm13
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm15
  movd	%ebp, %xmm0
  punpckldq	%xmm0, %xmm14
  pxor	%xmm13, %xmm2
  movdqa	%xmm1, %xmm0
  movd	%r9d, %xmm13
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm13, %xmm0
  punpcklqdq	%xmm14, %xmm0
  paddd	%xmm2, %xmm0
  paddd	%xmm12, %xmm0
  movd	%r11d, %xmm13
  pxor	%xmm0, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm4, %xmm12
  punpckldq	%xmm13, %xmm12
  movdqa	%xmm7, %xmm13
  movq	%xmm12, %rdx
  movd	%r10d, %xmm12
  punpckldq	%xmm12, %xmm13
  movq	%xmm13, %r12
  movdqa	%xmm13, %xmm12
  movq	%rdx, %xmm13
  punpcklqdq	%xmm13, %xmm12
  movdqa	%xmm12, %xmm13
  paddd	%xmm2, %xmm13
  movdqa	%xmm13, %xmm12
  movd	%r10d, %xmm13
  paddd	%xmm0, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$57, %xmm5, %xmm5
  movaps	%xmm5, 32(%rsp)
  movdqa	%xmm15, %xmm0
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm15
  movd	%r9d, %xmm5
  pslld	$25, %xmm15
  pshufd	$78, %xmm0, %xmm0
  psrld	$7, %xmm2
  pxor	%xmm15, %xmm2
  movdqa	%xmm1, %xmm15
  pshufd	$147, %xmm2, %xmm2
  punpckldq	%xmm13, %xmm15
  movdqa	%xmm3, %xmm13
  punpckldq	%xmm5, %xmm13
  movdqa	32(%rsp), %xmm5
  punpcklqdq	%xmm15, %xmm13
  paddd	%xmm2, %xmm13
  paddd	%xmm12, %xmm13
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm4, %xmm12
  punpckldq	%xmm10, %xmm12
  punpcklqdq	%xmm14, %xmm12
  paddd	%xmm2, %xmm12
  movdqa	%xmm7, %xmm14
  paddd	%xmm12, %xmm13
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$8, %xmm5
  pslld	$24, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$147, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm15
  pslld	$25, %xmm12
  pxor	%xmm12, %xmm2
  movd	%eax, %xmm12
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm12, %xmm14
  movd	%edi, %xmm12
  punpckldq	%xmm8, %xmm12
  punpcklqdq	%xmm14, %xmm12
  paddd	%xmm2, %xmm12
  movd	%r11d, %xmm14
  paddd	%xmm13, %xmm12
  punpckldq	%xmm9, %xmm14
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$16, %xmm5
  pslld	$16, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm0
  psrld	$12, %xmm2
  pslld	$20, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm11, %xmm0
  punpckldq	%xmm6, %xmm0
  punpcklqdq	%xmm14, %xmm0
  paddd	%xmm2, %xmm0
  movq	%rdx, %xmm14
  paddd	%xmm0, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$57, %xmm5, %xmm5
  movdqa	%xmm15, %xmm0
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm15
  pslld	$25, %xmm15
  movdqa	%xmm15, %xmm13
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm15
  movdqa	%xmm1, %xmm0
  pxor	%xmm13, %xmm2
  punpckldq	%xmm7, %xmm0
  pshufd	$147, %xmm2, %xmm2
  punpcklqdq	%xmm14, %xmm0
  paddd	%xmm2, %xmm0
  movd	%eax, %xmm14
  movd	%r10d, %xmm13
  paddd	%xmm12, %xmm0
  pxor	%xmm0, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm8, %xmm12
  punpckldq	%xmm14, %xmm12
  movdqa	%xmm6, %xmm14
  punpckldq	%xmm13, %xmm14
  punpcklqdq	%xmm12, %xmm14
  paddd	%xmm2, %xmm14
  movd	%ebx, %xmm13
  paddd	%xmm0, %xmm14
  punpckldq	%xmm10, %xmm13
  pxor	%xmm14, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$147, %xmm5, %xmm5
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  pshufd	$78, %xmm15, %xmm0
  psrld	$7, %xmm2
  pslld	$25, %xmm12
  movd	%ebp, %xmm15
  punpckldq	%xmm11, %xmm15
  pxor	%xmm12, %xmm2
  punpcklqdq	%xmm15, %xmm13
  pshufd	$57, %xmm2, %xmm2
  paddd	%xmm2, %xmm13
  movd	%r9d, %xmm15
  paddd	%xmm14, %xmm13
  movd	%edi, %xmm14
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  punpckldq	%xmm3, %xmm14
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm9, %xmm12
  punpckldq	%xmm15, %xmm12
  punpcklqdq	%xmm14, %xmm12
  paddd	%xmm2, %xmm12
  movd	%r10d, %xmm14
  paddd	%xmm12, %xmm13
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$8, %xmm5
  pslld	$24, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$57, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm15
  pslld	$25, %xmm12
  movq	%r14, %xmm0
  pxor	%xmm12, %xmm2
  movdqa	%xmm6, %xmm12
  pshufd	$147, %xmm2, %xmm2
  punpckldq	%xmm11, %xmm12
  punpcklqdq	%xmm0, %xmm12
  paddd	%xmm2, %xmm12
  paddd	%xmm13, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$16, %xmm5
  pslld	$16, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm0
  psrld	$12, %xmm2
  pslld	$20, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm9, %xmm0
  punpckldq	%xmm14, %xmm0
  movq	%r15, %xmm14
  punpcklqdq	%xmm0, %xmm14
  movdqa	%xmm14, %xmm0
  movdqa	%xmm3, %xmm14
  paddd	%xmm2, %xmm0
  paddd	%xmm0, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$147, %xmm5, %xmm5
  movdqa	%xmm15, %xmm0
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm15
  pslld	$25, %xmm15
  movdqa	%xmm15, %xmm13
  pshufd	$78, %xmm0, %xmm15
  movd	%r11d, %xmm0
  punpckldq	%xmm0, %xmm14
  psrld	$7, %xmm2
  movdqa	%xmm4, %xmm0
  pxor	%xmm13, %xmm2
  punpckldq	%xmm7, %xmm0
  pshufd	$57, %xmm2, %xmm2
  punpcklqdq	%xmm14, %xmm0
  paddd	%xmm2, %xmm0
  movq	%r8, %xmm13
  paddd	%xmm12, %xmm0
  pxor	%xmm0, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm15
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm1, %xmm12
  punpckldq	%xmm8, %xmm12
  punpcklqdq	%xmm12, %xmm13
  paddd	%xmm2, %xmm13
  movdqa	%xmm13, %xmm14
  movdqa	%xmm9, %xmm13
  paddd	%xmm0, %xmm14
  punpckldq	%xmm10, %xmm13
  pxor	%xmm14, %xmm5
  movdqa	%xmm5, %xmm0
  psrld	$8, %xmm5
  pslld	$24, %xmm0
  pxor	%xmm0, %xmm5
  paddd	%xmm5, %xmm15
  pshufd	$57, %xmm5, %xmm5
  pxor	%xmm15, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  pshufd	$78, %xmm15, %xmm0
  pslld	$25, %xmm12
  movdqa	%xmm6, %xmm15
  pxor	%xmm12, %xmm2
  movd	%eax, %xmm12
  pshufd	$147, %xmm2, %xmm2
  punpckldq	%xmm12, %xmm15
  punpcklqdq	%xmm15, %xmm13
  paddd	%xmm2, %xmm13
  movd	%edi, %xmm15
  paddd	%xmm14, %xmm13
  movdqa	%xmm8, %xmm14
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  punpckldq	%xmm15, %xmm14
  pslld	$16, %xmm12
  movdqa	%xmm14, %xmm15
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm11, %xmm12
  punpckldq	%xmm3, %xmm12
  punpcklqdq	%xmm12, %xmm15
  movdqa	%xmm15, %xmm12
  movq	%r15, %xmm15
  paddd	%xmm2, %xmm12
  paddd	%xmm12, %xmm13
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$8, %xmm5
  pslld	$24, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$147, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm0
  pslld	$25, %xmm12
  pxor	%xmm12, %xmm2
  movd	%r11d, %xmm12
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm1, %xmm12
  punpcklqdq	%xmm12, %xmm15
  movdqa	%xmm15, %xmm12
  movd	%ebx, %xmm15
  paddd	%xmm2, %xmm12
  paddd	%xmm12, %xmm13
  pxor	%xmm13, %xmm5
  movdqa	%xmm5, %xmm12
  psrld	$16, %xmm5
  pslld	$16, %xmm12
  pxor	%xmm12, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm12
  psrld	$12, %xmm2
  pslld	$20, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm4, %xmm12
  punpckldq	%xmm15, %xmm12
  movq	%r12, %xmm15
  punpcklqdq	%xmm15, %xmm12
  paddd	%xmm2, %xmm12
  paddd	%xmm13, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm15
  psrld	$8, %xmm5
  pslld	$24, %xmm15
  pxor	%xmm15, %xmm5
  paddd	%xmm5, %xmm0
  movdqa	%xmm8, %xmm15
  movdqa	%xmm7, %xmm8
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm13
  psrld	$7, %xmm2
  punpckldq	%xmm4, %xmm15
  pslld	$25, %xmm13
  pshufd	$57, %xmm5, %xmm5
  pshufd	$78, %xmm0, %xmm0
  pxor	%xmm13, %xmm2
  movdqa	%xmm15, %xmm13
  movd	%edi, %xmm15
  pshufd	$147, %xmm2, %xmm2
  punpckldq	%xmm15, %xmm8
  punpcklqdq	%xmm13, %xmm8
  paddd	%xmm2, %xmm8
  movd	%r11d, %xmm15
  paddd	%xmm8, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm8
  psrld	$16, %xmm5
  pslld	$16, %xmm8
  pxor	%xmm8, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm8
  psrld	$12, %xmm2
  pslld	$20, %xmm8
  pxor	%xmm8, %xmm2
  movd	%eax, %xmm8
  punpckldq	%xmm15, %xmm8
  movd	%ebp, %xmm15
  punpckldq	%xmm3, %xmm15
  movdqa	%xmm15, %xmm3
  punpcklqdq	%xmm8, %xmm3
  movdqa	%xmm3, %xmm8
  movdqa	%xmm11, %xmm3
  paddd	%xmm2, %xmm8
  paddd	%xmm8, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm8
  psrld	$8, %xmm5
  pslld	$24, %xmm8
  pxor	%xmm8, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$147, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm8
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm0
  pslld	$25, %xmm8
  pxor	%xmm8, %xmm2
  movd	%r10d, %xmm8
  pshufd	$57, %xmm2, %xmm2
  punpckldq	%xmm8, %xmm3
  movdqa	%xmm6, %xmm8
  punpckldq	%xmm4, %xmm6
  punpcklqdq	%xmm6, %xmm14
  punpckldq	%xmm9, %xmm8
  punpcklqdq	%xmm3, %xmm8
  paddd	%xmm2, %xmm8
  movdqa	(%rsp), %xmm4
  paddd	%xmm8, %xmm12
  movaps	48(%rsp), %xmm6
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm8
  psrld	$16, %xmm5
  pslld	$16, %xmm8
  pxor	%xmm8, %xmm5
  paddd	%xmm5, %xmm0
  movd	%r9d, %xmm8
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm3
  psrld	$12, %xmm2
  pslld	$20, %xmm3
  pxor	%xmm3, %xmm2
  movd	%ebx, %xmm3
  punpckldq	%xmm8, %xmm3
  movdqa	%xmm1, %xmm8
  punpckldq	%xmm10, %xmm8
  punpcklqdq	%xmm3, %xmm8
  paddd	%xmm2, %xmm8
  punpckldq	%xmm11, %xmm10
  paddd	%xmm8, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm8
  psrld	$8, %xmm5
  pslld	$24, %xmm8
  pxor	%xmm8, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$57, %xmm5, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm2, %xmm3
  psrld	$7, %xmm2
  pshufd	$78, %xmm0, %xmm0
  pslld	$25, %xmm3
  movdqa	%xmm3, %xmm13
  movd	%r9d, %xmm3
  pxor	%xmm2, %xmm13
  movq	%rsi, %xmm2
  pshufd	$147, %xmm13, %xmm13
  punpckldq	%xmm3, %xmm7
  punpcklqdq	%xmm10, %xmm2
  paddd	%xmm13, %xmm2
  movd	%ebx, %xmm3
  paddd	%xmm2, %xmm12
  punpckldq	%xmm3, %xmm1
  punpcklqdq	%xmm7, %xmm1
  movdqa	16(%rsp), %xmm3
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm2
  psrld	$16, %xmm5
  movaps	64(%rsp), %xmm7
  pslld	$16, %xmm2
  pxor	%xmm2, %xmm5
  paddd	%xmm5, %xmm0
  pxor	%xmm0, %xmm13
  movdqa	%xmm13, %xmm8
  psrld	$12, %xmm13
  pslld	$20, %xmm8
  pxor	%xmm8, %xmm13
  paddd	%xmm13, %xmm1
  paddd	%xmm1, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm1
  psrld	$8, %xmm5
  pslld	$24, %xmm1
  pxor	%xmm1, %xmm5
  paddd	%xmm5, %xmm0
  pshufd	$147, %xmm5, %xmm5
  pxor	%xmm0, %xmm13
  movdqa	%xmm13, %xmm1
  psrld	$7, %xmm13
  pshufd	$78, %xmm0, %xmm0
  pslld	$25, %xmm1
  pxor	%xmm1, %xmm13
  movd	%eax, %xmm1
  pshufd	$57, %xmm13, %xmm13
  punpckldq	%xmm9, %xmm1
  punpcklqdq	%xmm1, %xmm15
  paddd	%xmm13, %xmm15
  paddd	%xmm15, %xmm12
  pxor	%xmm12, %xmm5
  movdqa	%xmm5, %xmm2
  psrld	$16, %xmm5
  pslld	$16, %xmm2
  pxor	%xmm5, %xmm2
  paddd	%xmm2, %xmm0
  pxor	%xmm0, %xmm13
  movdqa	%xmm13, %xmm1
  psrld	$12, %xmm13
  pslld	$20, %xmm1
  pxor	%xmm1, %xmm13
  paddd	%xmm13, %xmm14
  movdqa	%xmm13, %xmm1
  paddd	%xmm14, %xmm12
  pxor	%xmm12, %xmm2
  movdqa	%xmm2, %xmm5
  psrld	$8, %xmm2
  pslld	$24, %xmm5
  pxor	%xmm5, %xmm2
  paddd	%xmm2, %xmm0
  pshufd	$57, %xmm2, %xmm2
  pxor	%xmm0, %xmm1
  movdqa	%xmm1, %xmm5
  psrld	$7, %xmm1
  pshufd	$78, %xmm0, %xmm0
  pslld	$25, %xmm5
  pxor	%xmm0, %xmm4
  pxor	%xmm12, %xmm4
  movups	%xmm4, (%rcx)
  pxor	%xmm5, %xmm1
  pshufd	$147, %xmm1, %xmm1
  pxor	%xmm1, %xmm3
  pxor	%xmm2, %xmm3
  movups	%xmm3, 16(%rcx)
  movaps	80(%rsp), %xmm8
  movaps	96(%rsp), %xmm9
  movaps	112(%rsp), %xmm10
  movaps	128(%rsp), %xmm11
  movaps	144(%rsp), %xmm12
  movaps	160(%rsp), %xmm13
  movaps	176(%rsp), %xmm14
  movaps	192(%rsp), %xmm15
  addq	$208, %rsp
  popq	%rbx
  popq	%rbp
  popq	%r12
  popq	%r14
  popq	%r15
{$IF DEFINED(WINDOWS)}
  popq	%rsi
  popq	%rdi
{$ELSE IF DEFINED(UNIX)}
  popq	%rdx
  popq	%rcx
{$ENDIF}
end;

procedure blake2b_compress( S: Pblake2b_state; const block: pcuint8 ); assembler; nostackframe;
asm
{$IF DEFINED(UNIX)}
  pushq	%rcx
  movq	%rdi,	%rcx
  pushq	%rdx
  movq	%rsi,	%rdx
{$ENDIF}
  subq	$552, %rsp
  movaps	%xmm6, 384(%rsp)
  movaps	%xmm7, 400(%rsp)
  movaps	%xmm8, 416(%rsp)
  movaps	%xmm9, 432(%rsp)
  movaps	%xmm10, 448(%rsp)
  movaps	%xmm11, 464(%rsp)
  movaps	%xmm12, 480(%rsp)
  movaps	%xmm13, 496(%rsp)
  movaps	%xmm14, 512(%rsp)
  movaps	%xmm15, 528(%rsp)
  movq	(%rdx), %rax
  movdqu	(%rcx), %xmm7
  movdqu	32(%rcx), %xmm5
  movq	16(%rdx), %xmm6
  movq	%rax, 8(%rsp)
  movq	32(%rdx), %rax
  paddq	%xmm7, %xmm5
  movq	8(%rsp), %xmm1
  movdqu	16(%rcx), %xmm0
  movdqu	48(%rcx), %xmm4
  punpcklqdq	%xmm6, %xmm1
  paddq	%xmm1, %xmm5
  movaps	%xmm1, 144(%rsp)
  movq	%rax, 40(%rsp)
  movq	48(%rdx), %rax
  movq	40(%rsp), %xmm7
  paddq	%xmm0, %xmm4
  movdqu	64(%rcx), %xmm3
  pxor	blake2b_IV_3(%rip), %xmm3
  pxor	%xmm5, %xmm3
  movdqa	%xmm3, %xmm0
  psllq	$32, %xmm0
  movdqu	80(%rcx), %xmm2
  pxor	blake2b_IV_4(%rip), %xmm2
  movq	%rax, 16(%rsp)
  movq	8(%rdx), %rax
  psrlq	$32, %xmm3
  movhps	16(%rsp), %xmm7
  pxor	%xmm0, %xmm3
  movdqu	32(%rcx), %xmm9
  paddq	%xmm7, %xmm4
  movaps	%xmm7, 160(%rsp)
  movdqu	48(%rcx), %xmm11
  pxor	%xmm4, %xmm2
  movdqa	%xmm2, %xmm0
  psrlq	$32, %xmm2
  movq	%rax, (%rsp)
  movq	24(%rdx), %rax
  psllq	$32, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	blake2b_IV(%rip), %xmm0
  paddq	%xmm3, %xmm0
  movq	%rax, 24(%rsp)
  movq	40(%rdx), %rax
  movdqa	%xmm0, %xmm1
  movdqa	blake2b_IV_2(%rip), %xmm0
  pxor	%xmm1, %xmm9
  movdqa	%xmm9, %xmm7
  movdqa	%xmm9, %xmm8
  psllq	$40, %xmm8
  paddq	%xmm2, %xmm0
  psrlq	$24, %xmm7
  movq	%rax, 48(%rsp)
  movq	56(%rdx), %rax
  pxor	%xmm0, %xmm11
  pxor	%xmm8, %xmm7
  movdqa	%xmm11, %xmm8
  psrlq	$24, %xmm11
  psllq	$40, %xmm8
  pxor	%xmm8, %xmm11
  movq	%rax, 56(%rsp)
  movq	(%rsp), %xmm8
  movq	48(%rsp), %xmm14
  movhps	24(%rsp), %xmm8
  movq	64(%rdx), %rax
  paddq	%xmm8, %xmm5
  movhps	56(%rsp), %xmm14
  movq	72(%rdx), %xmm10
  movaps	%xmm8, 176(%rsp)
  paddq	%xmm7, %xmm5
  paddq	%xmm14, %xmm4
  movq	104(%rdx), %xmm8
  movaps	%xmm14, 192(%rsp)
  pxor	%xmm5, %xmm3
  movdqa	%xmm3, %xmm13
  paddq	%xmm11, %xmm4
  psrlq	$16, %xmm3
  psllq	$48, %xmm13
  pxor	%xmm4, %xmm2
  movq	%rax, 64(%rsp)
  movq	80(%rdx), %rax
  pxor	%xmm13, %xmm3
  movdqa	%xmm2, %xmm13
  paddq	%xmm3, %xmm1
  psrlq	$16, %xmm2
  psllq	$48, %xmm13
  pxor	%xmm1, %xmm7
  movdqa	%xmm10, %xmm14
  pxor	%xmm13, %xmm2
  movdqa	%xmm7, %xmm13
  paddq	%xmm2, %xmm0
  psrlq	$63, %xmm7
  psllq	$1, %xmm13
  pxor	%xmm0, %xmm11
  movq	%rax, 72(%rsp)
  movq	96(%rdx), %rax
  pxor	%xmm13, %xmm7
  movdqa	%xmm11, %xmm13
  psrlq	$63, %xmm11
  movdqa	%xmm2, %xmm12
  psllq	$1, %xmm13
  punpcklqdq	%xmm2, %xmm2
  pxor	%xmm13, %xmm11
  movdqa	%xmm3, %xmm13
  punpcklqdq	%xmm3, %xmm13
  punpckhqdq	%xmm2, %xmm3
  movdqa	%xmm11, %xmm2
  punpckhqdq	%xmm13, %xmm12
  punpcklqdq	%xmm11, %xmm2
  movdqa	%xmm7, %xmm13
  punpcklqdq	%xmm7, %xmm7
  punpckhqdq	%xmm7, %xmm11
  movq	64(%rsp), %xmm7
  movq	%rax, 32(%rsp)
  punpckhqdq	%xmm2, %xmm13
  movdqa	%xmm13, %xmm2
  movq	112(%rdx), %rax
  movhps	72(%rsp), %xmm7
  movaps	%xmm7, 208(%rsp)
  paddq	%xmm13, %xmm7
  paddq	%xmm7, %xmm5
  movq	32(%rsp), %xmm7
  movq	%rax, 80(%rsp)
  pxor	%xmm5, %xmm12
  movdqa	%xmm12, %xmm13
  psrlq	$32, %xmm12
  movhps	80(%rsp), %xmm7
  psllq	$32, %xmm13
  movq	120(%rdx), %rax
  movdqa	%xmm7, %xmm15
  pxor	%xmm13, %xmm12
  paddq	%xmm12, %xmm0
  movaps	%xmm7, 112(%rsp)
  paddq	%xmm11, %xmm15
  pxor	%xmm0, %xmm2
  movq	88(%rdx), %xmm7
  paddq	%xmm15, %xmm4
  pxor	%xmm4, %xmm3
  movdqa	%xmm3, %xmm13
  psrlq	$32, %xmm3
  punpcklqdq	%xmm7, %xmm14
  psllq	$32, %xmm13
  movq	%rax, %xmm9
  movq	%rax, 88(%rsp)
  movaps	%xmm14, 224(%rsp)
  pxor	%xmm13, %xmm3
  movdqa	%xmm2, %xmm13
  paddq	%xmm3, %xmm1
  psllq	$40, %xmm13
  pxor	%xmm1, %xmm11
  psrlq	$24, %xmm2
  pxor	%xmm13, %xmm2
  movdqa	%xmm11, %xmm13
  psrlq	$24, %xmm11
  psllq	$40, %xmm13
  pxor	%xmm13, %xmm11
  movdqa	%xmm14, %xmm13
  movdqa	%xmm8, %xmm14
  paddq	%xmm2, %xmm13
  punpcklqdq	%xmm9, %xmm14
  movdqa	%xmm14, %xmm15
  movaps	%xmm14, 240(%rsp)
  paddq	%xmm13, %xmm5
  paddq	%xmm11, %xmm15
  movq	80(%rsp), %xmm14
  pxor	%xmm5, %xmm12
  movdqa	%xmm12, %xmm13
  paddq	%xmm15, %xmm4
  psrlq	$16, %xmm12
  psllq	$48, %xmm13
  pxor	%xmm4, %xmm3
  movhps	40(%rsp), %xmm14
  movaps	%xmm14, 128(%rsp)
  pxor	%xmm13, %xmm12
  movdqa	%xmm3, %xmm13
  psrlq	$16, %xmm3
  psllq	$48, %xmm13
  paddq	%xmm12, %xmm0
  pxor	%xmm13, %xmm3
  paddq	%xmm3, %xmm1
  pxor	%xmm0, %xmm2
  pxor	%xmm1, %xmm11
  movdqa	%xmm11, %xmm13
  movdqa	%xmm2, %xmm11
  psllq	$1, %xmm11
  psrlq	$63, %xmm2
  pxor	%xmm11, %xmm2
  movdqa	%xmm13, %xmm11
  psrlq	$63, %xmm13
  psllq	$1, %xmm11
  pxor	%xmm11, %xmm13
  movdqa	%xmm2, %xmm11
  movdqa	%xmm13, %xmm15
  punpcklqdq	%xmm13, %xmm13
  punpcklqdq	%xmm2, %xmm11
  punpckhqdq	%xmm13, %xmm2
  movdqa	%xmm3, %xmm13
  punpckhqdq	%xmm11, %xmm15
  punpcklqdq	%xmm3, %xmm13
  movdqa	%xmm15, %xmm11
  movdqa	%xmm12, %xmm15
  punpcklqdq	%xmm12, %xmm12
  punpckhqdq	%xmm12, %xmm3
  movdqa	%xmm14, %xmm12
  punpckhqdq	%xmm13, %xmm15
  movdqa	%xmm15, %xmm13
  paddq	%xmm11, %xmm12
  paddq	%xmm12, %xmm5
  movdqa	%xmm10, %xmm12
  punpcklqdq	%xmm8, %xmm12
  movdqa	%xmm12, %xmm15
  pxor	%xmm5, %xmm13
  movaps	%xmm12, 256(%rsp)
  paddq	%xmm2, %xmm15
  movdqa	%xmm13, %xmm12
  paddq	%xmm15, %xmm4
  psllq	$32, %xmm12
  psrlq	$32, %xmm13
  pxor	%xmm4, %xmm3
  pxor	%xmm12, %xmm13
  movdqa	%xmm3, %xmm12
  paddq	%xmm13, %xmm1
  psrlq	$32, %xmm3
  psllq	$32, %xmm12
  pxor	%xmm1, %xmm11
  pxor	%xmm12, %xmm3
  paddq	%xmm3, %xmm0
  movdqa	%xmm3, %xmm14
  movdqa	%xmm11, %xmm3
  psllq	$40, %xmm3
  pxor	%xmm0, %xmm2
  psrlq	$24, %xmm11
  pxor	%xmm3, %xmm11
  movdqa	%xmm2, %xmm3
  psrlq	$24, %xmm2
  psllq	$40, %xmm3
  pxor	%xmm3, %xmm2
  movq	72(%rsp), %xmm3
  movhps	64(%rsp), %xmm3
  movq	24(%rsp), %xmm9
  movaps	%xmm3, 272(%rsp)
  movdqa	%xmm3, %xmm12
  movq	%rax, %xmm3
  movhps	16(%rsp), %xmm3
  paddq	%xmm11, %xmm12
  paddq	%xmm12, %xmm5
  movaps	%xmm3, 288(%rsp)
  paddq	%xmm2, %xmm3
  paddq	%xmm3, %xmm4
  pxor	%xmm5, %xmm13
  movdqa	%xmm13, %xmm12
  psrlq	$16, %xmm13
  pxor	%xmm4, %xmm14
  psllq	$48, %xmm12
  movdqa	%xmm13, %xmm3
  movdqa	%xmm14, %xmm13
  psrlq	$16, %xmm14
  pxor	%xmm12, %xmm3
  paddq	%xmm3, %xmm1
  psllq	$48, %xmm13
  movdqa	%xmm14, %xmm12
  pxor	%xmm1, %xmm11
  pxor	%xmm13, %xmm12
  movdqa	%xmm11, %xmm13
  paddq	%xmm12, %xmm0
  psrlq	$63, %xmm11
  psllq	$1, %xmm13
  pxor	%xmm0, %xmm2
  movdqa	%xmm12, %xmm14
  punpcklqdq	%xmm12, %xmm12
  pxor	%xmm13, %xmm11
  movdqa	%xmm2, %xmm13
  psrlq	$63, %xmm2
  psllq	$1, %xmm13
  pxor	%xmm13, %xmm2
  movdqa	%xmm3, %xmm13
  punpcklqdq	%xmm3, %xmm13
  punpckhqdq	%xmm12, %xmm3
  movdqa	%xmm2, %xmm12
  punpckhqdq	%xmm13, %xmm14
  punpcklqdq	%xmm2, %xmm12
  movdqa	%xmm14, %xmm13
  movdqa	%xmm11, %xmm14
  punpcklqdq	%xmm11, %xmm11
  punpckhqdq	%xmm11, %xmm2
  movq	(%rsp), %xmm11
  punpckhqdq	%xmm12, %xmm14
  movdqa	%xmm7, %xmm12
  movhps	48(%rsp), %xmm12
  movaps	%xmm12, 320(%rsp)
  movhps	8(%rsp), %xmm11
  paddq	%xmm2, %xmm12
  movaps	%xmm11, 304(%rsp)
  paddq	%xmm14, %xmm11
  paddq	%xmm12, %xmm4
  paddq	%xmm11, %xmm5
  pxor	%xmm4, %xmm3
  pxor	%xmm5, %xmm13
  movdqa	%xmm13, %xmm11
  psrlq	$32, %xmm13
  psllq	$32, %xmm11
  pxor	%xmm11, %xmm13
  movdqa	%xmm3, %xmm11
  paddq	%xmm13, %xmm0
  psrlq	$32, %xmm3
  psllq	$32, %xmm11
  pxor	%xmm0, %xmm14
  pxor	%xmm11, %xmm3
  movdqa	%xmm14, %xmm11
  paddq	%xmm3, %xmm1
  psrlq	$24, %xmm14
  psllq	$40, %xmm11
  pxor	%xmm1, %xmm2
  pxor	%xmm11, %xmm14
  movdqa	%xmm2, %xmm11
  psrlq	$24, %xmm2
  psllq	$40, %xmm11
  pxor	%xmm11, %xmm2
  movdqa	%xmm2, %xmm11
  movq	32(%rsp), %xmm2
  punpcklqdq	%xmm6, %xmm2
  movaps	%xmm2, 336(%rsp)
  paddq	%xmm14, %xmm2
  paddq	%xmm2, %xmm5
  movq	56(%rsp), %xmm2
  pxor	%xmm5, %xmm13
  punpcklqdq	%xmm9, %xmm2
  movdqa	%xmm2, %xmm15
  movaps	%xmm2, 96(%rsp)
  movdqa	%xmm13, %xmm2
  paddq	%xmm11, %xmm15
  psllq	$48, %xmm2
  paddq	%xmm15, %xmm4
  psrlq	$16, %xmm13
  pxor	%xmm4, %xmm3
  pxor	%xmm2, %xmm13
  movdqa	%xmm13, %xmm12
  movdqa	%xmm3, %xmm13
  paddq	%xmm12, %xmm0
  psllq	$48, %xmm13
  psrlq	$16, %xmm3
  pxor	%xmm0, %xmm14
  movdqa	%xmm14, %xmm2
  pxor	%xmm13, %xmm3
  movdqa	%xmm14, %xmm13
  paddq	%xmm3, %xmm1
  psrlq	$63, %xmm2
  psllq	$1, %xmm13
  pxor	%xmm1, %xmm11
  pxor	%xmm13, %xmm2
  movdqa	%xmm11, %xmm13
  psrlq	$63, %xmm11
  psllq	$1, %xmm13
  pxor	%xmm13, %xmm11
  movdqa	%xmm2, %xmm13
  movdqa	%xmm11, %xmm14
  punpcklqdq	%xmm11, %xmm11
  punpcklqdq	%xmm2, %xmm13
  punpckhqdq	%xmm13, %xmm14
  movdqa	%xmm3, %xmm13
  punpckhqdq	%xmm11, %xmm2
  punpcklqdq	%xmm3, %xmm13
  movdqa	%xmm13, %xmm11
  movdqa	%xmm12, %xmm13
  punpcklqdq	%xmm12, %xmm12
  punpckhqdq	%xmm11, %xmm13
  movdqa	%xmm13, %xmm11
  movdqa	%xmm7, %xmm13
  punpckhqdq	%xmm12, %xmm3
  movhps	32(%rsp), %xmm13
  movdqa	%xmm13, %xmm12
  paddq	%xmm14, %xmm12
  paddq	%xmm5, %xmm12
  movq	48(%rsp), %xmm5
  pxor	%xmm12, %xmm11
  movhps	88(%rsp), %xmm5
  movdqa	%xmm5, %xmm13
  movaps	%xmm5, 352(%rsp)
  movdqa	%xmm11, %xmm5
  paddq	%xmm2, %xmm13
  psrlq	$32, %xmm11
  movdqa	%xmm13, %xmm15
  psllq	$32, %xmm5
  paddq	%xmm4, %xmm15
  movdqa	%xmm3, %xmm4
  movdqa	%xmm11, %xmm3
  pxor	%xmm15, %xmm4
  pxor	%xmm5, %xmm3
  movdqa	%xmm4, %xmm5
  paddq	%xmm3, %xmm1
  psrlq	$32, %xmm4
  pxor	%xmm1, %xmm14
  psllq	$32, %xmm5
  movdqa	%xmm4, %xmm11
  movdqa	%xmm14, %xmm4
  pxor	%xmm5, %xmm11
  psllq	$40, %xmm4
  paddq	%xmm11, %xmm0
  movq	64(%rsp), %xmm5
  psrlq	$24, %xmm14
  pxor	%xmm0, %xmm2
  pxor	%xmm4, %xmm14
  movdqa	%xmm2, %xmm4
  psrlq	$24, %xmm2
  movhps	8(%rsp), %xmm5
  psllq	$40, %xmm4
  paddq	%xmm14, %xmm5
  pxor	%xmm4, %xmm2
  movdqa	%xmm6, %xmm4
  paddq	%xmm5, %xmm12
  punpcklqdq	%xmm8, %xmm4
  movdqa	%xmm4, %xmm13
  pxor	%xmm12, %xmm3
  movdqa	%xmm3, %xmm5
  paddq	%xmm2, %xmm13
  psllq	$48, %xmm5
  movdqa	%xmm13, %xmm4
  psrlq	$16, %xmm3
  paddq	%xmm15, %xmm4
  pxor	%xmm5, %xmm3
  paddq	%xmm3, %xmm1
  pxor	%xmm4, %xmm11
  movdqa	%xmm11, %xmm5
  psrlq	$16, %xmm11
  pxor	%xmm1, %xmm14
  psllq	$48, %xmm5
  pxor	%xmm5, %xmm11
  movdqa	%xmm14, %xmm5
  psrlq	$63, %xmm14
  paddq	%xmm11, %xmm0
  psllq	$1, %xmm5
  pxor	%xmm0, %xmm2
  movdqa	%xmm5, %xmm13
  movdqa	%xmm14, %xmm5
  movdqa	%xmm11, %xmm14
  punpcklqdq	%xmm11, %xmm11
  pxor	%xmm13, %xmm5
  movdqa	%xmm2, %xmm13
  psrlq	$63, %xmm2
  psllq	$1, %xmm13
  pxor	%xmm13, %xmm2
  movdqa	%xmm3, %xmm13
  punpcklqdq	%xmm3, %xmm13
  punpckhqdq	%xmm13, %xmm14
  movdqa	%xmm2, %xmm13
  punpckhqdq	%xmm11, %xmm3
  punpcklqdq	%xmm2, %xmm13
  movdqa	%xmm13, %xmm11
  movdqa	%xmm5, %xmm13
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm5, %xmm2
  movq	72(%rsp), %xmm5
  punpckhqdq	%xmm11, %xmm13
  movdqa	%xmm13, %xmm11
  punpcklqdq	%xmm9, %xmm5
  paddq	%xmm13, %xmm5
  movq	56(%rsp), %xmm13
  paddq	%xmm12, %xmm5
  movq	40(%rsp), %xmm9
  punpcklqdq	%xmm10, %xmm13
  paddq	%xmm2, %xmm13
  pxor	%xmm5, %xmm14
  paddq	%xmm4, %xmm13
  movdqa	%xmm14, %xmm4
  psllq	$32, %xmm4
  pxor	%xmm13, %xmm3
  psrlq	$32, %xmm14
  pxor	%xmm4, %xmm14
  movdqa	%xmm3, %xmm4
  paddq	%xmm14, %xmm0
  psrlq	$32, %xmm3
  psllq	$32, %xmm4
  pxor	%xmm0, %xmm11
  pxor	%xmm4, %xmm3
  movdqa	%xmm11, %xmm4
  paddq	%xmm3, %xmm1
  psrlq	$24, %xmm11
  psllq	$40, %xmm4
  pxor	%xmm1, %xmm2
  pxor	%xmm4, %xmm11
  movdqa	%xmm2, %xmm4
  psrlq	$24, %xmm2
  psllq	$40, %xmm4
  movdqa	%xmm4, %xmm12
  movdqa	%xmm2, %xmm4
  movq	80(%rsp), %xmm2
  pxor	%xmm12, %xmm4
  movhps	16(%rsp), %xmm2
  movdqa	%xmm2, %xmm12
  movq	(%rsp), %xmm2
  paddq	%xmm11, %xmm12
  paddq	%xmm12, %xmm5
  punpcklqdq	%xmm9, %xmm2
  movdqa	%xmm2, %xmm15
  paddq	%xmm4, %xmm15
  pxor	%xmm5, %xmm14
  movdqa	%xmm14, %xmm2
  paddq	%xmm15, %xmm13
  psllq	$48, %xmm2
  psrlq	$16, %xmm14
  pxor	%xmm13, %xmm3
  pxor	%xmm2, %xmm14
  movdqa	%xmm3, %xmm2
  psrlq	$16, %xmm3
  paddq	%xmm14, %xmm0
  psllq	$48, %xmm2
  pxor	%xmm0, %xmm11
  movdqa	%xmm14, %xmm12
  movdqa	%xmm11, %xmm14
  pxor	%xmm2, %xmm3
  paddq	%xmm3, %xmm1
  movdqa	%xmm11, %xmm2
  pxor	%xmm1, %xmm4
  movdqa	%xmm4, %xmm11
  psllq	$1, %xmm14
  psllq	$1, %xmm11
  psrlq	$63, %xmm2
  psrlq	$63, %xmm4
  pxor	%xmm14, %xmm2
  pxor	%xmm11, %xmm4
  movdqa	%xmm2, %xmm11
  movdqa	%xmm4, %xmm14
  punpcklqdq	%xmm4, %xmm4
  punpcklqdq	%xmm2, %xmm11
  punpckhqdq	%xmm4, %xmm2
  movdqa	%xmm3, %xmm4
  punpckhqdq	%xmm11, %xmm14
  punpcklqdq	%xmm3, %xmm4
  movdqa	%xmm14, %xmm11
  movdqa	%xmm12, %xmm14
  punpcklqdq	%xmm12, %xmm12
  punpckhqdq	%xmm12, %xmm3
  movdqa	96(%rsp), %xmm12
  punpckhqdq	%xmm4, %xmm14
  movdqa	%xmm14, %xmm4
  paddq	%xmm11, %xmm12
  paddq	%xmm5, %xmm12
  movdqa	%xmm8, %xmm5
  punpcklqdq	%xmm7, %xmm5
  movdqa	%xmm5, %xmm15
  pxor	%xmm12, %xmm4
  movdqa	%xmm4, %xmm5
  paddq	%xmm2, %xmm15
  psllq	$32, %xmm5
  paddq	%xmm13, %xmm15
  psrlq	$32, %xmm4
  movdqa	112(%rsp), %xmm13
  pxor	%xmm15, %xmm3
  pxor	%xmm5, %xmm4
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm1
  psllq	$32, %xmm5
  pxor	%xmm1, %xmm11
  psrlq	$32, %xmm3
  pxor	%xmm5, %xmm3
  movdqa	%xmm11, %xmm5
  paddq	%xmm3, %xmm0
  psrlq	$24, %xmm11
  psllq	$40, %xmm5
  pxor	%xmm0, %xmm2
  pxor	%xmm5, %xmm11
  movdqa	%xmm2, %xmm5
  psrlq	$24, %xmm2
  psllq	$40, %xmm5
  pxor	%xmm5, %xmm2
  movdqa	%xmm10, %xmm5
  paddq	%xmm2, %xmm13
  movhps	(%rsp), %xmm5
  paddq	%xmm13, %xmm15
  movdqa	%xmm5, %xmm14
  pxor	%xmm15, %xmm3
  paddq	%xmm11, %xmm14
  movdqa	%xmm14, %xmm5
  paddq	%xmm12, %xmm5
  pxor	%xmm5, %xmm4
  movdqa	%xmm4, %xmm13
  psrlq	$16, %xmm4
  psllq	$48, %xmm13
  pxor	%xmm13, %xmm4
  movdqa	%xmm3, %xmm13
  paddq	%xmm4, %xmm1
  psrlq	$16, %xmm3
  psllq	$48, %xmm13
  pxor	%xmm1, %xmm11
  pxor	%xmm13, %xmm3
  movdqa	%xmm11, %xmm13
  paddq	%xmm3, %xmm0
  psrlq	$63, %xmm11
  psllq	$1, %xmm13
  pxor	%xmm0, %xmm2
  pxor	%xmm13, %xmm11
  movdqa	%xmm2, %xmm13
  psrlq	$63, %xmm2
  movdqa	%xmm11, %xmm14
  psllq	$1, %xmm13
  punpcklqdq	%xmm11, %xmm11
  pxor	%xmm13, %xmm2
  movdqa	%xmm4, %xmm13
  punpcklqdq	%xmm4, %xmm13
  movdqa	%xmm13, %xmm12
  movdqa	%xmm3, %xmm13
  punpcklqdq	%xmm3, %xmm3
  punpckhqdq	%xmm3, %xmm4
  movdqa	%xmm2, %xmm3
  punpckhqdq	%xmm12, %xmm13
  punpcklqdq	%xmm2, %xmm3
  punpckhqdq	%xmm3, %xmm14
  movdqa	%xmm14, %xmm3
  movdqa	%xmm6, %xmm14
  movhps	48(%rsp), %xmm14
  punpckhqdq	%xmm11, %xmm2
  paddq	%xmm3, %xmm14
  paddq	%xmm5, %xmm14
  movdqa	%xmm9, %xmm5
  movhps	88(%rsp), %xmm5
  pxor	%xmm14, %xmm13
  movdqa	%xmm5, %xmm12
  movdqa	%xmm2, %xmm5
  paddq	%xmm12, %xmm5
  paddq	%xmm5, %xmm15
  movdqa	%xmm13, %xmm5
  psllq	$32, %xmm5
  pxor	%xmm15, %xmm4
  psrlq	$32, %xmm13
  movdqa	%xmm5, %xmm11
  movdqa	%xmm13, %xmm5
  movdqa	%xmm4, %xmm13
  pxor	%xmm11, %xmm5
  psllq	$32, %xmm13
  paddq	%xmm5, %xmm0
  psrlq	$32, %xmm4
  pxor	%xmm0, %xmm3
  pxor	%xmm13, %xmm4
  movdqa	%xmm3, %xmm13
  paddq	%xmm4, %xmm1
  psrlq	$24, %xmm3
  psllq	$40, %xmm13
  pxor	%xmm1, %xmm2
  pxor	%xmm13, %xmm3
  movdqa	%xmm2, %xmm13
  psrlq	$24, %xmm2
  psllq	$40, %xmm13
  pxor	%xmm13, %xmm2
  movq	16(%rsp), %xmm13
  movhps	72(%rsp), %xmm13
  movq	8(%rsp), %xmm11
  movaps	%xmm13, 368(%rsp)
  paddq	%xmm3, %xmm13
  movhps	64(%rsp), %xmm11
  paddq	%xmm13, %xmm14
  movdqa	%xmm11, %xmm13
  pxor	%xmm14, %xmm5
  paddq	%xmm2, %xmm13
  paddq	%xmm13, %xmm15
  movdqa	%xmm5, %xmm13
  psrlq	$16, %xmm13
  pxor	%xmm15, %xmm4
  psllq	$48, %xmm5
  pxor	%xmm5, %xmm13
  movdqa	%xmm4, %xmm5
  paddq	%xmm13, %xmm0
  psrlq	$16, %xmm4
  psllq	$48, %xmm5
  pxor	%xmm0, %xmm3
  pxor	%xmm5, %xmm4
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm1
  psrlq	$63, %xmm3
  psllq	$1, %xmm5
  pxor	%xmm1, %xmm2
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  psrlq	$63, %xmm2
  psllq	$1, %xmm5
  pxor	%xmm5, %xmm2
  movdqa	%xmm3, %xmm5
  movdqa	%xmm2, %xmm9
  punpcklqdq	%xmm2, %xmm2
  punpcklqdq	%xmm3, %xmm5
  punpckhqdq	%xmm5, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm4, %xmm9
  punpckhqdq	%xmm2, %xmm3
  punpcklqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm2
  movdqa	%xmm13, %xmm9
  punpcklqdq	%xmm13, %xmm13
  punpckhqdq	%xmm13, %xmm4
  movdqa	%xmm10, %xmm13
  punpckhqdq	%xmm2, %xmm9
  movhps	48(%rsp), %xmm13
  movdqa	%xmm9, %xmm2
  paddq	%xmm5, %xmm13
  paddq	%xmm13, %xmm14
  movdqa	%xmm6, %xmm13
  movhps	72(%rsp), %xmm13
  pxor	%xmm14, %xmm2
  movdqa	%xmm2, %xmm9
  paddq	%xmm3, %xmm13
  psllq	$32, %xmm9
  paddq	%xmm15, %xmm13
  psrlq	$32, %xmm2
  movq	8(%rsp), %xmm15
  pxor	%xmm13, %xmm4
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm1
  psllq	$32, %xmm9
  pxor	%xmm1, %xmm5
  movhps	56(%rsp), %xmm15
  psrlq	$32, %xmm4
  pxor	%xmm9, %xmm4
  movdqa	%xmm5, %xmm9
  paddq	%xmm4, %xmm0
  psrlq	$24, %xmm5
  psllq	$40, %xmm9
  pxor	%xmm0, %xmm3
  pxor	%xmm9, %xmm5
  movdqa	%xmm3, %xmm9
  paddq	%xmm5, %xmm15
  psrlq	$24, %xmm3
  paddq	%xmm15, %xmm14
  psllq	$40, %xmm9
  pxor	%xmm9, %xmm3
  pxor	%xmm14, %xmm2
  paddq	%xmm3, %xmm12
  movdqa	%xmm2, %xmm9
  paddq	%xmm12, %xmm13
  psllq	$48, %xmm9
  psrlq	$16, %xmm2
  pxor	%xmm13, %xmm4
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  psrlq	$16, %xmm4
  psllq	$48, %xmm9
  pxor	%xmm9, %xmm4
  movdqa	%xmm4, %xmm12
  movdqa	%xmm1, %xmm4
  paddq	%xmm12, %xmm0
  paddq	%xmm2, %xmm4
  movdqa	%xmm12, %xmm9
  punpcklqdq	%xmm12, %xmm12
  pxor	%xmm4, %xmm5
  pxor	%xmm0, %xmm3
  movdqa	%xmm0, %xmm1
  movdqa	%xmm5, %xmm0
  psllq	$1, %xmm0
  psrlq	$63, %xmm5
  pxor	%xmm0, %xmm5
  movdqa	%xmm3, %xmm0
  psrlq	$63, %xmm3
  psllq	$1, %xmm0
  pxor	%xmm0, %xmm3
  movdqa	%xmm2, %xmm0
  punpcklqdq	%xmm2, %xmm0
  punpckhqdq	%xmm0, %xmm9
  movdqa	%xmm9, %xmm0
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm9
  punpckhqdq	%xmm12, %xmm2
  movdqa	%xmm9, %xmm12
  movdqa	%xmm5, %xmm9
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm5, %xmm3
  movq	80(%rsp), %xmm5
  punpckhqdq	%xmm12, %xmm9
  movdqa	%xmm9, %xmm12
  punpcklqdq	%xmm7, %xmm5
  movdqa	%xmm5, %xmm15
  movq	16(%rsp), %xmm5
  paddq	%xmm9, %xmm15
  paddq	%xmm15, %xmm14
  movhps	24(%rsp), %xmm5
  paddq	%xmm3, %xmm5
  pxor	%xmm14, %xmm0
  movdqa	%xmm0, %xmm9
  paddq	%xmm5, %xmm13
  psllq	$32, %xmm9
  psrlq	$32, %xmm0
  pxor	%xmm13, %xmm2
  pxor	%xmm9, %xmm0
  movdqa	%xmm0, %xmm5
  movdqa	%xmm2, %xmm0
  paddq	%xmm5, %xmm1
  psllq	$32, %xmm0
  psrlq	$32, %xmm2
  pxor	%xmm1, %xmm12
  pxor	%xmm0, %xmm2
  movdqa	%xmm12, %xmm0
  paddq	%xmm2, %xmm4
  psrlq	$24, %xmm12
  psllq	$40, %xmm0
  pxor	%xmm4, %xmm3
  pxor	%xmm0, %xmm12
  movdqa	%xmm3, %xmm0
  psrlq	$24, %xmm3
  psllq	$40, %xmm0
  pxor	%xmm0, %xmm3
  movq	(%rsp), %xmm0
  movhps	32(%rsp), %xmm0
  movdqa	%xmm0, %xmm15
  movq	64(%rsp), %xmm0
  paddq	%xmm12, %xmm15
  paddq	%xmm15, %xmm14
  punpcklqdq	%xmm8, %xmm0
  paddq	%xmm3, %xmm0
  paddq	%xmm0, %xmm13
  pxor	%xmm14, %xmm5
  movdqa	%xmm5, %xmm0
  psllq	$48, %xmm0
  pxor	%xmm13, %xmm2
  psrlq	$16, %xmm5
  pxor	%xmm0, %xmm5
  movdqa	%xmm2, %xmm0
  paddq	%xmm5, %xmm1
  psrlq	$16, %xmm2
  psllq	$48, %xmm0
  pxor	%xmm1, %xmm12
  pxor	%xmm0, %xmm2
  movdqa	%xmm12, %xmm0
  paddq	%xmm2, %xmm4
  psrlq	$63, %xmm12
  psllq	$1, %xmm0
  pxor	%xmm4, %xmm3
  pxor	%xmm0, %xmm12
  movdqa	%xmm3, %xmm0
  psrlq	$63, %xmm3
  psllq	$1, %xmm0
  pxor	%xmm0, %xmm3
  movdqa	%xmm12, %xmm0
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm3
  punpcklqdq	%xmm12, %xmm0
  punpckhqdq	%xmm0, %xmm9
  movdqa	%xmm2, %xmm0
  movdqa	%xmm9, %xmm15
  movdqa	%xmm5, %xmm9
  punpcklqdq	%xmm2, %xmm0
  punpckhqdq	%xmm3, %xmm12
  paddq	%xmm12, %xmm11
  punpckhqdq	%xmm0, %xmm9
  movdqa	%xmm6, %xmm0
  movdqa	%xmm9, %xmm3
  paddq	%xmm11, %xmm13
  movhps	16(%rsp), %xmm0
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm5, %xmm2
  pxor	%xmm13, %xmm2
  paddq	%xmm15, %xmm0
  movq	40(%rsp), %xmm5
  paddq	%xmm0, %xmm14
  pxor	%xmm14, %xmm3
  movdqa	%xmm3, %xmm0
  psrlq	$32, %xmm3
  movhps	56(%rsp), %xmm5
  psllq	$32, %xmm0
  pxor	%xmm0, %xmm3
  movdqa	%xmm2, %xmm0
  psrlq	$32, %xmm2
  psllq	$32, %xmm0
  pxor	%xmm0, %xmm2
  movdqa	%xmm4, %xmm0
  paddq	%xmm2, %xmm1
  paddq	%xmm3, %xmm0
  pxor	%xmm1, %xmm12
  pxor	%xmm0, %xmm15
  movdqa	%xmm15, %xmm4
  psrlq	$24, %xmm15
  psllq	$40, %xmm4
  pxor	%xmm4, %xmm15
  movdqa	%xmm12, %xmm4
  psrlq	$24, %xmm12
  psllq	$40, %xmm4
  pxor	%xmm4, %xmm12
  movq	32(%rsp), %xmm4
  movhps	72(%rsp), %xmm4
  paddq	%xmm15, %xmm4
  paddq	%xmm4, %xmm14
  movdqa	%xmm7, %xmm4
  movhps	24(%rsp), %xmm4
  pxor	%xmm14, %xmm3
  movdqa	%xmm4, %xmm11
  movdqa	%xmm3, %xmm4
  paddq	%xmm12, %xmm11
  psllq	$48, %xmm4
  paddq	%xmm11, %xmm13
  psrlq	$16, %xmm3
  pxor	%xmm4, %xmm3
  pxor	%xmm13, %xmm2
  movdqa	%xmm2, %xmm4
  paddq	%xmm3, %xmm0
  psllq	$48, %xmm4
  pxor	%xmm0, %xmm15
  psrlq	$16, %xmm2
  pxor	%xmm4, %xmm2
  movdqa	%xmm15, %xmm4
  paddq	%xmm2, %xmm1
  psrlq	$63, %xmm15
  psllq	$1, %xmm4
  pxor	%xmm1, %xmm12
  movdqa	%xmm2, %xmm9
  punpcklqdq	%xmm2, %xmm2
  pxor	%xmm4, %xmm15
  movdqa	%xmm12, %xmm4
  psrlq	$63, %xmm12
  psllq	$1, %xmm4
  pxor	%xmm4, %xmm12
  movdqa	%xmm3, %xmm4
  punpcklqdq	%xmm3, %xmm4
  punpckhqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm4
  movdqa	%xmm12, %xmm9
  punpcklqdq	%xmm12, %xmm9
  punpckhqdq	%xmm2, %xmm3
  movdqa	%xmm9, %xmm2
  movdqa	%xmm15, %xmm9
  punpcklqdq	%xmm15, %xmm15
  punpckhqdq	%xmm15, %xmm12
  movdqa	%xmm5, %xmm15
  punpckhqdq	%xmm2, %xmm9
  paddq	%xmm9, %xmm15
  movq	%rax, %xmm5
  movdqa	%xmm9, %xmm2
  paddq	%xmm15, %xmm14
  movq	(%rsp), %xmm15
  pxor	%xmm14, %xmm4
  punpcklqdq	%xmm15, %xmm5
  movdqa	%xmm5, %xmm11
  movdqa	%xmm4, %xmm5
  paddq	%xmm12, %xmm11
  psllq	$32, %xmm5
  paddq	%xmm11, %xmm13
  psrlq	$32, %xmm4
  pxor	%xmm13, %xmm3
  pxor	%xmm5, %xmm4
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm1
  psllq	$32, %xmm5
  pxor	%xmm1, %xmm2
  psrlq	$32, %xmm3
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  paddq	%xmm3, %xmm0
  psrlq	$24, %xmm2
  psllq	$40, %xmm5
  pxor	%xmm0, %xmm12
  pxor	%xmm5, %xmm2
  movdqa	%xmm12, %xmm5
  psrlq	$24, %xmm12
  psllq	$40, %xmm5
  pxor	%xmm5, %xmm12
  movdqa	%xmm8, %xmm5
  movhps	48(%rsp), %xmm5
  paddq	%xmm2, %xmm5
  paddq	%xmm5, %xmm14
  movq	80(%rsp), %xmm5
  pxor	%xmm14, %xmm4
  punpcklqdq	%xmm10, %xmm5
  movdqa	%xmm5, %xmm11
  movdqa	%xmm4, %xmm5
  paddq	%xmm12, %xmm11
  psllq	$48, %xmm5
  paddq	%xmm11, %xmm13
  psrlq	$16, %xmm4
  pxor	%xmm5, %xmm4
  pxor	%xmm13, %xmm3
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm1
  psllq	$48, %xmm5
  pxor	%xmm1, %xmm2
  psrlq	$16, %xmm3
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  paddq	%xmm3, %xmm0
  psrlq	$63, %xmm2
  psllq	$1, %xmm5
  pxor	%xmm0, %xmm12
  pxor	%xmm5, %xmm2
  movdqa	%xmm12, %xmm5
  psrlq	$63, %xmm12
  psllq	$1, %xmm5
  pxor	%xmm5, %xmm12
  movdqa	%xmm2, %xmm5
  movdqa	%xmm12, %xmm9
  punpcklqdq	%xmm12, %xmm12
  punpcklqdq	%xmm2, %xmm5
  punpckhqdq	%xmm5, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm9
  movdqa	%xmm9, %xmm11
  movdqa	%xmm4, %xmm9
  punpcklqdq	%xmm4, %xmm4
  punpckhqdq	%xmm4, %xmm3
  movq	32(%rsp), %xmm4
  punpckhqdq	%xmm11, %xmm9
  punpckhqdq	%xmm12, %xmm2
  movdqa	128(%rsp), %xmm11
  movdqa	%xmm9, %xmm12
  punpcklqdq	%xmm15, %xmm4
  paddq	%xmm5, %xmm4
  movdqa	352(%rsp), %xmm15
  paddq	%xmm4, %xmm14
  paddq	%xmm2, %xmm11
  pxor	%xmm14, %xmm12
  movdqa	%xmm12, %xmm4
  paddq	%xmm11, %xmm13
  psrlq	$32, %xmm12
  psllq	$32, %xmm4
  pxor	%xmm13, %xmm3
  movdqa	%xmm3, %xmm9
  movdqa	%xmm4, %xmm11
  psllq	$32, %xmm9
  movdqa	%xmm12, %xmm4
  pxor	%xmm11, %xmm4
  psrlq	$32, %xmm3
  paddq	%xmm4, %xmm0
  movdqa	%xmm15, %xmm11
  pxor	%xmm9, %xmm3
  pxor	%xmm0, %xmm5
  movdqa	%xmm5, %xmm9
  psrlq	$24, %xmm5
  psllq	$40, %xmm9
  paddq	%xmm3, %xmm1
  movdqa	%xmm8, %xmm12
  pxor	%xmm9, %xmm5
  paddq	%xmm5, %xmm11
  pxor	%xmm1, %xmm2
  movdqa	%xmm2, %xmm9
  paddq	%xmm11, %xmm14
  psrlq	$24, %xmm2
  movdqa	%xmm8, %xmm11
  movhps	72(%rsp), %xmm11
  psllq	$40, %xmm9
  pxor	%xmm14, %xmm4
  movhps	56(%rsp), %xmm12
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm11
  psrlq	$16, %xmm4
  paddq	%xmm11, %xmm13
  psllq	$48, %xmm9
  pxor	%xmm9, %xmm4
  pxor	%xmm13, %xmm3
  movdqa	%xmm3, %xmm9
  paddq	%xmm4, %xmm0
  psllq	$48, %xmm9
  pxor	%xmm0, %xmm5
  psrlq	$16, %xmm3
  pxor	%xmm9, %xmm3
  movdqa	%xmm5, %xmm9
  paddq	%xmm3, %xmm1
  psrlq	$63, %xmm5
  psllq	$1, %xmm9
  pxor	%xmm1, %xmm2
  pxor	%xmm9, %xmm5
  movdqa	%xmm2, %xmm9
  psrlq	$63, %xmm2
  psllq	$1, %xmm9
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  punpcklqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm11
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm3
  punpckhqdq	%xmm11, %xmm9
  movdqa	%xmm9, %xmm11
  movdqa	%xmm2, %xmm9
  punpckhqdq	%xmm3, %xmm4
  punpcklqdq	%xmm2, %xmm9
  movdqa	%xmm9, %xmm3
  movdqa	%xmm5, %xmm9
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm5, %xmm2
  movq	8(%rsp), %xmm5
  punpckhqdq	%xmm3, %xmm9
  movdqa	%xmm9, %xmm3
  movhps	16(%rsp), %xmm5
  paddq	%xmm9, %xmm5
  paddq	%xmm5, %xmm14
  movdqa	%xmm10, %xmm5
  movhps	64(%rsp), %xmm5
  pxor	%xmm14, %xmm11
  paddq	%xmm2, %xmm5
  paddq	%xmm5, %xmm13
  movdqa	%xmm11, %xmm5
  psllq	$32, %xmm5
  pxor	%xmm13, %xmm4
  psrlq	$32, %xmm11
  pxor	%xmm5, %xmm11
  movdqa	%xmm4, %xmm5
  paddq	%xmm11, %xmm1
  psrlq	$32, %xmm4
  psllq	$32, %xmm5
  pxor	%xmm1, %xmm3
  pxor	%xmm5, %xmm4
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm0
  psrlq	$24, %xmm3
  psllq	$40, %xmm5
  pxor	%xmm0, %xmm2
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  psrlq	$24, %xmm2
  psllq	$40, %xmm5
  pxor	%xmm5, %xmm2
  movdqa	96(%rsp), %xmm5
  paddq	%xmm3, %xmm5
  paddq	%xmm5, %xmm14
  movdqa	%xmm6, %xmm5
  pxor	%xmm14, %xmm11
  punpcklqdq	%xmm7, %xmm5
  movdqa	%xmm11, %xmm9
  paddq	%xmm2, %xmm5
  paddq	%xmm5, %xmm13
  psllq	$48, %xmm9
  psrlq	$16, %xmm11
  pxor	%xmm13, %xmm4
  pxor	%xmm9, %xmm11
  movdqa	%xmm4, %xmm9
  paddq	%xmm11, %xmm1
  psrlq	$16, %xmm4
  psllq	$48, %xmm9
  pxor	%xmm1, %xmm3
  pxor	%xmm9, %xmm4
  movdqa	%xmm3, %xmm9
  paddq	%xmm4, %xmm0
  psrlq	$63, %xmm3
  psllq	$1, %xmm9
  pxor	%xmm0, %xmm2
  pxor	%xmm9, %xmm3
  movdqa	%xmm2, %xmm9
  psrlq	$63, %xmm2
  psllq	$1, %xmm9
  pxor	%xmm9, %xmm2
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm2, %xmm9
  punpcklqdq	%xmm2, %xmm2
  punpckhqdq	%xmm5, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm4, %xmm9
  punpckhqdq	%xmm2, %xmm3
  punpcklqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm2
  movdqa	%xmm11, %xmm9
  punpcklqdq	%xmm11, %xmm11
  punpckhqdq	%xmm11, %xmm4
  movdqa	%xmm12, %xmm11
  punpckhqdq	%xmm2, %xmm9
  movq	32(%rsp), %xmm12
  paddq	%xmm5, %xmm11
  movdqa	%xmm9, %xmm2
  movhps	24(%rsp), %xmm12
  paddq	%xmm11, %xmm14
  movdqa	%xmm12, %xmm11
  pxor	%xmm14, %xmm2
  movdqa	%xmm2, %xmm9
  movdqa	%xmm7, %xmm12
  paddq	%xmm3, %xmm11
  psllq	$32, %xmm9
  movhps	80(%rsp), %xmm12
  paddq	%xmm11, %xmm13
  psrlq	$32, %xmm2
  movdqa	%xmm12, %xmm11
  pxor	%xmm13, %xmm4
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm0
  psllq	$32, %xmm9
  pxor	%xmm0, %xmm5
  psrlq	$32, %xmm4
  pxor	%xmm9, %xmm4
  movdqa	%xmm5, %xmm9
  paddq	%xmm4, %xmm1
  psrlq	$24, %xmm5
  psllq	$40, %xmm9
  pxor	%xmm1, %xmm3
  pxor	%xmm9, %xmm5
  movdqa	%xmm3, %xmm9
  psrlq	$24, %xmm3
  psllq	$40, %xmm9
  pxor	%xmm9, %xmm3
  movdqa	%xmm5, %xmm9
  paddq	%xmm12, %xmm9
  movq	(%rsp), %xmm12
  paddq	%xmm9, %xmm14
  pxor	%xmm14, %xmm2
  punpcklqdq	%xmm10, %xmm12
  movdqa	%xmm2, %xmm9
  paddq	%xmm3, %xmm12
  paddq	%xmm12, %xmm13
  psllq	$48, %xmm9
  psrlq	$16, %xmm2
  pxor	%xmm13, %xmm4
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm0
  psrlq	$16, %xmm4
  psllq	$48, %xmm9
  pxor	%xmm0, %xmm5
  pxor	%xmm9, %xmm4
  movdqa	%xmm5, %xmm9
  paddq	%xmm4, %xmm1
  psrlq	$63, %xmm5
  psllq	$1, %xmm9
  pxor	%xmm1, %xmm3
  pxor	%xmm9, %xmm5
  movdqa	%xmm3, %xmm9
  psrlq	$63, %xmm3
  psllq	$1, %xmm9
  pxor	%xmm9, %xmm3
  movdqa	%xmm2, %xmm9
  punpcklqdq	%xmm2, %xmm9
  movdqa	%xmm9, %xmm12
  movdqa	%xmm4, %xmm9
  punpcklqdq	%xmm4, %xmm4
  punpckhqdq	%xmm12, %xmm9
  punpckhqdq	%xmm4, %xmm2
  movdqa	%xmm9, %xmm12
  movdqa	%xmm3, %xmm4
  movdqa	%xmm5, %xmm9
  punpcklqdq	%xmm3, %xmm4
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm5, %xmm3
  punpckhqdq	%xmm4, %xmm9
  paddq	%xmm9, %xmm15
  movdqa	%xmm9, %xmm4
  movq	64(%rsp), %xmm5
  paddq	%xmm15, %xmm14
  movq	8(%rsp), %xmm15
  pxor	%xmm14, %xmm12
  punpcklqdq	%xmm6, %xmm5
  movdqa	%xmm12, %xmm9
  paddq	%xmm3, %xmm5
  paddq	%xmm5, %xmm13
  psllq	$32, %xmm9
  movdqa	%xmm15, %xmm5
  punpcklqdq	%xmm15, %xmm7
  psrlq	$32, %xmm12
  pxor	%xmm13, %xmm2
  movhps	40(%rsp), %xmm5
  movq	%rax, %xmm15
  pxor	%xmm9, %xmm12
  movdqa	%xmm2, %xmm9
  paddq	%xmm12, %xmm1
  psrlq	$32, %xmm2
  psllq	$32, %xmm9
  pxor	%xmm1, %xmm4
  punpcklqdq	%xmm10, %xmm15
  movdqa	%xmm15, %xmm10
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  psrlq	$24, %xmm4
  paddq	%xmm2, %xmm0
  psllq	$40, %xmm9
  pxor	%xmm0, %xmm3
  pxor	%xmm9, %xmm4
  paddq	%xmm4, %xmm5
  movdqa	%xmm3, %xmm9
  paddq	%xmm5, %xmm14
  psllq	$40, %xmm9
  movdqa	368(%rsp), %xmm5
  psrlq	$24, %xmm3
  pxor	%xmm14, %xmm12
  pxor	%xmm9, %xmm3
  movdqa	%xmm12, %xmm9
  paddq	%xmm3, %xmm5
  psrlq	$16, %xmm12
  paddq	%xmm5, %xmm13
  psllq	$48, %xmm9
  pxor	%xmm9, %xmm12
  pxor	%xmm13, %xmm2
  movdqa	%xmm2, %xmm9
  paddq	%xmm12, %xmm1
  psllq	$48, %xmm9
  pxor	%xmm1, %xmm4
  psrlq	$16, %xmm2
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm0
  psrlq	$63, %xmm4
  psllq	$1, %xmm9
  pxor	%xmm0, %xmm3
  pxor	%xmm9, %xmm4
  movdqa	%xmm3, %xmm9
  psrlq	$63, %xmm3
  psllq	$1, %xmm9
  pxor	%xmm9, %xmm3
  movdqa	%xmm4, %xmm9
  punpcklqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm3
  punpckhqdq	%xmm5, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm2, %xmm9
  punpckhqdq	%xmm3, %xmm4
  punpcklqdq	%xmm2, %xmm9
  movdqa	%xmm9, %xmm3
  movdqa	%xmm12, %xmm9
  punpcklqdq	%xmm12, %xmm12
  punpckhqdq	%xmm12, %xmm2
  movq	16(%rsp), %xmm12
  punpckhqdq	%xmm3, %xmm9
  movdqa	%xmm9, %xmm3
  paddq	%xmm4, %xmm7
  movhps	80(%rsp), %xmm12
  paddq	%xmm7, %xmm13
  paddq	%xmm5, %xmm12
  pxor	%xmm13, %xmm2
  paddq	%xmm12, %xmm14
  pxor	%xmm14, %xmm3
  movdqa	%xmm3, %xmm9
  psrlq	$32, %xmm3
  psllq	$32, %xmm9
  pxor	%xmm9, %xmm3
  movdqa	%xmm2, %xmm9
  paddq	%xmm3, %xmm0
  psrlq	$32, %xmm2
  psllq	$32, %xmm9
  pxor	%xmm0, %xmm5
  pxor	%xmm9, %xmm2
  movdqa	%xmm5, %xmm9
  paddq	%xmm2, %xmm1
  psrlq	$24, %xmm5
  psllq	$40, %xmm9
  pxor	%xmm1, %xmm4
  pxor	%xmm9, %xmm5
  movdqa	%xmm4, %xmm9
  psrlq	$24, %xmm4
  psllq	$40, %xmm9
  pxor	%xmm9, %xmm4
  movdqa	%xmm5, %xmm9
  paddq	%xmm15, %xmm9
  movq	24(%rsp), %xmm15
  paddq	%xmm9, %xmm14
  movhps	64(%rsp), %xmm15
  pxor	%xmm14, %xmm3
  movdqa	%xmm3, %xmm9
  movdqa	%xmm15, %xmm7
  psllq	$48, %xmm9
  paddq	%xmm4, %xmm7
  psrlq	$16, %xmm3
  paddq	%xmm7, %xmm13
  pxor	%xmm9, %xmm3
  paddq	%xmm3, %xmm0
  pxor	%xmm13, %xmm2
  movdqa	%xmm2, %xmm9
  psrlq	$16, %xmm2
  pxor	%xmm0, %xmm5
  psllq	$48, %xmm9
  pxor	%xmm9, %xmm2
  movdqa	%xmm5, %xmm9
  paddq	%xmm2, %xmm1
  psrlq	$63, %xmm5
  psllq	$1, %xmm9
  pxor	%xmm1, %xmm4
  pxor	%xmm9, %xmm5
  movdqa	%xmm4, %xmm9
  psrlq	$63, %xmm4
  psllq	$1, %xmm9
  pxor	%xmm9, %xmm4
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm9
  movdqa	%xmm9, %xmm7
  movdqa	%xmm2, %xmm9
  punpcklqdq	%xmm2, %xmm2
  punpckhqdq	%xmm7, %xmm9
  movdqa	%xmm9, %xmm15
  movdqa	%xmm4, %xmm9
  punpckhqdq	%xmm2, %xmm3
  punpcklqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm2
  movdqa	%xmm5, %xmm9
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm5, %xmm4
  movq	32(%rsp), %xmm5
  punpckhqdq	%xmm2, %xmm9
  movdqa	%xmm9, %xmm2
  punpcklqdq	%xmm8, %xmm5
  movdqa	%xmm5, %xmm12
  movq	(%rsp), %xmm5
  paddq	%xmm9, %xmm12
  movhps	72(%rsp), %xmm5
  paddq	%xmm12, %xmm14
  movdqa	%xmm5, %xmm7
  pxor	%xmm14, %xmm15
  movdqa	%xmm15, %xmm9
  movdqa	%xmm6, %xmm5
  paddq	%xmm4, %xmm7
  psllq	$32, %xmm9
  movhps	56(%rsp), %xmm5
  paddq	%xmm7, %xmm13
  psrlq	$32, %xmm15
  movdqa	%xmm5, %xmm12
  movq	40(%rsp), %xmm5
  pxor	%xmm13, %xmm3
  pxor	%xmm9, %xmm15
  movdqa	%xmm3, %xmm9
  paddq	%xmm15, %xmm1
  psllq	$32, %xmm9
  pxor	%xmm1, %xmm2
  movhps	48(%rsp), %xmm5
  movhps	40(%rsp), %xmm6
  psrlq	$32, %xmm3
  movdqa	%xmm5, %xmm7
  pxor	%xmm9, %xmm3
  movdqa	%xmm2, %xmm9
  paddq	%xmm3, %xmm0
  psrlq	$24, %xmm2
  psllq	$40, %xmm9
  pxor	%xmm0, %xmm4
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm12
  psrlq	$24, %xmm4
  paddq	%xmm12, %xmm14
  psllq	$40, %xmm9
  movq	56(%rsp), %xmm12
  pxor	%xmm9, %xmm4
  pxor	%xmm14, %xmm15
  paddq	%xmm4, %xmm7
  movdqa	%xmm15, %xmm9
  paddq	%xmm7, %xmm13
  psllq	$48, %xmm9
  movhps	(%rsp), %xmm12
  psrlq	$16, %xmm15
  pxor	%xmm13, %xmm3
  pxor	%xmm9, %xmm15
  movdqa	%xmm3, %xmm9
  psrlq	$16, %xmm3
  paddq	%xmm15, %xmm1
  psllq	$48, %xmm9
  pxor	%xmm9, %xmm3
  movdqa	%xmm2, %xmm9
  paddq	%xmm3, %xmm0
  pxor	%xmm1, %xmm9
  movdqa	%xmm9, %xmm5
  psllq	$1, %xmm9
  pxor	%xmm0, %xmm4
  movdqa	%xmm9, %xmm2
  psrlq	$63, %xmm5
  movdqa	%xmm4, %xmm9
  psllq	$1, %xmm9
  pxor	%xmm5, %xmm2
  psrlq	$63, %xmm4
  pxor	%xmm9, %xmm4
  movdqa	%xmm2, %xmm9
  punpcklqdq	%xmm2, %xmm9
  movdqa	%xmm9, %xmm5
  movdqa	%xmm4, %xmm9
  punpcklqdq	%xmm4, %xmm4
  punpckhqdq	%xmm4, %xmm2
  movdqa	%xmm3, %xmm4
  punpckhqdq	%xmm5, %xmm9
  movdqa	%xmm9, %xmm5
  punpcklqdq	%xmm3, %xmm4
  movdqa	%xmm15, %xmm9
  punpcklqdq	%xmm15, %xmm15
  punpckhqdq	%xmm15, %xmm3
  movdqa	272(%rsp), %xmm15
  punpckhqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm4
  movdqa	%xmm15, %xmm7
  paddq	%xmm5, %xmm7
  paddq	%xmm7, %xmm14
  movdqa	%xmm12, %xmm7
  paddq	%xmm2, %xmm7
  pxor	%xmm14, %xmm4
  movdqa	%xmm4, %xmm9
  paddq	%xmm7, %xmm13
  psllq	$32, %xmm9
  psrlq	$32, %xmm4
  pxor	%xmm13, %xmm3
  pxor	%xmm9, %xmm4
  movdqa	%xmm3, %xmm9
  paddq	%xmm4, %xmm0
  psrlq	$32, %xmm3
  psllq	$32, %xmm9
  pxor	%xmm0, %xmm5
  pxor	%xmm9, %xmm3
  movdqa	%xmm5, %xmm9
  paddq	%xmm3, %xmm1
  psrlq	$24, %xmm5
  psllq	$40, %xmm9
  pxor	%xmm1, %xmm2
  pxor	%xmm9, %xmm5
  movdqa	%xmm2, %xmm9
  psrlq	$24, %xmm2
  paddq	%xmm5, %xmm6
  psllq	$40, %xmm9
  paddq	%xmm6, %xmm14
  pxor	%xmm9, %xmm2
  movq	16(%rsp), %xmm9
  pxor	%xmm14, %xmm4
  movhps	48(%rsp), %xmm9
  movdqa	%xmm9, %xmm6
  movdqa	%xmm4, %xmm9
  paddq	%xmm2, %xmm6
  psllq	$48, %xmm9
  paddq	%xmm6, %xmm13
  psrlq	$16, %xmm4
  pxor	%xmm9, %xmm4
  pxor	%xmm13, %xmm3
  movdqa	%xmm3, %xmm9
  paddq	%xmm4, %xmm0
  psllq	$48, %xmm9
  pxor	%xmm0, %xmm5
  psrlq	$16, %xmm3
  pxor	%xmm9, %xmm3
  movdqa	%xmm5, %xmm9
  paddq	%xmm3, %xmm1
  psrlq	$63, %xmm5
  psllq	$1, %xmm9
  pxor	%xmm1, %xmm2
  pxor	%xmm9, %xmm5
  movdqa	%xmm2, %xmm9
  psrlq	$63, %xmm2
  movdqa	%xmm5, %xmm12
  psllq	$1, %xmm9
  punpcklqdq	%xmm5, %xmm5
  pxor	%xmm9, %xmm2
  movdqa	%xmm4, %xmm9
  punpcklqdq	%xmm4, %xmm9
  movdqa	%xmm9, %xmm6
  movdqa	%xmm3, %xmm9
  punpcklqdq	%xmm3, %xmm3
  punpckhqdq	%xmm3, %xmm4
  movdqa	%xmm2, %xmm3
  punpckhqdq	%xmm6, %xmm9
  punpcklqdq	%xmm2, %xmm3
  punpckhqdq	%xmm5, %xmm2
  movq	24(%rsp), %xmm5
  punpckhqdq	%xmm3, %xmm12
  paddq	%xmm12, %xmm10
  movdqa	%xmm12, %xmm3
  paddq	%xmm10, %xmm14
  punpcklqdq	%xmm8, %xmm5
  paddq	%xmm2, %xmm5
  movdqa	176(%rsp), %xmm8
  paddq	%xmm5, %xmm13
  pxor	%xmm14, %xmm9
  movdqa	%xmm9, %xmm5
  psllq	$32, %xmm5
  pxor	%xmm13, %xmm4
  psrlq	$32, %xmm9
  pxor	%xmm5, %xmm9
  movdqa	%xmm4, %xmm5
  paddq	%xmm9, %xmm1
  psrlq	$32, %xmm4
  psllq	$32, %xmm5
  pxor	%xmm1, %xmm3
  pxor	%xmm5, %xmm4
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm0
  psrlq	$24, %xmm3
  psllq	$40, %xmm5
  pxor	%xmm0, %xmm2
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  psrlq	$24, %xmm2
  paddq	%xmm3, %xmm11
  psllq	$40, %xmm5
  paddq	%xmm11, %xmm14
  pxor	%xmm5, %xmm2
  movq	32(%rsp), %xmm5
  pxor	%xmm14, %xmm9
  movhps	8(%rsp), %xmm5
  paddq	%xmm2, %xmm5
  paddq	%xmm5, %xmm13
  movdqa	%xmm9, %xmm5
  psllq	$48, %xmm5
  pxor	%xmm13, %xmm4
  psrlq	$16, %xmm9
  pxor	%xmm5, %xmm9
  movdqa	%xmm4, %xmm5
  paddq	%xmm9, %xmm1
  psrlq	$16, %xmm4
  psllq	$48, %xmm5
  pxor	%xmm1, %xmm3
  pxor	%xmm5, %xmm4
  movdqa	%xmm3, %xmm5
  paddq	%xmm4, %xmm0
  psrlq	$63, %xmm3
  psllq	$1, %xmm5
  pxor	%xmm0, %xmm2
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  psrlq	$63, %xmm2
  psllq	$1, %xmm5
  pxor	%xmm5, %xmm2
  movdqa	%xmm3, %xmm5
  movdqa	%xmm2, %xmm10
  punpcklqdq	%xmm2, %xmm2
  punpcklqdq	%xmm3, %xmm5
  punpckhqdq	%xmm5, %xmm10
  movdqa	%xmm10, %xmm7
  movdqa	144(%rsp), %xmm10
  punpckhqdq	%xmm2, %xmm3
  movdqa	%xmm9, %xmm5
  movdqa	%xmm4, %xmm2
  punpcklqdq	%xmm9, %xmm9
  paddq	%xmm7, %xmm10
  punpcklqdq	%xmm4, %xmm2
  punpckhqdq	%xmm2, %xmm5
  movdqa	%xmm5, %xmm2
  paddq	%xmm10, %xmm14
  punpckhqdq	%xmm9, %xmm4
  movdqa	160(%rsp), %xmm10
  pxor	%xmm14, %xmm2
  movdqa	%xmm2, %xmm9
  psrlq	$32, %xmm2
  paddq	%xmm3, %xmm10
  psllq	$32, %xmm9
  paddq	%xmm10, %xmm13
  pxor	%xmm9, %xmm2
  paddq	%xmm2, %xmm0
  movdqa	192(%rsp), %xmm10
  pxor	%xmm13, %xmm4
  movdqa	%xmm4, %xmm9
  psrlq	$32, %xmm4
  pxor	%xmm0, %xmm7
  psllq	$32, %xmm9
  pxor	%xmm9, %xmm4
  movdqa	%xmm7, %xmm9
  paddq	%xmm4, %xmm1
  psrlq	$24, %xmm7
  psllq	$40, %xmm9
  pxor	%xmm1, %xmm3
  pxor	%xmm9, %xmm7
  movdqa	%xmm3, %xmm9
  paddq	%xmm7, %xmm8
  psrlq	$24, %xmm3
  psllq	$40, %xmm9
  paddq	%xmm8, %xmm14
  pxor	%xmm9, %xmm3
  paddq	%xmm3, %xmm10
  pxor	%xmm14, %xmm2
  paddq	%xmm10, %xmm13
  movdqa	%xmm2, %xmm10
  psllq	$48, %xmm10
  pxor	%xmm13, %xmm4
  psrlq	$16, %xmm2
  pxor	%xmm10, %xmm2
  movdqa	%xmm4, %xmm10
  paddq	%xmm2, %xmm0
  psrlq	$16, %xmm4
  psllq	$48, %xmm10
  pxor	%xmm0, %xmm7
  pxor	%xmm10, %xmm4
  movdqa	%xmm7, %xmm10
  paddq	%xmm4, %xmm1
  psrlq	$63, %xmm7
  psllq	$1, %xmm10
  pxor	%xmm1, %xmm3
  movdqa	%xmm4, %xmm8
  punpcklqdq	%xmm4, %xmm4
  pxor	%xmm10, %xmm7
  movdqa	%xmm3, %xmm10
  psrlq	$63, %xmm3
  psllq	$1, %xmm10
  pxor	%xmm10, %xmm3
  movdqa	%xmm2, %xmm10
  punpcklqdq	%xmm2, %xmm10
  punpckhqdq	%xmm4, %xmm2
  movdqa	%xmm3, %xmm4
  punpckhqdq	%xmm10, %xmm8
  punpcklqdq	%xmm3, %xmm4
  movdqa	%xmm7, %xmm10
  punpcklqdq	%xmm7, %xmm7
  punpckhqdq	%xmm7, %xmm3
  movdqa	208(%rsp), %xmm7
  punpckhqdq	%xmm4, %xmm10
  movdqa	%xmm10, %xmm4
  movdqa	112(%rsp), %xmm6
  movdqa	128(%rsp), %xmm11
  paddq	%xmm10, %xmm7
  paddq	%xmm7, %xmm14
  paddq	%xmm3, %xmm6
  movdqa	320(%rsp), %xmm12
  pxor	%xmm14, %xmm8
  movdqa	%xmm8, %xmm7
  paddq	%xmm6, %xmm13
  psrlq	$32, %xmm8
  psllq	$32, %xmm7
  pxor	%xmm13, %xmm2
  movdqa	224(%rsp), %xmm6
  movaps	432(%rsp), %xmm9
  pxor	%xmm7, %xmm8
  movdqa	%xmm2, %xmm7
  paddq	%xmm8, %xmm1
  psllq	$32, %xmm7
  pxor	%xmm1, %xmm4
  movaps	448(%rsp), %xmm10
  psrlq	$32, %xmm2
  pxor	%xmm7, %xmm2
  movdqa	%xmm4, %xmm7
  psrlq	$24, %xmm4
  paddq	%xmm2, %xmm0
  psllq	$40, %xmm7
  pxor	%xmm0, %xmm3
  pxor	%xmm7, %xmm4
  paddq	%xmm4, %xmm6
  movdqa	%xmm3, %xmm7
  paddq	%xmm6, %xmm14
  psllq	$40, %xmm7
  movdqa	240(%rsp), %xmm6
  psrlq	$24, %xmm3
  pxor	%xmm14, %xmm8
  pxor	%xmm7, %xmm3
  movdqa	%xmm8, %xmm7
  paddq	%xmm3, %xmm6
  psrlq	$16, %xmm8
  paddq	%xmm6, %xmm13
  psllq	$48, %xmm7
  movdqa	256(%rsp), %xmm6
  pxor	%xmm7, %xmm8
  pxor	%xmm13, %xmm2
  movdqa	%xmm2, %xmm7
  paddq	%xmm8, %xmm1
  psllq	$48, %xmm7
  pxor	%xmm1, %xmm4
  psrlq	$16, %xmm2
  pxor	%xmm7, %xmm2
  movdqa	%xmm4, %xmm7
  paddq	%xmm2, %xmm0
  psrlq	$63, %xmm4
  psllq	$1, %xmm7
  pxor	%xmm0, %xmm3
  pxor	%xmm7, %xmm4
  movdqa	%xmm3, %xmm7
  psrlq	$63, %xmm3
  psllq	$1, %xmm7
  pxor	%xmm7, %xmm3
  movdqa	%xmm4, %xmm7
  punpcklqdq	%xmm4, %xmm7
  movdqa	%xmm7, %xmm5
  movdqa	%xmm3, %xmm7
  punpcklqdq	%xmm3, %xmm3
  punpckhqdq	%xmm5, %xmm7
  movdqa	%xmm7, %xmm5
  movdqa	%xmm2, %xmm7
  punpckhqdq	%xmm3, %xmm4
  punpcklqdq	%xmm2, %xmm7
  paddq	%xmm5, %xmm11
  movdqa	%xmm7, %xmm3
  paddq	%xmm4, %xmm6
  paddq	%xmm11, %xmm14
  movdqa	%xmm8, %xmm7
  paddq	%xmm6, %xmm13
  punpcklqdq	%xmm8, %xmm8
  punpckhqdq	%xmm3, %xmm7
  movdqa	%xmm7, %xmm3
  punpckhqdq	%xmm8, %xmm2
  pxor	%xmm13, %xmm2
  movdqa	304(%rsp), %xmm11
  pxor	%xmm14, %xmm3
  movdqa	%xmm3, %xmm6
  psrlq	$32, %xmm3
  movaps	416(%rsp), %xmm8
  psllq	$32, %xmm6
  pxor	%xmm6, %xmm3
  movdqa	%xmm2, %xmm6
  paddq	%xmm3, %xmm0
  psrlq	$32, %xmm2
  psllq	$32, %xmm6
  pxor	%xmm0, %xmm5
  pxor	%xmm6, %xmm2
  movdqa	%xmm5, %xmm6
  paddq	%xmm2, %xmm1
  psrlq	$24, %xmm5
  psllq	$40, %xmm6
  pxor	%xmm1, %xmm4
  pxor	%xmm6, %xmm5
  movdqa	%xmm4, %xmm6
  psrlq	$24, %xmm4
  paddq	%xmm5, %xmm15
  psllq	$40, %xmm6
  paddq	%xmm15, %xmm14
  movaps	528(%rsp), %xmm15
  pxor	%xmm6, %xmm4
  pxor	%xmm14, %xmm3
  movdqa	288(%rsp), %xmm6
  paddq	%xmm4, %xmm6
  paddq	%xmm6, %xmm13
  movdqa	%xmm3, %xmm6
  psllq	$48, %xmm6
  pxor	%xmm13, %xmm2
  psrlq	$16, %xmm3
  pxor	%xmm6, %xmm3
  movdqa	%xmm2, %xmm6
  psrlq	$16, %xmm2
  paddq	%xmm3, %xmm0
  psllq	$48, %xmm6
  pxor	%xmm0, %xmm5
  pxor	%xmm6, %xmm2
  paddq	%xmm2, %xmm1
  movdqa	%xmm5, %xmm6
  pxor	%xmm1, %xmm4
  movdqa	%xmm4, %xmm7
  psllq	$1, %xmm6
  psllq	$1, %xmm7
  psrlq	$63, %xmm5
  psrlq	$63, %xmm4
  pxor	%xmm6, %xmm5
  movdqa	%xmm3, %xmm6
  pxor	%xmm7, %xmm4
  movdqa	%xmm2, %xmm7
  punpcklqdq	%xmm3, %xmm6
  punpcklqdq	%xmm2, %xmm2
  punpckhqdq	%xmm6, %xmm7
  movdqa	%xmm4, %xmm6
  punpckhqdq	%xmm2, %xmm3
  punpcklqdq	%xmm4, %xmm6
  movdqa	%xmm6, %xmm2
  movdqa	%xmm5, %xmm6
  punpcklqdq	%xmm5, %xmm5
  punpckhqdq	%xmm2, %xmm6
  paddq	%xmm6, %xmm11
  punpckhqdq	%xmm5, %xmm4
  movdqa	%xmm6, %xmm2
  paddq	%xmm11, %xmm14
  paddq	%xmm4, %xmm12
  movdqa	96(%rsp), %xmm5
  pxor	%xmm14, %xmm7
  movdqa	%xmm7, %xmm6
  paddq	%xmm12, %xmm13
  psrlq	$32, %xmm7
  psllq	$32, %xmm6
  pxor	%xmm13, %xmm3
  movdqa	336(%rsp), %xmm11
  movaps	480(%rsp), %xmm12
  pxor	%xmm6, %xmm7
  movdqa	%xmm3, %xmm6
  paddq	%xmm7, %xmm1
  psllq	$32, %xmm6
  pxor	%xmm1, %xmm2
  psrlq	$32, %xmm3
  pxor	%xmm6, %xmm3
  movdqa	%xmm2, %xmm6
  paddq	%xmm3, %xmm0
  psrlq	$24, %xmm2
  psllq	$40, %xmm6
  pxor	%xmm0, %xmm4
  pxor	%xmm6, %xmm2
  movdqa	%xmm4, %xmm6
  paddq	%xmm2, %xmm11
  psrlq	$24, %xmm4
  psllq	$40, %xmm6
  paddq	%xmm14, %xmm11
  movaps	512(%rsp), %xmm14
  pxor	%xmm6, %xmm4
  paddq	%xmm4, %xmm5
  pxor	%xmm11, %xmm7
  paddq	%xmm5, %xmm13
  movdqa	%xmm7, %xmm5
  psllq	$48, %xmm5
  pxor	%xmm13, %xmm3
  psrlq	$16, %xmm7
  pxor	%xmm5, %xmm7
  movdqa	%xmm3, %xmm5
  paddq	%xmm7, %xmm1
  psrlq	$16, %xmm3
  psllq	$48, %xmm5
  pxor	%xmm1, %xmm2
  pxor	%xmm5, %xmm3
  movdqa	%xmm2, %xmm5
  paddq	%xmm3, %xmm0
  psrlq	$63, %xmm2
  psllq	$1, %xmm5
  pxor	%xmm0, %xmm4
  pxor	%xmm5, %xmm2
  movdqa	%xmm4, %xmm5
  psrlq	$63, %xmm4
  psllq	$1, %xmm5
  pxor	%xmm5, %xmm4
  movdqa	%xmm2, %xmm5
  movdqa	%xmm4, %xmm6
  punpcklqdq	%xmm4, %xmm4
  punpcklqdq	%xmm2, %xmm5
  punpckhqdq	%xmm4, %xmm2
  punpckhqdq	%xmm5, %xmm6
  movdqa	%xmm3, %xmm4
  movdqa	%xmm6, %xmm5
  movdqa	%xmm7, %xmm6
  punpcklqdq	%xmm3, %xmm4
  punpcklqdq	%xmm7, %xmm7
  punpckhqdq	%xmm4, %xmm6
  movdqa	%xmm6, %xmm4
  movdqu	(%rcx), %xmm6
  punpckhqdq	%xmm7, %xmm3
  pxor	%xmm4, %xmm5
  pxor	%xmm3, %xmm2
  movaps	400(%rsp), %xmm7
  pxor	%xmm6, %xmm11
  movdqu	16(%rcx), %xmm6
  pxor	%xmm11, %xmm0
  movups	%xmm0, (%rcx)
  movaps	464(%rsp), %xmm11
  pxor	%xmm6, %xmm13
  movdqu	32(%rcx), %xmm6
  pxor	%xmm13, %xmm1
  movups	%xmm1, 16(%rcx)
  movaps	496(%rsp), %xmm13
  pxor	%xmm6, %xmm5
  movdqu	48(%rcx), %xmm6
  movups	%xmm5, 32(%rcx)
  pxor	%xmm6, %xmm2
  movaps	384(%rsp), %xmm6
  movups	%xmm2, 48(%rcx)
  addq	$552, %rsp
{$IF DEFINED(UNIX)}
  popq	%rdx
  popq	%rcx
{$ENDIF}
end;

