% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DropulationCensusStandardAnalysis.R
\name{censusSeqQC}
\alias{censusSeqQC}
\title{Run standard analysis for census, roll call, and csi.}
\usage{
censusSeqQC(
  readQualityMetricsFile = NULL,
  censusFile = NULL,
  rollCallFile = NULL,
  csiFile = NULL,
  donorListFile = NULL,
  expName = "",
  outPDF = NULL,
  minNumSNPS = 1000
)
}
\arguments{
\item{readQualityMetricsFile}{A file containing the number of reads that aligned in the experiment. 
This file is generated by Picard's CollectMultipleMetrics. (optional)}

\item{censusFile}{The dropulation census output file}

\item{rollCallFile}{The Roll Call output file}

\item{csiFile}{The CSI output file}

\item{donorListFile}{A list of donors expected in the data set.}

\item{expName}{The name of the experiment.}

\item{outPDF}{A file location where plots will be generated. (optional)}

\item{minNumSNPS}{The minimum number of SNPs to consider a roll call result to be well powered.}
}
\description{
Run standard analysis for census, roll call, and csi.  
All input files are optional, plots will be generated based on the files that are not null.
}
\details{
While many inputs are optional, CensusSeq should be run in combination with RollCall and CSI to
fully evaluate a donor pool.
}
