#include <iostream>
#include <map>
#include "ipfix_rfc.h"

/* This file is autogenerated with script ipfix_csv_processor.pl */
/* Please do not edit it directly */

std::string ipfix_information_element_t::get_name() {
    return this->name;
}

unsigned int ipfix_information_element_t::get_length() {
    return this->length;
}

ipfix_information_element_t::ipfix_information_element_t(std::string name, unsigned int length) {
    this->name = name;
    this->length = length;
}

ipfix_information_element_t::ipfix_information_element_t() {
    this->name = std::string("");
    this->length = 0;
}

std::string ipfix_information_database::get_name_by_id(unsigned int field_id) {
    ipfix_database_t::iterator itr = database.find(field_id);

    if (itr == database.end()) {
        return std::string("");
    }

    return itr->second.get_name();
}

unsigned int ipfix_information_database::get_length_by_id(unsigned int field_id) {
    ipfix_database_t::iterator itr = database.find(field_id);

    if (itr == database.end()) {
        return 0;
    }

    return itr->second.get_length();
}

bool ipfix_information_database::add_element(unsigned int field_id, std::string name, unsigned int length) {
    ipfix_database_t::iterator itr = database.find(field_id);

    // Duplicate ID's strictly prohibited
    if (itr != database.end()) {
        return false;
    }

    database[field_id] = ipfix_information_element_t(name, length);
    return true;
}

ipfix_information_database::ipfix_information_database() {
    this->add_element(0, "Reserved", 0);
    this->add_element(1, "octetDeltaCount", 8);
    this->add_element(2, "packetDeltaCount", 8);
    this->add_element(3, "deltaFlowCount", 8);
    this->add_element(4, "protocolIdentifier", 1);
    this->add_element(5, "ipClassOfService", 1);
    this->add_element(6, "tcpControlBits", 2);
    this->add_element(7, "sourceTransportPort", 2);
    this->add_element(8, "sourceIPv4Address", 4);
    this->add_element(9, "sourceIPv4PrefixLength", 1);
    this->add_element(10, "ingressInterface", 4);
    this->add_element(11, "destinationTransportPort", 2);
    this->add_element(12, "destinationIPv4Address", 4);
    this->add_element(13, "destinationIPv4PrefixLength", 1);
    this->add_element(14, "egressInterface", 4);
    this->add_element(15, "ipNextHopIPv4Address", 4);
    this->add_element(16, "bgpSourceAsNumber", 4);
    this->add_element(17, "bgpDestinationAsNumber", 4);
    this->add_element(18, "bgpNextHopIPv4Address", 4);
    this->add_element(19, "postMCastPacketDeltaCount", 8);
    this->add_element(20, "postMCastOctetDeltaCount", 8);
    this->add_element(21, "flowEndSysUpTime", 4);
    this->add_element(22, "flowStartSysUpTime", 4);
    this->add_element(23, "postOctetDeltaCount", 8);
    this->add_element(24, "postPacketDeltaCount", 8);
    this->add_element(25, "minimumIpTotalLength", 8);
    this->add_element(26, "maximumIpTotalLength", 8);
    this->add_element(27, "sourceIPv6Address", 16);
    this->add_element(28, "destinationIPv6Address", 16);
    this->add_element(29, "sourceIPv6PrefixLength", 1);
    this->add_element(30, "destinationIPv6PrefixLength", 1);
    this->add_element(31, "flowLabelIPv6", 4);
    this->add_element(32, "icmpTypeCodeIPv4", 2);
    this->add_element(33, "igmpType", 1);
    this->add_element(34, "samplingInterval", 4);
    this->add_element(35, "samplingAlgorithm", 1);
    this->add_element(36, "flowActiveTimeout", 2);
    this->add_element(37, "flowIdleTimeout", 2);
    this->add_element(38, "engineType", 1);
    this->add_element(39, "engineId", 1);
    this->add_element(40, "exportedOctetTotalCount", 8);
    this->add_element(41, "exportedMessageTotalCount", 8);
    this->add_element(42, "exportedFlowRecordTotalCount", 8);
    this->add_element(43, "ipv4RouterSc", 4);
    this->add_element(44, "sourceIPv4Prefix", 4);
    this->add_element(45, "destinationIPv4Prefix", 4);
    this->add_element(46, "mplsTopLabelType", 1);
    this->add_element(47, "mplsTopLabelIPv4Address", 4);
    this->add_element(48, "samplerId", 1);
    this->add_element(49, "samplerMode", 1);
    this->add_element(50, "samplerRandomInterval", 4);
    this->add_element(51, "classId", 1);
    this->add_element(52, "minimumTTL", 1);
    this->add_element(53, "maximumTTL", 1);
    this->add_element(54, "fragmentIdentification", 4);
    this->add_element(55, "postIpClassOfService", 1);
    this->add_element(56, "sourceMacAddress", 0);
    this->add_element(57, "postDestinationMacAddress", 0);
    this->add_element(58, "vlanId", 2);
    this->add_element(59, "postVlanId", 2);
    this->add_element(60, "ipVersion", 1);
    this->add_element(61, "flowDirection", 1);
    this->add_element(62, "ipNextHopIPv6Address", 16);
    this->add_element(63, "bgpNextHopIPv6Address", 16);
    this->add_element(64, "ipv6ExtensionHeaders", 4);
    this->add_element(65, "Reserved", 0);
    this->add_element(66, "Reserved", 0);
    this->add_element(67, "Reserved", 0);
    this->add_element(68, "Reserved", 0);
    this->add_element(69, "Reserved", 0);
    this->add_element(70, "mplsTopLabelStackSection", 0);
    this->add_element(71, "mplsLabelStackSection2", 0);
    this->add_element(72, "mplsLabelStackSection3", 0);
    this->add_element(73, "mplsLabelStackSection4", 0);
    this->add_element(74, "mplsLabelStackSection5", 0);
    this->add_element(75, "mplsLabelStackSection6", 0);
    this->add_element(76, "mplsLabelStackSection7", 0);
    this->add_element(77, "mplsLabelStackSection8", 0);
    this->add_element(78, "mplsLabelStackSection9", 0);
    this->add_element(79, "mplsLabelStackSection10", 0);
    this->add_element(80, "destinationMacAddress", 0);
    this->add_element(81, "postSourceMacAddress", 0);
    this->add_element(82, "interfaceName", 0);
    this->add_element(83, "interfaceDescription", 0);
    this->add_element(84, "samplerName", 0);
    this->add_element(85, "octetTotalCount", 8);
    this->add_element(86, "packetTotalCount", 8);
    this->add_element(87, "flagsAndSamplerId", 4);
    this->add_element(88, "fragmentOffset", 2);
    this->add_element(89, "forwardingStatus", 4);
    this->add_element(90, "mplsVpnRouteDistinguisher", 0);
    this->add_element(91, "mplsTopLabelPrefixLength", 1);
    this->add_element(92, "srcTrafficIndex", 4);
    this->add_element(93, "dstTrafficIndex", 4);
    this->add_element(94, "applicationDescription", 0);
    this->add_element(95, "applicationId", 0);
    this->add_element(96, "applicationName", 0);
    this->add_element(97, "Assigned for NetFlow v9 compatibility", 0);
    this->add_element(98, "postIpDiffServCodePoint", 1);
    this->add_element(99, "multicastReplicationFactor", 4);
    this->add_element(100, "className", 0);
    this->add_element(101, "classificationEngineId", 1);
    this->add_element(102, "layer2packetSectionOffset", 2);
    this->add_element(103, "layer2packetSectionSize", 2);
    this->add_element(104, "layer2packetSectionData", 0);
    this->add_element(105, "Reserved", 0);
    this->add_element(106, "Reserved", 0);
    this->add_element(107, "Reserved", 0);
    this->add_element(108, "Reserved", 0);
    this->add_element(109, "Reserved", 0);
    this->add_element(110, "Reserved", 0);
    this->add_element(111, "Reserved", 0);
    this->add_element(112, "Reserved", 0);
    this->add_element(113, "Reserved", 0);
    this->add_element(114, "Reserved", 0);
    this->add_element(115, "Reserved", 0);
    this->add_element(116, "Reserved", 0);
    this->add_element(117, "Reserved", 0);
    this->add_element(118, "Reserved", 0);
    this->add_element(119, "Reserved", 0);
    this->add_element(120, "Reserved", 0);
    this->add_element(121, "Reserved", 0);
    this->add_element(122, "Reserved", 0);
    this->add_element(123, "Reserved", 0);
    this->add_element(124, "Reserved", 0);
    this->add_element(125, "Reserved", 0);
    this->add_element(126, "Reserved", 0);
    this->add_element(127, "Reserved", 0);
    this->add_element(128, "bgpNextAdjacentAsNumber", 4);
    this->add_element(129, "bgpPrevAdjacentAsNumber", 4);
    this->add_element(130, "exporterIPv4Address", 4);
    this->add_element(131, "exporterIPv6Address", 16);
    this->add_element(132, "droppedOctetDeltaCount", 8);
    this->add_element(133, "droppedPacketDeltaCount", 8);
    this->add_element(134, "droppedOctetTotalCount", 8);
    this->add_element(135, "droppedPacketTotalCount", 8);
    this->add_element(136, "flowEndReason", 1);
    this->add_element(137, "commonPropertiesId", 8);
    this->add_element(138, "observationPointId", 8);
    this->add_element(139, "icmpTypeCodeIPv6", 2);
    this->add_element(140, "mplsTopLabelIPv6Address", 16);
    this->add_element(141, "lineCardId", 4);
    this->add_element(142, "portId", 4);
    this->add_element(143, "meteringProcessId", 4);
    this->add_element(144, "exportingProcessId", 4);
    this->add_element(145, "templateId", 2);
    this->add_element(146, "wlanChannelId", 1);
    this->add_element(147, "wlanSSID", 0);
    this->add_element(148, "flowId", 8);
    this->add_element(149, "observationDomainId", 4);
    this->add_element(150, "flowStartSeconds", 0);
    this->add_element(151, "flowEndSeconds", 0);
    this->add_element(152, "flowStartMilliseconds", 0);
    this->add_element(153, "flowEndMilliseconds", 0);
    this->add_element(154, "flowStartMicroseconds", 0);
    this->add_element(155, "flowEndMicroseconds", 0);
    this->add_element(156, "flowStartNanoseconds", 0);
    this->add_element(157, "flowEndNanoseconds", 0);
    this->add_element(158, "flowStartDeltaMicroseconds", 4);
    this->add_element(159, "flowEndDeltaMicroseconds", 4);
    this->add_element(160, "systemInitTimeMilliseconds", 0);
    this->add_element(161, "flowDurationMilliseconds", 4);
    this->add_element(162, "flowDurationMicroseconds", 4);
    this->add_element(163, "observedFlowTotalCount", 8);
    this->add_element(164, "ignoredPacketTotalCount", 8);
    this->add_element(165, "ignoredOctetTotalCount", 8);
    this->add_element(166, "notSentFlowTotalCount", 8);
    this->add_element(167, "notSentPacketTotalCount", 8);
    this->add_element(168, "notSentOctetTotalCount", 8);
    this->add_element(169, "destinationIPv6Prefix", 16);
    this->add_element(170, "sourceIPv6Prefix", 16);
    this->add_element(171, "postOctetTotalCount", 8);
    this->add_element(172, "postPacketTotalCount", 8);
    this->add_element(173, "flowKeyIndicator", 8);
    this->add_element(174, "postMCastPacketTotalCount", 8);
    this->add_element(175, "postMCastOctetTotalCount", 8);
    this->add_element(176, "icmpTypeIPv4", 1);
    this->add_element(177, "icmpCodeIPv4", 1);
    this->add_element(178, "icmpTypeIPv6", 1);
    this->add_element(179, "icmpCodeIPv6", 1);
    this->add_element(180, "udpSourcePort", 2);
    this->add_element(181, "udpDestinationPort", 2);
    this->add_element(182, "tcpSourcePort", 2);
    this->add_element(183, "tcpDestinationPort", 2);
    this->add_element(184, "tcpSequenceNumber", 4);
    this->add_element(185, "tcpAcknowledgementNumber", 4);
    this->add_element(186, "tcpWindowSize", 2);
    this->add_element(187, "tcpUrgentPointer", 2);
    this->add_element(188, "tcpHeaderLength", 1);
    this->add_element(189, "ipHeaderLength", 1);
    this->add_element(190, "totalLengthIPv4", 2);
    this->add_element(191, "payloadLengthIPv6", 2);
    this->add_element(192, "ipTTL", 1);
    this->add_element(193, "nextHeaderIPv6", 1);
    this->add_element(194, "mplsPayloadLength", 4);
    this->add_element(195, "ipDiffServCodePoint", 1);
    this->add_element(196, "ipPrecedence", 1);
    this->add_element(197, "fragmentFlags", 1);
    this->add_element(198, "octetDeltaSumOfSquares", 8);
    this->add_element(199, "octetTotalSumOfSquares", 8);
    this->add_element(200, "mplsTopLabelTTL", 1);
    this->add_element(201, "mplsLabelStackLength", 4);
    this->add_element(202, "mplsLabelStackDepth", 4);
    this->add_element(203, "mplsTopLabelExp", 1);
    this->add_element(204, "ipPayloadLength", 4);
    this->add_element(205, "udpMessageLength", 2);
    this->add_element(206, "isMulticast", 1);
    this->add_element(207, "ipv4IHL", 1);
    this->add_element(208, "ipv4Options", 4);
    this->add_element(209, "tcpOptions", 8);
    this->add_element(210, "paddingOctets", 0);
    this->add_element(211, "collectorIPv4Address", 4);
    this->add_element(212, "collectorIPv6Address", 16);
    this->add_element(213, "exportInterface", 4);
    this->add_element(214, "exportProtocolVersion", 1);
    this->add_element(215, "exportTransportProtocol", 1);
    this->add_element(216, "collectorTransportPort", 2);
    this->add_element(217, "exporterTransportPort", 2);
    this->add_element(218, "tcpSynTotalCount", 8);
    this->add_element(219, "tcpFinTotalCount", 8);
    this->add_element(220, "tcpRstTotalCount", 8);
    this->add_element(221, "tcpPshTotalCount", 8);
    this->add_element(222, "tcpAckTotalCount", 8);
    this->add_element(223, "tcpUrgTotalCount", 8);
    this->add_element(224, "ipTotalLength", 8);
    this->add_element(225, "postNATSourceIPv4Address", 4);
    this->add_element(226, "postNATDestinationIPv4Address", 4);
    this->add_element(227, "postNAPTSourceTransportPort", 2);
    this->add_element(228, "postNAPTDestinationTransportPort", 2);
    this->add_element(229, "natOriginatingAddressRealm", 1);
    this->add_element(230, "natEvent", 1);
    this->add_element(231, "initiatorOctets", 8);
    this->add_element(232, "responderOctets", 8);
    this->add_element(233, "firewallEvent", 1);
    this->add_element(234, "ingressVRFID", 4);
    this->add_element(235, "egressVRFID", 4);
    this->add_element(236, "VRFname", 0);
    this->add_element(237, "postMplsTopLabelExp", 1);
    this->add_element(238, "tcpWindowScale", 2);
    this->add_element(239, "biflowDirection", 1);
    this->add_element(240, "ethernetHeaderLength", 1);
    this->add_element(241, "ethernetPayloadLength", 2);
    this->add_element(242, "ethernetTotalLength", 2);
    this->add_element(243, "dot1qVlanId", 2);
    this->add_element(244, "dot1qPriority", 1);
    this->add_element(245, "dot1qCustomerVlanId", 2);
    this->add_element(246, "dot1qCustomerPriority", 1);
    this->add_element(247, "metroEvcId", 0);
    this->add_element(248, "metroEvcType", 1);
    this->add_element(249, "pseudoWireId", 4);
    this->add_element(250, "pseudoWireType", 2);
    this->add_element(251, "pseudoWireControlWord", 4);
    this->add_element(252, "ingressPhysicalInterface", 4);
    this->add_element(253, "egressPhysicalInterface", 4);
    this->add_element(254, "postDot1qVlanId", 2);
    this->add_element(255, "postDot1qCustomerVlanId", 2);
    this->add_element(256, "ethernetType", 2);
    this->add_element(257, "postIpPrecedence", 1);
    this->add_element(258, "collectionTimeMilliseconds", 0);
    this->add_element(259, "exportSctpStreamId", 2);
    this->add_element(260, "maxExportSeconds", 0);
    this->add_element(261, "maxFlowEndSeconds", 0);
    this->add_element(262, "messageMD5Checksum", 0);
    this->add_element(263, "messageScope", 1);
    this->add_element(264, "minExportSeconds", 0);
    this->add_element(265, "minFlowStartSeconds", 0);
    this->add_element(266, "opaqueOctets", 0);
    this->add_element(267, "sessionScope", 1);
    this->add_element(268, "maxFlowEndMicroseconds", 0);
    this->add_element(269, "maxFlowEndMilliseconds", 0);
    this->add_element(270, "maxFlowEndNanoseconds", 0);
    this->add_element(271, "minFlowStartMicroseconds", 0);
    this->add_element(272, "minFlowStartMilliseconds", 0);
    this->add_element(273, "minFlowStartNanoseconds", 0);
    this->add_element(274, "collectorCertificate", 0);
    this->add_element(275, "exporterCertificate", 0);
    this->add_element(276, "dataRecordsReliability", 0);
    this->add_element(277, "observationPointType", 1);
    this->add_element(278, "newConnectionDeltaCount", 4);
    this->add_element(279, "connectionSumDurationSeconds", 8);
    this->add_element(280, "connectionTransactionId", 8);
    this->add_element(281, "postNATSourceIPv6Address", 16);
    this->add_element(282, "postNATDestinationIPv6Address", 16);
    this->add_element(283, "natPoolId", 4);
    this->add_element(284, "natPoolName", 0);
    this->add_element(285, "anonymizationFlags", 2);
    this->add_element(286, "anonymizationTechnique", 2);
    this->add_element(287, "informationElementIndex", 2);
    this->add_element(288, "p2pTechnology", 0);
    this->add_element(289, "tunnelTechnology", 0);
    this->add_element(290, "encryptedTechnology", 0);
    this->add_element(291, "basicList", 0);
    this->add_element(292, "subTemplateList", 0);
    this->add_element(293, "subTemplateMultiList", 0);
    this->add_element(294, "bgpValidityState", 1);
    this->add_element(295, "IPSecSPI", 4);
    this->add_element(296, "greKey", 4);
    this->add_element(297, "natType", 1);
    this->add_element(298, "initiatorPackets", 8);
    this->add_element(299, "responderPackets", 8);
    this->add_element(300, "observationDomainName", 0);
    this->add_element(301, "selectionSequenceId", 8);
    this->add_element(302, "selectorId", 8);
    this->add_element(303, "informationElementId", 2);
    this->add_element(304, "selectorAlgorithm", 2);
    this->add_element(305, "samplingPacketInterval", 4);
    this->add_element(306, "samplingPacketSpace", 4);
    this->add_element(307, "samplingTimeInterval", 4);
    this->add_element(308, "samplingTimeSpace", 4);
    this->add_element(309, "samplingSize", 4);
    this->add_element(310, "samplingPopulation", 4);
    this->add_element(311, "samplingProbability", 0);
    this->add_element(312, "dataLinkFrameSize", 2);
    this->add_element(313, "ipHeaderPacketSection", 0);
    this->add_element(314, "ipPayloadPacketSection", 0);
    this->add_element(315, "dataLinkFrameSection", 0);
    this->add_element(316, "mplsLabelStackSection", 0);
    this->add_element(317, "mplsPayloadPacketSection", 0);
    this->add_element(318, "selectorIdTotalPktsObserved", 8);
    this->add_element(319, "selectorIdTotalPktsSelected", 8);
    this->add_element(320, "absoluteError", 0);
    this->add_element(321, "relativeError", 0);
    this->add_element(322, "observationTimeSeconds", 0);
    this->add_element(323, "observationTimeMilliseconds", 0);
    this->add_element(324, "observationTimeMicroseconds", 0);
    this->add_element(325, "observationTimeNanoseconds", 0);
    this->add_element(326, "digestHashValue", 8);
    this->add_element(327, "hashIPPayloadOffset", 8);
    this->add_element(328, "hashIPPayloadSize", 8);
    this->add_element(329, "hashOutputRangeMin", 8);
    this->add_element(330, "hashOutputRangeMax", 8);
    this->add_element(331, "hashSelectedRangeMin", 8);
    this->add_element(332, "hashSelectedRangeMax", 8);
    this->add_element(333, "hashDigestOutput", 0);
    this->add_element(334, "hashInitialiserValue", 8);
    this->add_element(335, "selectorName", 0);
    this->add_element(336, "upperCILimit", 0);
    this->add_element(337, "lowerCILimit", 0);
    this->add_element(338, "confidenceLevel", 0);
    this->add_element(339, "informationElementDataType", 1);
    this->add_element(340, "informationElementDescription", 0);
    this->add_element(341, "informationElementName", 0);
    this->add_element(342, "informationElementRangeBegin", 8);
    this->add_element(343, "informationElementRangeEnd", 8);
    this->add_element(344, "informationElementSemantics", 1);
    this->add_element(345, "informationElementUnits", 2);
    this->add_element(346, "privateEnterpriseNumber", 4);
    this->add_element(347, "virtualStationInterfaceId", 0);
    this->add_element(348, "virtualStationInterfaceName", 0);
    this->add_element(349, "virtualStationUUID", 0);
    this->add_element(350, "virtualStationName", 0);
    this->add_element(351, "layer2SegmentId", 8);
    this->add_element(352, "layer2OctetDeltaCount", 8);
    this->add_element(353, "layer2OctetTotalCount", 8);
    this->add_element(354, "ingressUnicastPacketTotalCount", 8);
    this->add_element(355, "ingressMulticastPacketTotalCount", 8);
    this->add_element(356, "ingressBroadcastPacketTotalCount", 8);
    this->add_element(357, "egressUnicastPacketTotalCount", 8);
    this->add_element(358, "egressBroadcastPacketTotalCount", 8);
    this->add_element(359, "monitoringIntervalStartMilliSeconds", 0);
    this->add_element(360, "monitoringIntervalEndMilliSeconds", 0);
    this->add_element(361, "portRangeStart", 2);
    this->add_element(362, "portRangeEnd", 2);
    this->add_element(363, "portRangeStepSize", 2);
    this->add_element(364, "portRangeNumPorts", 2);
    this->add_element(365, "staMacAddress", 0);
    this->add_element(366, "staIPv4Address", 4);
    this->add_element(367, "wtpMacAddress", 0);
    this->add_element(368, "ingressInterfaceType", 4);
    this->add_element(369, "egressInterfaceType", 4);
    this->add_element(370, "rtpSequenceNumber", 2);
    this->add_element(371, "userName", 0);
    this->add_element(372, "applicationCategoryName", 0);
    this->add_element(373, "applicationSubCategoryName", 0);
    this->add_element(374, "applicationGroupName", 0);
    this->add_element(375, "originalFlowsPresent", 8);
    this->add_element(376, "originalFlowsInitiated", 8);
    this->add_element(377, "originalFlowsCompleted", 8);
    this->add_element(378, "distinctCountOfSourceIPAddress", 8);
    this->add_element(379, "distinctCountOfDestinationIPAddress", 8);
    this->add_element(380, "distinctCountOfSourceIPv4Address", 4);
    this->add_element(381, "distinctCountOfDestinationIPv4Address", 4);
    this->add_element(382, "distinctCountOfSourceIPv6Address", 8);
    this->add_element(383, "distinctCountOfDestinationIPv6Address", 8);
    this->add_element(384, "valueDistributionMethod", 1);
    this->add_element(385, "rfc3550JitterMilliseconds", 4);
    this->add_element(386, "rfc3550JitterMicroseconds", 4);
    this->add_element(387, "rfc3550JitterNanoseconds", 4);
    this->add_element(388, "dot1qDEI", 0);
    this->add_element(389, "dot1qCustomerDEI", 0);
    this->add_element(390, "flowSelectorAlgorithm", 2);
    this->add_element(391, "flowSelectedOctetDeltaCount", 8);
    this->add_element(392, "flowSelectedPacketDeltaCount", 8);
    this->add_element(393, "flowSelectedFlowDeltaCount", 8);
    this->add_element(394, "selectorIDTotalFlowsObserved", 8);
    this->add_element(395, "selectorIDTotalFlowsSelected", 8);
    this->add_element(396, "samplingFlowInterval", 8);
    this->add_element(397, "samplingFlowSpacing", 8);
    this->add_element(398, "flowSamplingTimeInterval", 8);
    this->add_element(399, "flowSamplingTimeSpacing", 8);
    this->add_element(400, "hashFlowDomain", 2);
    this->add_element(401, "transportOctetDeltaCount", 8);
    this->add_element(402, "transportPacketDeltaCount", 8);
    this->add_element(403, "originalExporterIPv4Address", 4);
    this->add_element(404, "originalExporterIPv6Address", 16);
    this->add_element(405, "originalObservationDomainId", 4);
    this->add_element(406, "intermediateProcessId", 4);
    this->add_element(407, "ignoredDataRecordTotalCount", 8);
    this->add_element(408, "dataLinkFrameType", 2);
    this->add_element(409, "sectionOffset", 2);
    this->add_element(410, "sectionExportedOctets", 2);
    this->add_element(411, "dot1qServiceInstanceTag", 0);
    this->add_element(412, "dot1qServiceInstanceId", 4);
    this->add_element(413, "dot1qServiceInstancePriority", 1);
    this->add_element(414, "dot1qCustomerSourceMacAddress", 0);
    this->add_element(415, "dot1qCustomerDestinationMacAddress", 0);
    this->add_element(416, "reserved", 0);
    this->add_element(417, "postLayer2OctetDeltaCount", 8);
    this->add_element(418, "postMCastLayer2OctetDeltaCount", 8);
    this->add_element(419, "reserved", 0);
    this->add_element(420, "postLayer2OctetTotalCount", 8);
    this->add_element(421, "postMCastLayer2OctetTotalCount", 8);
    this->add_element(422, "minimumLayer2TotalLength", 8);
    this->add_element(423, "maximumLayer2TotalLength", 8);
    this->add_element(424, "droppedLayer2OctetDeltaCount", 8);
    this->add_element(425, "droppedLayer2OctetTotalCount", 8);
    this->add_element(426, "ignoredLayer2OctetTotalCount", 8);
    this->add_element(427, "notSentLayer2OctetTotalCount", 8);
    this->add_element(428, "layer2OctetDeltaSumOfSquares", 8);
    this->add_element(429, "layer2OctetTotalSumOfSquares", 8);
    this->add_element(430, "layer2FrameDeltaCount", 8);
    this->add_element(431, "layer2FrameTotalCount", 8);
    this->add_element(432, "pseudoWireDestinationIPv4Address", 4);
    this->add_element(433, "ignoredLayer2FrameTotalCount", 8);
}
