/*
 * $Id: network_bridge.c,v 1.27 2012-02-22 09:27:20 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DBG_DUMP	0

#include "config.h"

#if defined(HAVE_LINUX_IF_TUN_H) || defined(HAVE_NET_IF_TUN_H)

#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue.h"

#define INCLUDE
#include "arch_tap.c"
#undef INCLUDE

#include "network_bridge.h"

struct cpssp {
	struct sig_eth *port_eth;
#define STATE
#define NAME		tuntap
#include "arch_tap.c"
#undef NAME
#undef STATE
};

/* ------------------------------------------------------------------ */
/* tun/tap
 */

/*forward*/ static void
bridge_real_to_virt(struct cpssp * cpssp, unsigned char *buf, unsigned int bufsize);

#define BEHAVIOR
#define NAME		tuntap
#define NAME_(x)	tuntap_ ## x
#include "arch_tap.c"
#undef NAME_
#undef NAME
#undef BEHAVIOR

/* ------------------------------------------------------------------ */
/* debugging
 */

static int
dump(const char *string, const unsigned char *buf, int bufsize)
{
#if DBG_DUMP
	int i;
	char arp=0 ;

#if 0
	/* FIXME - won't work with CIM/bridge */
	static unsigned char broadcast[6] = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff
	};

	if (memcmp(buf, broadcast, 6) != 0
	 && memcmp(buf + 6, broadcast, 6) != 0) {
		for (i = 0; ; i++) {
			if (i == 16) {
				/* foreign packet => don't dump */
				/* fprintf(stderr, "foreign packet!\n") ; */
				return 0;
			}
			if (host[i].addr == 0
			 || host[i].port == 0) {
				continue;
			}
			if (memcmp(buf, host[i].mac, 6) == 0
			 || memcmp(buf + 6, host[i].mac, 6) == 0) {
				break;
			}
		}
	}
#endif

	if (((*((const char*)(&buf[12]))) == (char)0x08) &&
		((*((const char*)(&buf[13]))) == (char)0x06)) {
		arp = 1 ;
	}
	fprintf(stderr, "%s len(%d):", string, bufsize);
	for (i = 0; i < bufsize && i < (160 - strlen(string)) / 3; i++) {
		fprintf(stderr, " %02x", buf[i]);
		switch(i) {
		case 5:
		case 11:
			fprintf(stderr, " |") ; break ;
		case 13:
			fprintf(stderr, " ||\n\t") ; break ;
		case 15:
		case 17:
		case 18:
		case 19:
		case 21:
		case 27:
		case 31:
		case 37:
		case 41:
			if (arp) { fprintf(stderr, " |") ; } break ;
		default:
			break ;
		}
	}
	fprintf(stderr, "\n");
	return 1 ;
#endif
#if !DBG_DUMP
	return 0 ;
#endif
}

/* ------------------------------------------------------------------ */
/* called from tun/tap
 */

static void
bridge_real_to_virt(
	struct cpssp * cpssp,
	unsigned char *buf,
	unsigned int bufsize
)
{
	int dumped;

	dumped = dump("#### phys -> virt ### start\np->v", buf, bufsize);

	/* fix packet by padding with zeros */
	/* Linux bridging code seems to truncate padding ??! */
	while (bufsize < 60) {
		buf[bufsize++] = 0;
	}
	sig_eth_send(cpssp->port_eth, &cpssp->port_eth, buf, bufsize);

	if (dumped) { fprintf(stderr, "#### phys -> virt ### end\n") ;}
}

/* ------------------------------------------------------------------ */
/* callback for ethernet port
 */

static void
bridge_virt_to_real(void *_cpssp, const void *buf, unsigned int bufsize)
{
	struct cpssp * cpssp = (struct cpssp *) _cpssp;
	int dumped;
	int ret;

	dumped = dump("#### virt -> phys ### start\nv->p", buf, bufsize);

	ret = tuntap_send(cpssp, buf, bufsize);
	if (ret < 0) {
		fprintf(stderr, "%s: phys_send: %s.\n",
				progname,
				strerror(errno));
	}

	if (dumped) { fprintf(stderr, "#### virt -> phys ### end\n") ; }
}

/* ------------------------------------------------------------------ */
/* interface of module
 */

void *
network_bridge_create(
	const char *name,
	const char *interface,
	struct sig_manage *port_manage,
	struct sig_eth *port_eth
)
{
	static const struct sig_eth_funcs eth_funcs = {
		.recv = bridge_virt_to_real,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);
	memset(cpssp, 0, sizeof(*cpssp));

	assert(interface);

	tuntap_create(cpssp, interface);

	cpssp->port_eth = port_eth;
	sig_eth_connect(cpssp->port_eth, cpssp, &eth_funcs);

	return cpssp;
}

void
network_bridge_destroy(void *_cpssp)
{
	struct cpssp * cpssp = (struct cpssp *) _cpssp;

	tuntap_destroy(cpssp);

	shm_free(cpssp);
}

void
network_bridge_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
network_bridge_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}

#else /* defined(HAVE_LINUX_IF_TUN_H) || defined(HAVE_NET_IF_TUN_H) */

#include <stdio.h>
#include "network_bridge.h"

void *
network_bridge_create(
	const char *name,
	const char *interface,
	struct sig_manage *port_manage,
	struct sig_eth *port_eth
)
{
	return NULL;
}

void
network_bridge_destroy(void *_cpssp)
{
}

void
network_bridge_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
network_bridge_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}

#endif /* defined(HAVE_LINUX_IF_TUN_H) || defined(HAVE_NET_IF_TUN_H) */
