/* $Id: pci_gen_dio24_rom.c,v 1.4 2009-01-28 12:59:21 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <inttypes.h>
#include <stdio.h>
#include <unistd.h>

/* Set the correct values - FIXME */
#define PCI_VENDOR_ID_CBOARDS 0x1307
#define PCI_DEVICE_ID_CBOARDS_DIO24H 0x0028
#define PCI_CLASS_COMMUNICATION_PARALLEL 0x0701
#define PCI_CLASS_PROG_IF 0x0100
#define PCI_SUBSYSTEM_ID 0x0000
#define PCI_SUBSYSTEM_VENDOR_ID 0x0000
#define PCI_MAXLAT_MINGRANT 0x0000
#define PCI_INTPIN_INTLINE 0x0100
#define PCI_TO_LOCAL_ADDR0_RANGE_MSW 0xffff
#define PCI_TO_LOCAL_ADDR0_RANGE_LSW 0xfff9
#define PCI_TO_LOCAL_ADDR1_RANGE_MSW 0x0000
#define PCI_TO_LOCAL_ADDR1_RANGE_LSW 0x0000
#define PCI_TO_LOCAL_ADDR2_RANGE_MSW 0x0000
#define PCI_TO_LOCAL_ADDR2_RANGE_LSW 0x0000
#define PCI_TO_LOCAL_ADDR3_RANGE_MSW 0x0000
#define PCI_TO_LOCAL_ADDR3_RANGE_LSW 0x0000
#define PCI_TO_LOCAL_EXP_ROM_RANGE_MSW 0x0000
#define PCI_TO_LOCAL_EXP_ROM_RANGE_LSW 0x0000
#define LOCAL_BASE_ADDR0_MSW 0x0000
#define LOCAL_BASE_ADDR0_LSW 0x0001
#define LOCAL_BASE_ADDR1_MSW 0x0000
#define LOCAL_BASE_ADDR1_LSW 0x0001
#define LOCAL_BASE_ADDR2_MSW 0x0100
#define LOCAL_BASE_ADDR2_LSW 0x0001
#define LOCAL_BASE_ADDR3_MSW 0x0200
#define LOCAL_BASE_ADDR3_LSW 0x0001
#define LOCAL_BASE_ADDR_EXP_ROM_MSW 0x0000
#define LOCAL_BASE_ADDR_EXP_ROM_LSW 0x0000
#define BUS_REG_DESCR_ADDR0_MSW 0x0000
#define BUS_REG_DESCR_ADDR0_LSW 0x0022
#define BUS_REG_DESCR_ADDR1_MSW 0x0000
#define BUS_REG_DESCR_ADDR1_LSW 0x0022
#define BUS_REG_DESCR_ADDR2_MSW 0x0080
#define BUS_REG_DESCR_ADDR2_LSW 0x0001
#define BUS_REG_DESCR_ADDR3_MSW 0x5421
#define BUS_REG_DESCR_ADDR3_LSW 0x38e9
#define BUS_REG_DESCR_EXP_ROM_MSW 0x0000
#define BUS_REG_DESCR_EXP_ROM_LSW 0x0000
#define CHIP_SEL0_BAR_MSW 0x0008
#define CHIP_SEL0_BAR_LSW 0x0001
#define CHIP_SEL1_BAR_MSW 0x0000
#define CHIP_SEL1_BAR_LSW 0x0000
#define CHIP_SEL2_BAR_MSW 0x0000
#define CHIP_SEL2_BAR_LSW 0x0000
#define CHIP_SEL3_BAR_MSW 0x0000
#define CHIP_SEL3_BAR_LSW 0x0000
#define INT_CONT_STAT_MSW 0x0000
#define INT_CONT_STAT_LSW 0x0043
#define USER_IO_MSW 0x007c
#define USER_IO_LSW 0x4252

int
main(int argc, char **argv)
{
	uint16_t rom[64];
	int fd;
	int ret;
	unsigned int i;

	assert(argc == 2);

	rom[ 0] = PCI_DEVICE_ID_CBOARDS_DIO24H;
	rom[ 1] = PCI_VENDOR_ID_CBOARDS;
	rom[ 2] = PCI_CLASS_COMMUNICATION_PARALLEL;
	rom[ 3] = PCI_CLASS_PROG_IF;
	rom[ 4] = PCI_SUBSYSTEM_ID;
	rom[ 5] = PCI_SUBSYSTEM_VENDOR_ID;
	rom[ 6] = PCI_MAXLAT_MINGRANT;
	rom[ 7] = PCI_INTPIN_INTLINE;
	rom[ 8] = PCI_TO_LOCAL_ADDR0_RANGE_MSW;
	rom[ 9] = PCI_TO_LOCAL_ADDR0_RANGE_LSW;
	rom[10] = PCI_TO_LOCAL_ADDR1_RANGE_MSW;
	rom[11] = PCI_TO_LOCAL_ADDR1_RANGE_LSW;
	rom[12] = PCI_TO_LOCAL_ADDR2_RANGE_MSW;
	rom[13] = PCI_TO_LOCAL_ADDR2_RANGE_LSW;
	rom[14] = PCI_TO_LOCAL_ADDR3_RANGE_MSW;
	rom[15] = PCI_TO_LOCAL_ADDR3_RANGE_LSW;
	rom[16] = PCI_TO_LOCAL_EXP_ROM_RANGE_MSW;
	rom[17] = PCI_TO_LOCAL_EXP_ROM_RANGE_LSW;
	rom[18] = LOCAL_BASE_ADDR0_MSW;
	rom[19] = LOCAL_BASE_ADDR0_LSW;
	rom[20] = LOCAL_BASE_ADDR1_MSW;
	rom[21] = LOCAL_BASE_ADDR1_LSW;
	rom[22] = LOCAL_BASE_ADDR2_MSW;
	rom[23] = LOCAL_BASE_ADDR2_LSW;
	rom[24] = LOCAL_BASE_ADDR3_MSW;
	rom[25] = LOCAL_BASE_ADDR3_LSW;
	rom[26] = LOCAL_BASE_ADDR_EXP_ROM_MSW;
	rom[27] = LOCAL_BASE_ADDR_EXP_ROM_LSW;
	rom[28] = BUS_REG_DESCR_ADDR0_MSW;
	rom[29] = BUS_REG_DESCR_ADDR0_LSW;
	rom[30] = BUS_REG_DESCR_ADDR1_MSW;
	rom[31] = BUS_REG_DESCR_ADDR1_LSW;
	rom[32] = BUS_REG_DESCR_ADDR2_MSW;
	rom[33] = BUS_REG_DESCR_ADDR2_LSW;
	rom[34] = BUS_REG_DESCR_ADDR3_MSW;
	rom[35] = BUS_REG_DESCR_ADDR3_LSW;
	rom[36] = BUS_REG_DESCR_EXP_ROM_MSW;
	rom[37] = BUS_REG_DESCR_EXP_ROM_LSW;
	rom[38] = CHIP_SEL0_BAR_MSW;
	rom[39] = CHIP_SEL0_BAR_LSW;
	rom[40] = CHIP_SEL1_BAR_MSW;
	rom[41] = CHIP_SEL1_BAR_LSW;
	rom[42] = CHIP_SEL2_BAR_MSW;
	rom[43] = CHIP_SEL2_BAR_LSW;
	rom[44] = CHIP_SEL3_BAR_MSW;
	rom[45] = CHIP_SEL3_BAR_LSW;
	rom[46] = INT_CONT_STAT_MSW;
	rom[47] = INT_CONT_STAT_LSW;
	rom[48] = USER_IO_MSW;
	rom[49] = USER_IO_LSW;
	for (i = 50; i < sizeof(rom) / sizeof(rom[0]); i++) {
		rom[i] = 0x0000;
	}

	fd = open(argv[1], O_WRONLY | O_CREAT, 0666);
	assert(0 <= fd);

	ret = write(fd, rom, sizeof(rom));
	assert(0 <= ret);
	assert(ret == sizeof(rom));

	ret = close(fd);
	assert(0 <= ret);

	return 0;
}
