/* $Id: ptrace.h,v 1.11 2009-01-28 16:47:15 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PTRACE_H_INCLUDED
#define __PTRACE_H_INCLUDED

struct regs {
	unsigned short ax;	/* saved by interrupt handler */
#ifndef CONFIG_80286_SUPPORT
	unsigned short ax_high;
#endif
	unsigned short bx;
	unsigned short cx;
	unsigned short dx;
#ifndef CONFIG_80286_SUPPORT
	unsigned short dx_high;
#endif
	unsigned short bp;
	unsigned short si;
	unsigned short di;
	unsigned short es;
	unsigned short ds;
	unsigned short ip;	/* saved by int $xx call */
	unsigned short cs;
	unsigned short flags;
};

#define AX	regs->ax
#define AL	(*((unsigned char *) &regs->ax + 0))
#define AH	(*((unsigned char *) &regs->ax + 1))

#define BX	regs->bx
#define BL	(*((unsigned char *) &regs->bx + 0))
#define BH	(*((unsigned char *) &regs->bx + 1))

#define CX	regs->cx
#define CL	(*((unsigned char *) &regs->cx + 0))
#define CH	(*((unsigned char *) &regs->cx + 1))

#define DX	regs->dx
#define DL	(*((unsigned char *) &regs->dx + 0))
#define DH	(*((unsigned char *) &regs->dx + 1))

#define BP	regs->bp

#define SI	regs->si

#define DI	regs->di

#define ES	regs->es
#define DS	regs->ds

#define IP	regs->ip
#define CS	regs->cs

#define F	regs->flags

#endif /* __PTRACE_H_INCLUDED */
