/*
 * $Id: conn_dimm.c,v 1.16 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_dimm.h"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_cs_merge *forward_cs0;
	struct sig_cs_merge *forward_cs1;
#if 0	/* FIXME */
	struct sig_mem_bus_main_forward forward_main;
#endif
	struct sig_i2c_bus_merge *forward_i2cbus;
	struct sig_boolean_merge *forward_id0;
	struct sig_boolean_merge *forward_id1;
	struct sig_boolean_merge *forward_id2;
};

void *
conn_dimm_create(
	const char *name,
	struct sig_manage *port_manage,

	struct sig_mem_bus *port_mem,

	struct sig_boolean *port_power,
	struct sig_cs *port_cs0,
	struct sig_cs *port_cs1,
	struct sig_mem_bus_main *port_main,
	struct sig_i2c_bus *port_i2cbus,
	struct sig_boolean *port_id0,
	struct sig_boolean *port_id1,
	struct sig_boolean *port_id2
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_power = sig_boolean_merge(port_power, port_mem->power);
	cpssp->forward_cs0 = sig_cs_merge(port_cs0, port_mem->cs0);
	cpssp->forward_cs1 = sig_cs_merge(port_cs1, port_mem->cs1);
#if 0 /* FIXME */
	sig_mem_bus_main_forward_init(&cpssp->forward_main,
			port_main, port_mem->main);
#endif
	cpssp->forward_i2cbus = sig_i2c_bus_merge(port_i2cbus, port_mem->i2cbus);
	cpssp->forward_id0 = sig_boolean_merge(port_id0, port_mem->id0);
	cpssp->forward_id1 = sig_boolean_merge(port_id1, port_mem->id1);
	cpssp->forward_id2 = sig_boolean_merge(port_id2, port_mem->id2);

	return cpssp;
}

void
conn_dimm_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
conn_dimm_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
conn_dimm_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
