/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file dtmf.h
 * \brief Dtmf structure header
 */

#ifndef DTMF_H
#define DTMF_H

struct sDtmf {
	gchar *pnName;
	gchar *pnCalled;
	gchar *pnCaller;
	gchar *pnCode;
	gchar *pnExecute;
};

GList *getDtmf( void );
struct sDtmf *findDtmf( const gchar *pnName );
void executeDtmfActions( gchar *pnCaller, gchar *pnCalled, gchar *pnCode );
void saveDtmfActions( void );
void DtmfActionsLoad( void );
gboolean validDtmfAction( gchar *pnCaller, gchar *pnCalled );

#endif
