#include <ffgtk.h>
#include <windows.h>
#include <stdio.h>

typedef int (CALLBACK *LPFNFFGTKMAIN)(HINSTANCE, int, char **);

static LPFNFFGTKMAIN ffgtk_main = NULL;

static wchar_t *win_lcid_to_posix(LCID lcid) {
	wchar_t *posix = NULL;
	int lang_id = PRIMARYLANGID(lcid);

	switch (lang_id) {
		case LANG_GERMAN:
			posix = L"de";
			break;
		case LANG_ENGLISH:
			posix = L"en";
			break;
		case LANG_DUTCH:
			posix = L"nl";
			break;
	}

	return posix;
}

static const wchar_t *win_get_locale() {
	LCID lcid;
	const wchar_t *locale;

	lcid = GetUserDefaultLCID();
	if ((locale = win_lcid_to_posix(lcid))) {
		return locale;
	}

	return L"en";
}

static const wchar_t *get_win32_error_message(DWORD err) {
	static wchar_t err_msg[512];

	FormatMessageW(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPWSTR) &err_msg, sizeof(err_msg) / sizeof(wchar_t), NULL );

	return err_msg;
}

int _stdcall WinMain(struct HINSTANCE__ *hInstance, struct HINSTANCE__ *hPrevInstance, char *lpszCmdLine, int nCmdShow ) {
	gchar *ffgtk_dir = NULL;
	int ffgtk_argc = 0;
	char **ffgtk_argv = NULL;
	const wchar_t *locale;
	wchar_t envstr[25];
	HMODULE hmod;
	int ret = -1;

	locale = win_get_locale();
	_snwprintf(envstr, sizeof(envstr) / sizeof(wchar_t), L"LANG=%s", locale);
	_wputenv(envstr);

	ffgtk_dir = g_win32_get_package_installation_directory_of_module(NULL);
	strcpy(ffgtk_dir, "libffgtk_core-0.dll");

	if ((hmod = LoadLibrary(ffgtk_dir))) {
		ffgtk_main = (LPFNFFGTKMAIN) GetProcAddress(hmod, "ffgtk_main");
	} else {
		printf("Could not load libffgtk_core-0.dll\n");
	}

	if (!ffgtk_main) {
		DWORD dw = GetLastError();
		BOOL mod_not_found = (dw == ERROR_MOD_NOT_FOUND || dw == ERROR_DLL_NOT_FOUND );
		const wchar_t *err_msg = get_win32_error_message(dw);
	
		printf("Could not load ffgtk_main from libffgtk_core-0.dll\n");
		wprintf( L"Error (%u) %s%s%s\n", dw, err_msg, mod_not_found ? L"\n" : L"", mod_not_found ? L"This probably means that GTK+ can't be found" : L"");
		return 0;
	}

	ret = ffgtk_main(hInstance, ffgtk_argc, ffgtk_argv);

	exit(ret);

	return 0;
}
