/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.EditTournamentPanel;
import friendless.games.filler.FillerPanel;
import friendless.games.filler.HeadToHeadPanel;
import friendless.games.filler.HelpPanel;
import friendless.games.filler.PlayerRatings;
import friendless.games.filler.PlayerWrappers;
import friendless.games.filler.RankingsPanel;
import friendless.games.filler.TournamentResultsPanel;
import friendless.games.filler.TournamentRules;
import friendless.games.filler.remote.NetworkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainPanel
extends JPanel {
    JTabbedPane tabPane;
    EditTournamentPanel editTourn;
    PlayerRatings ratings;
    PlayerWrappers players;
    RankingsPanel rankings;
    HeadToHeadPanel h2h;
    ResourceBundle resources;
    FillerPanel fillerPanel;
    HelpPanel help;

    public MainPanel(ResourceBundle resourceBundle) {
        super(new BorderLayout());
        this.resources = resourceBundle;
        PlayerRatings.retrieve();
        this.players = new PlayerWrappers(resourceBundle);
        PlayerWrappers playerWrappers = new PlayerWrappers(resourceBundle);
        this.tabPane = new JTabbedPane(3);
        this.add((Component)this.tabPane, "Center");
        this.fillerPanel = new FillerPanel(this.players, resourceBundle);
        this.tabPane.add(resourceBundle.getString("filler.mainpanel.name"), this.fillerPanel);
        this.editTourn = new EditTournamentPanel(playerWrappers, resourceBundle, this);
        this.tabPane.addTab(resourceBundle.getString("filler.label.tournament"), null, this.editTourn, resourceBundle.getString("filler.string.cfgtourn"));
        this.rankings = new RankingsPanel(playerWrappers);
        this.tabPane.addTab(resourceBundle.getString("filler.label.rankings"), null, new JScrollPane(this.rankings), resourceBundle.getString("filler.string.rankings"));
        this.h2h = new HeadToHeadPanel(playerWrappers);
        this.tabPane.addTab(resourceBundle.getString("filler.string.h2h"), null, new JScrollPane(this.h2h), resourceBundle.getString("filler.string.h2hrec"));
        this.tabPane.addTab(resourceBundle.getString("filler.label.network"), null, new NetworkPanel(resourceBundle), resourceBundle.getString("filler.string.network"));
        this.tabPane.addTab(resourceBundle.getString("filler.label.tournamentresults"), null, TournamentResultsPanel.getInstance(resourceBundle), resourceBundle.getString("filler.string.tournamentresults"));
        this.help = new HelpPanel();
        this.tabPane.addTab(resourceBundle.getString("filler.label.help"), null, new JScrollPane(this.help, 22, 30), resourceBundle.getString("filler.string.help"));
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MainPanel.this.refreshTabs();
            }
        });
    }

    void refreshTabs() {
        int n = this.tabPane.getSelectedIndex();
        String string = this.tabPane.getTitleAt(n);
        if (string.equals(this.resources.getString("filler.label.rankings"))) {
            this.rankings.refresh();
        } else if (string.equals(this.resources.getString("filler.string.h2h"))) {
            this.h2h.refresh();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 430);
    }

    public void playTournament(TournamentRules tournamentRules, PlayerWrappers playerWrappers) {
        this.tabPane.setSelectedComponent(this.fillerPanel);
        this.fillerPanel.playTournament(tournamentRules, playerWrappers);
    }
}

