/*****************************************************************************/
/* biquad-isc.h 							     */
/*****************************************************************************/

#ifndef	__BIQUAD_ISC_H_INCLUDED
#define	__BIQUAD_ISC_H_INCLUDED	1

/* biquad_isc_int_pixel_circle():
   Calculates the integral of the biquadratic surface 'c' on the intersecion
   of the pixel (ix,iy) (thus, the rectangle ['ix':'ix'+1,'iy':'iy'+1]) and 
   the circle with a center of ('cx','cy') and radius of 'cr'. If the circle 
   and the rectangle are disjoint, the function returns 0, otherwise it returns
   the desired integral. To create such biquadratic interpolation surfaces, 
   the function  biquad_coeff() can be used (see also biquad.c or biquad.h). */

double biquad_isc_int_pixel_circle(double **c,int ix,int iy,double cx,
				   double cy,double cr);

/* biquad_isc_int_subpixel():
   Calculates the integral of the biquadratic surface 'c' on the subrectangle
   ['x0':'x1','y0':'y1'] of the pixel ('iy','ix'). The quantities 'x0', 'y0',
   'x1' and 'y1' should be between 0 and 1, otherwise the integral will be
   limited to the intersection of the rectangle ['x0':'x1','y0':'y1']
   and the rectangle [0:1,0:1]. 					     */
double	biquad_isc_int_subpixel(double **c,int ix,int iy,
				double x0,double y0,double x1,double y1);

/* biquad_isc_int_rectangle():
   Calcluates the integral of the biquadratic surface 'c' on the rectangl
   ['x0':'x1','y0':'y1']. Note that 'x0' and 'x1' should be between 0 and sx
   and 'y0' and 'y1' shouldbe between 0 and sy, otherwise the integration
   might spectaculary fail (with segmentation fault). 			     */
double	biquad_isc_int_rectangle(double **c,
				double x0,double y0,double x1,double y1);

/* biquad_isc_int_block_subpixels():
   Calculates the integral of the biquadratic surface 'c' to all subpixels
   of the pixel ('iy','ix') on a grid with a size of 'nx' times 'ny'. 
   The integrals are stored in the array 'ret' where must be enough
   space allocated for them. The function returns 0, if both 'nx' and 'ny'
   are positive. Otherwise the function returns a nonzero value.
   Note that because of the sigma-subadditiviy of the integral and the
   properties of the biquadratic surface storage method in arrays like 'c'
   (generated by biquad_coeff(), see also biquad.c), the sum of the integrals 
   returned in 'ret' is always c[2*iy+1][2*ix+1].			     */
int	biquad_isc_int_block_subpixels(double **c,int ix,int iy,
				       int nx,int ny,double **ret);

/* biquad_isc_int_triangle():
   This function integrates the biquadratic surface described by the 
   coefficients 'c' on the area of the triangle (x1,y1)-(x2,y2)-(x3,y3).
   The coordinates (xn and yn) should be in the intervals [0,sx] and
   [0,sy], respectively where sx and sy are the horizontal and vertical
   dimensions of the surface (see also biquad_coeff()). In other cases the
   parts of the integral outside the domain [0,sx]x[0,sy] are going 
   to be zero (if both sx and sy are positive) or the function might 
   spectaculary fail (with segmentation fault, if any of sx or sy is non-
   positive). The sign of the integral does not depend on the ordering of the 
   points (it can be both counter-clockwise and clockwise, the result is 
   going to be the same).							     */
double	biquad_isc_int_triangle(double **c,int is_spline,
		double x1,double y1,double x2,double y2,double x3,double y3,
		int sx,int sy);
#endif
                         
