//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     


//
// Vietnamese.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef VIETNAMESE
#define VIETNAMESE

namespace Vietnamese{

//
// Unicode values 
//
UINT32 values[]={
	0x00C0,
	0x00E0,
	0x00C1,
	0x00E1,
	0x00C2,
	0x00E2,
	0x1EA6,
	0x1EA7,
	0x1EA4,
	0x1EA5,
	0x1EAA,
	0x1EAB,
	0x1EA8,
	0x1EA9,
	0x1EAC,
	0x1EAD,
	0x00C3,
	0x00E3,
	0x0102,
	0x0103,
	0x1EB0,
	0x1EB1,
	0x1EAE,
	0x1EAF,
	0x1EB4,
	0x1EB5,
	0x1EB2,
	0x1EB3,
	0x1EB6,
	0x1EB7,
	0x1EA2,
	0x1EA3,
	0x1EA0,
	0x1EA1,
	0x0110,
	0x0111,
	0x00C8,
	0x00E8,
	0x00C9,
	0x00E9,
	0x00CA,
	0x00EA,
	0x1EC0,
	0x1EC1,
	0x1EBE,
	0x1EBF,
	0x1EC4,
	0x1EC5,
	0x1EC2,
	0x1EC3,
	0x1EC6,
	0x1EC7,
	0x1EBC,
	0x1EBD,
	0x1EBA,
	0x1EBB,
	0x1EB8,
	0x1EB9,
	0x00CC,
	0x00EC,
	0x00CD,
	0x00ED,
	0x0128,
	0x0129,
	0x1EC8,
	0x1EC9,
	0x1ECA,
	0x1ECB,
	0x00D2,
	0x00F2,
	0x00D3,
	0x00F3,
	0x00D4,
	0x00F4,
	0x1ED2,
	0x1ED3,
	0x1ED0,
	0x1ED1,
	0x1ED6,
	0x1ED7,
	0x1ED4,
	0x1ED5,
	0x1ED8,
	0x1ED9,
	0x00D5,
	0x00F5,
	0x1ECE,
	0x1ECF,
	0x01A0,
	0x01A1,
	0x1EDC,
	0x1EDD,
	0x1EDA,
	0x1EDB,
	0x1EE0,
	0x1EE1,
	0x1EDE,
	0x1EDF,
	0x1EE2,
	0x1EE3,
	0x1ECC,
	0x1ECD,
	0x00D9,
	0x00F9,
	0x00DA,
	0x00FA,
	0x0168,
	0x0169,
	0x1EE6,
	0x1EE7,
	0x01AF,
	0x01B0,
	0x1EEA,
	0x1EEB,
	0x1EE8,
	0x1EE9,
	0x1EEE,
	0x1EEF,
	0x1EEC,
	0x1EED,
	0x1EF0,
	0x1EF1,
	0x1EE4,
	0x1EE5,
	0x1EF2,
	0x1EF3,
	0x00DD,
	0x00FD,
	0x1EF8,
	0x1EF9,
	0x1EF6,
	0x1EF7,
	0x1EF4,
	0x1EF5,
	END_OF_DATA
};

//
// Sample sentences : First 2 lines of Tale of Kiều (傳翹): 
// 
const char *sentences[]={
	"Trăm năm, trong cõi người ta, Chữ tài, chữ mệnh, khéo là ghét nhau.",
	"Trải qua một cuộc bể dâu, Những điều trông thấy mà đau đớn lòng;",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"Vietnamese",
	"tiếng Việt",
	0x1EA6, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
	values,
	"ẦầẵặỒỗỬửỴỵ",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
