//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     


//
// Jinmeiyo.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef JINMEIYO
#define JINMEIYO

namespace Jinmeiyo{

//
// Unicode values 
//
// 773 Japanese jinmeiyo characters (with variants) based on
// http://en.wikipedia.org/wiki/Jinmeiy%C5%8D_kanji
// #List_of_the_jinmeiy.C5.8D_kanji_.28.E4.BA.BA.E5.90.8D.E7.94.A8.E6.BC.A2.E5.AD.97.E5.88.A5.E8.A1.A8.29
// 
// At the top of the article a number of 983 characters is given.
// However preceding the actual list of characters, the number 774 is given.
// I found one duplicate though, so here there are but 773 ...
// 
UINT32 values[]={
	0x4e11,
	0x4e1e,
	0x4e32,
	0x4e43,
	0x4e4b,
	0x4e4e,
	0x4e5f,
	0x4e91,
	0x4e98,
	0x4e99,
	0x4e9b,
	0x4ea6,
	0x4ea5,
	0x4ea8,
	0x4eae,
	0x4ed4,
	0x4f0a,
	0x4f0e,
	0x4f0d,
	0x4f3d,
	0x4f43,
	0x4f51,
	0x4f36,
	0x4f83,
	0x4f91,
	0x4fc4,
	0x4fe0,
	0x4fe3,
	0x4fd0,
	0x4fb6,
	0x502d,
	0x4ffa,
	0x4ff1,
	0x5026,
	0x5016,
	0x5072,
	0x50c5,
	0x50ad,
	0x5132,
	0x5141,
	0x514e,
	0x515c,
	0x5176,
	0x51a5,
	0x51b4,
	0x51b6,
	0x51c4,
	0x51cc,
	0x51dc,
	0x51db,
	0x51e7,
	0x51ea,
	0x51f0,
	0x51f1,
	0x51fd,
	0x5239,
	0x5289,
	0x52ab,
	0x52c1,
	0x52c3,
	0x52fe,
	0x5302,
	0x52ff,
	0x5321,
	0x5eff,
	0x535c,
	0x536f,
	0x537f,
	0x53a8,
	0x53a9,
	0x53c9,
	0x53e1,
	0x53e2,
	0x53f6,
	0x53ea,
	0x543e,
	0x541e,
	0x543b,
	0x5442,
	0x54c9,
	0x54e8,
	0x5544,
	0x5504,
	0x54e9,
	0x55ac,
	0x55a7,
	0x55b0,
	0x558b,
	0x5629,
	0x5609,
	0x5617,
	0x564c,
	0x5642,
	0x5703,
	0x572d,
	0x5750,
	0x5c2d,
	0x582f,
	0x5766,
	0x57fc,
	0x57f4,
	0x5806,
	0x5830,
	0x583a,
	0x5835,
	0x5859,
	0x585e,
	0x5861,
	0x58d5,
	0x58ec,
	0x5937,
	0x5944,
	0x5948,
	0x594e,
	0x5957,
	0x5996,
	0x5a03,
	0x59ea,
	0x59e5,
	0x5a29,
	0x5a9b,
	0x5b09,
	0x5b5f,
	0x5b8f,
	0x5b8b,
	0x5b9b,
	0x5b95,
	0x5ba5,
	0x5bc5,
	0x5bd3,
	0x5bf5,
	0x5c16,
	0x5c24,
	0x5c51,
	0x5ca1,
	0x5ce8,
	0x5cfb,
	0x5d16,
	0x5d1a,
	0x5d50,
	0x5d6f,
	0x5d69,
	0x5dba,
	0x5dcc,
	0x5dd6,
	0x5df2,
	0x5df3,
	0x5df4,
	0x5df7,
	0x5dfd,
	0x5dfe,
	0x5e16,
	0x5e4c,
	0x5e61,
	0x5e84,
	0x5e87,
	0x5e9a,
	0x5eb5,
	0x5edf,
	0x5efb,
	0x5f18,
	0x5f1b,
	0x5f25,
	0x5f4c,
	0x5f57,
	0x5f66,
	0x5f6a,
	0x5f6c,
	0x5fa0,
	0x5ffd,
	0x601c,
	0x6062,
	0x6070,
	0x6055,
	0x608c,
	0x60df,
	0x60da,
	0x6089,
	0x60c7,
	0x60f9,
	0x60fa,
	0x60e3,
	0x6167,
	0x61a7,
	0x6190,
	0x620a,
	0x6216,
	0x621a,
	0x621f,
	0x6234,
	0x6258,
	0x6309,
	0x62f6,
	0x62ed,
	0x6328,
	0x62f3,
	0x6349,
	0x633a,
	0x633d,
	0x63ac,
	0x6372,
	0x6377,
	0x637a,
	0x637b,
	0x6367,
	0x63a0,
	0x63c3,
	0x6451,
	0x647a,
	0x6492,
	0x64b0,
	0x649e,
	0x64ad,
	0x64ab,
	0x64e2,
	0x5b5c,
	0x6566,
	0x6591,
	0x6590,
	0x65a1,
	0x65a7,
	0x65af,
	0x65bc,
	0x65e6,
	0x65ed,
	0x65fa,
	0x6602,
	0x660a,
	0x660f,
	0x660c,
	0x6627,
	0x6634,
	0x664f,
	0x6643,
	0x6644,
	0x6652,
	0x664b,
	0x665f,
	0x6666,
	0x6668,
	0x667a,
	0x6689,
	0x66a2,
	0x66d6,
	0x66d9,
	0x66dd,
	0x66f3,
	0x66fd,
	0x66fe,
	0x670b,
	0x6714,
	0x674f,
	0x6756,
	0x675c,
	0x674e,
	0x676d,
	0x6775,
	0x6795,
	0x6777,
	0x6787,
	0x67d1,
	0x67f4,
	0x67f5,
	0x67ff,
	0x67d8,
	0x67ca,
	0x6803,
	0x67cf,
	0x67fe,
	0x67da,
	0x6867,
	0x6a9c,
	0x681e,
	0x6854,
	0x6842,
	0x6841,
	0x6816,
	0x6850,
	0x6817,
	0x68a7,
	0x6897,
	0x6893,
	0x68a2,
	0x689b,
	0x68af,
	0x6876,
	0x68b6,
	0x691b,
	0x68a8,
	0x6881,
	0x6905,
	0x68f2,
	0x690e,
	0x690b,
	0x6900,
	0x696f,
	0x695a,
	0x6955,
	0x693f,
	0x6960,
	0x6953,
	0x6930,
	0x6962,
	0x694a,
	0x698e,
	0x6a3a,
	0x698a,
	0x699b,
	0x69d9,
	0x69c7,
	0x69cd,
	0x69cc,
	0x6a2b,
	0x69fb,
	0x6a1f,
	0x6a0b,
	0x6a58,
	0x6a3d,
	0x6a59,
	0x6a8e,
	0x6a80,
	0x6ac2,
	0x6adb,
	0x6ad3,
	0x6b23,
	0x6b3d,
	0x6b4e,
	0x6b64,
	0x6b86,
	0x6bc5,
	0x6bd8,
	0x6bec,
	0x6c40,
	0x6c5d,
	0x6c50,
	0x6c4e,
	0x6c72,
	0x6c99,
	0x6c70,
	0x6c8c,
	0x6c93,
	0x6cab,
	0x6d38,
	0x6d32,
	0x6d35,
	0x6d1b,
	0x6d69,
	0x6d6c,
	0x6df5,
	0x6df3,
	0x6e1a,
	0x6e1a,
	0x6dc0,
	0x6dcb,
	0x6e25,
	0x6e58,
	0x6e4a,
	0x6e5b,
	0x6e67,
	0x6ea2,
	0x6ec9,
	0x6e9c,
	0x6f31,
	0x6f15,
	0x6f23,
	0x6faa,
	0x6fe1,
	0x7015,
	0x7058,
	0x7078,
	0x707c,
	0x70cf,
	0x7130,
	0x711a,
	0x714c,
	0x714e,
	0x7164,
	0x7149,
	0x7199,
	0x718a,
	0x71d5,
	0x71ce,
	0x71e6,
	0x71ed,
	0x71ff,
	0x722a,
	0x723d,
	0x723e,
	0x7252,
	0x7259,
	0x725f,
	0x7261,
	0x727d,
	0x7280,
	0x72fc,
	0x732a,
	0x7345,
	0x7396,
	0x73a9,
	0x73c2,
	0x73c8,
	0x73ca,
	0x73c0,
	0x73b2,
	0x7422,
	0x7422,
	0x7409,
	0x745b,
	0x7425,
	0x7436,
	0x7435,
	0x7433,
	0x745a,
	0x745e,
	0x7476,
	0x7473,
	0x7460,
	0x7483,
	0x74dc,
	0x74e2,
	0x74e6,
	0x7525,
	0x752b,
	0x754f,
	0x7560,
	0x7562,
	0x757f,
	0x758b,
	0x758f,
	0x7626,
	0x7690,
	0x7693,
	0x7709,
	0x7738,
	0x7766,
	0x77b3,
	0x77a5,
	0x77ad,
	0x77e9,
	0x7826,
	0x7825,
	0x7827,
	0x786f,
	0x7893,
	0x7897,
	0x78a9,
	0x78a7,
	0x78d0,
	0x78ef,
	0x7947,
	0x7962,
	0x79b0,
	0x7950,
	0x7950,
	0x7984,
	0x797f,
	0x798e,
	0x798e,
	0x79b1,
	0x79bd,
	0x79be,
	0x79e6,
	0x79e4,
	0x7a00,
	0x7a14,
	0x7a1f,
	0x7a1c,
	0x7a3d,
	0x7a63,
	0x7a70,
	0x7a7f,
	0x7a84,
	0x7a9f,
	0x7aaa,
	0x7aba,
	0x7ae3,
	0x7aea,
	0x7afa,
	0x7aff,
	0x7b08,
	0x7b39,
	0x7b19,
	0x7b20,
	0x7b48,
	0x7b51,
	0x7b95,
	0x7b94,
	0x7bb8,
	0x7bc7,
	0x7be0,
	0x7c1e,
	0x7c3e,
	0x7c7e,
	0x7ca5,
	0x7c9f,
	0x7cca,
	0x7d18,
	0x7d17,
	0x7d10,
	0x7d43,
	0x7d2c,
	0x7d46,
	0x7d62,
	0x7dba,
	0x7d9c,
	0x7db4,
	0x7dcb,
	0x7dbe,
	0x7db8,
	0x7e1e,
	0x5fbd,
	0x7e6b,
	0x7e61,
	0x7e82,
	0x7e8f,
	0x7f9a,
	0x7fa8,
	0x7fd4,
	0x7fe0,
	0x8000,
	0x800c,
	0x8036,
	0x803d,
	0x8061,
	0x8087,
	0x808b,
	0x8098,
	0x80b4,
	0x80e4,
	0x80e1,
	0x8107,
	0x8129,
	0x8154,
	0x814e,
	0x818f,
	0x81b3,
	0x81c6,
	0x81e5,
	0x81fc,
	0x821c,
	0x8237,
	0x8235,
	0x8276,
	0x82a5,
	0x82b9,
	0x82af,
	0x82ad,
	0x8299,
	0x82a6,
	0x82d1,
	0x8304,
	0x82d4,
	0x82fa,
	0x8305,
	0x8309,
	0x8328,
	0x8338,
	0x831c,
	0x839e,
	0x837b,
	0x83ab,
	0x8389,
	0x83c5,
	0x83eb,
	0x83d6,
	0x8404,
	0x83e9,
	0x840c,
	0x8420,
	0x840a,
	0x83f1,
	0x8466,
	0x845b,
	0x8475,
	0x8431,
	0x847a,
	0x8429,
	0x8463,
	0x8461,
	0x84cb,
	0x84d1,
	0x8494,
	0x8490,
	0x84bc,
	0x84b2,
	0x8499,
	0x84c9,
	0x84ee,
	0x852d,
	0x8523,
	0x8526,
	0x84ec,
	0x8513,
	0x854e,
	0x8568,
	0x8549,
	0x8543,
	0x856a,
	0x853d,
	0x8599,
	0x857e,
	0x8557,
	0x85c1,
	0x85a9,
	0x85e4,
	0x85cd,
	0x8607,
	0x862d,
	0x864e ,
	0x8679,
	0x8702,
	0x871c,
	0x8766,
	0x8776,
	0x87ba,
	0x87ec,
	0x87f9,
	0x881f,
	0x887f,
	0x8896,
	0x8888,
	0x88b4,
	0x88e1,
	0x88fe,
	0x88df,
	0x88f3,
	0x8956,
	0x8a0a,
	0x8a23,
	0x8a3b,
	0x8a63,
	0x8a62,
	0x8a6e,
	0x8a6b,
	0x8abc,
	0x8acf,
	0x8ac4,
	0x8ab0,
	0x8ad2,
	0x8b02,
	0x8afa,
	0x8ae6,
	0x8b0e,
	0x8b83,
	0x8c79,
	0x8c8c,
	0x8cb0,
	0x8cbc,
	0x8cd1,
	0x8d73,
	0x8de8,
	0x8e44,
	0x8e5f,
	0x8e74,
	0x8f14,
	0x8f2f,
	0x8f3f,
	0x8f5f,
	0x8fb0,
	0x8fbb,
	0x8fc2,
	0x8fc4,
	0x8fbf,
	0x8fea,
	0x8fe6,
	0x9019,
	0x901e,
	0x9017,
	0x9022,
	0x9065,
	0x9059,
	0x9041,
	0x9061,
	0x905c,
	0x907c,
	0x9091,
	0x90a3,
	0x7941,
	0x90c1,
	0x912d,
	0x9149,
	0x914e,
	0x9187,
	0x9190,
	0x9192,
	0x918d,
	0x91ac,
	0x91c7,
	0x91c9,
	0x91d8,
	0x91dc,
	0x91e7,
	0x92d2,
	0x92f8,
	0x9326,
	0x9310,
	0x9306,
	0x932b,
	0x934b,
	0x9375,
	0x936c,
	0x93a7,
	0x938c,
	0x9583,
	0x958f,
	0x95a4,
	0x95c7,
	0x961c,
	0x962a,
	0x963f,
	0x9640,
	0x9688,
	0x9699,
	0x96bc,
	0x96c0,
	0x96c1,
	0x96db,
	0x96eb,
	0x971e,
	0x9756,
	0x9784,
	0x978d,
	0x9798,
	0x97a0,
	0x97ad,
	0x97d3,
	0x9801,
	0x9803,
	0x9808,
	0x980c,
	0x9813,
	0x9817,
	0x9830,
	0x985a,
	0x98af,
	0x9905,
	0x9957,
	0x99a8,
	0x99b4,
	0x99b3,
	0x99d5,
	0x99d2,
	0x99ff,
	0x9a4d,
	0x9b41,
	0x9b6f,
	0x9b8e,
	0x9bc9,
	0x9bdb,
	0x9c2f,
	0x9c52,
	0x9c57,
	0x9ce9,
	0x9cf6,
	0x9cf3,
	0x9d28,
	0x9d3b,
	0x9d5c,
	0x9d6c,
	0x9db4,
	0x9dd7,
	0x9df2,
	0x9dfa,
	0x9df9,
	0x9e7f,
	0x9e92,
	0x9e93,
	0x9e9f,
	0x9ebf,
	0x9ece,
	0x9edb,
	0x9f0e,
	0x4e80,
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"琵琶湖（びわこ）は、滋賀県にある湖。",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"Japanese Jinmeiyo",
	"日本人名用漢字",
	0x7435,  // The "bi" in Biwa ... 
	values,
	"串之佃寵尖胤萠琵琶頁鷗鼎",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
