/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEAJRenderer
extends OnTheFlyRenderer {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private String[] args;

    public IDEAJRenderer(String[] args) {
        this.args = args;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        if (this.args[4].equals(".method")) {
            String sourcePath = this.args[3];
            this.render(writer, violations, sourcePath);
            return;
        }
        String classAndMethodName = this.args[4];
        String singleFileName = this.args[5];
        this.render(writer, violations, classAndMethodName, singleFileName);
    }

    @Override
    public void end() throws IOException {
    }

    private void render(Writer writer, Iterator<IRuleViolation> violations, String sourcePathString) throws IOException {
        SourcePath sourcePath = new SourcePath(sourcePathString);
        StringBuffer buf = new StringBuffer();
        while (violations.hasNext()) {
            buf.setLength(0);
            IRuleViolation rv = violations.next();
            buf.append(rv.getDescription() + PMD.EOL);
            buf.append(" at ").append(this.getFullyQualifiedClassName(rv.getFilename(), sourcePath)).append(".method(");
            buf.append(this.getSimpleFileName(rv.getFilename())).append(':').append(rv.getBeginLine()).append(')').append(PMD.EOL);
            writer.write(buf.toString());
        }
    }

    private void render(Writer writer, Iterator<IRuleViolation> violations, String classAndMethod, String file) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (violations.hasNext()) {
            buf.setLength(0);
            IRuleViolation rv = violations.next();
            buf.append(rv.getDescription()).append(PMD.EOL);
            buf.append(" at ").append(classAndMethod).append('(').append(file).append(':').append(rv.getBeginLine()).append(')').append(PMD.EOL);
            writer.write(buf.toString());
        }
    }

    private String getFullyQualifiedClassName(String in, SourcePath sourcePath) {
        String classNameWithSlashes = sourcePath.clipPath(in);
        String className = classNameWithSlashes.replace(FILE_SEPARATOR.charAt(0), '.');
        return className.substring(0, className.length() - 5);
    }

    private String getSimpleFileName(String in) {
        return in.substring(in.lastIndexOf(FILE_SEPARATOR) + 1);
    }

    private static class SourcePath {
        private Set<String> paths = new HashSet<String>();

        public SourcePath(String sourcePathString) {
            StringTokenizer st = new StringTokenizer(sourcePathString, PATH_SEPARATOR);
            while (st.hasMoreTokens()) {
                this.paths.add(st.nextToken());
            }
        }

        public String clipPath(String fullFilename) {
            for (String path : this.paths) {
                if (!fullFilename.startsWith(path)) continue;
                return fullFilename.substring(path.length() + 1);
            }
            throw new RuntimeException("Couldn't find src path for " + fullFilename);
        }
    }
}

