{
 *  MDLineage.h
 *
 *  Copyright 2006 Apple. All rights reserved.
 *
 }

 { Pascal Translation: Gorazd Krosl <gorazd_1957@yahoo.ca>, October 2009 }

{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

unit MDLineage;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
{$ifc defined(iphonesim)}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{ will require compiler define when/if other Apple devices with ARM cpus ship }
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
uses MacTypes,CFBase,CFString,CFURL,CFArray,CFDictionary,MDItem;
{$endc} {not MACOSALLINCLUDE}


{$ifc TARGET_OS_MAC}

{$ALIGN POWER}


{!
@header MDItem

 The MDLineage APIs can be used to set, alter, and store data concerning 
 the relationships between different versions of the same logical file.
 
 Lineage information is stored on files in plist-encoded dictionaries.
 
 }


{!
    @function 
    @abstract   This function creates a new, unique lineage.
    @param      allocator The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
    @result     A new, globally unique lineage, or NULL if there was an error.
 }
function MDLineageCreate( allocator: CFAllocatorRef ): CFDictionaryRef; external name '_MDLineageCreate';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{!
    @function 
    @abstract   This function copies lineage data from a file.
    @param      allocator The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
    @param      fileURL The URL for a file to copy lineage data from.
    @result     The function will return a CFDictionaryRef containing lineage data.  In the case where there was no lineage data associated with the file, NULL will be returned.  If there was an error, NULL will be returned.
}
function MDLineageCreateFromFile( allocator: CFAllocatorRef; fileURL: CFURLRef ): CFDictionaryRef; external name '_MDLineageCreateFromFile';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
 @function 
 @abstract   This file will create a new lineage descending from the provided lineage.
 @param      allocator The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
 @param      originalLineage The lineage to create a branched lineage from.
 @result     The function will return a CFDictionaryRef containing lineage data.  If there was an error, NULL will be returned.
 }

function MDLineageCreateBranch( allocator: CFAllocatorRef; originalLineage: CFDictionaryRef ): CFDictionaryRef; external name '_MDLineageCreateBranch';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
    @function 
    @abstract   This file will create a new lineage descending from the provided file.
    @param      allocator The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
    @param      fileURL The URL for a file to create branched lineage from.
    @result     The function will return a CFDictionaryRef containing lineage data.  In the case where there was no lineage data associated with the file, NULL will be returned.  If there was an error, NULL will be returned.
}
function MDLineageCreateBranchFromFile( allocator: CFAllocatorRef; fileURL: CFURLRef ): CFDictionaryRef; external name '_MDLineageCreateBranchFromFile';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{!
    @function 
    @abstract   This function will write the provided lineage data on the file at fileURL.
    @discussion This function overwrites any lineage data already marked on the file.
    @param      lineage lineage data obtained from one of the MDLineageCreate functions.
    @param      fileURL The URL for a file to write the lineage data onto.
    @result     Returns true if the operation succeeded, and false otherwise.
 }
function MDLineageSetOnFile( lineage: CFDictionaryRef; fileURL: CFURLRef ): Boolean; external name '_MDLineageSetOnFile';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
    @function 
    @abstract   This function removes any existing lineage from the provided document.
    @param      fileURL the file to remove all lineage data from.
    @result     Returns true if all lineage data was removed from the file at fileURL, and false otherwise.  If there was no lineage data on the file, the function returns true.
 }
function MDLineageRemoveFromFile( fileURL: CFURLRef ): Boolean; external name '_MDLineageRemoveFromFile';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
 @function 
 @abstract   This function creates a query string which will find members of the provided MDItem's document lineage family.  The query string is suitable for passing to MDQueryCreate.
 @param      item a member of the document family to locate
 @result     Returns a CFStringRef appropriate for passing to MDQueryCreate, or NULL if an error occurred.
 }

function MDLineageCreateQueryString( item: MDItemRef ): CFStringRef; external name '_MDLineageCreateQueryString';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
 @function 
 @abstract   This function creates a CFArray with the most direct ancestor(s) of the given item, within the context of the MDItemRefs listed in the family parameter.
 @param      item the item whose direct ancestor(s) should be returned
 @param      family a CFArrayRef of MDItemRefs  
 @result     Returns a CFArrayRef containing the most direct ancestor(s) of item.  An item could have more than one parent if a single most direct ancestor cannot be determined.  NULL is returned if no ancestors can be found in family, or if an error occurred.
 }

function MDLineageCopyParents( item: MDItemRef; family: CFArrayRef ): CFArrayRef; external name '_MDLineageCopyParents';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
 @function 
 @abstract   This function creates a CFArray with the root ancestor(s) of the given item, within the context of the MDItemRefs listed in the family parameter.
 @param      item the item whose root ancestor(s) should be returned
 @param      family a CFArrayRef of MDItemRefs  
 @result     Returns a CFArrayRef containing the root ancestor(s) of item.  Note that in some cases there may be multiple items returned in the array.  NULL is returned if no ancestors can be found in family, or if an error occurred.
 }

function MDLineageCopyRootAncestors( item: MDItemRef; family: CFArrayRef ): CFArrayRef; external name '_MDLineageCopyRootAncestors';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
 @function 
 @abstract   This function creates a CFArray with the most direct descendants of the given item, within the context of the MDItemRefs listed in the family parameter.
 @param      item the item whose direct descendants should be returned
 @param      family a CFArrayRef of MDItemRefs
 @result     Returns a CFArrayRef containing the most direct descendents of item.  Note that in some cases there may be multiple items returned in the array.  NULL is returned if no descendants of item can be found in family, or if an error occurred.
 }

function MDLineageCopyChildren( item: MDItemRef; family: CFArrayRef ): CFArrayRef; external name '_MDLineageCopyChildren';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{!
 @function 
 @abstract   This function creates a CFArray with the leaf descendants of the given item (the "leaf nodes" on the tree), within the context of the MDItemRefs listed in the family parameter.
 @param      item the item whose leaf descendants should be returned
 @param      family a CFArrayRef of MDItemRefs
 @result     Returns a CFArrayRef containing the leaf descendants of the item.   NULL is returned if no descendants of item can be found in family, or if an error occurred.
 }

function MDLineageCopyLeafDescendants( item: MDItemRef; family: CFArrayRef ): CFArrayRef; external name '_MDLineageCopyLeafDescendants';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)

{$endc} {TARGET_OS_MAC}
{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}

end.
{$endc} {not MACOSALLINCLUDE}
