/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef FILEMANAGER_H
#define FILEMANAGER_H

#include <QWidget>
#include <QQueue>
#include <QApplication>
#include "auth/auth_tcp_client.h"
#include "../../../commons/constants.h"
#include "../xml/xml_parser_client.h"

class FileManager : public QObject
{
    Q_OBJECT

public:
    FileManager(auth_tcp_client *file_tcp_client, QObject *parent);
    QQueue<File*> *file_queue;
    void append_file(File* file);
    int send_document(QString name, QString path);

public slots:
    void received_stream_slot_files(QString message);

signals:
    void file_received(File *file);
    void update_percent(int current, int total);
    void showMessage(QString title, QString content, int duration);
    void showLabelSignal(QString label);
private:
    File *current_file;
    QString slash;
    auth_tcp_client *tcp_client;
};

#endif
