/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#ifndef XML_CREATOR_SERVER_H
#define XML_CREATOR_SERVER_H

#include <QHostInfo>
#include <QWidget>
#include <QFileInfo>
#include <QFile>
#include <QDateTime>
#include <QDir>
#include "../../../commons/constants.h"
#include <stdlib.h>

class XmlCreatorServer : public QObject
{
    Q_OBJECT

public:
    XmlCreatorServer(QObject *parent);
    QString getFoldersParameters(QString path);
    QString getConnectionParameters(QString path);
    QString getFileInfo(QString filePath, QString path, QString header);
    QString createXmlParameters(QString path, QStringList *ipList);
    void appendFolderAndFileInfo(QString &xmlDocument, QString path );

    QString xmlOpening;
    QString xmlClosing;
    QString xmlEnding;
    QString xmlDoctype;
    QString xmlParametersDocument;
    QString xmlContextDocument;
    QString xmlContextFileDocument;
    QString xmlKontrolPackElement;
    QString xmlHostnameElement;
    QString xmlSystemElement;
    QString xmlPathElement;
    QString xmlFolderListElement;
    QString xmlFileListElement;
    QString xmlFolderElement;
    QString xmlFileElement;
    QString xmlIpListElement;
    QString xmlIpElement;
};
#endif
