/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/multiModuleLineMarker")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MultiModuleLineMarkerTestGenerated extends AbstractMultiModuleLineMarkerTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    @TestMetadata("actualConstructorWithProperties")
    public void testActualConstructorWithProperties() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/actualConstructorWithProperties/");
    }

    @TestMetadata("actualDerived")
    public void testActualDerived() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/actualDerived/");
    }

    @TestMetadata("actualEnumEntries")
    public void testActualEnumEntries() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/actualEnumEntries/");
    }

    @TestMetadata("actualEnumEntriesInOneLine")
    public void testActualEnumEntriesInOneLine() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/actualEnumEntriesInOneLine/");
    }

    @TestMetadata("actualWithOverload")
    public void testActualWithOverload() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/actualWithOverload/");
    }

    public void testAllFilesPresentInMultiModuleLineMarker() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/multiModuleLineMarker"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("expectConstructorWithProperties")
    public void testExpectConstructorWithProperties() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/expectConstructorWithProperties/");
    }

    @TestMetadata("expectEnumEntries")
    public void testExpectEnumEntries() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/expectEnumEntries/");
    }

    @TestMetadata("expectEnumEntriesInOneLine")
    public void testExpectEnumEntriesInOneLine() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/expectEnumEntriesInOneLine/");
    }

    @TestMetadata("expectEnumWithEnumEntriesInOneLine")
    public void testExpectEnumWithEnumEntriesInOneLine() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/expectEnumWithEnumEntriesInOneLine/");
    }

    @TestMetadata("expectWithOverload")
    public void testExpectWithOverload() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/expectWithOverload/");
    }

    @TestMetadata("fromActualAnnotation")
    public void testFromActualAnnotation() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualAnnotation/");
    }

    @TestMetadata("fromActualAnnotationWithParametersInOneLine")
    public void testFromActualAnnotationWithParametersInOneLine() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualAnnotationWithParametersInOneLine/");
    }

    @TestMetadata("fromActualCompanion")
    public void testFromActualCompanion() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualCompanion/");
    }

    @TestMetadata("fromActualPrimaryConstructor")
    public void testFromActualPrimaryConstructor() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualPrimaryConstructor/");
    }

    @TestMetadata("fromActualSealedClass")
    public void testFromActualSealedClass() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualSealedClass/");
    }

    @TestMetadata("fromActualSecondaryConstructor")
    public void testFromActualSecondaryConstructor() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualSecondaryConstructor/");
    }

    @TestMetadata("fromActualTypeAlias")
    public void testFromActualTypeAlias() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromActualTypeAlias/");
    }

    @TestMetadata("fromClassToAlias")
    public void testFromClassToAlias() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromClassToAlias/");
    }

    @TestMetadata("fromClassToJavaAliasInTest")
    public void testFromClassToJavaAliasInTest() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromClassToJavaAliasInTest/");
    }

    @TestMetadata("fromCommonToJvmHeader")
    public void testFromCommonToJvmHeader() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromCommonToJvmHeader/");
    }

    @TestMetadata("fromCommonToJvmImpl")
    public void testFromCommonToJvmImpl() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromCommonToJvmImpl/");
    }

    @TestMetadata("fromExpectCompanion")
    public void testFromExpectCompanion() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromExpectCompanion/");
    }

    @TestMetadata("fromExpectedAnnotation")
    public void testFromExpectedAnnotation() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromExpectedAnnotation/");
    }

    @TestMetadata("fromExpectedPrimaryConstructor")
    public void testFromExpectedPrimaryConstructor() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromExpectedPrimaryConstructor/");
    }

    @TestMetadata("fromExpectedSealedClass")
    public void testFromExpectedSealedClass() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromExpectedSealedClass/");
    }

    @TestMetadata("fromExpectedSecondaryConstructor")
    public void testFromExpectedSecondaryConstructor() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromExpectedSecondaryConstructor/");
    }

    @TestMetadata("fromExpectedTypeAlias")
    public void testFromExpectedTypeAlias() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/fromExpectedTypeAlias/");
    }

    @TestMetadata("hierarchyWithExpectClassCommonSide")
    public void testHierarchyWithExpectClassCommonSide() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/hierarchyWithExpectClassCommonSide/");
    }

    @TestMetadata("hierarchyWithExpectClassCommonSideNonJavaIds")
    public void testHierarchyWithExpectClassCommonSideNonJavaIds() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/hierarchyWithExpectClassCommonSideNonJavaIds/");
    }

    @TestMetadata("hierarchyWithExpectClassPlatformSide")
    public void testHierarchyWithExpectClassPlatformSide() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/hierarchyWithExpectClassPlatformSide/");
    }

    @TestMetadata("kotlinTestAnnotations")
    public void testKotlinTestAnnotations() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/kotlinTestAnnotations/");
    }

    @TestMetadata("suspendImplInPlatformModules")
    public void testSuspendImplInPlatformModules() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/suspendImplInPlatformModules/");
    }

    @TestMetadata("topLevelFunWithKotlinTest")
    public void testTopLevelFunWithKotlinTest() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/topLevelFunWithKotlinTest/");
    }

    @TestMetadata("transitive")
    public void testTransitive() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/transitive/");
    }

    @TestMetadata("transitiveCommon")
    public void testTransitiveCommon() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/transitiveCommon/");
    }

    @TestMetadata("withOverloads")
    public void testWithOverloads() throws Exception {
        runTest("idea/testData/multiModuleLineMarker/withOverloads/");
    }
}
