; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+tbm | FileCheck %s --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver2 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver3 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver4 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER4

define i32 @test_x86_tbm_bextri_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_bextri_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    bextr $3076, %edi, %ecx # imm = 0xC04
; GENERIC-NEXT:    # sched: [1:0.33]
; GENERIC-NEXT:    bextr $3076, (%rsi), %eax # imm = 0xC04
; GENERIC-NEXT:    # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_bextri_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    bextr $3076, %edi, %ecx # imm = 0xC04
; BDVER-NEXT:    bextr $3076, (%rsi), %eax # imm = 0xC04
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = lshr i32 %a0, 4
  %m0 = lshr i32 %a1, 4
  %r1 = and i32 %r0, 4095
  %m1 = and i32 %m0, 4095
  %res = add i32 %r1, %m1
  ret i32 %res
}

define i64 @test_x86_tbm_bextri_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_bextri_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    bextr $3076, %edi, %ecx # imm = 0xC04
; GENERIC-NEXT:    # sched: [1:0.33]
; GENERIC-NEXT:    bextr $3076, (%rsi), %eax # imm = 0xC04
; GENERIC-NEXT:    # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_bextri_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    bextr $3076, %edi, %ecx # imm = 0xC04
; BDVER-NEXT:    bextr $3076, (%rsi), %eax # imm = 0xC04
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = lshr i64 %a0, 4
  %m0 = lshr i64 %a1, 4
  %r1 = and i64 %r0, 4095
  %m1 = and i64 %m0, 4095
  %res = add i64 %r1, %m1
  ret i64 %res
}

define i32 @test_x86_tbm_blcfill_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcfill_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcfill %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blcfill (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcfill_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcfill %edi, %ecx
; BDVER-NEXT:    blcfill (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = add i32 %a0, 1
  %m0 = add i32 %a1, 1
  %r1 = and i32 %r0, %a0
  %m1 = and i32 %m0, %a1
  %res = add i32 %r1, %m1
  ret i32 %res
}

define i64 @test_x86_tbm_blcfill_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcfill_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcfill %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blcfill (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcfill_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcfill %rdi, %rcx
; BDVER-NEXT:    blcfill (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = add i64 %a0, 1
  %m0 = add i64 %a1, 1
  %r1 = and i64 %r0, %a0
  %m1 = and i64 %m0, %a1
  %res = add i64 %r1, %m1
  ret i64 %res
}

define i32 @test_x86_tbm_blci_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blci_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blci %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blci (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blci_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blci %edi, %ecx
; BDVER-NEXT:    blci (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = add i32 1, %a0
  %m0 = add i32 1, %a1
  %r1 = xor i32 %r0, -1
  %m1 = xor i32 %m0, -1
  %r2 = or i32 %r1, %a0
  %m2 = or i32 %m1, %a1
  %res = add i32 %r2, %m2
  ret i32 %res
}

define i64 @test_x86_tbm_blci_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blci_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blci %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blci (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blci_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blci %rdi, %rcx
; BDVER-NEXT:    blci (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = add i64 1, %a0
  %m0 = add i64 1, %a1
  %r1 = xor i64 %r0, -1
  %m1 = xor i64 %m0, -1
  %r2 = or i64 %r1, %a0
  %m2 = or i64 %m1, %a1
  %res = add i64 %r2, %m2
  ret i64 %res
}

define i32 @test_x86_tbm_blcic_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcic_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcic %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blcic (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcic_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcic %edi, %ecx
; BDVER-NEXT:    blcic (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = xor i32 %a0, -1
  %m0 = xor i32 %a1, -1
  %r1 = add i32 %a0, 1
  %m1 = add i32 %a1, 1
  %r2 = and i32 %r1, %r0
  %m2 = and i32 %m1, %m0
  %res = add i32 %r2, %m2
  ret i32 %res
}

define i64 @test_x86_tbm_blcic_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcic_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcic %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blcic (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcic_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcic %rdi, %rcx
; BDVER-NEXT:    blcic (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = xor i64 %a0, -1
  %m0 = xor i64 %a1, -1
  %r1 = add i64 %a0, 1
  %m1 = add i64 %a1, 1
  %r2 = and i64 %r1, %r0
  %m2 = and i64 %m1, %m0
  %res = add i64 %r2, %m2
  ret i64 %res
}

define i32 @test_x86_tbm_blcmsk_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcmsk_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcmsk %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blcmsk (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcmsk_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcmsk %edi, %ecx
; BDVER-NEXT:    blcmsk (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = add i32 %a0, 1
  %m0 = add i32 %a1, 1
  %r1 = xor i32 %r0, %a0
  %m1 = xor i32 %m0, %a1
  %res = add i32 %r1, %m1
  ret i32 %res
}

define i64 @test_x86_tbm_blcmsk_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcmsk_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcmsk %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blcmsk (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcmsk_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcmsk %rdi, %rcx
; BDVER-NEXT:    blcmsk (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = add i64 %a0, 1
  %m0 = add i64 %a1, 1
  %r1 = xor i64 %r0, %a0
  %m1 = xor i64 %m0, %a1
  %res = add i64 %r1, %m1
  ret i64 %res
}

define i32 @test_x86_tbm_blcs_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcs_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcs %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blcs (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcs_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcs %edi, %ecx
; BDVER-NEXT:    blcs (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = add i32 %a0, 1
  %m0 = add i32 %a1, 1
  %r1 = or i32 %r0, %a0
  %m1 = or i32 %m0, %a1
  %res = add i32 %r1, %m1
  ret i32 %res
}

define i64 @test_x86_tbm_blcs_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blcs_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blcs %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blcs (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blcs_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blcs %rdi, %rcx
; BDVER-NEXT:    blcs (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = add i64 %a0, 1
  %m0 = add i64 %a1, 1
  %r1 = or i64 %r0, %a0
  %m1 = or i64 %m0, %a1
  %res = add i64 %r1, %m1
  ret i64 %res
}

define i32 @test_x86_tbm_blsfill_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blsfill_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blsfill %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blsfill (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blsfill_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blsfill %edi, %ecx
; BDVER-NEXT:    blsfill (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = add i32 %a0, -1
  %m0 = add i32 %a1, -1
  %r1 = or i32 %r0, %a0
  %m1 = or i32 %m0, %a1
  %res = add i32 %r1, %m1
  ret i32 %res
}

define i64 @test_x86_tbm_blsfill_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blsfill_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blsfill %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blsfill (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blsfill_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blsfill %rdi, %rcx
; BDVER-NEXT:    blsfill (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = add i64 %a0, -1
  %m0 = add i64 %a1, -1
  %r1 = or i64 %r0, %a0
  %m1 = or i64 %m0, %a1
  %res = add i64 %r1, %m1
  ret i64 %res
}

define i32 @test_x86_tbm_blsic_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blsic_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blsic %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    blsic (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blsic_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blsic %edi, %ecx
; BDVER-NEXT:    blsic (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = xor i32 %a0, -1
  %m0 = xor i32 %a1, -1
  %r1 = add i32 %a0, -1
  %m1 = add i32 %a1, -1
  %r2 = or i32 %r0, %r1
  %m2 = or i32 %m0, %m1
  %res = add i32 %r2, %m2
  ret i32 %res
}

define i64 @test_x86_tbm_blsic_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_blsic_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    blsic %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    blsic (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_blsic_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    blsic %rdi, %rcx
; BDVER-NEXT:    blsic (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = xor i64 %a0, -1
  %m0 = xor i64 %a1, -1
  %r1 = add i64 %a0, -1
  %m1 = add i64 %a1, -1
  %r2 = or i64 %r0, %r1
  %m2 = or i64 %m0, %m1
  %res = add i64 %r2, %m2
  ret i64 %res
}

define i32 @test_x86_tbm_t1mskc_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_t1mskc_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    t1mskc %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    t1mskc (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_t1mskc_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    t1mskc %edi, %ecx
; BDVER-NEXT:    t1mskc (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = xor i32 %a0, -1
  %m0 = xor i32 %a1, -1
  %r1 = add i32 %a0, 1
  %m1 = add i32 %a1, 1
  %r2 = or i32 %r0, %r1
  %m2 = or i32 %m0, %m1
  %res = add i32 %r2, %m2
  ret i32 %res
}

define i64 @test_x86_tbm_t1mskc_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_t1mskc_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    t1mskc %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    t1mskc (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_t1mskc_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    t1mskc %rdi, %rcx
; BDVER-NEXT:    t1mskc (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = xor i64 %a0, -1
  %m0 = xor i64 %a1, -1
  %r1 = add i64 %a0, 1
  %m1 = add i64 %a1, 1
  %r2 = or i64 %r0, %r1
  %m2 = or i64 %m0, %m1
  %res = add i64 %r2, %m2
  ret i64 %res
}

define i32 @test_x86_tbm_tzmsk_u32(i32 %a0, i32* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_tzmsk_u32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    tzmsk %edi, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    tzmsk (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_tzmsk_u32:
; BDVER:       # %bb.0:
; BDVER-NEXT:    tzmsk %edi, %ecx
; BDVER-NEXT:    tzmsk (%rsi), %eax
; BDVER-NEXT:    addl %ecx, %eax
; BDVER-NEXT:    retq
  %a1 = load i32, i32* %p1
  %r0 = xor i32 %a0, -1
  %m0 = xor i32 %a1, -1
  %r1 = add i32 %a0, -1
  %m1 = add i32 %a1, -1
  %r2 = and i32 %r0, %r1
  %m2 = and i32 %m0, %m1
  %res = add i32 %r2, %m2
  ret i32 %res
}

define i64 @test_x86_tbm_tzmsk_u64(i64 %a0, i64* nocapture %p1) nounwind {
; GENERIC-LABEL: test_x86_tbm_tzmsk_u64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    tzmsk %rdi, %rcx # sched: [1:0.33]
; GENERIC-NEXT:    tzmsk (%rsi), %rax # sched: [5:0.50]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER-LABEL: test_x86_tbm_tzmsk_u64:
; BDVER:       # %bb.0:
; BDVER-NEXT:    tzmsk %rdi, %rcx
; BDVER-NEXT:    tzmsk (%rsi), %rax
; BDVER-NEXT:    addq %rcx, %rax
; BDVER-NEXT:    retq
  %a1 = load i64, i64* %p1
  %r0 = xor i64 %a0, -1
  %m0 = xor i64 %a1, -1
  %r1 = add i64 %a0, -1
  %m1 = add i64 %a1, -1
  %r2 = and i64 %r0, %r1
  %m2 = and i64 %m0, %m1
  %res = add i64 %r2, %m2
  ret i64 %res
}
